/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDeclareVar;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDependency;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeImport;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.application.service.task.BaseGenTask;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeSectionService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeTableService;
import com.irdstudio.allinrdm.dev.console.facade.SrvErrorMappingService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInoutDTO;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GenDsWebTask
extends BaseGenTask {
    @Autowired
    protected SrvErrorMappingService srvErrorMappingService;
    @Autowired
    protected OsrvArrangeSectionService osrvArrangeSectionService;
    @Autowired
    protected OsrvArrangeTableService osrvArrangeTableService;

    @Override
    public boolean execute(PaasAppsInfoDTO appInfo) {
        String loginUserId = appInfo.getLoginUserId();
        String appCode = appInfo.getAppCode();
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setAppId(appInfo.getAppId());
        if (StringUtils.isNotBlank((CharSequence)appInfo.getSrvModelId())) {
            SrvModelInfoDTO srvModelInfo = new SrvModelInfoDTO();
            srvModelInfo.setSrvModelId(appInfo.getSrvModelId());
            srvModelInfo = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)srvModelInfo);
            if (srvModelInfo != null && StringUtils.isNotBlank((CharSequence)srvModelInfo.getTableModelId())) {
                tableParam.setObjectId(srvModelInfo.getTableModelId());
            }
        }
        List tableList = this.modelTableInfoService.queryList((Object)tableParam);
        ModelTableInfoDTO isrvRspInfo = this.modelTableInfoService.generateIsrvRspInfo(appInfo.getAppId());
        ModelTableInfoDTO pageInfo = this.modelTableInfoService.generatePageInfo(appInfo.getAppId());
        TmProjectInfoBo tpib = new TmProjectInfoBo();
        tpib.setProjectId(appInfo.getAppCode());
        tpib.setProjectCode(appInfo.getAppCode());
        tpib.setProjectName(appInfo.getAppName());
        ArrayList inoutParamList = new ArrayList(tableList.size());
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            ArrayList<CodeTemplateDataBo> codeBoList = new ArrayList<CodeTemplateDataBo>(tableList.size());
            SrvModelInfoDTO modelParam = new SrvModelInfoDTO();
            modelParam.setAppId(appInfo.getAppId());
            modelParam.setSrvModelCatalog(SrvModelCatalogEnum.SrvServer.getCode());
            for (Object table : tableList) {
                ObjectType objectTypeEnum = ObjectType.getType((String)String.valueOf(table.getObjectType()));
                if (objectTypeEnum == ObjectType.Inout || objectTypeEnum == ObjectType.Common || objectTypeEnum == ObjectType.Data || objectTypeEnum == ObjectType.FreeStyleData) continue;
                modelParam.setTableModelId(table.getObjectId());
                List modelList = this.srvModelInfoService.queryList((Object)modelParam);
                String inputDOName = TmModelUtil.modelCodeToClassName((String)table.getObjectCode()) + "Input";
                ModelTableInfoDTO inputDO = this.queryTableWithNameForInout(appInfo.getAppId(), inputDOName);
                if (inputDO == null) continue;
                String tableClassName = TmModelUtil.modelCodeToClassName((String)table.getObjectCode());
                String tableModelCode = table.getObjectCode();
                HashMap<String, OsrvArrangeImport> importMap = new HashMap<String, OsrvArrangeImport>();
                HashMap<String, OsrvArrangeDeclareVar> propMap = new HashMap<String, OsrvArrangeDeclareVar>();
                OsrvArrangeDeclareVar inputDTOProp = new OsrvArrangeDeclareVar();
                String inputDO_className = this.wrapperTableToClassName(inputDO.getObjectCode(), inputDO.getObjectType().toString(), inputDO.getObjectId());
                inputDTOProp.setVarClassName(inputDO_className);
                inputDTOProp.setVarName(StringUtils.uncapitalize((String)inputDO_className));
                inputDTOProp.setListFlag(YesOrNO.NO.getCode());
                inputDTOProp.setComment(String.format("%s %s\u53ca\u6269\u5c55\u53c2\u6570\u5bf9\u8c61", IOType.Input.getName(), inputDO.getObjectName()));
                propMap.put(inputDTOProp.getVarName(), inputDTOProp);
                OsrvArrangeImport inputDTOProp_import = new OsrvArrangeImport();
                inputDTOProp_import.setClassName(inputDO_className);
                inputDTOProp_import.setProjectCode(tpib.getProjectCode());
                inputDTOProp_import.setImportType(this.judgeTableToClassName(inputDO.getObjectCode(), inputDO.getObjectType().toString(), inputDO.getObjectId()));
                importMap.put(inputDTOProp_import.getClassName(), inputDTOProp_import);
                OsrvArrangeImport isrvRspInfo_import = new OsrvArrangeImport();
                String isrvRspInfo_class = this.wrapperTableToClassName(isrvRspInfo.getObjectCode(), isrvRspInfo.getObjectType().toString(), isrvRspInfo.getObjectId());
                isrvRspInfo_import.setClassName(isrvRspInfo_class);
                isrvRspInfo_import.setProjectCode(tpib.getProjectCode());
                isrvRspInfo_import.setImportType(this.judgeTableToClassName(isrvRspInfo.getObjectCode(), isrvRspInfo.getObjectType().toString(), isrvRspInfo.getObjectId()));
                importMap.put(isrvRspInfo_import.getClassName(), isrvRspInfo_import);
                OsrvArrangeImport pageInfo_import = new OsrvArrangeImport();
                String pageInfo_class = this.wrapperTableToClassName(pageInfo.getObjectCode(), pageInfo.getObjectType().toString(), pageInfo.getObjectId());
                pageInfo_import.setClassName(pageInfo_class);
                pageInfo_import.setProjectCode(tpib.getProjectCode());
                pageInfo_import.setImportType(this.judgeTableToClassName(pageInfo.getObjectCode(), pageInfo.getObjectType().toString(), pageInfo.getObjectId()));
                importMap.put(pageInfo_import.getClassName(), pageInfo_import);
                OsrvArrangeDeclareVar tableDO = new OsrvArrangeDeclareVar();
                String tableDO_className = this.wrapperTableToClassName(table.getObjectCode(), table.getObjectType().toString(), table.getObjectId());
                tableDO.setVarClassName(tableDO_className);
                tableDO.setVarName(StringUtils.uncapitalize((String)tableDO_className));
                tableDO.setListFlag(YesOrNO.NO.getCode());
                tableDO.setComment(String.format("%s %s", IOType.Input.getName(), table.getObjectName()));
                propMap.put(tableDO.getVarName(), tableDO);
                OsrvArrangeImport tableDO_import = new OsrvArrangeImport();
                tableDO_import.setClassName(tableDO_className);
                tableDO_import.setProjectCode(tpib.getProjectCode());
                tableDO_import.setImportType(this.judgeTableToClassName(table.getObjectCode(), table.getObjectType().toString(), table.getObjectId()));
                importMap.put(tableDO_import.getClassName(), tableDO_import);
                OsrvArrangeImport serviceInput_import = new OsrvArrangeImport();
                serviceInput_import.setClassName("ServiceInput");
                serviceInput_import.setProjectCode(tpib.getProjectCode());
                serviceInput_import.setImportType(this.judgeTableToClassName("ServiceInput", ObjectType.Common.getCode(), null));
                importMap.put(serviceInput_import.getClassName(), serviceInput_import);
                OsrvArrangeImport serviceOutput_import = new OsrvArrangeImport();
                serviceOutput_import.setClassName("ServiceOutput");
                serviceOutput_import.setProjectCode(tpib.getProjectCode());
                serviceOutput_import.setImportType(this.judgeTableToClassName("ServiceOutput", ObjectType.Common.getCode(), null));
                importMap.put(serviceOutput_import.getClassName(), serviceOutput_import);
                OsrvArrangeImport service_import = new OsrvArrangeImport();
                service_import.setClassName(TmModelUtil.tableCodeToClassName((String)(table.getObjectCode() + "_ds")));
                service_import.setProjectCode(tpib.getProjectCode());
                service_import.setImportType(OsrvArrangeImport.ImportType.Facade.getCode());
                importMap.put(service_import.getClassName(), service_import);
                if (!CollectionUtils.isNotEmpty((Collection)modelList)) continue;
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                String author = table.getCreateUser();
                String TablebjectType = String.valueOf(table.getObjectType());
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(loginUserId);
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s Web %s", appInfo.getAppName(), table.getObjectName()));
                Map dataMap = bo.getMapData();
                ArrayList methods = new ArrayList(modelList.size());
                dataMap.put("methods", methods);
                for (SrvModelInfoDTO modelInfo : modelList) {
                    HashMap<String, Object> method = new HashMap<String, Object>();
                    method.put("modelInfo", modelInfo);
                    SrvModelTypeEnum srvModelTypeEnum = SrvModelTypeEnum.getModelByType((String)modelInfo.getSrvModelType());
                    method.put("methodName", modelInfo.getSrvModelCode());
                    String inputGenClass = inputDO_className;
                    SrvModelInoutDTO serviceInputInout = new SrvModelInoutDTO();
                    serviceInputInout.setSrvModelId(modelInfo.getSrvModelId());
                    serviceInputInout.setListFlag(YesOrNO.NO.getCode());
                    serviceInputInout.setTableModelCode(inputGenClass);
                    SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
                    inoutParam.setSrvModelId(modelInfo.getSrvModelId());
                    inoutParam.setIoType(IOType.Output.getCode());
                    List outputParams = this.srvModelInoutService.queryList((Object)inoutParam);
                    String outputGenericsClass = tableDO_className;
                    String listFlag = YesOrNO.YES.getCode();
                    if (CollectionUtils.isNotEmpty((Collection)outputParams)) {
                        SrvModelInoutDTO outputInout = (SrvModelInoutDTO)outputParams.get(0);
                        listFlag = outputInout.getListFlag();
                        outputGenericsClass = this.wrapperTableToClassName(outputInout.getTableModelCode(), outputInout.getObjectType().toString(), outputInout.getTableModelId());
                    }
                    SrvModelInoutDTO serviceOutputInout = new SrvModelInoutDTO();
                    serviceOutputInout.setSrvModelId(modelInfo.getSrvModelId());
                    serviceOutputInout.setListFlag(listFlag);
                    serviceOutputInout.setTableModelCode(outputGenericsClass);
                    method.put("input", serviceInputInout);
                    method.put("output", serviceOutputInout);
                    methods.add(method);
                }
                dataMap.put("importList", importMap.values());
                bo.getMapData().put("tableModelCode", table.getObjectCode() + "_ds");
                bo.getMapData().put("tableClassName", TmModelUtil.tableCodeToClassName((String)table.getObjectCode()));
                codeBoList.add(bo);
            }
            Map<String, Object> appsParam = this.wrapAppsParam(appInfo.getAppId(), null);
            for (CodeTemplateDataBo ctdb : codeBoList) {
                ctdb.getMapData().put("appsParam", appsParam);
                String package_prefix = this.getPackagePrefix(ctdb);
                Map mapData = ctdb.getMapData();
                this.produceCodeFile("XXXDsController.java", "XXXDs", "web", "src/main/java/" + package_prefix + "/" + GenDsWebTask.formatClassPath(appCode).replaceAll("_|-", ".") + "/web/controller/api/", appInfo, ctdb);
            }
        }
        SSubsInfoDTO sSubsInfo = new SSubsInfoDTO();
        sSubsInfo.setSubsId(appInfo.getSubsId());
        sSubsInfo = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)sSubsInfo);
        List<OsrvArrangeDependency> dependencies = this.querySubsSDKDependencies(sSubsInfo);
        CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
        pomBo.setTmProjectInfo(tpib);
        pomBo.getMapData().put("sdkList", dependencies);
        this.wrapAppsParam(appInfo.getAppId(), pomBo);
        String package_prefix = this.getPackagePrefix(pomBo);
        this.produceCodeFile("web-pom.xml", "", "web-", "web", "", appInfo, pomBo);
        return true;
    }
}

