/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.application.service.task.BaseGenTask;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionEnumService;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.SrvErrorMappingService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvErrorMappingDTO;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GenTypesTask
extends BaseGenTask {
    @Autowired
    protected SrvErrorMappingService srvErrorMappingService;
    @Autowired
    protected DictOptionInfoService dictOptionInfoService;
    @Autowired
    protected DictOptionEnumService dictOptionEnumService;
    private static final Pattern NumberCheckPattern = Pattern.compile("^\\d+\\S*");

    @Override
    public boolean execute(PaasAppsInfoDTO appInfo) {
        String package_prefix;
        String appCode = appInfo.getAppCode();
        String loginUserId = appInfo.getLoginUserId();
        List optionsList = this.modelTableFieldService.queryModelTableFieldAllOptions(appInfo.getAppId());
        if (CollectionUtils.isNotEmpty((Collection)optionsList)) {
            ArrayList<CodeTemplateDataBo> codeBoList = new ArrayList<CodeTemplateDataBo>(optionsList.size());
            for (ModelTableFieldDTO option : optionsList) {
                if (StringUtils.isBlank((CharSequence)option.getDictId())) continue;
                DictOptionEnumDTO enumParam = new DictOptionEnumDTO();
                enumParam.setDictId(option.getDictId());
                enumParam.setSubsId(option.getDictDslId());
                List dicts = this.dictOptionEnumService.queryList((Object)enumParam);
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                DictOptionInfoDTO optionInfo = new DictOptionInfoDTO();
                optionInfo.setDictId(option.getDictId());
                optionInfo.setSubsId(option.getDictDslId());
                if ((optionInfo = (DictOptionInfoDTO)this.dictOptionInfoService.queryByPk((Object)optionInfo)) == null) continue;
                if (CollectionUtils.isNotEmpty((Collection)dicts)) {
                    for (DictOptionEnumDTO dict : dicts) {
                        Matcher m;
                        if (StringUtils.isBlank((CharSequence)dict.getOptionEnum())) {
                            String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionCode());
                            dict.setOptionEnum(optionEnum);
                        }
                        if (!(m = NumberCheckPattern.matcher(dict.getOptionEnum())).matches()) continue;
                        String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionEnum());
                        dict.setOptionEnum(optionEnum);
                    }
                }
                TmProjectInfoBo tpib = new TmProjectInfoBo();
                tpib.setProjectId(appInfo.getAppCode());
                tpib.setProjectCode(appInfo.getAppCode());
                tpib.setProjectName(appInfo.getAppName());
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(loginUserId);
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s Types Enum %s %s", appInfo.getAppName(), optionInfo.getDictCode(), optionInfo.getDictName()));
                option.setFieldCode(TmModelUtil.tableCodeToClassName((String)option.getFieldOption()));
                bo.getMapData().put("fieldOption", option);
                bo.getMapData().put("dicts", dicts);
                bo.getMapData().put("tableModelCode", option.getFieldOption());
                codeBoList.add(bo);
            }
            for (CodeTemplateDataBo ctdb : codeBoList) {
                this.wrapAppsParam(appInfo.getAppId(), ctdb);
                String package_prefix2 = this.getPackagePrefix(ctdb);
                this.produceCodeFile("XXXEnum.java", "types", "src/main/java/" + package_prefix2 + "/" + GenTypesTask.formatClassPath(appCode) + "/types/", appInfo, ctdb);
            }
        }
        SrvErrorMappingDTO srvErrorMapping = new SrvErrorMappingDTO();
        srvErrorMapping.setAppId(appInfo.getAppId());
        List dictErrorInfoList = this.srvErrorMappingService.queryList((Object)srvErrorMapping);
        if (CollectionUtils.isNotEmpty((Collection)dictErrorInfoList)) {
            CodeTemplateDataBo errorCode = new CodeTemplateDataBo();
            TmProjectInfoBo tpib = new TmProjectInfoBo();
            tpib.setProjectId(appInfo.getAppCode());
            tpib.setProjectCode(appInfo.getAppCode());
            tpib.setProjectName(appInfo.getAppName());
            errorCode.setTmProjectInfo(tpib);
            errorCode.getEnvBo().setAuthor(loginUserId);
            errorCode.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
            errorCode.getEnvBo().setDesc(String.format("%s Types Error Enum", appInfo.getAppName()));
            errorCode.getMapData().put("tableModelCode", appInfo.getAppCode());
            errorCode.getMapData().put("errorClassName", TmModelUtil.tableCodeToClassName((String)appInfo.getAppCode()));
            errorCode.getMapData().put("dicts", dictErrorInfoList);
            this.wrapAppsParam(appInfo.getAppId(), errorCode);
            package_prefix = this.getPackagePrefix(errorCode);
            this.produceCodeFile("XXXErrorEnum.java", "types", "src/main/java/" + package_prefix + "/" + GenTypesTask.formatClassPath(appCode) + "/types/", appInfo, errorCode);
        }
        CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
        TmProjectInfoBo pomTp = new TmProjectInfoBo();
        pomTp.setProjectId(appInfo.getAppCode());
        pomTp.setProjectCode(appInfo.getAppCode());
        pomTp.setProjectName(appInfo.getAppName());
        pomBo.setTmProjectInfo(pomTp);
        this.wrapAppsParam(appInfo.getAppId(), pomBo);
        package_prefix = this.getPackagePrefix(pomBo);
        this.produceCodeFile("types-pom.xml", "", "types-", "types", "", appInfo, pomBo);
        return true;
    }
}

