/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.acl.repository.PaasEcsInfoRepository;
import com.irdstudio.allinapaas.deliver.console.domain.entity.PaasEcsInfoDO;
import com.irdstudio.allinapaas.design.console.acl.repository.PaasTemplateInfoRepository;
import com.irdstudio.allinapaas.design.console.acl.repository.PaasTemplateParamRepository;
import com.irdstudio.allinapaas.design.console.acl.repository.SSubsDatasourceRepository;
import com.irdstudio.allinapaas.design.console.domain.entity.PaasAppsInfoDO;
import com.irdstudio.allinapaas.design.console.domain.entity.PaasAppsSqlDO;
import com.irdstudio.allinapaas.design.console.domain.entity.PaasTemplateInfoDO;
import com.irdstudio.allinapaas.design.console.domain.entity.PaasTemplateParamDO;
import com.irdstudio.allinapaas.design.console.domain.entity.SSubsDatasourceDO;
import com.irdstudio.allinapaas.design.console.facade.PaasTemplateComService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateComDTO;
import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.portal.console.application.service.task.AppTemplateRepoPullTask;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskComimportService;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskInfoService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskComimportDTO;
import com.irdstudio.allinapaas.portal.console.types.BizDbOption;
import com.irdstudio.allinapaas.portal.console.types.DataStdFlag;
import com.irdstudio.allinrdm.dam.console.facade.ModelFolderInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableIndexService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelFolderInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableIndexDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.QueryDatasourceService;
import com.irdstudio.allinrdm.dev.console.facade.dto.QueryDatasourceDTO;
import com.irdstudio.allinrdm.dev.console.types.PageImportType;
import com.irdstudio.allinrdm.sam.console.types.ComDependType;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeModuleInitTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(InvokeModuleInitTask.class);
    private PaasAppsInfoDO appInfo;
    private List<PaasAppsSqlDO> sqlList;
    private ModelTableInfoService modelTableInfoService;
    private ModelTableFieldService modelTableFieldService;
    private ModelTableIndexService modelTableIndexService;
    private PaasTemplateComService paasTemplateComService;
    private PaasTaskComimportService paasTaskComimportService;
    private PaasTaskInfoService paasTaskInfoService;

    public InvokeModuleInitTask(PaasAppsInfoDO appInfo, List<PaasAppsSqlDO> sqlList) {
        this.appInfo = appInfo;
        this.sqlList = sqlList;
        this.modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
        this.modelTableFieldService = (ModelTableFieldService)SpringContextUtils.getBean(ModelTableFieldService.class);
        this.modelTableIndexService = (ModelTableIndexService)SpringContextUtils.getBean(ModelTableIndexService.class);
        this.paasTaskComimportService = (PaasTaskComimportService)SpringContextUtils.getBean(PaasTaskComimportService.class);
        this.paasTaskInfoService = (PaasTaskInfoService)SpringContextUtils.getBean(PaasTaskInfoService.class);
        this.paasTemplateComService = (PaasTemplateComService)SpringContextUtils.getBean(PaasTemplateComService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteRtnInfo call() throws Exception {
        String moduleCode;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        PaasEcsInfoRepository paasEcsInfoRepository = (PaasEcsInfoRepository)SpringContextUtils.getBean(PaasEcsInfoRepository.class);
        PaasTemplateInfoRepository paasTemplateInfoRepository = (PaasTemplateInfoRepository)SpringContextUtils.getBean(PaasTemplateInfoRepository.class);
        if (this.appInfo == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.sqlList)) {
            this.sqlList = new ArrayList<PaasAppsSqlDO>();
        }
        PaasTemplateInfoDO templateParam = new PaasTemplateInfoDO();
        templateParam.setAppTemplateId(this.appInfo.getAppTemplateId());
        PaasTemplateInfoDO templateInfo = (PaasTemplateInfoDO)paasTemplateInfoRepository.queryByPk((Object)templateParam);
        if (templateInfo == null) {
            return null;
        }
        this.invokeModuleInterface(templateInfo);
        AppTemplateRepoPullTask templateRepoPullTask = new AppTemplateRepoPullTask(templateInfo.getAppTemplateId(), templateInfo.getAppTemplateGitUrl());
        templateRepoPullTask.syncRun();
        String appTemplatePath = templateRepoPullTask.getAppTemplatePath();
        File templateScriptDir = new File(appTemplatePath, templateInfo.getAppTemplateId() + "-script");
        File createDbSqlFile = new File(templateScriptDir, "create_db.sql");
        if (createDbSqlFile.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(createDbSqlFile);
                String createDbSqlContent = IOUtils.toString((InputStream)input, (String)"UTF-8");
                this.createModelTableInfoBySQL(this.appInfo.getAppId(), null, ObjectType.Table.getCode(), this.appInfo.getCreateUser(), createDbSqlContent);
            }
            catch (Exception e) {
                try {
                    logger.error("\u8bfb\u53d6\u5e94\u7528\u6a21\u677f\u4ed3\u5e93 \u8868\u6a21\u578b\u811a\u672c\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        File createAppSqlFile = new File(templateScriptDir, "create_app.sql");
        String createAppSqlContent = null;
        if (createAppSqlFile.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(createAppSqlFile);
                createAppSqlContent = IOUtils.toString((InputStream)input, (String)"UTF-8");
                PaasAppsSqlDO createDbSql = new PaasAppsSqlDO();
                createDbSql.setAppId(this.appInfo.getAppId());
                createDbSql.setExecuteStage("1");
                createDbSql.setSqlContent(createAppSqlContent);
                this.sqlList.add(createDbSql);
            }
            catch (Exception e) {
                try {
                    logger.error("\u8bfb\u53d6\u5e94\u7528\u6a21\u677f\u4ed3\u5e93\u521b\u5efa\u5e94\u7528\u65f6\u6267\u884c\u811a\u672c\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        PaasTemplateComDTO comParam = new PaasTemplateComDTO();
        comParam.setAppTemplateId(this.appInfo.getAppTemplateId());
        List comList = this.paasTemplateComService.queryList((Object)comParam);
        if (CollectionUtils.isNotEmpty((Collection)comList)) {
            ArrayList<PaasTaskComimportDTO> comImportTask = new ArrayList<PaasTaskComimportDTO>();
            for (PaasTemplateComDTO com : comList) {
                PaasTaskComimportDTO comImport = new PaasTaskComimportDTO();
                BeanUtility.beanCopy((Object)com, (Object)comImport, (boolean)true);
                comImport.setTaskType("C01001");
                comImport.setAppId(this.appInfo.getAppId());
                comImport.setAppCode(this.appInfo.getAppCode());
                comImport.setAppName(this.appInfo.getAppName());
                comImport.setSubsId(this.appInfo.getSubsId());
                comImport.setTaskName(String.format("%s-%s-%s", com.getComDomainName(), com.getComGroupName(), com.getComName()));
                comImport.setTaskId(UUIDUtil.getShortUUID());
                comImport.setComSubsId(com.getSubsId());
                comImport.setComDependType(ComDependType.Static.getCode());
                comImport.setPageImportType(PageImportType.DOT_NOT_IMPORT.getCode());
                comImport.setPackagePrefix("com.irdstudio");
                comImport.setCreateUser(this.appInfo.getCreateUser());
                comImport.setCreateTime(this.appInfo.getCreateTime());
                comImport.setLastUpdateUser(this.appInfo.getCreateUser());
                comImport.setLastUpdateTime(this.appInfo.getCreateTime());
                comImportTask.add(comImport);
                this.paasTaskComimportService.insert((Object)comImport);
            }
            for (PaasTaskComimportDTO task : comImportTask) {
                this.paasTaskInfoService.executeTask(task.getTaskId(), this.appInfo.getCreateUser());
            }
        }
        if (StringUtils.equalsAny((CharSequence)(moduleCode = templateInfo.getModuleCode()), (CharSequence[])new CharSequence[]{"apdpaas", "radpaas"})) {
            DataSource dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
            int count = 0;
            Connection conn = null;
            try {
                conn = dataSource.getConnection();
                if (CollectionUtils.isNotEmpty(this.sqlList)) {
                    for (PaasAppsSqlDO appSql : this.sqlList) {
                        String sql = appSql.getSqlContent();
                        sql = ExpressionUtil.parse((String)sql, (Object)this.appInfo);
                        ScriptRunner sr = new ScriptRunner(conn);
                        BufferedReader reader = new BufferedReader(new StringReader(sql));
                        sr.runScript((Reader)reader);
                        ++count;
                    }
                }
            }
            catch (Exception e) {
                logger.error(moduleCode + e.getMessage(), (Throwable)e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        logger.error("\u6267\u884c\u5e94\u7528\u521d\u59cb\u5316\u811a\u672c\u65f6\uff0c\u5173\u95ed\u8fde\u63a5\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                    }
                }
            }
            return null;
        }
        PaasEcsInfoDO portalEcs = new PaasEcsInfoDO();
        portalEcs.setEnvId("pedestal");
        portalEcs.setPaasDuId("D000001");
        portalEcs.setAppCodeLike(moduleCode);
        portalEcs.setSubsId("AllinPaas");
        List ecsList = paasEcsInfoRepository.queryListByPage((Object)portalEcs);
        if (CollectionUtils.isNotEmpty((Collection)ecsList)) {
            HashMap<String, Object> reqData = new HashMap<String, Object>();
            reqData.put("root", this.appInfo);
            reqData.put("sql", this.sqlList);
            for (PaasEcsInfoDO ecs : ecsList) {
                String ecsPortString;
                String ecsIpString = ecs.getEcsIp();
                if (ecsIpString.isEmpty() || (ecsPortString = ecs.getEcsPort()).isEmpty()) continue;
                String urlString = "http://" + ecsIpString + ":" + ecsPortString + "/" + ecs.getAppCode() + "/openapi/app/init/sql/exec";
                HttpPost syncPost = new HttpPost(urlString);
                StringEntity createEntity = new StringEntity(JSON.toJSONString(reqData), "UTF-8");
                syncPost.setHeader("Content-Type", "application/json;charset=UTF-8");
                syncPost.setEntity((HttpEntity)createEntity);
                try {
                    HttpResponse response = httpClient.execute((HttpUriRequest)syncPost);
                    String json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    logger.info(moduleCode + "\u5e94\u7528\u521b\u5efa\u65f6\u8c03\u7528\u63a7\u5236\u53f0\u5e94\u7528\u521d\u59cb\u5316\u811a\u672c\u6267\u884c\u63a5\u53e3\u8fd4\u56de {}", (Object)json);
                }
                catch (Exception e) {
                    logger.error(moduleCode + e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private String trimBackquote(String str) {
        if (StringUtils.startsWith((CharSequence)str, (CharSequence)"`")) {
            str = StringUtils.removeStart((String)str, (String)"`");
        }
        if (StringUtils.endsWith((CharSequence)str, (CharSequence)"`")) {
            str = StringUtils.removeEnd((String)str, (String)"`");
        }
        return str.toLowerCase();
    }

    public List<ModelTableInfoDTO> createModelTableInfoBySQL(String projectId, String packageId, String objectType, String userId, String sql) {
        String createTime = CurrentDateUtil.getTodayDateEx2();
        String createUser = userId;
        if (StringUtils.isBlank((CharSequence)sql)) {
            return null;
        }
        sql = sql.replaceFirst("##", "--");
        try {
            ArrayList<ModelTableInfoDTO> tableList = new ArrayList<ModelTableInfoDTO>();
            Statements stats = CCJSqlParserUtil.parseStatements((String)sql);
            for (Statement sqlParse : stats.getStatements()) {
                if (sqlParse instanceof CreateTable) {
                    CreateTable createTb = (CreateTable)sqlParse;
                    ModelTableInfoDTO newTable = new ModelTableInfoDTO();
                    newTable.setObjectId(UUIDUtil.getUUID());
                    newTable.setAppId(projectId);
                    newTable.setFolderId(packageId);
                    newTable.setObjectType(Integer.valueOf(objectType));
                    newTable.setCreateUser(createUser);
                    newTable.setCreateTime(createTime);
                    newTable.setLastModifyUser(createUser);
                    newTable.setLastModifyTime(createTime);
                    newTable.setObjectCode(this.trimBackquote(createTb.getTable().getName()));
                    if (createTb.getTableOptionsStrings() != null) {
                        for (int i = 0; i < createTb.getTableOptionsStrings().size(); ++i) {
                            String val = ((String)createTb.getTableOptionsStrings().get(i)).toString();
                            if (val == null || !val.equalsIgnoreCase("COMMENT") || i + 2 >= createTb.getTableOptionsStrings().size()) continue;
                            String comment = ((String)createTb.getTableOptionsStrings().get(i + 2)).toString();
                            comment = comment.replaceAll("'", "");
                            newTable.setObjectName(comment);
                            break;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)newTable.getObjectName())) {
                        newTable.setObjectName(newTable.getObjectCode());
                    }
                    this.modelTableInfoService.insert((Object)newTable);
                    ModelTableIndexDTO primaryKey = null;
                    if (createTb.getIndexes() != null) {
                        for (Index index : createTb.getIndexes()) {
                            ModelTableIndexDTO modelTableIndex = new ModelTableIndexDTO();
                            modelTableIndex.setObjectId(newTable.getObjectId());
                            modelTableIndex.setCreateTime(createTime);
                            modelTableIndex.setCreateUser(createUser);
                            modelTableIndex.setIndexName(index.getName());
                            ArrayList<String> indexCols = new ArrayList<String>();
                            for (String col : index.getColumnsNames()) {
                                indexCols.add(this.trimBackquote(col));
                            }
                            modelTableIndex.setIndexFields(StringUtils.join(indexCols, (String)",").toLowerCase());
                            if (index.getType().toUpperCase().startsWith("PRIMARY ")) {
                                modelTableIndex.setIndexTypePrimary("Y");
                                modelTableIndex.setIndexTypeUnique("N");
                                modelTableIndex.setIndexName(String.format("PK_%s", newTable.getObjectCode()).toUpperCase());
                                primaryKey = modelTableIndex;
                            } else if (index.getType().toUpperCase().startsWith("UNIQUE ")) {
                                modelTableIndex.setIndexTypePrimary("N");
                                modelTableIndex.setIndexTypeUnique("Y");
                                if (StringUtils.isBlank((CharSequence)index.getName())) {
                                    modelTableIndex.setIndexName(String.format("UK_%s_%s", newTable.getObjectCode(), StringUtils.join(indexCols, (String)"_")).toUpperCase());
                                }
                            } else {
                                modelTableIndex.setIndexTypePrimary("N");
                                modelTableIndex.setIndexTypeUnique("N");
                            }
                            this.modelTableIndexService.insert((Object)modelTableIndex);
                        }
                    }
                    if (createTb.getColumnDefinitions() != null) {
                        int order = 1;
                        for (ColumnDefinition col : createTb.getColumnDefinitions()) {
                            ModelTableFieldDTO field = new ModelTableFieldDTO();
                            field.setFieldId(UUIDUtil.getUUID());
                            field.setObjectId(newTable.getObjectId());
                            field.setCreateUser(createUser);
                            field.setCreateTime(createTime);
                            field.setFieldCode(this.trimBackquote(col.getColumnName()));
                            field.setFieldOrder(Integer.valueOf(order++));
                            field.setIsAllowNull("Y");
                            if (col.getColumnSpecs() != null) {
                                for (int i = 0; i < col.getColumnSpecs().size(); ++i) {
                                    String val = (String)col.getColumnSpecs().get(i);
                                    if (val != null && val.equalsIgnoreCase("NOT") && ((String)col.getColumnSpecs().get(i + 1)).equalsIgnoreCase("NULL")) {
                                        field.setIsAllowNull("N");
                                        ++i;
                                        continue;
                                    }
                                    if (val != null && val.equalsIgnoreCase("NULL")) {
                                        field.setIsAllowNull("Y");
                                        continue;
                                    }
                                    if (val == null || !val.equalsIgnoreCase("COMMENT") || i + 1 >= col.getColumnSpecs().size()) continue;
                                    val = (String)col.getColumnSpecs().get(i + 1);
                                    val = val.replaceAll("'", "");
                                    field.setFieldName(val);
                                    field.setFieldDesc(val);
                                    ++i;
                                }
                            }
                            field.setFieldType(col.getColDataType().getDataType());
                            if (col.getColDataType().getArgumentsStringList() != null && col.getColDataType().getArgumentsStringList().size() > 0) {
                                String len = (String)col.getColDataType().getArgumentsStringList().get(0);
                                field.setFieldLength(Integer.valueOf(len));
                                if (col.getColDataType().getArgumentsStringList().size() > 1) {
                                    field.setFieldPrecision(Integer.valueOf((String)col.getColDataType().getArgumentsStringList().get(1)));
                                }
                            }
                            if (primaryKey != null && primaryKey.getIndexFields().contains(field.getFieldCode().toLowerCase())) {
                                field.setIsPk("Y");
                            } else {
                                field.setIsPk("N");
                            }
                            field.setDataStdFlag(DataStdFlag.Auto.getCode());
                            this.modelTableFieldService.insert((Object)field);
                        }
                    }
                    tableList.add(newTable);
                    continue;
                }
                logger.error("sql \u4e0d\u662fcreate table\u8bed\u6cd5 {}", (Object)sql);
            }
            return tableList;
        }
        catch (JSQLParserException e) {
            logger.error("sql \u89e3\u6790\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void invokeModuleInterface(PaasTemplateInfoDO templateInfo) {
        if (StringUtils.equals((CharSequence)templateInfo.getModuleCode(), (CharSequence)"ncdpaas") && StringUtils.equals((CharSequence)this.appInfo.getAppType(), (CharSequence)AppType.C01.getCode()) && StringUtils.equalsAny((CharSequence)this.appInfo.getBizDbOption(), (CharSequence[])new CharSequence[]{BizDbOption.SelfDB.getCode(), BizDbOption.ShareDB.getCode()})) {
            QueryDatasourceDTO queryDatasource = new QueryDatasourceDTO();
            queryDatasource.setAppId(this.appInfo.getAppId());
            QueryDatasourceService queryDatasourceService = (QueryDatasourceService)SpringContextUtils.getBean(QueryDatasourceService.class);
            SSubsDatasourceRepository sSubsDatasourceRepository = (SSubsDatasourceRepository)SpringContextUtils.getBean(SSubsDatasourceRepository.class);
            ModelFolderInfoService modelFolderInfoService = (ModelFolderInfoService)SpringContextUtils.getBean(ModelFolderInfoService.class);
            PaasEcsInfoRepository paasEcsInfoRepository = (PaasEcsInfoRepository)SpringContextUtils.getBean(PaasEcsInfoRepository.class);
            PaasTemplateParamRepository paasTemplateParamRepository = (PaasTemplateParamRepository)SpringContextUtils.getBean(PaasTemplateParamRepository.class);
            PaasTemplateParamDO templateParam = new PaasTemplateParamDO();
            templateParam.setAppTemplateId(templateInfo.getAppTemplateId());
            templateParam.setSize(Integer.valueOf(1000));
            List templateParamList = paasTemplateParamRepository.queryList((Object)templateParam);
            String database_username = "";
            String database_password = "";
            if (CollectionUtils.isNotEmpty((Collection)templateParamList)) {
                for (PaasTemplateParamDO param : templateParamList) {
                    if (StringUtils.equals((CharSequence)param.getParamCode(), (CharSequence)"database_username")) {
                        database_username = param.getParamValue();
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)param.getParamCode(), (CharSequence)"database_password")) continue;
                    database_password = param.getParamValue();
                }
            }
            String currEnvId = "dev";
            PaasEcsInfoDO ecsParam = new PaasEcsInfoDO();
            ecsParam.setSize(Integer.valueOf(100));
            ecsParam.setSubsId(this.appInfo.getSubsId());
            ecsParam.setAppId(this.appInfo.getAppId());
            ecsParam.setEnvId(currEnvId);
            ecsParam.setPaasDuId("G000001");
            List ecsList = paasEcsInfoRepository.queryListByPage((Object)ecsParam);
            if (CollectionUtils.isEmpty((Collection)ecsList)) {
                ecsParam = new PaasEcsInfoDO();
                ecsParam.setSubsId(this.appInfo.getSubsId());
                ecsParam.setEnvId(currEnvId);
                ecsParam.setPaasDuId("G000001");
                ecsList = paasEcsInfoRepository.queryListByPage((Object)ecsParam);
            }
            if (CollectionUtils.isEmpty((Collection)ecsList)) {
                ecsParam = new PaasEcsInfoDO();
                ecsParam.setEnvId(currEnvId);
                ecsParam.setPaasDuId("G000001");
                ecsList = paasEcsInfoRepository.queryListByPage((Object)ecsParam);
            }
            if (CollectionUtils.isNotEmpty((Collection)ecsList)) {
                PaasEcsInfoDO ecsInfo = (PaasEcsInfoDO)ecsList.get(0);
                String ecsIp = ecsInfo.getEcsIp();
                String ecsPort = ecsInfo.getEcsPort();
                String databaseName = this.appInfo.getBizDbName();
                String dbName = this.appInfo.getBizDbCnname();
                String dbms = this.appInfo.getBizDbDbms();
                queryDatasource.setDsName(dbName);
                queryDatasource.setDsDbms(Integer.valueOf(NumberUtils.toInt((String)dbms, (int)425)));
                queryDatasource.setDsCode(databaseName);
                queryDatasource.setDsDbName(databaseName);
                queryDatasource.setDsConnStr(String.format("jdbc:mysql://%s:%s/%s", ecsIp, ecsPort, databaseName));
                queryDatasource.setDsUsername(database_username);
                queryDatasource.setDsPassword(database_password);
                queryDatasource.setDsSchemaName(databaseName);
                queryDatasource.setLoginUserId(this.appInfo.getCreateUser());
                queryDatasource.setCreateUser(queryDatasource.getLoginUserId());
                queryDatasource.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                queryDatasourceService.insert((Object)queryDatasource);
                SSubsDatasourceDO subsDatasourceVO = new SSubsDatasourceDO();
                subsDatasourceVO.setSubsId(this.appInfo.getSubsId());
                subsDatasourceVO.setSubsDsCode(queryDatasource.getDsCode());
                subsDatasourceVO.setSubsDsName(queryDatasource.getDsName());
                subsDatasourceVO.setDsConnStr(queryDatasource.getDsConnStr());
                subsDatasourceVO.setDsUserId(queryDatasource.getDsUsername());
                subsDatasourceVO.setDsUserPwd(queryDatasource.getDsPassword());
                subsDatasourceVO.setDsDbName(queryDatasource.getDsDbName());
                subsDatasourceVO.setSubsDsType(queryDatasource.getDsDbms().toString());
                subsDatasourceVO.setAppId(this.appInfo.getAppId());
                subsDatasourceVO.setRefDsId(queryDatasource.getDsId());
                sSubsDatasourceRepository.insert((Object)subsDatasourceVO);
                ModelFolderInfoDTO dsPackage = new ModelFolderInfoDTO();
                dsPackage.setFolderId(queryDatasource.getDsId());
                dsPackage.setFolderCode(queryDatasource.getDsCode());
                dsPackage.setFolderName(queryDatasource.getDsName());
                dsPackage.setFolderType(ObjectType.Table.getIntCode());
                dsPackage.setAppId(this.appInfo.getAppId());
                dsPackage.setFolderAbvId(this.appInfo.getAppId());
                modelFolderInfoService.insert((Object)dsPackage);
            } else {
                logger.error("\u4f4e\u4ee3\u7801\u5f00\u53d1\u5e73\u53f0 \u5e94\u7528\u521b\u5efa \u521b\u5efa\u9ed8\u8ba4\u6570\u636e\u6e90\u5f02\u5e38 \u5e94\u7528\u4ea4\u4ed8\u5f00\u53d1\u73af\u5883\u672a\u914d\u7f6e\u6709\u6570\u636e\u5e93\u670d\u52a1\u5668\uff0c \u672a\u521b\u5efa\u9ed8\u8ba4\u6570\u636e\u6e90 " + this.appInfo.getAppId());
            }
        }
    }
}

