/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.impl;

import com.irdstudio.allinapaas.design.console.acl.repository.PaasAppsMeasureRepository;
import com.irdstudio.allinapaas.design.console.domain.entity.PaasAppsMeasureDO;
import com.irdstudio.allinapaas.portal.console.acl.repository.SummaryRepository;
import com.irdstudio.allinapaas.portal.console.facade.SummaryService;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.util.ReflectUtility;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service(value="summaryServiceImpl")
public class SummaryServiceImpl
implements SummaryService,
FrameworkService {
    private static final Logger logger = LoggerFactory.getLogger(SummaryServiceImpl.class);
    @Autowired
    private SummaryRepository summaryRepository;
    @Autowired
    private PaasAppsMeasureRepository paasAppsMeasureRepository;

    public SummaryRepository getRepository() {
        return this.summaryRepository;
    }

    public List<Map<String, Object>> querySummaryByMapperId(String method, Map<String, Object> params) {
        return this.getRepository().querySummaryByMapperId(method, params);
    }

    public void updateMeasure(String method, Map<String, Object> params) {
        String appId = MapUtils.getString(params, (Object)"appId");
        PaasAppsMeasureDO measure = new PaasAppsMeasureDO();
        measure.setAppId(appId);
        List summaryList = this.summaryRepository.querySummaryByMapperId(method, params);
        if (CollectionUtils.isNotEmpty((Collection)summaryList)) {
            int re;
            boolean updateFlag = false;
            for (Map map : summaryList) {
                String fieldName = MapUtils.getString((Map)map, (Object)"name");
                String valStr = MapUtils.getString((Map)map, (Object)"num");
                if (valStr == null) continue;
                Object val = valStr;
                Field field = ReflectionUtils.findField(measure.getClass(), (String)fieldName);
                if (field == null) continue;
                Class<?> paramType = field.getType();
                if (paramType == Integer.class) {
                    val = Integer.parseInt(valStr);
                } else if (paramType == BigDecimal.class) {
                    val = new BigDecimal(valStr);
                }
                ReflectUtility.invokeSetter((Object)measure, (String)fieldName, (Object)val, (boolean)false);
                updateFlag = true;
            }
            if (updateFlag && (re = this.paasAppsMeasureRepository.updateByPk((Object)measure)) == 0) {
                re = this.paasAppsMeasureRepository.insert((Object)measure);
            }
        }
    }
}

