/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDependency;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.application.service.task.BaseGenTask;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GenS01StartTask
extends BaseGenTask {
    @Autowired
    protected PaasEnvInfoService paasEnvInfoService;

    @Override
    public boolean execute(PaasAppsInfoDTO appInfo) {
        String loginUserId = appInfo.getLoginUserId();
        String subsId = appInfo.getSubsId();
        Map e4aMap = Collections.emptyMap();
        CodeTemplateDataBo bo = new CodeTemplateDataBo();
        TmProjectInfoBo tpib = new TmProjectInfoBo();
        tpib.setProjectId(appInfo.getAppCode());
        tpib.setProjectCode(appInfo.getAppCode());
        tpib.setProjectName(appInfo.getAppName());
        bo.setTmProjectInfo(tpib);
        bo.getEnvBo().setAuthor(loginUserId);
        bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
        bo.getEnvBo().setDesc(String.format("%s Application", appInfo.getAppName()));
        bo.getMapData().put("e4a", e4aMap);
        this.wrapAppsParam(appInfo.getAppId(), bo);
        Map appParams = (Map)bo.getMapData().get("appsParam");
        String appId = appInfo.getAppId();
        String appCode = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
        String package_prefix = MapUtils.getString((Map)appParams, (Object)"package_prefix", (String)"com.irdstudio");
        String newAppCode = StringUtils.replace((String)appCode, (String)"-", (String)".");
        String replacePackage = package_prefix + "." + newAppCode;
        SSubsInfoDTO sSubsInfo = new SSubsInfoDTO();
        sSubsInfo.setSubsId(appInfo.getSubsId());
        sSubsInfo = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)sSubsInfo);
        List<OsrvArrangeDependency> dependencies = this.querySubsSDKDependencies(sSubsInfo);
        bo.getMapData().put("sdkList", dependencies);
        bo.getMapData().put("tableModelCode", appCode.replaceAll("-", "_"));
        bo.getMapData().put("tableCodeToClassName", TmModelUtil.tableCodeToClassName((String)appCode.replaceAll("-", "_")));
        if (StringUtils.equalsAny((CharSequence)appInfo.getAppTemplateId(), (CharSequence[])new CharSequence[]{"dynpage"})) {
            String targetPath = SdEnvUtil.PROJECT_PATH + appId + File.separator + String.format("%s-%s", appCode, "start").replace(".", "-") + File.separator + "src/main/java/" + GenS01StartTask.formatClassPath(package_prefix) + "/" + GenS01StartTask.formatClassPath(appCode) + "/start/";
            File securityConfigFile = new File(targetPath + File.separator + "config", "SecurityConfig.java");
            File fadpaasConsoleApplicationFile = new File(targetPath, "FadpaasConsoleApplication.java");
            File dynpageCode = new File(SdEnvUtil.PROJECT_PATH + appId + File.separator, "dynpage-code");
            File dynpageScript = new File(SdEnvUtil.PROJECT_PATH + appId + File.separator, "dynpage-script");
            FileUtils.deleteQuietly((File)securityConfigFile);
            FileUtils.deleteQuietly((File)fadpaasConsoleApplicationFile);
            FileUtils.deleteQuietly((File)dynpageCode);
            FileUtils.deleteQuietly((File)dynpageScript);
            this.produceCodeFile("domain-pom.xml", "", "domain-", "domain", "", appInfo, bo);
            this.produceCodeFile("facade-pom.xml", "", "facade-", "facade", "", appInfo, bo);
            this.produceCodeFile("web-pom.xml", "", "web-", "web", "", appInfo, bo);
            this.produceCodeFile("project-pom.xml", "", "project-", null, "", appInfo, bo);
        }
        if (!StringUtils.equalsAny((CharSequence)appInfo.getAppTemplateId(), (CharSequence[])new CharSequence[]{"S01MOD", "A13SPR"})) {
            bo.getMapData().put("appCodes", Collections.emptyList());
            this.produceCodeFile("XXXApplication.java", "start", "src/main/java/" + GenS01StartTask.formatClassPath(package_prefix) + "/" + GenS01StartTask.formatClassPath(appCode) + "/start/", appInfo, bo);
            this.produceCodeFile("DruidConfig.java", "", "", "start", "src/main/java/" + GenS01StartTask.formatClassPath(package_prefix) + "/" + GenS01StartTask.formatClassPath(appCode) + "/start/config/", appInfo, bo);
            this.produceCodeFile("TransactionAspConfig.java", "", "", "start", "src/main/java/" + GenS01StartTask.formatClassPath(package_prefix) + "/" + GenS01StartTask.formatClassPath(appCode) + "/start/config/", appInfo, bo);
            this.produceCodeFile("start-pom.xml", "", "start-", "start", "", appInfo, bo);
            this.produceCodeFile("XXXAutoConfiguration.java", "autoconfigure", "src/main/java/" + GenS01StartTask.formatClassPath(package_prefix) + "/" + GenS01StartTask.formatClassPath(appCode) + "/autoconfigure/", appInfo, bo);
            this.produceCodeFile("spring.factories", "autoconfigure", "src/main/resources/META-INF/", appInfo, bo);
        }
        return true;
    }
}

