/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeBlockAssign;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeClassContext;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeContext;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDeclareVar;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDependency;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeImport;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeMethod;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.application.service.task.BaseGenTask;
import com.irdstudio.allinapaas.portal.console.types.ArchType;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeSectionService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeTableService;
import com.irdstudio.allinrdm.dev.console.facade.SrvErrorMappingService;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeSectionDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeTableDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvErrorMappingDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInoutDTO;
import com.irdstudio.allinrdm.dev.console.types.DataServiceModelEnum;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SectionType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GenWebTask
extends BaseGenTask {
    @Autowired
    protected SrvErrorMappingService srvErrorMappingService;
    @Autowired
    protected OsrvArrangeSectionService osrvArrangeSectionService;
    @Autowired
    protected OsrvArrangeTableService osrvArrangeTableService;

    @Override
    public boolean execute(PaasAppsInfoDTO appInfo) {
        String loginUserId = appInfo.getLoginUserId();
        String appCode = appInfo.getAppCode();
        ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>();
        SrvModelInfoDTO modelParam = new SrvModelInfoDTO();
        modelParam.setAppId(appInfo.getAppId());
        modelParam.setSrvModelId(appInfo.getSrvModelId());
        modelParam.setSrvModelCatalogs(Arrays.asList(SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
        List modelList = this.srvModelInfoService.queryList((Object)modelParam);
        SrvErrorMappingDTO errorMappingParam = new SrvErrorMappingDTO();
        errorMappingParam.setAppId(appInfo.getAppId());
        List errorCodeList = this.srvErrorMappingService.queryList((Object)errorMappingParam);
        boolean hasErrorMapping = CollectionUtils.isNotEmpty((Collection)errorCodeList);
        String errorClassName = TmModelUtil.tableCodeToClassName((String)appInfo.getAppCode());
        TmProjectInfoBo tpib = new TmProjectInfoBo();
        tpib.setProjectId(appInfo.getAppCode());
        tpib.setProjectCode(appInfo.getAppCode());
        tpib.setProjectName(appInfo.getAppName());
        PaasAppsInfo executoerAppInfo = this.beanCopy((Object)appInfo, PaasAppsInfo.class);
        HashMap<String, OsrvArrangeClassContext> clsCtxMap = new HashMap<String, OsrvArrangeClassContext>();
        if (CollectionUtils.isNotEmpty((Collection)modelList)) {
            OsrvArrangeClassContext clsCtx;
            for (SrvModelInfoDTO srvModelInfoDTO : modelList) {
                SrvModelInfo executorModel = this.beanCopy((Object)srvModelInfoDTO, SrvModelInfo.class);
                String className = TmModelUtil.modelCodeToClassName((String)srvModelInfoDTO.getSrvModelCode());
                Object clsCtx2 = (OsrvArrangeClassContext)clsCtxMap.get(className + srvModelInfoDTO.getSrvModelCatalog());
                if (clsCtx2 == null) {
                    clsCtx2 = new OsrvArrangeClassContext(executoerAppInfo, srvModelInfoDTO.getSrvModelCatalog(), null);
                    clsCtx2.setClassName(className);
                    clsCtxMap.put(className + srvModelInfoDTO.getSrvModelCatalog(), (OsrvArrangeClassContext)clsCtx2);
                }
                OsrvArrangeContext osrvCtx = new OsrvArrangeContext(executoerAppInfo, executorModel, null);
                osrvCtx.setTableClassName(className);
                SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
                inoutParam.setSrvModelId(srvModelInfoDTO.getSrvModelId());
                inoutParam.setIoType(IOType.Input.getCode());
                List inputParams = this.srvModelInoutService.queryList((Object)inoutParam);
                inoutParam.setIoType(IOType.Output.getCode());
                List outputParams = this.srvModelInoutService.queryList((Object)inoutParam);
                this.initOsrvCtx(osrvCtx, inputParams, outputParams);
                OsrvArrangeImport serviceImport = new OsrvArrangeImport();
                serviceImport.setImportType(OsrvArrangeImport.ImportType.Facade.getCode());
                serviceImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
                serviceImport.setClassName(className + clsCtx2.getServiceSuffix());
                osrvCtx.addImport(serviceImport);
                clsCtx2.getMethodCtxList().add(osrvCtx);
            }
            for (Map.Entry entry : clsCtxMap.entrySet()) {
                clsCtx = (OsrvArrangeClassContext)entry.getValue();
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(loginUserId);
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s %s", appInfo.getAppName(), clsCtx.getClassName()));
                bo.getMapData().put("clsCtx", clsCtx);
                for (OsrvArrangeContext osrvCtx : clsCtx.getMethodCtxList()) {
                    clsCtx.addImport(osrvCtx.getImportList());
                }
                ctdbList.add(bo);
            }
            for (CodeTemplateDataBo codeTemplateDataBo : ctdbList) {
                clsCtx = (OsrvArrangeClassContext)codeTemplateDataBo.getMapData().get("clsCtx");
                clsCtx.setHasErrorMapping(Boolean.valueOf(hasErrorMapping));
                clsCtx.setErrorClassName(errorClassName);
                OsrvArrangeImport serviceInput_import = new OsrvArrangeImport();
                serviceInput_import.setClassName("ServiceInput");
                serviceInput_import.setProjectCode(tpib.getProjectCode());
                serviceInput_import.setImportType(this.judgeTableToClassName("ServiceInput", ObjectType.Common.getCode(), null));
                clsCtx.addImport(serviceInput_import);
                OsrvArrangeImport serviceOutput_import = new OsrvArrangeImport();
                serviceOutput_import.setClassName("ServiceOutput");
                serviceOutput_import.setProjectCode(tpib.getProjectCode());
                serviceOutput_import.setImportType(this.judgeTableToClassName("ServiceOutput", ObjectType.Common.getCode(), null));
                clsCtx.addImport(serviceOutput_import);
                this.wrapAppsParam(appInfo.getAppId(), codeTemplateDataBo);
                String package_prefix = this.getPackagePrefix(codeTemplateDataBo);
                if (!StringUtils.equals((CharSequence)ArchType.SpringCloud.getCode(), (CharSequence)appInfo.getArchType())) continue;
                this.produceCodeFile("XXXOsrvAppAPIController.java", clsCtx.getClassName() + clsCtx.getServiceSuffix(), "XXXOsrvAppAPI", "web", "src/main/java/" + package_prefix + "/" + GenWebTask.formatClassPath(appCode).replaceAll("_|-", ".") + "/web/controller/api/", appInfo, codeTemplateDataBo);
            }
        }
        SSubsInfoDTO sSubsInfo = new SSubsInfoDTO();
        sSubsInfo.setSubsId(appInfo.getSubsId());
        sSubsInfo = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)sSubsInfo);
        List<OsrvArrangeDependency> list = this.querySubsSDKDependencies(sSubsInfo);
        CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
        pomBo.setTmProjectInfo(tpib);
        pomBo.getMapData().put("sdkList", list);
        this.wrapAppsParam(appInfo.getAppId(), pomBo);
        String package_prefix = this.getPackagePrefix(pomBo);
        this.produceCodeFile("web-pom.xml", "", "web-", "web", "", appInfo, pomBo);
        return true;
    }

    private void initOsrvCtx(OsrvArrangeContext osrvCtx, List<SrvModelInoutDTO> inputParams, List<SrvModelInoutDTO> outputParams) {
        OsrvArrangeMethod method = new OsrvArrangeMethod();
        osrvCtx.setMethod(method);
        if (StringUtils.isNotBlank((CharSequence)osrvCtx.getSrvModelInfo().getSrvModelMethod())) {
            method.setMethodName(osrvCtx.getSrvModelInfo().getSrvModelMethod());
        } else {
            method.setMethodName("handle");
        }
        this.getOsrvMethod(osrvCtx, inputParams, outputParams);
        this.bServiceHandler(osrvCtx);
    }

    private void getOsrvMethod(OsrvArrangeContext osrvCtx, List<SrvModelInoutDTO> inputParams, List<SrvModelInoutDTO> outputParams) {
        SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(osrvCtx.getConn());
        OsrvArrangeMethod method = osrvCtx.getMethod();
        SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
        inoutParam.setSrvModelId(osrvCtx.getSrvModelInfo().getSrvModelId());
        String input = this.getMethodParam(inputParams, osrvCtx, "Input");
        method.setInputListFlag(YesOrNO.NO.getCode());
        method.setInputBigFlag(YesOrNO.YES.getCode());
        String mainParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), method.getMethodName(), IOType.Input);
        SrvModelInoutDTO inputInout = null;
        for (SrvModelInoutDTO inout : inputParams) {
            if (!StringUtils.equals((CharSequence)inout.getTableModelCode(), (CharSequence)mainParam)) continue;
            inputInout = inout;
        }
        mainParam = inputInout != null ? this.wrapperTableToClassName(inputInout.getTableModelCode(), inputInout.getObjectType().toString(), inputInout.getTableModelId()) : this.wrapperTableToClassName(mainParam, ObjectType.Inout.getCode(), null);
        method.setMainInput("input.getInput()");
        method.setInput(input);
        if (StringUtils.equals((CharSequence)osrvCtx.getSrvModelInfo().getSrvModelCatalog(), (CharSequence)SrvModelCatalogEnum.BackServer.getCode())) {
            OsrvArrangeBlockAssign setUserInfoToVOStat = new OsrvArrangeBlockAssign();
            setUserInfoToVOStat.setComment("\u5f53\u524d\u7528\u6237\u4fe1\u606f");
            setUserInfoToVOStat.setStatement(String.format("setUserInfoToVO(input.get%sVO());", "UserTokenInfo"));
            setUserInfoToVOStat.setAppendSemicolon(false);
            osrvCtx.getCommFieldAssignList().add(setUserInfoToVOStat);
        }
        String mainOutputParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), method.getMethodName(), IOType.Output);
        String output = this.getMethodParam(outputParams, osrvCtx, "Output");
        method.setOutputListFlag(YesOrNO.NO.getCode());
        method.setOutputBigFlag(YesOrNO.YES.getCode());
        SrvModelInoutDTO outputInout = null;
        for (SrvModelInoutDTO inout : outputParams) {
            if (!StringUtils.equals((CharSequence)inout.getTableModelCode(), (CharSequence)mainOutputParam)) continue;
            outputInout = inout;
        }
        mainOutputParam = outputInout != null ? this.wrapperTableToClassName(outputInout.getTableModelCode(), outputInout.getObjectType().toString(), outputInout.getTableModelId()) : this.wrapperTableToClassName(mainOutputParam, ObjectType.Inout.getCode(), null);
        method.setOutput(output);
    }

    private void bServiceHandler(OsrvArrangeContext osrvCtx) {
        SrvModelInfo model = osrvCtx.getSrvModelInfo();
        if (!StringUtils.equals((CharSequence)model.getSrvModelCatalog(), (CharSequence)SrvModelCatalogEnum.BackServer.getCode()) || StringUtils.equals((CharSequence)model.getSrvModelType(), (CharSequence)SrvModelTypeEnum.CUSTOM_BACK_SERVICE.getType())) {
            return;
        }
        OsrvArrangeSectionDTO sectionParam = new OsrvArrangeSectionDTO();
        sectionParam.setAppId(osrvCtx.getAppInfo().getAppId());
        sectionParam.setSrvModelId(model.getSrvModelId());
        List sectionList = this.osrvArrangeSectionService.queryList((Object)sectionParam);
        ArrayList<OsrvArrangeSectionDTO> rootList = new ArrayList<OsrvArrangeSectionDTO>(sectionList.size());
        for (OsrvArrangeSectionDTO s : sectionList) {
            if (s.getSectionType().equals(SectionType.ReferenceSection.getCode()) || StringUtils.isNotBlank((CharSequence)s.getSectionAbvId())) continue;
            rootList.add(s);
        }
        if (rootList.isEmpty()) {
            return;
        }
        OsrvArrangeSectionDTO rootSection = (OsrvArrangeSectionDTO)rootList.get(0);
        OsrvArrangeTableDTO osrvTableParam = new OsrvArrangeTableDTO();
        osrvTableParam.setSrvModelId(model.getSrvModelId());
        osrvTableParam.setSectionId(rootSection.getSectionId());
        List osrvTableList = this.osrvArrangeTableService.queryList((Object)osrvTableParam);
        if (osrvTableList.size() < 2) {
            return;
        }
        String dId = ((OsrvArrangeTableDTO)osrvTableList.get(0)).getRowOpTargetId();
        SrvModelInfoDTO dServiceParam = new SrvModelInfoDTO();
        dServiceParam.setSrvModelId(dId);
        SrvModelInfoDTO dService = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)dServiceParam);
        if (!StringUtils.equals((CharSequence)dService.getSrvModelCatalog(), (CharSequence)SrvModelCatalogEnum.SrvServer.getCode())) {
            return;
        }
        OsrvArrangeDeclareVar defaultInput = null;
        OsrvArrangeDeclareVar dServiceInput = null;
        OsrvArrangeDeclareVar dServiceOutput = null;
        OsrvArrangeDeclareVar dataServicePageInfo = null;
        String mainParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), osrvCtx.getMethod().getMethodName(), IOType.Input);
        if (StringUtils.equals((CharSequence)osrvCtx.getSrvModelInfo().getSrvModelCatalog(), (CharSequence)SrvModelCatalogEnum.BackServer.getCode())) {
            String tableModelCode = osrvCtx.getSrvModelInfo().getTableModelCode() + "_input";
            mainParam = TmModelUtil.tableCodeToClassName((String)tableModelCode);
        }
        SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
        inoutParam.setSrvModelId(model.getSrvModelId());
        List inoutList = this.srvModelInoutService.queryList((Object)inoutParam);
        for (SrvModelInoutDTO inout : inoutList) {
            if (!StringUtils.equals((CharSequence)inout.getTableModelCode(), (CharSequence)mainParam)) continue;
            defaultInput = new OsrvArrangeDeclareVar(this.beanCopy((Object)inout, SrvModelInout.class));
            String className = this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
            String varName = "input";
            defaultInput.setVarName(varName);
            defaultInput.setVarClassName(className);
        }
        inoutParam.setSrvModelId(dService.getSrvModelId());
        List dInoutList = this.srvModelInoutService.queryList((Object)inoutParam);
        DataServiceModelEnum modelEnum = DataServiceModelEnum.getModelByType((String)dService.getSrvModelType());
        for (SrvModelInoutDTO inout : dInoutList) {
            OsrvArrangeImport domainImport;
            String varName;
            String varClassName = this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
            String importType = this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
            if (StringUtils.equals((CharSequence)inout.getIoType(), (CharSequence)IOType.Input.getCode()) && !inout.getObjectType().equals(ObjectType.Common.getIntCode())) {
                dServiceInput = new OsrvArrangeDeclareVar(this.beanCopy((Object)inout, SrvModelInout.class));
                String className = varClassName;
                String varName2 = StringUtils.uncapitalize((String)className);
                dServiceInput.setVarName(varName2);
                dServiceInput.setVarClassName(className);
                OsrvArrangeImport domainImport2 = new OsrvArrangeImport();
                domainImport2.setImportType(importType);
                domainImport2.setClassName(className);
                domainImport2.setProjectCode(osrvCtx.getAppInfo().getAppCode());
                osrvCtx.addImport(domainImport2);
                continue;
            }
            if (StringUtils.equals((CharSequence)inout.getIoType(), (CharSequence)IOType.Input.getCode()) && StringUtils.equals((CharSequence)"PageInfo", (CharSequence)inout.getTableModelCode())) {
                dataServicePageInfo = new OsrvArrangeDeclareVar(this.beanCopy((Object)inout, SrvModelInout.class));
                varName = StringUtils.uncapitalize((String)varClassName);
                dataServicePageInfo.setVarName(varName);
                dataServicePageInfo.setVarClassName(varClassName);
                domainImport = new OsrvArrangeImport();
                domainImport.setImportType(importType);
                domainImport.setClassName(varClassName);
                domainImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
                osrvCtx.addImport(domainImport);
                continue;
            }
            if (!StringUtils.equals((CharSequence)inout.getIoType(), (CharSequence)IOType.Output.getCode())) continue;
            dServiceOutput = new OsrvArrangeDeclareVar(this.beanCopy((Object)inout, SrvModelInout.class));
            varName = "output";
            dServiceOutput.setVarName(varName);
            dServiceOutput.setVarClassName(varClassName);
            domainImport = new OsrvArrangeImport();
            domainImport.setImportType(importType);
            domainImport.setClassName(varClassName);
            domainImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
            osrvCtx.addImport(domainImport);
        }
        osrvCtx.getMethod().setDefaultInput(defaultInput);
        osrvCtx.getMethod().setDataServiceInput(dServiceInput);
        osrvCtx.getMethod().setDataServiceOutput(dServiceOutput);
        osrvCtx.getMethod().setDataServicePageInfo(dataServicePageInfo);
    }
}

