/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginConfGit;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class GitPullTask {
    private ILogger logger = null;
    private PluginConfGit pluginParam = null;
    private String gitLocalPath = null;
    private String gitLocalPathFileName;
    private String mediumUrl;
    private String gitlabName;
    private String gitlabPwd;

    public GitPullTask(String gitUrl, ILogger logger) {
        this.mediumUrl = gitUrl;
        this.logger = logger;
    }

    public boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone((String)localPath, (String)remotePath, (String)username, (String)password, (String)branchName, arg_0 -> ((ILogger)this.logger).info(arg_0));
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    this.logger.error((Object)("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage()), (Throwable)e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    protected boolean init() {
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        this.pluginParam = new PluginConfGit();
        this.pluginParam.setGitUserName(paasEnvParamService.queryEnvParamByCodeReturnValue("git.dev.template.store.username").getParamValue());
        this.pluginParam.setGitPassword(paasEnvParamService.queryEnvParamByCodeReturnValue("git.dev.template.store.password").getParamValue());
        this.gitlabName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.username").getParamValue();
        this.gitlabPwd = paasEnvParamService.queryEnvParamByCodeReturnValue("git.password").getParamValue();
        this.pluginParam.setGitBranchName(paasEnvParamService.queryEnvParamByCodeReturnValue("git.prjtemplate.branch.name").getParamValue());
        this.gitLocalPath = SdEnvUtil.TEMPLATE_PATH;
        return this.pluginParam != null && this.gitLocalPath != null;
    }

    public boolean execute() {
        this.logger.info((Object)"........................................................................");
        boolean flag = true;
        flag = this.init();
        if (!flag) {
            return flag;
        }
        if (this.gitLocalPath != null) {
            this.logger.info((Object)String.format("\u83b7\u53d6\u5b89\u88c5\u4ecb\u8d28 %s", this.mediumUrl));
            String name = this.mediumUrl.substring(this.mediumUrl.lastIndexOf("/") + 1, this.mediumUrl.lastIndexOf(".git"));
            String localMediumPath = name + "-medium";
            this.gitLocalPathFileName = this.gitLocalPath + localMediumPath;
            this.repositoryCreate(this.gitLocalPathFileName, this.mediumUrl, this.gitlabName, this.gitlabPwd, this.pluginParam.getGitBranchName());
            return flag;
        }
        return false;
    }

    public String gitPath() {
        return this.gitLocalPathFileName;
    }
}

