/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.quality.console.application.service.check.scheme.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.quality.console.application.service.check.conn.IConnPool;
import com.irdstudio.allinapaas.quality.console.application.service.check.conn.ProxySQL;
import com.irdstudio.allinapaas.quality.console.application.service.check.scheme.inf.CheckJavaRule;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDtlDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDtlService;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultService;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckRuleDTO;
import com.irdstudio.allinapaas.quality.console.types.CheckResult;
import com.irdstudio.allinapaas.quality.console.types.RuleResult;
import com.irdstudio.allinapaas.quality.console.types.YesOrNO;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexRule
implements CheckJavaRule {
    private static final Logger logger = LoggerFactory.getLogger(RegexRule.class);
    private ConcurrentHashMap<String, List<Map<String, Object>>> cache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(String serialNo, SCheckRuleDTO rule, Map<String, Object> param, IConnPool connTool) {
        SCheckResultDTO ruleResult = new SCheckResultDTO();
        ruleResult.setSerialNo(serialNo);
        ruleResult.setSchemeNo(rule.getSchemeNo());
        ruleResult.setRuleId(rule.getRuleId());
        ruleResult.setRuleName(rule.getRuleName());
        RuleResult flag = RuleResult.Pass;
        ArrayList<SCheckResultDtlDTO> ruleResultDtlList = new ArrayList<SCheckResultDtlDTO>();
        boolean genDtl = StringUtils.equals((CharSequence)rule.getRuleGenDtl(), (CharSequence)YesOrNO.YES.getCode());
        String json = rule.getRuleContent();
        Map jsonData = null;
        try {
            jsonData = (Map)JSON.parseObject((String)json, Map.class);
        }
        catch (Exception e) {
            logger.error("\u6b63\u5219\u8868\u8fbe\u5f0f\u6821\u9a8c\u5185\u5bb9\u89e3\u6790\u5f02\u5e38 {} {}", new Object[]{json, e.getMessage(), e});
        }
        if (jsonData == null) {
            flag = RuleResult.Fail;
        } else {
            String regex = MapUtils.getString((Map)jsonData, (Object)"exp");
            String target = MapUtils.getString((Map)jsonData, (Object)"target");
            List<Map<String, Object>> testRsList = null;
            switch (target) {
                case "subsCode": 
                case "subsName": {
                    String checkDesc;
                    CheckResult cr;
                    String val;
                    HashMap<String, Object> root;
                    testRsList = this.querySubs(param, connTool);
                    if (CollectionUtils.isEmpty(testRsList)) {
                        flag = RuleResult.Pass;
                        break;
                    }
                    String testExp = rule.getRuleSucCondition();
                    String errorMsgExp = rule.getRuleErrDesc();
                    for (Map<String, Object> re : testRsList) {
                        root = new HashMap<String, Object>();
                        root.putAll(param);
                        root.put("$result", re);
                        val = MapUtils.getString(re, (Object)target);
                        cr = Pattern.compile(regex).matcher(val).matches() ? CheckResult.Pass : CheckResult.Fail;
                        if (cr == CheckResult.Pass) continue;
                        flag = RuleResult.Fail;
                        if (!genDtl) continue;
                        SCheckResultDtlDTO sCheckResultDtlDTO = new SCheckResultDtlDTO();
                        sCheckResultDtlDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                        sCheckResultDtlDTO.setCheckResult(cr.getCode());
                        checkDesc = ExpressionUtil.parse((String)errorMsgExp, root);
                        sCheckResultDtlDTO.setCheckDesc(checkDesc);
                        ruleResultDtlList.add(sCheckResultDtlDTO);
                    }
                    break;
                }
                case "appCode": 
                case "appName": {
                    String checkDesc;
                    CheckResult cr;
                    String val;
                    HashMap<String, Object> root;
                    testRsList = this.queryApp(param, connTool);
                    if (CollectionUtils.isEmpty(testRsList)) {
                        flag = RuleResult.Pass;
                        break;
                    }
                    String testExp = rule.getRuleSucCondition();
                    String errorMsgExp = rule.getRuleErrDesc();
                    for (Map<String, Object> re : testRsList) {
                        root = new HashMap();
                        root.putAll(param);
                        root.put("$result", re);
                        val = MapUtils.getString(re, (Object)target);
                        cr = Pattern.compile(regex).matcher(val).matches() ? CheckResult.Pass : CheckResult.Fail;
                        if (cr == CheckResult.Pass) continue;
                        flag = RuleResult.Fail;
                        if (!genDtl) continue;
                        SCheckResultDtlDTO sCheckResultDtlDTO = new SCheckResultDtlDTO();
                        sCheckResultDtlDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                        sCheckResultDtlDTO.setCheckResult(cr.getCode());
                        checkDesc = ExpressionUtil.parse((String)errorMsgExp, root);
                        sCheckResultDtlDTO.setCheckDesc(checkDesc);
                        ruleResultDtlList.add(sCheckResultDtlDTO);
                    }
                    break;
                }
                case "objectCode": 
                case "objectName": {
                    String objectName;
                    String objectCode;
                    String objectId;
                    String checkDesc;
                    CheckResult cr;
                    String val;
                    HashMap<String, Object> root;
                    List<Map<String, Object>> tableList;
                    HashMap<String, Object> tableParam;
                    testRsList = this.queryApp(param, connTool);
                    if (CollectionUtils.isEmpty(testRsList)) {
                        flag = RuleResult.Pass;
                        break;
                    }
                    String testExp = rule.getRuleSucCondition();
                    String errorMsgExp = rule.getRuleErrDesc();
                    for (Map<String, Object> app : testRsList) {
                        tableParam = new HashMap<String, Object>();
                        tableParam.putAll(param);
                        tableParam.putAll(app);
                        tableList = this.queryTable(tableParam, connTool);
                        if (!CollectionUtils.isNotEmpty(tableList)) continue;
                        for (Map map : tableList) {
                            root = new HashMap<String, Object>();
                            root.putAll(tableParam);
                            root.put("$result", map);
                            val = MapUtils.getString((Map)map, (Object)target);
                            cr = Pattern.compile(regex).matcher(val).matches() ? CheckResult.Pass : CheckResult.Fail;
                            if (cr == CheckResult.Pass) continue;
                            flag = RuleResult.Fail;
                            if (!genDtl) continue;
                            SCheckResultDtlDTO sCheckResultDtlDTO = new SCheckResultDtlDTO();
                            sCheckResultDtlDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                            sCheckResultDtlDTO.setCheckResult(cr.getCode());
                            checkDesc = ExpressionUtil.parse((String)errorMsgExp, root);
                            sCheckResultDtlDTO.setCheckDesc(checkDesc);
                            objectId = MapUtils.getString((Map)map, (Object)"objectId");
                            objectCode = MapUtils.getString((Map)map, (Object)"objectCode");
                            objectName = MapUtils.getString((Map)map, (Object)"objectName");
                            sCheckResultDtlDTO.setObjectId(objectId);
                            sCheckResultDtlDTO.setObjectCode(objectCode);
                            sCheckResultDtlDTO.setObjectName(objectName);
                            ruleResultDtlList.add(sCheckResultDtlDTO);
                        }
                    }
                    break;
                }
                case "fieldCode": 
                case "fieldName": {
                    List<Map<String, Object>> tableList;
                    HashMap<String, Object> tableParam;
                    testRsList = this.queryApp(param, connTool);
                    if (CollectionUtils.isEmpty(testRsList)) {
                        flag = RuleResult.Pass;
                        break;
                    }
                    String testExp = rule.getRuleSucCondition();
                    String errorMsgExp = rule.getRuleErrDesc();
                    for (Map<String, Object> app : testRsList) {
                        tableParam = new HashMap();
                        tableParam.putAll(param);
                        tableParam.putAll(app);
                        tableList = this.queryTable(tableParam, connTool);
                        if (!CollectionUtils.isNotEmpty(tableList)) continue;
                        for (Map map : tableList) {
                            tableParam.putAll(map);
                            HashMap<String, Object> fieldParam = new HashMap<String, Object>();
                            fieldParam.putAll(tableParam);
                            List<Map<String, Object>> fieldList = this.queryField(fieldParam, connTool);
                            if (!CollectionUtils.isNotEmpty(fieldList)) continue;
                            for (Map map2 : fieldList) {
                                HashMap<String, Object> root = new HashMap<String, Object>();
                                root.putAll(fieldParam);
                                root.putAll(map);
                                root.put("$result", map2);
                                String val = MapUtils.getString((Map)map2, (Object)target, (String)"");
                                CheckResult cr = Pattern.compile(regex).matcher(val).matches() ? CheckResult.Pass : CheckResult.Fail;
                                if (cr == CheckResult.Pass) continue;
                                flag = RuleResult.Fail;
                                if (!genDtl) continue;
                                SCheckResultDtlDTO dtl = new SCheckResultDtlDTO();
                                dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                                dtl.setCheckResult(cr.getCode());
                                String checkDesc = ExpressionUtil.parse((String)errorMsgExp, root);
                                dtl.setCheckDesc(checkDesc);
                                String objectId = MapUtils.getString((Map)map, (Object)"objectId");
                                String objectCode = MapUtils.getString((Map)map, (Object)"objectCode");
                                String objectName = MapUtils.getString((Map)map, (Object)"objectName");
                                dtl.setObjectId(objectId);
                                dtl.setObjectCode(objectCode);
                                dtl.setObjectName(objectName);
                                ruleResultDtlList.add(dtl);
                            }
                        }
                    }
                    break;
                }
                case "srvModelCode": 
                case "srvModelName": {
                    String objectName;
                    String objectCode;
                    String objectId;
                    String checkDesc;
                    CheckResult cr;
                    String val;
                    HashMap<String, Object> root;
                    testRsList = this.queryApp(param, connTool);
                    if (CollectionUtils.isEmpty(testRsList)) {
                        flag = RuleResult.Pass;
                        break;
                    }
                    String testExp = rule.getRuleSucCondition();
                    String errorMsgExp = rule.getRuleErrDesc();
                    for (Map<String, Object> app : testRsList) {
                        HashMap<String, Object> srvParam = new HashMap<String, Object>();
                        srvParam.putAll(param);
                        srvParam.putAll(app);
                        List<Map<String, Object>> srvList = this.querySrvModelInfo(srvParam, connTool);
                        if (!CollectionUtils.isNotEmpty(srvList)) continue;
                        for (Map map : srvList) {
                            root = new HashMap();
                            root.putAll(srvParam);
                            root.put("$result", map);
                            val = MapUtils.getString((Map)map, (Object)target);
                            cr = Pattern.compile(regex).matcher(val).matches() ? CheckResult.Pass : CheckResult.Fail;
                            if (cr == CheckResult.Pass) continue;
                            flag = RuleResult.Fail;
                            if (!genDtl) continue;
                            SCheckResultDtlDTO sCheckResultDtlDTO = new SCheckResultDtlDTO();
                            sCheckResultDtlDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                            sCheckResultDtlDTO.setCheckResult(cr.getCode());
                            checkDesc = ExpressionUtil.parse((String)errorMsgExp, root);
                            sCheckResultDtlDTO.setCheckDesc(checkDesc);
                            objectId = MapUtils.getString((Map)map, (Object)"tableModelId");
                            objectCode = MapUtils.getString((Map)map, (Object)"tableModelCode");
                            objectName = MapUtils.getString((Map)map, (Object)"tableModelName");
                            sCheckResultDtlDTO.setObjectId(objectId);
                            sCheckResultDtlDTO.setObjectCode(objectCode);
                            sCheckResultDtlDTO.setObjectName(objectName);
                            ruleResultDtlList.add(sCheckResultDtlDTO);
                        }
                    }
                    break;
                }
            }
        }
        ruleResult.setRuleResult(flag.getCode());
        ruleResult.setCreateUser(rule.getLoginUserId());
        ruleResult.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            SCheckResultService sCheckResultService = (SCheckResultService)SpringContextUtils.getBean(SCheckResultService.class);
            SCheckResultDtlService sCheckResultDtlService = (SCheckResultDtlService)SpringContextUtils.getBean(SCheckResultDtlService.class);
            sCheckResultService.insert((Object)ruleResult);
            if (CollectionUtils.isNotEmpty(ruleResultDtlList)) {
                for (SCheckResultDtlDTO dtl : ruleResultDtlList) {
                    String subsId = MapUtils.getString(param, (Object)"subsId");
                    String subsCode = MapUtils.getString(param, (Object)"subsCode");
                    String subsName = MapUtils.getString(param, (Object)"subsName");
                    String appId = MapUtils.getString(param, (Object)"appId");
                    String appCode = MapUtils.getString(param, (Object)"appCode");
                    String appName = MapUtils.getString(param, (Object)"appName");
                    String appType = MapUtils.getString(param, (Object)"appType");
                    String string = UUIDUtil.getUUID();
                    dtl.setSerialNo(serialNo);
                    dtl.setRuleId(rule.getRuleId());
                    dtl.setRuleName(rule.getRuleName());
                    dtl.setDtlId(string);
                    dtl.setAppId(appId);
                    dtl.setAppCode(appCode);
                    dtl.setAppName(appName);
                    dtl.setSubsId(subsId);
                    dtl.setSubsCode(subsCode);
                    dtl.setSubsName(subsName);
                    dtl.setAppType(appType);
                    dtl.setCreateUser(rule.getLoginUserId());
                }
                sCheckResultDtlService.batchInsert(ruleResultDtlList);
            }
        }
        catch (Exception e) {
            logger.error("sql\u6821\u9a8c\u63d2\u4ef6\u4fdd\u5b58\u6821\u9a8c\u7ed3\u679c\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
        return flag == RuleResult.Pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> querySubs(Map<String, Object> paramVO, IConnPool connTool) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            final String subsId = MapUtils.getString(paramVO, (Object)"subsId");
            final ArrayList param = new ArrayList();
            String sql = new ProxySQL(){
                {
                    this.SELECT("*");
                    this.FROM("s_subs_info");
                    this.WHERE("subs_id = ?");
                    param.add(subsId);
                }
            }.toString();
            PreparedStatement ps = null;
            ResultSet rs = null;
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Map map = POJOUtils.generateMap((ResultSet)rs);
                list.add(map);
            }
            ps.close();
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7cfb\u7edf\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
            List<Map<String, Object>> list = Collections.emptyList();
            return list;
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> queryApp(Map<String, Object> paramVO, IConnPool connTool) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            final String subsId = MapUtils.getString(paramVO, (Object)"subsId");
            final String appId = MapUtils.getString(paramVO, (Object)"appId");
            final ArrayList param = new ArrayList();
            String sql = new ProxySQL(){
                {
                    this.SELECT("*");
                    this.FROM("paas_apps_info");
                    this.WHERE("subs_id = ?");
                    param.add(subsId);
                    if (StringUtils.isNotBlank((CharSequence)appId)) {
                        this.WHERE("(app_id = ? or ref_db_appid = ? )");
                        param.add(appId);
                        param.add(appId);
                    }
                }
            }.toString();
            PreparedStatement ps = null;
            ResultSet rs = null;
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Map map = POJOUtils.generateMap((ResultSet)rs);
                list.add(map);
            }
            ps.close();
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e94\u7528\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
            List<Map<String, Object>> list = Collections.emptyList();
            return list;
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> queryTable(Map<String, Object> paramVO, IConnPool connTool) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            final String subsId = MapUtils.getString(paramVO, (Object)"subsId");
            final String appId = MapUtils.getString(paramVO, (Object)"appId");
            final String objectId = MapUtils.getString(paramVO, (Object)"objectId");
            final ArrayList param = new ArrayList();
            String sql = new ProxySQL(){
                {
                    this.SELECT("*");
                    this.FROM("`allinrdm_db`.model_table_info");
                    this.WHERE("object_type != 3002");
                    this.WHERE("app_id in ( select app_id from paas_apps_info where subs_id = ?)");
                    param.add(subsId);
                    if (StringUtils.isNotBlank((CharSequence)appId)) {
                        this.WHERE("app_id in ( select app_id from paas_apps_info where (app_id = ? or ref_db_appid = ? ))");
                        param.add(appId);
                        param.add(appId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)objectId)) {
                        this.WHERE("object_id = ?");
                        param.add(objectId);
                    }
                }
            }.toString();
            PreparedStatement ps = null;
            ResultSet rs = null;
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Map map = POJOUtils.generateMap((ResultSet)rs);
                list.add(map);
            }
            ps.close();
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8868\u6a21\u578b\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
            List<Map<String, Object>> list = Collections.emptyList();
            return list;
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> queryField(Map<String, Object> paramVO, IConnPool connTool) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            final String subsId = MapUtils.getString(paramVO, (Object)"subsId");
            final String appId = MapUtils.getString(paramVO, (Object)"appId");
            final String objectId = MapUtils.getString(paramVO, (Object)"objectId");
            final ArrayList param = new ArrayList();
            String sql = new ProxySQL(){
                {
                    this.SELECT("*");
                    this.FROM("`allinrdm_db`.model_table_field");
                    this.WHERE("object_id in ( select object_id from `allinrdm_db`.model_table_info where app_id in ( select app_id from paas_apps_info where subs_id = ?))");
                    param.add(subsId);
                    if (StringUtils.isNotBlank((CharSequence)appId)) {
                        this.WHERE("object_id in ( select object_id from `allinrdm_db`.model_table_info where app_id in ( select app_id from paas_apps_info where (app_id = ? or ref_db_appid = ? )))");
                        param.add(appId);
                        param.add(appId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)objectId)) {
                        this.WHERE("object_id = ?");
                        param.add(objectId);
                    }
                }
            }.toString();
            String cacheKey = param.stream().collect(Collectors.joining(","));
            if (this.cache.containsKey(cacheKey)) {
                List<Map<String, Object>> list = this.cache.get(cacheKey);
                return list;
            }
            PreparedStatement ps = null;
            ResultSet rs = null;
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Map map = POJOUtils.generateMap((ResultSet)rs);
                list.add(map);
            }
            ps.close();
            this.cache.put(cacheKey, list);
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8868\u6a21\u578b\u5b57\u6bb5\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
            List<Map<String, Object>> list = Collections.emptyList();
            return list;
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> querySrvModelInfo(Map<String, Object> paramVO, IConnPool connTool) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            final String subsId = MapUtils.getString(paramVO, (Object)"subsId");
            final String appId = MapUtils.getString(paramVO, (Object)"appId");
            final ArrayList param = new ArrayList();
            String sql = new ProxySQL(){
                {
                    this.SELECT("*");
                    this.FROM("`allinrdm_db`.srv_model_info");
                    this.WHERE("app_id in ( select app_id from paas_apps_info where subs_id = ? )");
                    param.add(subsId);
                    if (StringUtils.isNotBlank((CharSequence)appId)) {
                        this.WHERE("(app_id = ? or ref_db_appid = ? )");
                        param.add(appId);
                        param.add(appId);
                    }
                }
            }.toString();
            PreparedStatement ps = null;
            ResultSet rs = null;
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Map map = POJOUtils.generateMap((ResultSet)rs);
                list.add(map);
            }
            ps.close();
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u670d\u52a1\u6a21\u578b\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
            List<Map<String, Object>> list = Collections.emptyList();
            return list;
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
    }
}

