/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsParamDTO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasAppsParamController
extends BaseController<PaasAppsParamDTO, PaasAppsParamService> {
    @RequestMapping(value={"/api/paas/apps/params"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsParamDTO>> queryPaasAppsParamAll(PaasAppsParamDTO vo) {
        List outputVo = ((PaasAppsParamService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/param/{appId}/{paramCode}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasAppsParamDTO> queryByPk(@PathVariable(value="appId") String appId, @PathVariable(value="paramCode") String paramCode) {
        PaasAppsParamDTO inVo = new PaasAppsParamDTO();
        inVo.setAppId(appId);
        inVo.setParamCode(paramCode);
        PaasAppsParamDTO outputVo = (PaasAppsParamDTO)((PaasAppsParamService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/param/code"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<PaasAppsParamDTO> queryByPkCode(@RequestBody PaasAppsParamDTO paasAppsParamVO) {
        paasAppsParamVO.setLoginUserId(this.getUserInfo().getUserId());
        paasAppsParamVO.setLoginUserOrgCode(this.getUserInfo().getOrgInfo().getOrgCode());
        paasAppsParamVO.setLoginUserLeageOrgCode(this.getUserInfo().getLegalOrg().getOrgCode());
        paasAppsParamVO.setLoginUserOrgLocation(this.getUserInfo().getOrgInfo().getOrgLocation());
        PaasAppsParamDTO outputVo = (PaasAppsParamDTO)((PaasAppsParamService)this.getService()).queryByPk((Object)paasAppsParamVO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/param"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasAppsParamDTO inPaasAppsParamVo) {
        int outputVo = ((PaasAppsParamService)this.getService()).deleteByPk((Object)inPaasAppsParamVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/param"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasAppsParamDTO inPaasAppsParamVo) {
        int outputVo = ((PaasAppsParamService)this.getService()).updateByPk((Object)inPaasAppsParamVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/param"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasAppsParam(@RequestBody PaasAppsParamDTO inPaasAppsParamVo) {
        int outputVo = ((PaasAppsParamService)this.getService()).insert((Object)inPaasAppsParamVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/param/paas/cba/init"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> paasCbaIndependentInit(@RequestParam(value="appId") String appId, @RequestParam(value="subsId") String subsId, @RequestParam(value="cbaCode") String cbaCode) {
        PaasAppsParamDTO inVo = new PaasAppsParamDTO();
        inVo.setAppId(appId);
        List outputVo = ((PaasAppsParamService)this.getService()).queryListByPage((Object)inVo);
        String moduleName = "";
        switch (cbaCode) {
            case "paas-deploy-batch": {
                moduleName = "bsp-console-web";
                break;
            }
            case "paas-deploy-flow": {
                moduleName = "bfp-console-start";
                break;
            }
            case "paas-deploy-dmp": {
                moduleName = "dmp-console-web";
                break;
            }
        }
        boolean flag = CollectionUtils.isNotEmpty((Collection)outputVo);
        if (!flag) {
            String init_json = "[\n    { 'paramCode': 'cas_server_url', 'paramName': '\u8ba4\u8bc1\u5730\u5740', 'paramValue': '${env.envCasServer}', 'paramGroup':'DPL', 'paramSource':'E' },\n    { 'paramCode': 'database_name', 'paramName':'\u6570\u636e\u5e93\u540d', 'paramValue':'', 'paramGroup': 'DPL', 'paramSource': 'C' },\n    { 'paramCode': 'database_password', 'paramName':'\u6570\u636e\u5e93\u670d\u52a1\u5668\u5bc6\u7801', 'paramValue':'123456', 'paramGroup':'DPL', 'paramSource':'C' },\n    { 'paramCode': 'database_username', 'paramName':'\u6570\u636e\u5e93\u670d\u52a1\u5668\u7528\u6237\u540d', 'paramValue':'root', 'paramGroup':'DPL', 'paramSource':'C' },\n    { 'paramCode': 'deploy_type', 'paramName':'\u90e8\u7f72\u7c7b\u578b', 'paramValue':'jar', 'paramGroup':'DPL', 'paramSource':'C' },\n    { 'paramCode': 'git.password', 'paramName':'GIT\u5bc6\u7801', 'paramValue':'', 'paramGroup':'DPL', 'paramSource':'C' },\n    { 'paramCode': 'git.username', 'paramName':'GIT\u8d26\u6237', 'paramValue':'', 'paramGroup':'DPL', 'paramSource':'C' },\n    { 'paramCode': 'init_data', 'paramName':'\u672c\u6b21\u662f\u5426\u521d\u59cb\u5316\u6570\u636e\u5e93', 'paramValue':'N', 'paramGroup':'DPL', 'paramSource':'C' },\n    { 'paramCode': 'integer_type', 'paramName':'\u96c6\u6210\u65b9\u5f0f', 'paramValue':'U', 'paramGroup':'DPL', 'paramSource':'C' },\n    { 'paramCode': 'jvm', 'paramName':'jvm\u53c2\u6570', 'paramValue':'-Xms128M -Xmx1024M', 'paramGroup':'DPL', 'paramSource':'C' },\n    { 'paramCode': 'maven_compiler', 'paramName':'maven\u7f16\u8bd1\u53c2\u6570', 'paramValue':'mvn -DskipTests=true clean package -U', 'paramGroup':'DPL', 'paramSource':'C' },\n    { 'paramCode': 'action_shell', 'paramName':'\u542f\u52a8\u811a\u672c', 'paramValue':'startJarApp.sh', 'paramGroup':'DPL', 'paramSource':'C' },\n    { 'paramCode': 'module', 'paramName':'\u6a21\u5757\u540d\u79f0', 'paramValue':'" + moduleName + "', 'paramGroup':'DPL', 'paramSource':'C' }\n]";
            List paramList = JSON.parseArray((String)init_json, PaasAppsParamDTO.class);
            paramList.stream().forEach(param -> param.setAppId(appId));
            ((PaasAppsParamService)this.getService()).batchInsert(paramList);
            flag = true;
        }
        return this.getResponseData(flag);
    }
}

