/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDBDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasAppsInfoController
extends BaseController<PaasAppsInfoDTO, PaasAppsInfoService> {
    private static final Logger logger = LoggerFactory.getLogger(PaasAppsInfoController.class);

    @RequestMapping(value={"/api/paas/apps/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryPaasAppsInfoAll(PaasAppsInfoDTO vo) {
        List outputVo = ((PaasAppsInfoService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/infos/pop/comps"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryMarketPopPageData(PaasAppsInfoDTO vo) {
        List outputVo = ((PaasAppsInfoService)this.getService()).queryMarketPopPageData(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/info/filtrate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryPaasAppsInfos(PaasAppsInfoDTO vo) {
        List outputVo = ((PaasAppsInfoService)this.getService()).queryAllByFiltrate(vo);
        return this.getResponseData(outputVo);
    }

    private Map<String, Object> createAdjustMap(String desc, String before, String after) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("desc", desc);
        map.put("beforeContent", before);
        map.put("afterContent", after);
        return map;
    }

    @RequestMapping(value={"/api/paas/apps/info/{appId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasAppsInfoDTO> queryByPk(@PathVariable(value="appId") String appId) {
        PaasAppsInfoDTO inVo = new PaasAppsInfoDTO();
        inVo.setAppId(appId);
        PaasAppsInfoDTO outputVo = (PaasAppsInfoDTO)((PaasAppsInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasAppsInfoDTO inPaasAppsInfoVo) {
        this.setUserInfoToVO(inPaasAppsInfoVo);
        int outputVo = ((PaasAppsInfoService)this.getService()).deleteByPk((Object)inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasAppsInfoDTO inPaasAppsInfoVo) {
        int outputVo = ((PaasAppsInfoService)this.getService()).updateByPk((Object)inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/info/replace/template"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateAppTemplateIdByPk(@RequestBody PaasAppsInfoDTO inPaasAppsInfoVo) {
        int outputVo = ((PaasAppsInfoService)this.getService()).updateAppTemplateIdByPk(inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/info/subsId"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateBySysCode(@RequestBody PaasAppsInfoDTO inPaasAppsInfoVo) {
        int outputVo = ((PaasAppsInfoService)this.getService()).updateBySubsCode(inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertPaasAppsInfo(@RequestBody PaasAppsInfoDTO inPaasAppsInfoVo) {
        String now = CurrentDateUtil.getTodayDateEx2();
        String userId = this.getUserInfo().getUserId();
        inPaasAppsInfoVo.setCreateUser(userId);
        inPaasAppsInfoVo.setCreateTime(now);
        inPaasAppsInfoVo.setLastUpdateUser(userId);
        inPaasAppsInfoVo.setLastUpdateTime(now);
        inPaasAppsInfoVo.setAppId(UUIDUtil.getUUID());
        int outputVo = ((PaasAppsInfoService)this.getService()).insert((Object)inPaasAppsInfoVo);
        return this.getResponseData(inPaasAppsInfoVo.getAppId());
    }

    @RequestMapping(value={"/api/paas/apps/info/project"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertPaasAppsInfoFromProject(@RequestParam(name="cpAppId", required=false) String cpAppId, @RequestBody PaasAppsInfoDTO inPaasAppsInfoDTO) {
        this.setUserInfoToVO(inPaasAppsInfoDTO);
        String now = CurrentDateUtil.getTodayDateEx2();
        String userId = this.getUserInfo().getUserId();
        String appType = inPaasAppsInfoDTO.getAppType();
        String archType = inPaasAppsInfoDTO.getArchType();
        String subsId = inPaasAppsInfoDTO.getSubsId();
        inPaasAppsInfoDTO.setSubsId(subsId);
        inPaasAppsInfoDTO.setCreateUser(userId);
        inPaasAppsInfoDTO.setCreateTime(now);
        inPaasAppsInfoDTO.setLastUpdateUser(userId);
        inPaasAppsInfoDTO.setLastUpdateTime(now);
        int outputVo = ((PaasAppsInfoService)this.getService()).insert((Object)inPaasAppsInfoDTO);
        return this.getResponseData(inPaasAppsInfoDTO.getAppId());
    }

    @RequestMapping(value={"/api/paas/apps/infos/page/index/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryAppCountByAppCategory(PaasAppsInfoDTO param) {
        List outputVo = ((PaasAppsInfoService)this.getService()).queryAppCountByAppCategory(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/infos/groups"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryAllGroupByPage(PaasAppsInfoDTO vo) {
        List outputVo = ((PaasAppsInfoService)this.getService()).queryAllGroupByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/infos/dbs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDBDTO>> queryDbAppListByPage(PaasAppsInfoDBDTO vo) {
        List outputVo = ((PaasAppsInfoService)this.getService()).queryDbAppListByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/info/seq"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryAppIdSeqWithPrefix(@RequestParam(value="subsId") String subsId) {
        String seq = ((PaasAppsInfoService)this.getService()).queryAppIdSeqWithPrefix(subsId, subsId);
        return this.getResponseData(seq);
    }

    @RequestMapping(value={"/client/PaasAppsInfoService/queryAppIdSeqWithPrefix"}, method={RequestMethod.GET})
    @ResponseBody
    public String queryAppIdSeqWithPrefix_client(@RequestParam(value="subsId") String subsId, @RequestParam(value="prefix") String prefix) {
        return ((PaasAppsInfoService)this.getService()).queryAppIdSeqWithPrefix(subsId, prefix);
    }

    @RequestMapping(value={"/api/paas/apps/infos/notz"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryNotZAppListByPage(PaasAppsInfoDTO param) {
        if (StringUtils.isNotBlank((String)param.getAppType()) && param.getAppType().contains(",")) {
            String[] appTyps = StringUtils.split((String)param.getAppType(), (String)",");
            param.setAppTypes(Arrays.asList(appTyps));
            param.setAppType(null);
        }
        List outputVo = ((PaasAppsInfoService)this.getService()).queryNotZAppListByPage(param);
        return this.getResponseData(outputVo);
    }
}

