/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsLayerService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsLayerDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasAppsLayerController
extends BaseController<PaasAppsLayerDTO, PaasAppsLayerService> {
    @Autowired
    @Qualifier(value="paasAppsLayerServiceImpl")
    private PaasAppsLayerService paasAppsLayerService;
    private final String DEFAULT_LAYER = "DEFAULT-LAYER";

    @RequestMapping(value={"/api/paas/apps/layers"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsLayerDTO>> queryPaasAppsLayerAll(PaasAppsLayerDTO dto) {
        List outputVo = this.paasAppsLayerService.queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/layers/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsLayerDTO>> queryPaasAppsLayerAllNotPage(PaasAppsLayerDTO dto) {
        List outputVo = this.paasAppsLayerService.queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/layer/{subsId}/{layerCode}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasAppsLayerDTO> queryByPk(@PathVariable(value="subsId") String subsId, @PathVariable(value="layerCode") String layerCode) {
        PaasAppsLayerDTO inVo = new PaasAppsLayerDTO();
        inVo.setSubsId(subsId);
        inVo.setLayerCode(layerCode);
        PaasAppsLayerDTO outputVo = (PaasAppsLayerDTO)this.paasAppsLayerService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/layer"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasAppsLayerDTO inPaasAppsLayerDTO) {
        int outputVo = this.paasAppsLayerService.deleteByPk((Object)inPaasAppsLayerDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/layer"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasAppsLayerDTO inPaasAppsLayerDTO) {
        int outputVo = this.paasAppsLayerService.updateByPk((Object)inPaasAppsLayerDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/layer"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasAppsLayer(@RequestBody PaasAppsLayerDTO inPaasAppsLayerDTO) {
        PaasAppsLayerDTO checkParam = new PaasAppsLayerDTO();
        checkParam.setLayerName(inPaasAppsLayerDTO.getLayerName());
        checkParam.setSubsId(inPaasAppsLayerDTO.getSubsId());
        List checkList = this.paasAppsLayerService.queryListByPage((Object)checkParam);
        if (CollectionUtils.isNotEmpty((Collection)checkList)) {
            ResponseData resp = this.getResponseData(-1);
            resp.setMessage("\u540c\u540d\u7684\u5e94\u7528\u5206\u5c42\u4fe1\u606f\u5df2\u5b58\u5728");
            return resp;
        }
        int outputVo = this.paasAppsLayerService.insert((Object)inPaasAppsLayerDTO);
        ResponseData resp = this.getResponseData(outputVo);
        resp.setMessage("\u5e94\u7528\u5206\u5c42\u6807\u8bc6\u5df2\u5b58\u5728");
        return resp;
    }

    @RequestMapping(value={"/client/PaasAppsLayerService/appLayerInit"}, method={RequestMethod.POST})
    public Integer appLayerInit(@RequestBody SSubsInfoDTO subsInfo) {
        PaasAppsLayerDTO layerParam = new PaasAppsLayerDTO();
        layerParam.setSubsId("DEFAULT-LAYER");
        List defaultLayerList = this.paasAppsLayerService.queryListByPage((Object)layerParam);
        if (CollectionUtils.isNotEmpty((Collection)defaultLayerList)) {
            defaultLayerList.stream().forEach(layer -> {
                layer.setSubsId(subsInfo.getSubsId());
                this.paasAppsLayerService.insert(layer);
            });
        }
        return defaultLayerList.size();
    }
}

