/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsPropertiesService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsPropertiesDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasAppsPropertiesController
extends BaseController<PaasAppsPropertiesDTO, PaasAppsPropertiesService> {
    @RequestMapping(value={"/api/paas/apps/propertiess"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsPropertiesDTO>> queryPaasAppsPropertiesAll(PaasAppsPropertiesDTO vo) {
        List outputVo = ((PaasAppsPropertiesService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/properties/{recordKeyid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasAppsPropertiesDTO> queryByPk(@PathVariable(value="recordKeyid") String recordKeyid) {
        PaasAppsPropertiesDTO inVo = new PaasAppsPropertiesDTO();
        inVo.setRecordKeyid(recordKeyid);
        PaasAppsPropertiesDTO outputVo = (PaasAppsPropertiesDTO)((PaasAppsPropertiesService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/properties"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasAppsPropertiesDTO inPaasAppsPropertiesVo) {
        int outputVo = ((PaasAppsPropertiesService)this.getService()).deleteByPk((Object)inPaasAppsPropertiesVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/properties"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasAppsPropertiesDTO inPaasAppsPropertiesVo) {
        inPaasAppsPropertiesVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPaasAppsPropertiesVo.setCreateUser(this.getUserInfo().getUserId());
        int outputVo = ((PaasAppsPropertiesService)this.getService()).updateByPk((Object)inPaasAppsPropertiesVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/properties"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasAppsProperties(@RequestBody PaasAppsPropertiesDTO inPaasAppsPropertiesVo) {
        if (StringUtils.isBlank((CharSequence)inPaasAppsPropertiesVo.getRecordKeyid())) {
            inPaasAppsPropertiesVo.setRecordKeyid(UUIDUtil.getUUID());
        }
        inPaasAppsPropertiesVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPaasAppsPropertiesVo.setCreateUser(this.getUserInfo().getUserId());
        int outputVo = ((PaasAppsPropertiesService)this.getService()).insert((Object)inPaasAppsPropertiesVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/propertie/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> saveList(@RequestBody List<PaasAppsPropertiesDTO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(prop -> {
                if (StringUtils.isBlank((CharSequence)prop.getRecordKeyid())) {
                    prop.setRecordKeyid(UUIDUtil.getUUID());
                }
                prop.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                prop.setCreateUser(this.getUserInfo().getUserId());
            });
            int outputVo = ((PaasAppsPropertiesService)this.getService()).batchInsert(list);
            return this.getResponseData(outputVo);
        }
        return this.getResponseData(0);
    }
}

