/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import com.irdstudio.allinapaas.portal.console.application.service.task.GitRepoPushTask;
import com.irdstudio.allinapaas.portal.console.application.service.utils.JGitUtil;
import com.irdstudio.allintpaas.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintpaas.admin.facade.dto.SUserDTO;
import com.irdstudio.allintpaas.admin.facade.dto.SUserProfileDTO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.GroupParams;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppRepoPushTaskImpl
implements GitRepoPushTask {
    private static Logger logger = LoggerFactory.getLogger(AppRepoPushTaskImpl.class);
    private String loginUserId = null;
    private File dir = null;
    private String repoGitUrl = null;
    private String commitComment = null;
    private PaasAppsInfoDTO appInfo = null;

    public AppRepoPushTaskImpl(String loginUserId, File dir, String repoGitUrl, String commitComment) {
        this.loginUserId = loginUserId;
        this.dir = dir;
        this.repoGitUrl = repoGitUrl;
        this.commitComment = commitComment;
    }

    public AppRepoPushTaskImpl(String loginUserId, File dir, String repoGitUrl, String commitComment, PaasAppsInfoDTO appInfo) {
        this(loginUserId, dir, repoGitUrl, commitComment);
        this.appInfo = appInfo;
    }

    @Override
    public void execute() {
        try {
            if (this.appInfo != null) {
                this.checkAppRepoAndCreate(this.appInfo, this.loginUserId);
            }
            this.commit();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u63a8\u9001\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6267\u884c\u63a8\u9001\u5931\u8d25" + e.getMessage(), e);
        }
    }

    public boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, arg_0 -> ((Logger)logger).info(arg_0));
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    public boolean repositoryPush(String localPath, String remotePath, String username, String password, String branchName) {
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.addAll();
            jGitUtil.commit(this.commitComment + "");
            jGitUtil.push(remotePath, false);
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u4ee3\u7801\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            return false;
        }
        jGitUtil.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commit() throws Exception {
        AllinCloudPortalClient portalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
        SSubsInfoService sSubsInfoService = (SSubsInfoService)SpringContextUtils.getBean(SSubsInfoService.class);
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        String currentUserId = this.loginUserId;
        SUserProfileDTO userProfile = portalClient.querySUserProfileByPk(currentUserId);
        if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            logger.error("************************************\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01************************************");
            return false;
        }
        String userEmail = "";
        SUserDTO user = portalClient.querySUserByPk(currentUserId);
        userEmail = user != null && StringUtils.isNotBlank((CharSequence)user.getUsermail()) ? user.getUsermail() : String.format("%s@%s.com", currentUserId, "irdstudio");
        String gitUserName = userProfile.getGitUsername();
        String gitPassword = userProfile.getGitAccessToken();
        gitPassword = StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken()) ? userProfile.getGitAccessToken() : userProfile.getGitPassword();
        String branchName = paasEnvParamService.queryEnvParamByCodeReturnValue("git.push.branch.name").getParamValue();
        String remoteUrl = this.repoGitUrl;
        if (StringUtils.isBlank((CharSequence)remoteUrl)) {
            return false;
        }
        boolean flag = true;
        String suffix = "-remote";
        String gitLocalPath = this.dir.getAbsolutePath();
        String remoteRepoPath = gitLocalPath + suffix;
        try {
            flag = this.repositoryCreate(remoteRepoPath, remoteUrl, gitUserName, gitPassword, branchName);
            if (!flag) {
                logger.info("\u8fdc\u7a0b\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c \u8def\u5f84\u4e3a\uff1a" + remoteUrl);
                boolean bl = flag;
                return bl;
            }
            File localProjectDir = new File(gitLocalPath);
            if (localProjectDir.exists() && localProjectDir.isDirectory()) {
                File[] localSubDir;
                for (File sub : localSubDir = localProjectDir.listFiles()) {
                    File target = new File(remoteRepoPath, sub.getName());
                    if (sub.isDirectory()) {
                        if (sub.getName().equals(".git")) continue;
                        FileUtils.copyDirectory((File)sub, (File)target);
                        continue;
                    }
                    FileUtils.copyFile((File)sub, (File)target);
                }
            }
            if (flag = this.repositoryPush(remoteRepoPath, remoteUrl, gitUserName, gitPassword, branchName)) {
                logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + remoteUrl);
            } else {
                logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + remoteUrl);
            }
            boolean bl = flag;
            return bl;
        }
        catch (Exception e) {
            flag = false;
        }
        finally {
            FileUtils.deleteQuietly((File)this.dir);
            FileUtils.deleteQuietly((File)new File(remoteRepoPath));
        }
        return flag;
    }

    private boolean checkAppRepoAndCreate(PaasAppsInfoDTO appInfo, String gitUser) {
        AllinCloudPortalClient portalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        String userEmail = "anonymous@unknown.com";
        SUserDTO user = portalClient.querySUserByPk(gitUser);
        userEmail = user != null && StringUtils.isNotBlank((CharSequence)user.getUsermail()) ? user.getUsermail() : String.format("%s@%s.com", gitUser, "irdstudio");
        SUserProfileDTO userProfile = portalClient.querySUserProfileByPk(gitUser);
        if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            throw new RuntimeException("\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01");
        }
        String gitPassword = userProfile.getGitAccessToken();
        if (StringUtils.isBlank((CharSequence)gitPassword)) {
            gitPassword = userProfile.getGitPassword();
        }
        String gitHostUrl = paasEnvParamService.queryEnvParamByCodeReturnValue("git.host.url").getParamValue();
        String pushUrl = appInfo.getAppGitUrl();
        if (pushUrl.endsWith("/")) {
            pushUrl = pushUrl.substring(0, pushUrl.length() - 1);
        }
        String projectName = pushUrl.substring(pushUrl.lastIndexOf("/"));
        String group = pushUrl.replace(projectName, "");
        group = group.substring(group.lastIndexOf("/") + 1);
        projectName = projectName.replace(".git", "").substring(1);
        String currentUserId = gitUser;
        logger.info("\u5f53\u524d\u7528\u6237\uff1a " + currentUserId);
        GitLabApi gitLabApi = new GitLabApi(gitHostUrl, gitPassword);
        User gitUserInfo = null;
        try {
            gitUserInfo = gitLabApi.getUserApi().getUser(currentUserId);
        }
        catch (GitLabApiException gitLabApiException) {
            // empty catch block
        }
        if (gitUserInfo == null) {
            gitUserInfo = new User();
            gitUserInfo.setName(currentUserId);
            gitUserInfo.setUsername(currentUserId);
            gitUserInfo.setEmail(userEmail);
            try {
                gitUserInfo = gitLabApi.getUserApi().createUser(gitUserInfo, (CharSequence)(currentUserId + currentUserId), false);
            }
            catch (GitLabApiException gitLabApiException) {
                // empty catch block
            }
        }
        GroupApi groupApi = gitLabApi.getGroupApi();
        Group namespace = null;
        try {
            namespace = groupApi.getGroup((Object)group);
        }
        catch (GitLabApiException e) {
            logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
            namespace = null;
        }
        if (namespace == null) {
            try {
                GroupParams createGroupParam = new GroupParams();
                createGroupParam.withName(group);
                createGroupParam.withPath(group);
                createGroupParam.withDescription(appInfo.getSubsName());
                namespace = groupApi.createGroup(createGroupParam);
                logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                try {
                    Member member = groupApi.addMember((Object)group, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                    if (member != null) {
                        logger.info("\u4ed3\u5e93\u7ec4\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                    }
                }
                catch (GitLabApiException member) {}
            }
            catch (GitLabApiException e) {
                logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                return false;
            }
        }
        ProjectApi prjApi = gitLabApi.getProjectApi();
        Project prj = null;
        try {
            prj = prjApi.getProject(group, projectName);
        }
        catch (GitLabApiException gitLabApiException) {
            // empty catch block
        }
        if (prj == null || prj.getId() == null || prj.getId() < 0L) {
            prj = new Project();
            prj.setName(projectName);
            prj.setPath(projectName);
            prj.setDescription(appInfo.getAppName());
            Project newPrj = null;
            try {
                newPrj = prjApi.createProject(namespace.getId(), prj);
            }
            catch (GitLabApiException gitLabApiException) {
                // empty catch block
            }
            if (newPrj != null) {
                logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                try {
                    Member member = prjApi.addMember((Object)newPrj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                    if (member != null) {
                        logger.info("\u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                    }
                }
                catch (GitLabApiException gitLabApiException) {}
            } else {
                logger.info("\u4ed3\u5e93\u521b\u5efa\u5931\u8d25\u4e86");
                return false;
            }
            return true;
        }
        logger.info("\u4ed3\u5e93\u5df2\u5b58\u5728");
        try {
            Member member = prjApi.addMember((Object)prj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
            if (member != null) {
                logger.info("\u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
            }
        }
        catch (GitLabApiException gitLabApiException) {
            // empty catch block
        }
        return true;
    }
}

