/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoPortalService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.design.console.application.service.impl.AbstractTemplateGenAppCodeService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoPortalService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamPortalService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsParamDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeContext;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDependency;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeImport;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.gencode.CodeGenerateConstant;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.MyFileUtil;
import com.irdstudio.allinrdm.dam.console.facade.ModelJoinDetailService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelJoinDetailDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInoutService;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInoutDTO;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableFieldBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Component;

@Component
public class BaseGenTask {
    static final Logger logger = LoggerFactory.getLogger(AbstractTemplateGenAppCodeService.class);
    Formatter javaFormatter = new Formatter(JavaFormatterOptions.builder().style(JavaFormatterOptions.Style.AOSP).build());
    @Autowired
    protected SSubsInfoService sSubsInfoService;
    @Autowired
    protected PaasAppsInfoService paasAppsInfoService;
    @Autowired
    protected PaasAppsInfoPortalService paasAppsInfoPortalService;
    @Autowired
    protected ModelTableInfoService modelTableInfoService;
    @Autowired
    protected ModelTableFieldService modelTableFieldService;
    @Autowired
    protected SrvModelInfoService srvModelInfoService;
    @Autowired
    protected SrvModelInoutService srvModelInoutService;
    @Autowired
    protected ModelJoinDetailService modelJoinDetailService;
    @Autowired
    protected PaasAppsParamService paasAppsParamService;
    @Autowired
    protected PaasAppsParamPortalService paasAppsParamPortalService;
    @Autowired
    protected PaasEnvParamService paasEnvParamService;
    @Autowired
    protected PaasEcsInfoPortalService paasEcsInfoService;

    public boolean execute(PaasAppsInfoDTO appInfo) {
        throw new UnsupportedOperationException("\u8bf7\u5b9e\u73b0execute");
    }

    public ModelTableInfoBo generateTableBO(ModelTableInfoDTO table) {
        try {
            ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
            fieldParam.setObjectId(table.getObjectId());
            List fields = this.modelTableFieldService.queryList((Object)fieldParam);
            ModelTableInfoBo tableBo = new ModelTableInfoBo();
            tableBo.setTableId(table.getObjectId());
            tableBo.setTableCode(table.getObjectCode());
            tableBo.setTableName(table.getObjectName());
            tableBo.setModelClassName(TmModelUtil.tableCodeToClassName((String)table.getObjectCode()));
            tableBo.setJavaPropertyName(TmModelUtil.fieldToProperty((String)table.getObjectCode()));
            ArrayList<ModelTableFieldBo> fieldBos = new ArrayList<ModelTableFieldBo>(fields.size());
            HashMap<String, ModelTableFieldBo> fieldMap = new HashMap<String, ModelTableFieldBo>(fields.size());
            if (CollectionUtils.isNotEmpty((Collection)fields)) {
                for (ModelTableFieldDTO field : fields) {
                    ModelTableFieldBo fieldBo = new ModelTableFieldBo();
                    BeanUtils.copyProperties((Object)field, (Object)fieldBo);
                    String javaPropertyName = TmModelUtil.fieldToProperty((String)field.getFieldCode());
                    fieldBo.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
                    fieldBo.setJavaPropertyName(javaPropertyName);
                    fieldBo.setJavaType(TmModelUtil.fieldTypeToJavaType((String)field.getFieldType()));
                    fieldBos.add(fieldBo);
                    fieldMap.put(field.getFieldCode(), fieldBo);
                }
            }
            tableBo.setFieldList(fieldBos);
            tableBo.setFieldMap(fieldMap);
            return tableBo;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa ModelTableInfoBo \u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void produceCodeFile(String templateFile, String modelName, String codePath, PaasAppsInfoDTO appInfo, CodeTemplateDataBo ctdb) {
        this.produceCodeFile(templateFile, CodeGenerateConstant.TABLE_VAR_NOSPLIT, modelName, codePath, appInfo, ctdb);
    }

    public void produceCodeFile(String templateFile, String replaceStr, String modelName, String codePath, PaasAppsInfoDTO appInfo, CodeTemplateDataBo ctdb) {
        String tableModelCode = (String)ctdb.getMapData().get("tableModelCode");
        String modelClassName = TmModelUtil.tableCodeToClassName((String)tableModelCode);
        this.produceCodeFile(templateFile, modelClassName, replaceStr, modelName, codePath, appInfo, ctdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceCodeFile(String templateFile, String replaceTarget, String replaceStr, String modelName, String codePath, PaasAppsInfoDTO appInfo, CodeTemplateDataBo ctdb) {
        block7: {
            String fileNameResult;
            block8: {
                String appId = appInfo.getAppId();
                String appCode = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
                String templatePath = BaseGenTask.getTemplatePath(appInfo);
                ctdb.getMapData().put("TEMPLATE_PATH", templatePath);
                String targetPath = SdEnvUtil.PROJECT_PATH + appId + File.separator + String.format("%s-%s", appCode, modelName).replace(".", "-") + File.separator + codePath;
                if (modelName == null) {
                    targetPath = SdEnvUtil.PROJECT_PATH + appCode + File.separator + codePath;
                }
                if (!MyFileUtil.checkFileExist((String)(targetPath = BaseGenTask.pathMatchSystem(targetPath))).booleanValue()) {
                    File targetDic = new File(targetPath);
                    targetDic.mkdirs();
                }
                fileNameResult = templateFile.replaceAll(replaceStr, replaceTarget);
                fileNameResult = fileNameResult.replaceAll(CodeGenerateConstant.TABLE_VAR_SPLIT, replaceTarget.replace("_", "-"));
                String outputFileName = targetPath + fileNameResult;
                ctdb.getMapData().put("TmModelUtil", new TmModelUtil());
                FreemarkerUtil.produceSingleFile((CodeTemplateDataBo)ctdb, (String)templatePath, (String)(templateFile + ".vm"), (String)outputFileName);
                if (!fileNameResult.endsWith(".java")) break block8;
                FileInputStream io = null;
                FileOutputStream out = null;
                try {
                    io = new FileInputStream(new File(outputFileName));
                    String sourceJavaCode = IOUtils.toString((InputStream)io, (String)"utf-8");
                    String formatted = this.javaFormatter.formatSource(sourceJavaCode);
                    out = new FileOutputStream(new File(outputFileName));
                    IOUtils.write((String)formatted, (OutputStream)out, (String)"utf-8");
                }
                catch (Exception e) {
                    try {
                        logger.error(fileNameResult + "\u683c\u5f0f\u5316\u5931\u8d25 " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(io);
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)io);
                    IOUtils.closeQuietly(out);
                    break block7;
                }
                IOUtils.closeQuietly((InputStream)io);
                IOUtils.closeQuietly((OutputStream)out);
                break block7;
            }
            if (fileNameResult.endsWith(".xml")) {
                // empty if block
            }
        }
    }

    public static final String getPageTemplatePath(PaasAppsInfoDTO appInfo) {
        String appTemplateId = appInfo.getAppTemplateId();
        return SdEnvUtil.TEMPLATE_PATH + File.separator + appTemplateId + "-template" + File.separator + appTemplateId + "-code" + File.separator;
    }

    public static final String getTemplatePath(PaasAppsInfoDTO appInfo) {
        String appTemplateId = appInfo.getAppTemplateId();
        File srvDir = new File(SdEnvUtil.TEMPLATE_PATH + File.separator + appTemplateId + "-template" + File.separator + appTemplateId + "-code" + File.separator + "srv");
        if (srvDir.exists()) {
            return srvDir.getAbsolutePath();
        }
        return SdEnvUtil.TEMPLATE_PATH + File.separator + "allincloud-template" + File.separator + "srv";
    }

    public static String pathMatchSystem(String path) {
        String targetSeparetor = File.separator;
        if (targetSeparetor.equals("\\")) {
            if (path.contains("/")) {
                // empty if block
            }
        } else if (targetSeparetor.equals("/") && path.contains("\\")) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }

    public static String formatClassPath(String appCode) {
        return appCode.replace(".", "/").replace("-", "/").replace("_", "/");
    }

    public ModelTableInfoBo generateModelTableJoinDetail(ModelTableInfoBo modelTableBo) {
        ModelJoinDetailDTO joinParam = new ModelJoinDetailDTO();
        joinParam.setJoinDetailId(modelTableBo.getTableId());
        List joinList = this.modelJoinDetailService.queryList((Object)joinParam);
        if (CollectionUtils.isNotEmpty((Collection)joinList)) {
            HashMap<String, ModelTableFieldDTO> fieldSetMap = new HashMap<String, ModelTableFieldDTO>();
            ArrayList<ModelTableFieldBo> fieldBos = new ArrayList<ModelTableFieldBo>();
            HashMap<String, ModelTableFieldBo> fieldMap = new HashMap<String, ModelTableFieldBo>();
            for (ModelJoinDetailDTO joinDetail : joinList) {
                ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
                fieldParam.setObjectId(joinDetail.getObjectId());
                List joinFieldList = this.modelTableFieldService.queryList((Object)fieldParam);
                if (!CollectionUtils.isNotEmpty((Collection)joinFieldList)) continue;
                for (ModelTableFieldDTO field : joinFieldList) {
                    if (fieldSetMap.get(field.getFieldCode()) != null) continue;
                    ModelTableFieldBo fieldBo = new ModelTableFieldBo();
                    BeanUtils.copyProperties((Object)field, (Object)fieldBo);
                    String javaPropertyName = TmModelUtil.fieldToProperty((String)field.getFieldCode());
                    fieldBo.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
                    fieldBo.setJavaPropertyName(javaPropertyName);
                    fieldBo.setJavaType(TmModelUtil.fieldTypeToJavaType((String)field.getFieldType()));
                    fieldBo.setTableAndFieldCode(String.format("%s.%s", joinDetail.getObjectCode(), field.getFieldCode()));
                    fieldBos.add(fieldBo);
                    fieldMap.put(field.getFieldId(), fieldBo);
                    fieldMap.put(field.getFieldCode(), fieldBo);
                    fieldSetMap.put(field.getFieldCode().toLowerCase(), field);
                }
            }
            modelTableBo.setFieldList(fieldBos);
            modelTableBo.setFieldMap(fieldMap);
        }
        return modelTableBo;
    }

    public Map<String, Object> wrapAppsParam(String appId, CodeTemplateDataBo dataBo) {
        PaasAppsParamDTO param = new PaasAppsParamDTO();
        param.setAppId(appId);
        List paramList = this.paasAppsParamService.queryList((Object)param);
        HashMap<String, Object> appsParam = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty((Collection)paramList)) {
            for (PaasAppsParamDTO p : paramList) {
                appsParam.put(p.getParamCode(), p.getParamValue());
            }
        }
        PaasEnvParamDTO paasEnvParam = new PaasEnvParamDTO();
        paasEnvParam.setEnvId("paas");
        List envList = this.paasEnvParamService.queryList((Object)paasEnvParam);
        HashMap<String, String> envParam = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty((Collection)envList)) {
            for (PaasEnvParamDTO ep : envList) {
                envParam.put(ep.getParamCode(), ep.getParamValue());
            }
        }
        if (dataBo != null) {
            dataBo.getMapData().put("appsParam", appsParam);
            dataBo.getMapData().put("envParam", envParam);
        }
        return appsParam;
    }

    public void wrapEnvInfoParam(String envId, PaasAppsInfoDTO appInfo, CodeTemplateDataBo dataBo) {
        Map appsParam;
        PaasEnvParamDTO paasEnvParam = new PaasEnvParamDTO();
        paasEnvParam.setEnvId(envId);
        List envList = this.paasEnvParamService.queryList((Object)paasEnvParam);
        HashMap<String, String> envParam = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty((Collection)envList)) {
            for (PaasEnvParamDTO ep : envList) {
                envParam.put(ep.getParamCode(), ep.getParamValue());
            }
        }
        PaasEcsInfoDTO ecsParam = new PaasEcsInfoDTO();
        ecsParam.setEnvId(envId);
        List ecsList = this.paasEcsInfoService.queryList((Object)ecsParam);
        if (CollectionUtils.isNotEmpty((Collection)ecsList)) {
            PaasEcsInfoDTO ecs = (PaasEcsInfoDTO)ecsList.get(0);
            String registerAdd = ecs.getEcsIp();
            String registerPort = StringUtils.isNotBlank((CharSequence)ecs.getEcsPort()) ? ecs.getEcsPort() : "2181";
            envParam.put("registry_address", registerAdd + ":" + registerPort);
            envParam.put("registry_type", "zookeeper");
        }
        if ((appsParam = MapUtils.getMap((Map)dataBo.getMapData(), (Object)"appsParam")) != null) {
            ecsParam = new PaasEcsInfoDTO();
            ecsParam.setSubsId(appInfo.getSubsId());
            ecsParam.setAppId(appInfo.getAppId());
            ecsParam.setEnvId(envId);
            ecsList = this.paasEcsInfoService.queryList((Object)ecsParam);
            String server_port = MapUtils.getString((Map)appsParam, (Object)"server_port", (String)"8080");
            if (CollectionUtils.isNotEmpty((Collection)ecsList) && StringUtils.isNotBlank((CharSequence)((PaasEcsInfoDTO)ecsList.get(0)).getEcsPort())) {
                server_port = ((PaasEcsInfoDTO)ecsList.get(0)).getEcsPort();
            }
            appsParam.put("server_port", server_port);
        }
        dataBo.getMapData().put("envInfoParam", envParam);
        Map ecsInfoParam = this.paasAppsParamPortalService.loadEcsParam(appInfo.getAppId(), envId);
        dataBo.getMapData().put("ecsParam", ecsInfoParam);
        this.getDatabaseConfig(envId, appInfo, appsParam);
    }

    public void getDatabaseConfig(String envId, PaasAppsInfoDTO appInfo, Map<String, Object> appsParam) {
        PaasEcsInfoDTO ecsParam = new PaasEcsInfoDTO();
        ecsParam.setSubsId(appInfo.getSubsId());
        ecsParam.setAppId(appInfo.getAppId());
        ecsParam.setEnvId(envId);
        List ecsList = this.paasEcsInfoService.queryList((Object)ecsParam);
        String database_name = "";
        String database_username = "root";
        String database_password = "Zaqpwdxsw@2";
        database_name = BaseGenTask.getAppDatabaseName(appInfo);
        appsParam.put("database_name", database_name);
        database_username = MapUtils.getString(appsParam, (Object)"database_username", (String)"root");
        appsParam.put("database_username", database_username);
        database_password = MapUtils.getString(appsParam, (Object)"database_password", (String)"Zaqpwdxsw@2");
        appsParam.put("database_password", database_password);
        if (CollectionUtils.isNotEmpty((Collection)ecsList)) {
            PaasEcsInfoDTO ecs = (PaasEcsInfoDTO)ecsList.get(0);
            appsParam.put("database_ip", ecs.getEcsIp());
            appsParam.put("database_port", ecs.getEcsPort());
        } else {
            appsParam.put("database_ip", "47.119.20.139");
            appsParam.put("database_port", "3306");
        }
    }

    public String getPackagePrefix(CodeTemplateDataBo dataBo) {
        Map appsParam = MapUtils.getMap((Map)dataBo.getMapData(), (Object)"appsParam");
        String path = "com/fdb";
        if (appsParam != null) {
            String package_prefix = MapUtils.getString((Map)appsParam, (Object)"package_prefix", (String)"com.fdb");
            path = package_prefix.replaceAll("\\.", "/");
        }
        return path;
    }

    public void wrapComponentParams(String envId, PaasAppsInfoDTO appInfo, CodeTemplateDataBo dataBo) {
        dataBo.getMapData().put("compParamList", Collections.emptyList());
    }

    public String wrapperTableToClassName(String tableModelCode, String objectType, String tableModelId) {
        if (StringUtils.endsWithAny((CharSequence)tableModelCode, (CharSequence[])new CharSequence[]{"DO", "VO"})) {
            return tableModelCode;
        }
        String className = TmModelUtil.tableCodeToClassName((String)tableModelCode);
        ObjectType type = ObjectType.getType((String)objectType);
        if (type == null) {
            return className;
        }
        switch (type) {
            case Table: 
            case Main: 
            case Second: {
                className = className + "DO";
                break;
            }
            case Data: 
            case FreeStyleData: 
            case Inout: 
            case Common: {
                className = className + "VO";
                break;
            }
        }
        return className;
    }

    public String judgeTableToClassName(String tableModelCode, String objectType, String tableModelId) {
        ObjectType type = ObjectType.getType((String)objectType);
        String className = TmModelUtil.tableCodeToClassName((String)tableModelCode);
        switch (type) {
            case Table: 
            case Main: 
            case Second: {
                return OsrvArrangeImport.ImportType.DO.getCode();
            }
            case Data: 
            case FreeStyleData: 
            case Inout: {
                return OsrvArrangeImport.ImportType.VO.getCode();
            }
            case Common: {
                return OsrvArrangeImport.ImportType.SDK.getCode();
            }
        }
        return "";
    }

    public String getDefaultParameterClassName(String srvModelCode, String methodName, IOType ioType) {
        return String.format("%s%s%s", StringUtils.capitalize((String)srvModelCode), StringUtils.capitalize((String)methodName), ioType.getSuffix());
    }

    public String getBigDTOClassName(String srvModelCode, String methodName, IOType ioType) {
        return String.format("%s%s%s", StringUtils.capitalize((String)srvModelCode), StringUtils.capitalize((String)methodName), StringUtils.capitalize((String)ioType.toString()));
    }

    public String getMethodParam(List<SrvModelInoutDTO> params, OsrvArrangeContext osrvCtx, String suffix) {
        if (!CollectionUtils.isNotEmpty(params) || params.size() == 1) {
            // empty if block
        }
        if (CollectionUtils.isNotEmpty(params)) {
            if (StringUtils.equals((CharSequence)osrvCtx.getSrvModelInfo().getSrvModelCatalog(), (CharSequence)SrvModelCatalogEnum.BackServer.getCode()) && !StringUtils.equals((CharSequence)osrvCtx.getSrvModelInfo().getSrvModelType(), (CharSequence)SrvModelTypeEnum.CUSTOM_BACK_SERVICE.getType())) {
                String name = "";
                if (suffix.equalsIgnoreCase("input")) {
                    String tableModelCode = osrvCtx.getSrvModelInfo().getTableModelCode() + "_input";
                    String className = this.wrapperTableToClassName(tableModelCode, ObjectType.Inout.getCode(), null);
                    name = String.format("%s<%s>", "ServiceInput", className);
                    OsrvArrangeImport genClassImport = new OsrvArrangeImport();
                    genClassImport.setImportType(this.judgeTableToClassName(tableModelCode, ObjectType.Inout.getCode(), null));
                    genClassImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
                    genClassImport.setClassName(className);
                    osrvCtx.addImport(genClassImport);
                    osrvCtx.getMethod().setMainInputClass(className);
                } else {
                    SrvModelInoutDTO inout = params.get(0);
                    String className = this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
                    name = String.format("%s<%s>", "ServiceOutput", className);
                    OsrvArrangeImport genClassImport = new OsrvArrangeImport();
                    genClassImport.setImportType(this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                    genClassImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
                    genClassImport.setClassName(className);
                    osrvCtx.addImport(genClassImport);
                    osrvCtx.getMethod().setMainOutputClass(className);
                }
                OsrvArrangeImport domainImport = new OsrvArrangeImport();
                domainImport.setImportType(OsrvArrangeImport.ImportType.SDK.getCode());
                domainImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
                domainImport.setClassName(suffix.equalsIgnoreCase("input") ? "ServiceInput" : "ServiceOutput");
                osrvCtx.addImport(domainImport);
                return name;
            }
            String name = osrvCtx.getTableClassName() + StringUtils.capitalize((String)osrvCtx.getMethod().getMethodName()) + suffix;
            OsrvArrangeImport domainImport = new OsrvArrangeImport();
            domainImport.setImportType(OsrvArrangeImport.ImportType.DTO.getCode());
            domainImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
            domainImport.setClassName(name);
            osrvCtx.addImport(domainImport);
            String serviceClass = "";
            if (suffix.equalsIgnoreCase("input")) {
                String mainParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), osrvCtx.getMethod().getMethodName(), IOType.Input);
                String bigClass = this.getBigDTOClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), osrvCtx.getMethod().getMethodName(), IOType.Input);
                String mainParam_className = this.wrapperTableToClassName(mainParam, ObjectType.Inout.getCode(), null);
                String className = this.wrapperTableToClassName(bigClass, null, null);
                osrvCtx.getMethod().setMainInputClass(mainParam_className);
                osrvCtx.getMethod().setMainBigInputClass(className);
                serviceClass = "ServiceInput";
            } else {
                String mainParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), osrvCtx.getMethod().getMethodName(), IOType.Output);
                String bigClass = this.getBigDTOClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), osrvCtx.getMethod().getMethodName(), IOType.Output);
                String mainParam_className = this.wrapperTableToClassName(mainParam, ObjectType.Inout.getCode(), null);
                String className = this.wrapperTableToClassName(bigClass, null, null);
                osrvCtx.getMethod().setMainOutputClass(mainParam_className);
                osrvCtx.getMethod().setMainBigOutputClass(className);
                serviceClass = "ServiceOutput";
            }
            name = String.format("%s<%s>", serviceClass, name);
            return name;
        }
        return null;
    }

    public List<OsrvArrangeDependency> querySubsSDKDependencies(SSubsInfoDTO subsInfo) {
        if (StringUtils.isBlank((CharSequence)subsInfo.getArchType())) {
            return Collections.emptyList();
        }
        ArrayList<OsrvArrangeDependency> dependencies = new ArrayList<OsrvArrangeDependency>();
        OsrvArrangeDependency dependency = new OsrvArrangeDependency("<dependency>\t<groupId>com.irdstudio.allinpaas.framework</groupId>\n\t<artifactId>framework-beans-admin</artifactId>\n\t<version>1.0-SNAPSHOT</version></dependency>");
        dependencies.add(dependency);
        OsrvArrangeDependency dependencyCode = new OsrvArrangeDependency("<dependency>\t<groupId>com.irdstudio.allinpaas.framework</groupId>\n\t<artifactId>framework-beans-core</artifactId>\n\t<version>1.0-SNAPSHOT</version></dependency>");
        dependencies.add(dependencyCode);
        OsrvArrangeDependency dependencyWeb = new OsrvArrangeDependency("<dependency>\t<groupId>com.irdstudio.allinpaas.framework</groupId>\n\t<artifactId>framework-beans-web</artifactId>\n\t<version>1.0-SNAPSHOT</version></dependency>");
        dependencies.add(dependencyWeb);
        OsrvArrangeDependency dependencyFreemarker = new OsrvArrangeDependency("<dependency>\t<groupId>com.irdstudio.allinpaas.framework</groupId>\n\t<artifactId>framework-beans-freemarker</artifactId>\n\t<version>1.0-SNAPSHOT</version></dependency>");
        dependencies.add(dependency);
        return dependencies;
    }

    public static final String getAppDatabaseName(PaasAppsInfoDTO appInfo, Map<String, Object> appsParam) {
        String database_name = MapUtils.getString(appsParam, (Object)"database_name");
        if (StringUtils.isNotEmpty((CharSequence)database_name)) {
            return database_name;
        }
        if (appInfo != null && StringUtils.isNotEmpty((CharSequence)appInfo.getBizDbName())) {
            return appInfo.getBizDbName();
        }
        String code = appInfo.getAppCode();
        if (StringUtils.isBlank((CharSequence)code)) {
            code = appInfo.getAppCode();
        }
        return code.replaceAll("[\\.-]", "_");
    }

    public static final String getAppDatabaseName(PaasAppsInfoDTO appInfo) {
        return BaseGenTask.getAppDatabaseName(appInfo, Collections.emptyMap());
    }

    public ModelTableInfoDTO queryTableWithNameForInout(String appId, String objectName) {
        ModelTableInfoDTO inputTbParam = new ModelTableInfoDTO();
        inputTbParam.setObjectType(ObjectType.Inout.getIntCode());
        inputTbParam.setAppId(appId);
        inputTbParam.setObjectCode(objectName);
        List tables = this.modelTableInfoService.queryList((Object)inputTbParam);
        return CollectionUtils.isNotEmpty((Collection)tables) ? (ModelTableInfoDTO)tables.get(0) : null;
    }

    public ModelTableInfoDTO queryModelTableInfo(String objectId) {
        ModelTableInfoDTO tableInfo = new ModelTableInfoDTO();
        tableInfo.setObjectId(objectId);
        tableInfo = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)tableInfo);
        return tableInfo;
    }

    public Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Class\u7c7b\u5bf9\u8c61:" + clazz.getName() + "\u5b9e\u4f8b\u5316\u65f6\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
            return null;
        }
    }

    public <T> T beanCopy(Object srcBean, Object targetBean) {
        if (Objects.nonNull(targetBean) && Objects.nonNull(srcBean)) {
            BeanCopier beanCopier = BeanCopier.create(srcBean.getClass(), targetBean.getClass(), (boolean)false);
            beanCopier.copy(srcBean, targetBean, null);
            return (T)targetBean;
        }
        return null;
    }

    public <T> T beanCopy(Object srcBean, Object targetBean, boolean ignoreNull) {
        return (T)BeanUtility.beanCopy((Object)srcBean, (Object)targetBean, (boolean)ignoreNull);
    }

    public <T> T beanCopy(Object srcBean, Class<T> clazz, boolean ignoreNull) {
        return this.beanCopy(srcBean, this.newInstance(clazz), ignoreNull);
    }

    public <T> T beanCopy(Object srcBean, Class<T> clazz) {
        return this.beanCopy(srcBean, this.newInstance(clazz), true);
    }

    public <T> Collection<? extends Object> beansCopy(Collection<? extends Object> srcBeans, Class<?> targetBean) {
        if (Objects.isNull(srcBeans)) {
            return null;
        }
        return srcBeans.stream().map(s -> this.beanCopy(s, this.newInstance(targetBean))).collect(Collectors.toList());
    }

    public <T> List<T> beansCopy(List<? extends Object> srcBeans, Class<T> targetBean) {
        if (Objects.isNull(srcBeans)) {
            return null;
        }
        return srcBeans.stream().map(s -> this.beanCopy(s, this.newInstance(targetBean))).collect(Collectors.toList());
    }
}

