/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.SSubsDatasourceService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsDatasourceDTO;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskMetascanService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskMetascanDTO;
import com.irdstudio.allinapaas.portal.console.types.DataStdFlag;
import com.irdstudio.allinapaas.portal.console.types.MetaTaskType;
import com.irdstudio.allinrdm.dam.console.facade.ModelFolderInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableIndexService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelFolderInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableIndexDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ConflictType;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dam.console.types.PackageTypeEnum;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.db.DBImportPlugin;
import com.irdstudio.sdk.beans.db.enums.IndexType;
import com.irdstudio.sdk.beans.db.vo.DBImportTableFieldVO;
import com.irdstudio.sdk.beans.db.vo.DBImportTableIndexVO;
import com.irdstudio.sdk.beans.db.vo.DBImportTableVO;
import com.irdstudio.sdk.beans.db.vo.DBInfoVO;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class DsMetaTask
extends AbstractMetaTask {
    private static final Logger logger = LoggerFactory.getLogger(DsMetaTask.class);
    private PaasTaskInfoDTO taskInfo;
    private PathMatcher matcher = new AntPathMatcher();
    private DataSource dataSource;

    public DsMetaTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        Connection conn = null;
        try {
            ModelFolderInfoDTO packageParam;
            String taskExclude;
            String[] taskExcludes;
            this.dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
            conn = this.dataSource.getConnection();
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            ModelFolderInfoService modelFolderInfoService = (ModelFolderInfoService)SpringContextUtils.getBean(ModelFolderInfoService.class);
            ModelTableInfoService modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
            ModelTableFieldService modelTableFieldService = (ModelTableFieldService)SpringContextUtils.getBean(ModelTableFieldService.class);
            ModelTableIndexService modelTableIndexService = (ModelTableIndexService)SpringContextUtils.getBean(ModelTableIndexService.class);
            SSubsDatasourceService sSubsDatasourceService = (SSubsDatasourceService)SpringContextUtils.getBean(SSubsDatasourceService.class);
            PaasTaskMetascanService paasTaskMetascanService = (PaasTaskMetascanService)SpringContextUtils.getBean(PaasTaskMetascanService.class);
            PaasTaskMetascanDTO metaScan = new PaasTaskMetascanDTO();
            metaScan.setTaskId(this.taskInfo.getTaskId());
            metaScan = (PaasTaskMetascanDTO)paasTaskMetascanService.queryByPk((Object)metaScan);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String dsCode = metaScan.getDsCode();
            String tableInclude = metaScan.getTableInclude();
            String[] taskIncludes = StringUtils.split((String)tableInclude, (String)";");
            if (taskIncludes == null || StringUtils.isBlank((CharSequence)tableInclude)) {
                taskIncludes = new String[]{"*"};
            }
            if ((taskExcludes = StringUtils.split((String)(taskExclude = metaScan.getTableExclude()), (String)";")) == null || StringUtils.isBlank((CharSequence)taskExclude)) {
                taskExcludes = new String[]{};
            }
            String taskType = this.taskInfo.getTaskType();
            String taskOption = metaScan.getTaskOption();
            MetaTaskType metaTaskType = MetaTaskType.getByCode((String)taskType);
            if (metaTaskType == null) {
                metaTaskType = MetaTaskType.Mysql;
            }
            PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
            appParam.setAppId(appId);
            PaasAppsInfoDTO appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appParam);
            SSubsDatasourceDTO dsParam = new SSubsDatasourceDTO();
            dsParam.setSubsId(subsId);
            dsParam.setSubsDsCode(dsCode);
            SSubsDatasourceDTO ds = (SSubsDatasourceDTO)sSubsDatasourceService.queryByPk((Object)dsParam);
            if (appInfo == null) {
                rtn.setFailCode("9999");
                rtn.setFailReason("\u672a\u9009\u62e9\u5e94\u7528");
                rtn.setSuccessFlag(false);
                ExecuteRtnInfo executeRtnInfo = rtn;
                return executeRtnInfo;
            }
            if (ds == null) {
                rtn.setFailCode("9999");
                rtn.setFailReason("\u6570\u636e\u6e90\u672a\u914d\u7f6e");
                rtn.setSuccessFlag(false);
                ExecuteRtnInfo executeRtnInfo = rtn;
                return executeRtnInfo;
            }
            String dbms = metaTaskType.getDbms();
            String dbUrl = ds.getDsConnStr();
            String dbUser = ds.getDsUserId();
            String dbPwd = ds.getDsUserPwd();
            String conflict = StringUtils.equals((CharSequence)taskOption, (CharSequence)"1") ? "recover" : "skip";
            ModelFolderInfoDTO tablePackage = null;
            if (StringUtils.isNotBlank((CharSequence)ds.getRefDsId())) {
                packageParam = new ModelFolderInfoDTO();
                packageParam.setFolderId(ds.getRefDsId());
                tablePackage = (ModelFolderInfoDTO)modelFolderInfoService.queryByPk((Object)packageParam);
            }
            if (tablePackage == null) {
                packageParam = new ModelFolderInfoDTO();
                packageParam.setAppId(appId);
                packageParam.setFolderId(appId);
                packageParam.setFolderType(Integer.valueOf(PackageTypeEnum.TABLE.getType()));
                Object packageList = modelFolderInfoService.queryListByPage((Object)packageParam);
                if (CollectionUtils.isNotEmpty((Collection)packageList)) {
                    tablePackage = (ModelFolderInfoDTO)packageList.get(0);
                } else {
                    tablePackage = new ModelFolderInfoDTO();
                    tablePackage.setAppId(appInfo.getAppId());
                    tablePackage.setFolderId(appId);
                    tablePackage.setFolderDesc(appInfo.getAppName());
                    tablePackage.setOrderValue(Integer.valueOf(1));
                    tablePackage.setFolderCode(appInfo.getAppCode());
                    tablePackage.setFolderName(PackageTypeEnum.TABLE.getCnname());
                    tablePackage.setFolderAbvId(appId);
                    tablePackage.setFolderType(Integer.valueOf(PackageTypeEnum.TABLE.getType()));
                    modelFolderInfoService.insert((Object)tablePackage);
                }
            }
            String driverClass = "com.mysql.jdbc.Driver";
            switch (dbms) {
                case "425": {
                    driverClass = "com.mysql.jdbc.Driver";
                    break;
                }
                case "125": {
                    driverClass = "oracle.jdbc.driver.OracleDriver";
                    break;
                }
                default: {
                    driverClass = "com.mysql.jdbc.Driver";
                }
            }
            DBImportPlugin readPlugin = DBImportPlugin.Factory.getInstance((int)Integer.valueOf(dbms));
            DBInfoVO db = readPlugin.readDBInfo(dbUrl, dbUser, dbPwd);
            if (db != null) {
                String createTime = CurrentDateUtil.getTodayDateEx2();
                Pattern pattern = Pattern.compile("\\w+\\(\\s*(\\d+),?(\\d*)(\\s+BYTE)*\\s*\\)");
                for (DBImportTableVO tb : db.getTables()) {
                    String objectCode = StringUtils.lowerCase((String)tb.getTable_name());
                    if (!this.taskNameMatch(taskIncludes, objectCode) || this.taskNameMatch(taskExcludes, objectCode)) continue;
                    ModelTableInfoDTO modelTb = new ModelTableInfoDTO();
                    modelTb.setAppId(appId);
                    modelTb.setObjectCode(objectCode);
                    modelTb.setObjectName(tb.getTable_comment());
                    List exists = modelTableInfoService.queryListByPage((Object)modelTb);
                    ModelTableInfoDTO model = null;
                    if (CollectionUtils.isNotEmpty((Collection)exists)) {
                        if (conflict.equals(ConflictType.skip.getCode())) {
                            logger.info(String.format("%s\u6a21\u578b\u5e93\u4e2d\u5b58\u5728%s, \u4e14\u5904\u7406\u65b9\u5f0f\u4e3a\u8df3\u8fc7", appId, tb.getTable_name()));
                            continue;
                        }
                        model = (ModelTableInfoDTO)exists.get(0);
                        if (StringUtils.isNotBlank((CharSequence)tb.getTable_comment())) {
                            model.setObjectName(tb.getTable_comment());
                        }
                        model.setLastModifyTime(createTime);
                        model.setLastModifyUser(userId);
                        modelTableInfoService.updateByPk((Object)model);
                        modelTableFieldService.deleteByObjectId(model.getObjectId());
                        modelTableIndexService.deleteByObjectId(model.getObjectId());
                    } else {
                        model = new ModelTableInfoDTO();
                        model.setObjectId(UUIDUtil.getUUID());
                        model.setObjectCode(objectCode);
                        if (StringUtils.isNotBlank((CharSequence)tb.getTable_comment()) && tb.getTable_comment().length() > 80) {
                            tb.setTable_comment(tb.getTable_comment().substring(0, 80));
                        }
                        model.setObjectName(tb.getTable_comment());
                        model.setAppId(appId);
                        model.setSubsId(subsId);
                        model.setFolderId(tablePackage.getFolderId());
                        model.setObjectDesc(tb.getTable_comment());
                        model.setObjectType(ObjectType.Table.getIntCode());
                        model.setObjectState(Integer.valueOf(0));
                        model.setSubjectId("0");
                        model.setTableDataCycle("00");
                        model.setCreateTime(createTime);
                        model.setCreateUser(userId);
                        modelTableInfoService.insert((Object)model);
                    }
                    DBImportTableIndexVO pkKey = null;
                    for (DBImportTableIndexVO ii : tb.getIndexes()) {
                        ModelTableIndexDTO index = new ModelTableIndexDTO();
                        index.setObjectId(model.getObjectId());
                        index.setIndexFields(StringUtils.lowerCase((String)ii.getColumns()));
                        index.setCreateTime(createTime);
                        index.setCreateUser(userId);
                        if (IndexType.Primary.getCode().equals(ii.getIndex_type())) {
                            index.setIndexTypePrimary("Y");
                            index.setIndexTypeUnique("N");
                            index.setIndexName(String.format("PK_%s", ii.getTable_name().toUpperCase()));
                            pkKey = ii;
                        } else {
                            index.setIndexTypePrimary("N");
                            index.setIndexName(ii.getIndex_name());
                        }
                        modelTableIndexService.insert((Object)index);
                    }
                    int fieldOrder = 2;
                    for (DBImportTableFieldVO ff : tb.getFields()) {
                        ModelTableFieldDTO field = new ModelTableFieldDTO();
                        field.setObjectId(model.getObjectId());
                        field.setFieldId(UUIDUtil.getUUID());
                        field.setCreateTime(createTime);
                        field.setCreateUser(userId);
                        field.setFieldCode(StringUtils.lowerCase((String)ff.getColumn_name()));
                        if (StringUtils.isNotBlank((CharSequence)ff.getIs_nullable()) && ff.getIs_nullable().equals("YES")) {
                            field.setIsAllowNull("Y");
                        } else {
                            field.setIsAllowNull("N");
                        }
                        field.setFieldDesc(ff.getColumn_comment());
                        field.setFieldName(ff.getColumn_comment());
                        field.setDefValue(ff.getColumn_default());
                        field.setFieldType(ff.getData_type());
                        if (pkKey != null) {
                            if (pkKey.getColumns().contains(ff.getColumn_name())) {
                                field.setIsPk("Y");
                                field.setFieldOrder(Integer.valueOf(1));
                            } else {
                                field.setIsPk("N");
                                field.setFieldOrder(Integer.valueOf(fieldOrder++));
                            }
                        } else {
                            field.setIsPk("N");
                            field.setFieldOrder(Integer.valueOf(fieldOrder++));
                        }
                        Matcher matcher = pattern.matcher(ff.getColumn_type());
                        if (matcher.matches()) {
                            field.setFieldLength(Integer.valueOf(matcher.group(1)));
                            if (StringUtils.isNotEmpty((CharSequence)matcher.group(2))) {
                                field.setFieldPrecision(Integer.valueOf(matcher.group(2)));
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)field.getFieldName()) && field.getFieldName().length() > 80) {
                            field.setFieldName(field.getFieldName().substring(0, 80));
                        }
                        if (StringUtils.isNotBlank((CharSequence)field.getFieldDesc()) && field.getFieldDesc().length() > 254) {
                            field.setFieldDesc(field.getFieldDesc().substring(0, 254));
                        }
                        field.setDataStdFlag(DataStdFlag.Auto.getCode());
                        modelTableFieldService.insert((Object)field);
                    }
                }
            }
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u6a21\u578b\u91c7\u96c6 \u4eceexcel\u4e2d\u8bfb\u53d6\u5f02\u5e38 " + e.getMessage());
            logger.error("\u6a21\u578b\u91c7\u96c6 \u6570\u636e\u6e90 \u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6a21\u578b\u91c7\u96c6 \u6570\u636e\u6e90 \u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }

    private boolean taskNameMatch(String[] patterns, String tableName) {
        boolean flag = false;
        if (patterns != null) {
            String patten;
            String[] stringArray = patterns;
            int n = stringArray.length;
            for (int i = 0; i < n && !(flag = this.matcher.match(patten = stringArray[i], tableName)); ++i) {
            }
        }
        return flag;
    }
}

