/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.portal.console.application.service.impl.apptype.PaasAppsTypeClazzServiceImpl;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.CodeTemplateRepoPullTask;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskFngenService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskFngenDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dev.console.facade.FormModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.FormModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.ModelStat;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FnFormGenTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(FnFormGenTask.class);
    private PaasTaskInfoDTO taskInfo;

    public FnFormGenTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            List formList;
            PaasTaskFngenService paasTaskFngenService = (PaasTaskFngenService)SpringContextUtils.getBean(PaasTaskFngenService.class);
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            FormModelInfoService formModelInfoService = (FormModelInfoService)SpringContextUtils.getBean(FormModelInfoService.class);
            PaasTaskFngenDTO fngenDTO = new PaasTaskFngenDTO();
            fngenDTO.setTaskId(this.taskInfo.getTaskId());
            fngenDTO = (PaasTaskFngenDTO)paasTaskFngenService.queryByPk((Object)fngenDTO);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String moduleId = this.taskInfo.getModuleId();
            String formId = fngenDTO.getFormId();
            String comId = fngenDTO.getComId();
            FormModelInfoDTO formParam = new FormModelInfoDTO();
            formParam.setSubsId(subsId);
            formParam.setAppId(appId);
            if (StringUtils.isNotBlank((CharSequence)formId)) {
                if (StringUtils.contains((CharSequence)formId, (CharSequence)",")) {
                    formParam.setFormIdList(Arrays.asList(StringUtils.split((String)formId, (String)",")));
                } else {
                    formParam.setFormId(formId);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(formList = formModelInfoService.queryList((Object)formParam)))) {
                String rootPath;
                File rootDir;
                PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
                appInfo.setAppId(appId);
                appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
                if (appInfo == null) {
                    throw new RuntimeException(appId + "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                appInfo.setLoginUserId(this.taskInfo.getLoginUserId());
                CodeTemplateRepoPullTask templatePullTask = new CodeTemplateRepoPullTask();
                templatePullTask.syncRun();
                PaasAppsTypeClazzServiceImpl genService = new PaasAppsTypeClazzServiceImpl(String.format("PaasAppsType%sServiceImpl", appInfo.getAppType()));
                if (StringUtils.equals((CharSequence)fngenDTO.getRegenRepo(), (CharSequence)YesOrNO.YES.getCode())) {
                    appInfo.setNoCopyTemplate(false);
                    genService.genPaasAppsCode(appInfo);
                }
                if (!(rootDir = new File(rootPath = SdEnvUtil.PROJECT_PATH + File.separator + appId)).exists()) {
                    rootDir.mkdirs();
                }
                for (FormModelInfoDTO form : formList) {
                    form.setLoginUserId(this.taskInfo.getLoginUserId());
                    formModelInfoService.generateFormCode(form);
                    String id = form.getFormId();
                    File idDir = new File(SdEnvUtil.PROJECT_PATH + File.separator + id);
                    if (idDir.exists()) {
                        FileUtils.copyDirectory((File)idDir, (File)rootDir);
                    }
                    form.setModelStat(ModelStat.Generated.getCode());
                    formModelInfoService.updateByPk((Object)form);
                }
            }
            if (StringUtils.equals((CharSequence)fngenDTO.getRegenRepo(), (CharSequence)YesOrNO.YES.getCode())) {
                fngenDTO.setRegenRepo(YesOrNO.NO.getCode());
                paasTaskFngenService.updateByPk((Object)fngenDTO);
            }
            this.taskInfo.setTaskErrorMsg(null);
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u6279\u91cf\u6309\u8868\u5355\u6a21\u578b\u529f\u80fd\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6279\u91cf\u6309\u8868\u5355\u6a21\u578b\u529f\u80fd\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }
}

