/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelJoinDetail;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeImport;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.application.service.task.BaseGenTask;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelJoinDetailDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.IsrvSqlCondService;
import com.irdstudio.allinrdm.dev.console.facade.IsrvSqlInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.IsrvSqlCondDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.IsrvSqlInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInoutDTO;
import com.irdstudio.allinrdm.dev.console.types.CondNotEmptyEnum;
import com.irdstudio.allinrdm.dev.console.types.FieldEvalWay;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.MapBeanUtil;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import de.dknapps.mybatter.main.MyBatter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GenInfrastructureTask
extends BaseGenTask {
    @Autowired
    protected IsrvSqlInfoService isrvSqlInfoService;
    @Autowired
    protected IsrvSqlCondService isrvSqlCondService;

    @Override
    public boolean execute(PaasAppsInfoDTO appInfo) {
        String loginUserId = appInfo.getLoginUserId();
        String appCode = appInfo.getAppCode();
        ModelTableInfoDTO userTokenInfo = this.modelTableInfoService.generateUserTokenInfo(appInfo.getAppId());
        SrvModelInoutDTO userTokenInout = new SrvModelInoutDTO();
        userTokenInout.setTableModelCode(this.wrapperTableToClassName(userTokenInfo.getObjectCode(), userTokenInfo.getObjectType().toString(), userTokenInfo.getObjectId()));
        userTokenInout.setTableModelName(userTokenInfo.getObjectName());
        userTokenInout.setTableModelId(userTokenInfo.getObjectId());
        userTokenInout.setObjectType(userTokenInfo.getObjectType());
        userTokenInout.setListFlag(YesOrNO.NO.getCode());
        ModelTableInfoDTO isrvRspInfo = this.modelTableInfoService.generateIsrvRspInfo(appInfo.getAppId());
        ModelTableInfoDTO pageInfo = this.modelTableInfoService.generatePageInfo(appInfo.getAppId());
        SrvModelInoutDTO pageInfoInout = new SrvModelInoutDTO();
        pageInfoInout.setTableModelCode(this.wrapperTableToClassName(pageInfo.getObjectCode(), pageInfo.getObjectType().toString(), pageInfo.getObjectId()));
        pageInfoInout.setTableModelName(pageInfo.getObjectName());
        pageInfoInout.setTableModelId(pageInfo.getObjectId());
        pageInfoInout.setObjectType(pageInfo.getObjectType());
        pageInfoInout.setListFlag(YesOrNO.NO.getCode());
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setAppId(appInfo.getAppId());
        tableParam.setObjectTypes(Arrays.asList(ObjectType.Table.getCode(), ObjectType.Main.getCode(), ObjectType.Second.getCode()));
        if (StringUtils.isNotBlank((CharSequence)appInfo.getSrvModelId())) {
            SrvModelInfoDTO srvModelInfo = new SrvModelInfoDTO();
            srvModelInfo.setSrvModelId(appInfo.getSrvModelId());
            srvModelInfo = (SrvModelInfoDTO)this.srvModelInfoService.queryByPk((Object)srvModelInfo);
            if (srvModelInfo != null && StringUtils.isNotBlank((CharSequence)srvModelInfo.getTableModelId())) {
                tableParam.setObjectId(srvModelInfo.getTableModelId());
            }
        }
        List tableList = this.modelTableInfoService.queryList((Object)tableParam);
        ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>(tableList.size());
        SrvModelInfoDTO modelParam = new SrvModelInfoDTO();
        modelParam.setAppId(appInfo.getAppId());
        modelParam.setSrvModelCatalog(SrvModelCatalogEnum.SrvServer.getCode());
        if (CollectionUtils.isNotEmpty((Collection)tableList)) {
            for (ModelTableInfoDTO table : tableList) {
                ObjectType objectTypeEnum = ObjectType.getType((String)String.valueOf(table.getObjectType()));
                String inputDOName = TmModelUtil.modelCodeToClassName((String)table.getObjectCode()) + "Input";
                ModelTableInfoDTO inputDO = this.queryTableWithNameForInout(appInfo.getAppId(), inputDOName);
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                String tableObjectType = String.valueOf(table.getObjectType());
                String author = table.getCreateUser();
                TmProjectInfoBo tpib = new TmProjectInfoBo();
                tpib.setProjectId(appInfo.getAppCode());
                tpib.setProjectCode(appInfo.getAppCode());
                tpib.setProjectName(appInfo.getAppName());
                tpib.setProjectType(tableObjectType);
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(loginUserId);
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s Dao %s-%s", appInfo.getAppName(), table.getObjectName(), table.getObjectCode()));
                ModelTableInfoBo tableBo = this.generateTableBO(table);
                bo.setMainTableModel(tableBo);
                bo.getMapData().put("table", table);
                bo.getMapData().put("tableModelCode", table.getObjectCode());
                HashMap<String, OsrvArrangeImport> importMap = new HashMap<String, OsrvArrangeImport>();
                ArrayList<ModelTableInfoBo> refTableList = new ArrayList<ModelTableInfoBo>();
                if (objectTypeEnum == ObjectType.Data || objectTypeEnum == ObjectType.Main || objectTypeEnum == ObjectType.Second) {
                    this.generateModelTableJoinDetail(tableBo);
                    ModelJoinDetailDTO joinParam = new ModelJoinDetailDTO();
                    joinParam.setJoinDetailId(tableBo.getTableId());
                    List joinList = this.modelJoinDetailService.queryList((Object)joinParam);
                    if (CollectionUtils.isNotEmpty((Collection)joinList)) {
                        for (ModelJoinDetailDTO joinDetail : joinList) {
                            ModelTableInfoDTO joinTable = new ModelTableInfoDTO();
                            joinTable.setObjectId(joinDetail.getObjectId());
                            joinTable = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)joinTable);
                            ModelTableInfoBo joinTableBo = this.generateTableBO(joinTable);
                            OsrvArrangeImport importInfo = new OsrvArrangeImport();
                            importInfo.setClassName(this.wrapperTableToClassName(joinTable.getObjectCode(), joinTable.getObjectType().toString(), joinTable.getObjectId()));
                            importInfo.setProjectCode(tpib.getProjectCode());
                            importInfo.setImportType(OsrvArrangeImport.ImportType.Mapper.getCode());
                            importMap.put(importInfo.getClassName(), importInfo);
                            refTableList.add(joinTableBo);
                        }
                    }
                    bo.getMapData().put("joinList", joinList);
                    Object[] reverserJoinList = joinList.toArray(new ModelJoinDetail[0]);
                    CollectionUtils.reverseArray((Object[])reverserJoinList);
                    bo.getMapData().put("reverserJoinList", Arrays.asList(reverserJoinList));
                } else {
                    bo.getMapData().put("joinList", Collections.EMPTY_LIST);
                }
                bo.getMapData().put("refTableList", refTableList);
                modelParam.setTableModelId(table.getObjectId());
                List modelList = this.srvModelInfoService.queryList((Object)modelParam);
                ArrayList methods = new ArrayList(modelList.size());
                Map dataMap = bo.getMapData();
                dataMap.put("methods", methods);
                for (SrvModelInfoDTO modelInfo : modelList) {
                    SrvModelInoutDTO outputSingle;
                    OsrvArrangeImport importCls;
                    HashMap<String, Object> method = new HashMap<String, Object>();
                    method.put("modelInfo", modelInfo);
                    method.put("methodName", modelInfo.getSrvModelCode());
                    SrvModelTypeEnum srvModelTypeEnum = SrvModelTypeEnum.getModelByType((String)modelInfo.getSrvModelType());
                    if (SrvModelTypeEnum.QUERY_BY_PK == srvModelTypeEnum || SrvModelTypeEnum.QUERY_SINGLE == srvModelTypeEnum) {
                        method.put("singleOutput", true);
                    } else {
                        method.put("singleOutput", false);
                    }
                    String mapperOutput_mainTableClassName = TmModelUtil.tableCodeToClassName((String)table.getObjectCode()) + "PO";
                    SrvModelInoutDTO mapperInput = new SrvModelInoutDTO();
                    mapperInput.setSrvModelId(modelInfo.getSrvModelId());
                    mapperInput.setListFlag(YesOrNO.NO.getCode());
                    mapperInput.setObjectType(table.getObjectType());
                    mapperInput.setTableModelId(table.getObjectId());
                    mapperInput.setTableModelCode(mapperOutput_mainTableClassName);
                    mapperInput.setTableModelName(table.getObjectName());
                    method.put("mapperInput", mapperInput);
                    OsrvArrangeImport mapperInput_importCls = new OsrvArrangeImport();
                    mapperInput_importCls.setClassName(mapperOutput_mainTableClassName);
                    mapperInput_importCls.setProjectCode(tpib.getProjectCode());
                    mapperInput_importCls.setImportType(OsrvArrangeImport.ImportType.PO.getCode());
                    importMap.put(mapperInput_importCls.getClassName(), mapperInput_importCls);
                    SrvModelInoutDTO inoutParam = new SrvModelInoutDTO();
                    inoutParam.setSrvModelId(modelInfo.getSrvModelId());
                    inoutParam.setIoType(IOType.Input.getCode());
                    List inputParams = this.srvModelInoutService.queryList((Object)inoutParam);
                    SrvModelInoutDTO inputSingle = null;
                    for (SrvModelInoutDTO inout : inputParams) {
                        if (StringUtils.equals((CharSequence)inputDOName, (CharSequence)inout.getTableModelCode())) {
                            inputSingle = inout;
                            mapperInput.setListFlag(inout.getListFlag());
                        }
                        inout.setTableModelCode(this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                        importCls = new OsrvArrangeImport();
                        importCls.setClassName(inout.getTableModelCode());
                        importCls.setProjectCode(tpib.getProjectCode());
                        importCls.setTableModelId(inout.getTableModelId());
                        importCls.setImportType(this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                        importMap.put(importCls.getClassName(), importCls);
                    }
                    if (srvModelTypeEnum == SrvModelTypeEnum.QUERY) {
                        method.put("input", Arrays.asList(inputSingle, userTokenInout, pageInfoInout));
                        method.put("mapperInputList", Arrays.asList(inputSingle, userTokenInout, pageInfoInout));
                        mapperInput = inputSingle;
                    } else if (srvModelTypeEnum == SrvModelTypeEnum.QUERY_BATCH || srvModelTypeEnum == SrvModelTypeEnum.QUERY_CUSTOMIZE) {
                        method.put("input", Arrays.asList(inputSingle, userTokenInout));
                        method.put("mapperInputList", Arrays.asList(inputSingle, userTokenInout));
                        mapperInput = inputSingle;
                    } else {
                        SrvModelInoutDTO inputTableDO = new SrvModelInoutDTO();
                        inputTableDO.setTableModelId(table.getObjectId());
                        inputTableDO.setTableModelCode(table.getObjectCode());
                        inputTableDO.setTableModelName(table.getObjectName());
                        inputTableDO.setObjectType(table.getObjectType());
                        inputTableDO.setIoType(IOType.Input.getCode());
                        inputTableDO.setListFlag(inputSingle.getListFlag());
                        String importType = this.judgeTableToClassName(inputTableDO.getTableModelCode(), inputTableDO.getObjectType().toString(), inputTableDO.getTableModelId());
                        inputTableDO.setTableModelCode(this.wrapperTableToClassName(inputTableDO.getTableModelCode(), inputTableDO.getObjectType().toString(), inputTableDO.getTableModelId()));
                        inputSingle = inputTableDO;
                        importCls = new OsrvArrangeImport();
                        importCls.setClassName(inputTableDO.getTableModelCode());
                        importCls.setProjectCode(tpib.getProjectCode());
                        importCls.setTableModelId(inputTableDO.getTableModelId());
                        importCls.setImportType(importType);
                        importMap.put(importCls.getClassName(), importCls);
                        method.put("input", Arrays.asList(inputTableDO, userTokenInout));
                        method.put("mapperInputList", Arrays.asList(mapperInput, userTokenInout));
                    }
                    method.put("inputSingle", inputSingle);
                    method.put("UserTokenInfo", this.wrapperTableToClassName(userTokenInfo.getObjectCode(), userTokenInfo.getObjectType().toString(), userTokenInfo.getObjectId()));
                    method.put("PageInfo", this.wrapperTableToClassName(pageInfo.getObjectCode(), pageInfo.getObjectType().toString(), pageInfo.getObjectId()));
                    inoutParam.setIoType(IOType.Output.getCode());
                    List outputParams = this.srvModelInoutService.queryList((Object)inoutParam);
                    SrvModelInoutDTO srvModelInoutDTO = outputSingle = outputParams.isEmpty() ? null : (SrvModelInoutDTO)outputParams.get(0);
                    if (CollectionUtils.isNotEmpty((Collection)outputParams)) {
                        String mainTableClassName = TmModelUtil.tableCodeToClassName((String)table.getObjectCode()) + "PO";
                        SrvModelInoutDTO output = (SrvModelInoutDTO)outputParams.get(0);
                        SrvModelInoutDTO mapperOutput = new SrvModelInoutDTO();
                        mapperOutput.setSrvModelId(modelInfo.getSrvModelId());
                        mapperOutput.setIoType(output.getIoType());
                        mapperOutput.setListFlag(output.getListFlag());
                        mapperOutput.setObjectType(table.getObjectType());
                        mapperOutput.setTableModelId(table.getObjectId());
                        mapperOutput.setTableModelCode(mainTableClassName);
                        mapperOutput.setTableModelName(table.getObjectName());
                        method.put("mapperOutput", mapperOutput);
                        OsrvArrangeImport importCls2 = new OsrvArrangeImport();
                        importCls2.setClassName(mainTableClassName);
                        importCls2.setProjectCode(tpib.getProjectCode());
                        importCls2.setImportType(OsrvArrangeImport.ImportType.PO.getCode());
                        importMap.put(importCls2.getClassName(), importCls2);
                    }
                    for (SrvModelInoutDTO inout : outputParams) {
                        inout.setTableModelCode(this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                        OsrvArrangeImport importCls3 = new OsrvArrangeImport();
                        importCls3.setClassName(inout.getTableModelCode());
                        importCls3.setProjectCode(tpib.getProjectCode());
                        importCls3.setTableModelId(inout.getTableModelId());
                        importCls3.setImportType(this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                        importMap.put(importCls3.getClassName(), importCls3);
                    }
                    method.put("output", outputParams.isEmpty() ? null : (Object)outputParams.get(0));
                    if (SrvModelTypeEnum.UPDATE_CUSTOMIZE == srvModelTypeEnum || SrvModelTypeEnum.DELETE_CUSTOMIZE == srvModelTypeEnum || SrvModelTypeEnum.QUERY_CUSTOMIZE == srvModelTypeEnum || SrvModelTypeEnum.ASSOCIATED_QUERY_CUSTOMIZE == srvModelTypeEnum) {
                        IsrvSqlInfoDTO isrvSqlInfo = new IsrvSqlInfoDTO();
                        isrvSqlInfo.setSrvModelId(modelInfo.getSrvModelId());
                        List isrvSqlInfos = this.isrvSqlInfoService.queryList((Object)isrvSqlInfo);
                        method.put("isrvSqlInfos", isrvSqlInfos);
                    }
                    IsrvSqlCondDTO isrvSqlCond = new IsrvSqlCondDTO();
                    isrvSqlCond.setSrvModelId(modelInfo.getSrvModelId());
                    List condList = this.isrvSqlCondService.queryList((Object)isrvSqlCond);
                    if (CollectionUtils.isNotEmpty((Collection)condList)) {
                        ArrayList<Map> condMapList = new ArrayList<Map>();
                        for (IsrvSqlCondDTO cond : condList) {
                            if (StringUtils.isBlank((CharSequence)cond.getTableFieldId())) continue;
                            ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
                            fieldParam.setFieldId(cond.getDomainFieldId());
                            ModelTableFieldDTO evalField = (ModelTableFieldDTO)this.modelTableFieldService.queryByPk((Object)fieldParam);
                            Map condMap = MapBeanUtil.beanToMap((Object)cond);
                            String javaPropName = TmModelUtil.fieldToProperty((String)cond.getEvalContent());
                            if (evalField != null) {
                                if (StringUtils.equals((CharSequence)evalField.getObjectId(), (CharSequence)inputDO.getObjectId())) {
                                    javaPropName = SrvModelTypeEnum.DELETE_BATCH == srvModelTypeEnum || SrvModelTypeEnum.UPDATE_BATCH == srvModelTypeEnum || SrvModelTypeEnum.QUERY_BATCH == srvModelTypeEnum ? "item." + javaPropName : StringUtils.uncapitalize((String)mapperInput.getTableModelCode()) + "." + javaPropName;
                                } else if (StringUtils.equals((CharSequence)evalField.getObjectId(), (CharSequence)userTokenInfo.getObjectId())) {
                                    javaPropName = StringUtils.uncapitalize((String)userTokenInout.getTableModelCode()) + "." + javaPropName;
                                } else if (StringUtils.equals((CharSequence)evalField.getObjectId(), (CharSequence)pageInfo.getObjectId())) {
                                    javaPropName = StringUtils.uncapitalize((String)pageInfoInout.getTableModelCode()) + "." + javaPropName;
                                }
                            }
                            condMap.put("javaPropertyName", javaPropName);
                            condMap.put("fieldCode", cond.getTableFieldCode());
                            if (FieldEvalWay.CONST.getCode().equals(cond.getFieldEvalWay())) {
                                condMap.put("const", true);
                            } else {
                                condMap.put("const", false);
                            }
                            if (CondNotEmptyEnum.Y.getCode().equals(cond.getCondNotEmpty())) {
                                condMap.put("condNotEmpty", Boolean.TRUE);
                            } else {
                                condMap.put("condNotEmpty", Boolean.FALSE);
                            }
                            condMapList.add(condMap);
                        }
                        method.put("condList", condMapList);
                    } else {
                        method.put("condList", new ArrayList());
                    }
                    methods.add(method);
                }
                dataMap.put("importList", importMap.values());
                ctdbList.add(bo);
            }
        }
        for (CodeTemplateDataBo ctdb : ctdbList) {
            this.wrapAppsParam(appInfo.getAppId(), ctdb);
            String package_prefix = this.getPackagePrefix(ctdb);
            Map mapData = ctdb.getMapData();
            TmProjectInfoBo tpib = (TmProjectInfoBo)mapData.get("TmProject");
            ctdb.getMapData().put("extendBaseInfoFlag", false);
            this.produceCodeFile("XXXPO.java", "infrastructure", "src/main/java/" + package_prefix + "/" + GenInfrastructureTask.formatClassPath(appCode) + "/infra/persistence/po/", appInfo, ctdb);
            this.produceCodeFile("XXXMapper.java", "infrastructure", "src/main/java/" + package_prefix + "/" + GenInfrastructureTask.formatClassPath(appCode) + "/infra/persistence/mapper/", appInfo, ctdb);
            this.produceCodeFile("XXXRepositoryImpl.java", "infrastructure", "src/main/java/" + package_prefix + "/" + GenInfrastructureTask.formatClassPath(appCode) + "/infra/repository/impl/", appInfo, ctdb);
            this.produceCodeFile("XXXMapperImpl.xml", "infrastructure", "src/main/resources/mybatis/mapper/", appInfo, ctdb);
        }
        String mapperXmlTargetPath = SdEnvUtil.PROJECT_PATH + appInfo.getAppCode() + File.separator + String.format("%s-%s", appInfo.getAppCode(), "infrastructure").replace(".", "-") + File.separator + "src/main/resources/mybatis/mapper/";
        MyBatter.formatFileOrDirectory((String)mapperXmlTargetPath, (String)"*.xml", (String)"utf-8", (boolean)false, (boolean)true);
        CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
        TmProjectInfoBo pomTp = new TmProjectInfoBo();
        pomTp.setProjectId(appInfo.getAppCode());
        pomTp.setProjectCode(appInfo.getAppCode());
        pomTp.setProjectName(appInfo.getAppName());
        pomBo.setTmProjectInfo(pomTp);
        this.wrapAppsParam(appInfo.getAppId(), pomBo);
        String package_prefix = this.getPackagePrefix(pomBo);
        this.produceCodeFile("infrastructure-pom.xml", "", "infrastructure-", "infrastructure", "", appInfo, pomBo);
        return true;
    }
}

