/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamPortalService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.CodeTemplateRepoPullTask;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskQrygenService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskQrygenDTO;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionEnumService;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.CodeProduceInfoService;
import com.irdstudio.allinrdm.dev.console.facade.QryModelCondService;
import com.irdstudio.allinrdm.dev.console.facade.QryModelInfoDevService;
import com.irdstudio.allinrdm.dev.console.facade.QryModelRelationService;
import com.irdstudio.allinrdm.dev.console.facade.QryModelResultService;
import com.irdstudio.allinrdm.dev.console.facade.QryModelSortService;
import com.irdstudio.allinrdm.dev.console.facade.QryModelTableService;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryModelCondDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryModelRelationDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryModelResultDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryModelSortDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryTableConfigDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.QryTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.CondType;
import com.irdstudio.allinrdm.dev.console.types.ModelStat;
import com.irdstudio.allinrdm.dev.console.types.ResultType;
import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryGenTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(QueryGenTask.class);
    private static final Pattern NumberCheckPattern = Pattern.compile("^\\d+\\S*");
    private PaasTaskInfoDTO taskInfo;
    private PaasTaskQrygenService paasTaskQryService;
    private PaasAppsInfoService paasAppsInfoService;
    private ComBaseInfoService comBaseInfoService;
    private RdmModuleInfoService rdmModuleInfoService;
    private CodeProduceInfoService codeProduceInfoService;
    private ModelTableInfoService modelTableInfoService;
    private ModelTableFieldService modelTableFieldService;
    private DictOptionEnumService dictOptionEnumService;
    private DictOptionInfoService dictOptionInfoService;
    private QryModelInfoDevService qryModelInfoService;
    private QryModelCondService qryModelCondService;
    private QryModelResultService qryModelResultService;
    private QryModelSortService qryModelSortService;
    private QryModelTableService qryModelTableService;
    private QryModelRelationService qryModelRelationService;

    public QueryGenTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            List qryList;
            this.paasTaskQryService = (PaasTaskQrygenService)SpringContextUtils.getBean(PaasTaskQrygenService.class);
            this.paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            this.comBaseInfoService = (ComBaseInfoService)SpringContextUtils.getBean(ComBaseInfoService.class);
            this.rdmModuleInfoService = (RdmModuleInfoService)SpringContextUtils.getBean(RdmModuleInfoService.class);
            this.codeProduceInfoService = (CodeProduceInfoService)SpringContextUtils.getBean(CodeProduceInfoService.class);
            this.modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
            this.modelTableFieldService = (ModelTableFieldService)SpringContextUtils.getBean(ModelTableFieldService.class);
            this.dictOptionEnumService = (DictOptionEnumService)SpringContextUtils.getBean(DictOptionEnumService.class);
            this.dictOptionInfoService = (DictOptionInfoService)SpringContextUtils.getBean(DictOptionInfoService.class);
            this.qryModelInfoService = (QryModelInfoDevService)SpringContextUtils.getBean(QryModelInfoDevService.class);
            this.qryModelCondService = (QryModelCondService)SpringContextUtils.getBean(QryModelCondService.class);
            this.qryModelResultService = (QryModelResultService)SpringContextUtils.getBean(QryModelResultService.class);
            this.qryModelSortService = (QryModelSortService)SpringContextUtils.getBean(QryModelSortService.class);
            this.qryModelTableService = (QryModelTableService)SpringContextUtils.getBean(QryModelTableService.class);
            this.qryModelRelationService = (QryModelRelationService)SpringContextUtils.getBean(QryModelRelationService.class);
            PaasTaskQrygenDTO fngenDTO = new PaasTaskQrygenDTO();
            fngenDTO.setTaskId(this.taskInfo.getTaskId());
            fngenDTO = (PaasTaskQrygenDTO)this.paasTaskQryService.queryByPk((Object)fngenDTO);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String moduleId = this.taskInfo.getModuleId();
            String qryId = fngenDTO.getQryId();
            String comId = null;
            QryModelInfoDTO qryParam = new QryModelInfoDTO();
            qryParam.setSubsId(subsId);
            qryParam.setAppId(appId);
            if (StringUtils.isNotBlank((CharSequence)qryId)) {
                qryParam.setQryId(qryId);
            }
            if (StringUtils.isNotBlank(comId)) {
                qryParam.setComId(comId);
            }
            if (StringUtils.isNotBlank((CharSequence)moduleId)) {
                qryParam.setModuleId(moduleId);
            }
            if (CollectionUtils.isNotEmpty((Collection)(qryList = this.qryModelInfoService.queryList((Object)qryParam)))) {
                PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
                appInfo.setAppId(appId);
                appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
                if (appInfo == null) {
                    throw new RuntimeException(appId + "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                appInfo.setLoginUserId(this.taskInfo.getLoginUserId());
                this.checkAndImportCom(appInfo, "COM01019", "S03013");
                CodeTemplateRepoPullTask templatePullTask = new CodeTemplateRepoPullTask();
                templatePullTask.syncRun();
                String nowTime = CurrentDateUtil.getTodayDate();
                String rootPath = SdEnvUtil.PROJECT_PATH + File.separator + appId;
                File rootDir = new File(rootPath);
                FileUtils.deleteQuietly((File)rootDir);
                if (!rootDir.exists()) {
                    rootDir.mkdirs();
                }
                PaasAppsParamPortalService paasAppsParamService = (PaasAppsParamPortalService)SpringContextUtils.getBean(PaasAppsParamPortalService.class);
                Map appsParam = paasAppsParamService.queryAppParamMap(appInfo.getAppId(), "dev");
                String packagePrefixVal = "com.irdstudio";
                if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)appsParam, (Object)"package_prefix"))) {
                    packagePrefixVal = MapUtils.getString((Map)appsParam, (Object)"package_prefix");
                }
                String appCode = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
                for (QryModelInfoDTO qryModel : qryList) {
                    String tableModelAlias;
                    CodeTemplateDataBo ctdb = new CodeTemplateDataBo();
                    ctdb.getEnvBo().setAuthor(userId);
                    ctdb.getEnvBo().setDesc(qryModel.getQryName());
                    ctdb.getEnvBo().setCurrentDate(nowTime);
                    ctdb.getMapData().put("qryModel", qryModel);
                    QryTableConfigDTO tableConfig = this.generationTableConfig(qryModel);
                    tableConfig.setQryInfo(qryModel);
                    ctdb.getMapData().put("tableConfig", tableConfig);
                    ctdb.getMapData().put("fromExpression", tableConfig.getFromExpression());
                    HashMap<String, Object> dtoFieldMap = new HashMap<String, Object>();
                    HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                    QryModelCondDTO condParam = new QryModelCondDTO();
                    condParam.setQryId(qryModel.getQryId());
                    List condList = this.qryModelCondService.queryList((Object)condParam);
                    ctdb.getMapData().put("condList", condList);
                    for (QryModelCondDTO cond : condList) {
                        if (StringUtils.equals((CharSequence)cond.getCondType(), (CharSequence)CondType.Inside.getCode())) {
                            cond.setExpression(cond.getCondExp());
                            continue;
                        }
                        Object field = new ModelTableFieldDTO();
                        field.setFieldId(cond.getFieldId());
                        if ((field = (ModelTableFieldDTO)this.modelTableFieldService.queryByPk(field)) == null) continue;
                        field = this.generateTableField((ModelTableFieldDTO)field);
                        cond.setFieldCode(field.getFieldCode());
                        cond.setFieldName(field.getFieldName());
                        cond.setFieldOption(field.getFieldOption());
                        cond.setJavaMethodName(field.getJavaMethodName());
                        cond.setJavaPropertyName(field.getJavaPropertyName());
                        cond.setJavaType(field.getJavaType());
                        String expression = cond.getCondExp();
                        String replaceStr = String.format("#{%s}", field.getJavaPropertyName());
                        expression = expression.replaceAll("\\?", replaceStr);
                        QryTableInfoDTO table = (QryTableInfoDTO)tableConfig.getTableMap().get(field.getObjectId());
                        if (table != null && !StringUtils.equals((CharSequence)table.getTableModelAlias(), (CharSequence)table.getTableModelCode())) {
                            String tableAlias = table.getTableModelAlias();
                            String tableCode = table.getTableModelCode();
                            expression = expression.replaceAll(tableCode, tableAlias);
                        }
                        cond.setExpression(expression);
                        dtoFieldMap.put(field.getJavaPropertyName(), cond);
                        fieldMap.put(field.getFieldId(), field);
                    }
                    QryModelResultDTO resultParam = new QryModelResultDTO();
                    resultParam.setQryId(qryModel.getQryId());
                    List resultList = this.qryModelResultService.queryList((Object)resultParam);
                    ctdb.getMapData().put("resultList", resultList);
                    for (QryModelResultDTO result : resultList) {
                        Object field = new ModelTableFieldDTO();
                        field.setFieldId(result.getFieldId());
                        if ((field = (ModelTableFieldDTO)this.modelTableFieldService.queryByPk(field)) == null) continue;
                        field = this.generateTableField((ModelTableFieldDTO)field);
                        result.setFieldCode(field.getFieldCode());
                        result.setFieldName(field.getFieldName());
                        result.setFieldOption(field.getFieldOption());
                        result.setJavaMethodName(field.getJavaMethodName());
                        result.setJavaPropertyName(field.getJavaPropertyName());
                        result.setJavaType(field.getJavaType());
                        String expression = result.getResultExp();
                        QryTableInfoDTO table = (QryTableInfoDTO)tableConfig.getTableMap().get(field.getObjectId());
                        if (StringUtils.equals((CharSequence)ResultType.Field.getCode(), (CharSequence)result.getResultType())) {
                            tableModelAlias = table.getTableModelAlias();
                            expression = String.format("%s.%s", tableModelAlias, field.getFieldCode());
                        }
                        if (table != null && !StringUtils.equals((CharSequence)table.getTableModelAlias(), (CharSequence)table.getTableModelCode())) {
                            String tableAlias = table.getTableModelAlias();
                            String tableCode = table.getTableModelCode();
                            expression = expression.replaceAll(tableCode, tableAlias);
                        }
                        result.setExpression(expression);
                        dtoFieldMap.put(field.getJavaPropertyName(), result);
                        fieldMap.put(field.getFieldId(), field);
                    }
                    QryModelSortDTO sortParam = new QryModelSortDTO();
                    sortParam.setQryId(qryModel.getQryId());
                    List sortList = this.qryModelSortService.queryList((Object)sortParam);
                    ctdb.getMapData().put("sortList", sortList);
                    for (QryModelSortDTO sort : sortList) {
                        QryTableInfoDTO config = (QryTableInfoDTO)tableConfig.getTableMap().get(sort.getTableModelId());
                        tableModelAlias = config.getTableModelAlias();
                        String fieldCode = String.format("%s.%s", tableModelAlias, sort.getSortCode());
                        sort.setFieldCode(fieldCode);
                        ModelTableFieldDTO field = (ModelTableFieldDTO)fieldMap.get(sort.getFieldId());
                        if (field == null) continue;
                        sort.setFieldName(field.getFieldName());
                        sort.setFieldOption(field.getFieldOption());
                        sort.setJavaMethodName(field.getJavaMethodName());
                        sort.setJavaPropertyName(field.getJavaPropertyName());
                        sort.setJavaType(field.getJavaType());
                    }
                    ctdb.getMapData().put("fieldList", dtoFieldMap.values());
                    List<Map<String, Object>> optionsList = this.getOptionList(fieldMap.values());
                    ctdb.getMapData().put("optionsList", optionsList);
                    String comFeatureCodePackage = "";
                    RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
                    moduleInfo.setModuleId(qryModel.getModuleId());
                    moduleInfo = this.rdmModuleInfoService.queryByPk(moduleInfo);
                    if (moduleInfo != null) {
                        comFeatureCodePackage = moduleInfo.getFeatureCode();
                        packagePrefixVal = moduleInfo.getOrgCode();
                    } else {
                        comFeatureCodePackage = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
                    }
                    String appCodePackage = (packagePrefixVal + "." + comFeatureCodePackage).replaceAll("_|\\.|-", "/");
                    ctdb.getMapData().put("appCode", appCode);
                    ctdb.getMapData().put("appCodePackage", appCodePackage.replaceAll("_|\\.|-|/", "."));
                    ctdb.getMapData().put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "."));
                    ctdb.getMapData().put("comFeatureCodePackagePath", comFeatureCodePackage.replaceAll("_|\\.|-", "/"));
                    ctdb.getMapData().put("appsParam", appsParam);
                    ctdb.getMapData().put("nowTime", nowTime);
                    ctdb.getMapData().put("tableConfig", tableConfig);
                    ctdb.getMapData().put("qryModel", qryModel);
                    ctdb.getMapData().put("optionList", optionsList);
                    ctdb.getMapData().put("BASE_PATH", this.getBasePath(comFeatureCodePackage.replaceAll("_|\\.|-", "/")));
                    List<String> mainCodeTemplateFiles = Arrays.asList("${appCode}-web/src/main/java/${appCodePackage}/web/operation/", "XXXQryController.java", "${appCode}-infrastructure/src/main/resources/mybatis/mapper/${appCodePackage}/", "XXXMapperImpl.xml", "${appCode}-start/src/main/resources/front/page/${comFeatureCodePackage}/", "XXXQryPage.html");
                    HashMap<String, String> expMap = new HashMap<String, String>();
                    expMap.put("appCode", SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode()));
                    expMap.put("appCodePackage", appCodePackage);
                    expMap.put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "/"));
                    for (int i = 0; i < mainCodeTemplateFiles.size(); i += 2) {
                        String path = mainCodeTemplateFiles.get(i);
                        String templateFile = mainCodeTemplateFiles.get(i + 1);
                        String targetPath = ExpressionUtil.parse((String)path, expMap);
                        this.codeProduceInfoService.produceCodeFile("qry", templateFile, qryModel.getQryId(), "XXX", qryModel.getQryId(), null, targetPath, appInfo.getAppId(), ctdb);
                    }
                    String id = qryModel.getQryId();
                    File idDir = new File(SdEnvUtil.PROJECT_PATH + File.separator + id);
                    this.genQryDataJsonFile(tableConfig, idDir.getAbsolutePath(), appCode);
                    if (idDir.exists()) {
                        FileUtils.copyDirectory((File)idDir, (File)rootDir);
                    }
                    qryModel.setModelStat(ModelStat.Generated.getCode());
                    this.qryModelInfoService.updateByPk((Object)qryModel);
                }
            }
            this.taskInfo.setTaskErrorMsg(null);
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u67e5\u8be2\u6a21\u578b\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u67e5\u8be2\u6a21\u578b\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }

    private String getBasePath(String codePackagePath) {
        String[] strs = StringUtils.split((String)codePackagePath, (String)"/");
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("..");
        for (String s : strs) {
            paths.add("..");
        }
        return StringUtils.join(paths, (String)"/");
    }

    private void genQryDataJsonFile(QryTableConfigDTO tableConfig, String rootPath, String appCode) {
        String qryId = tableConfig.getQryInfo().getQryId();
        String comFeatureCodePackage = "";
        RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
        moduleInfo.setModuleId(tableConfig.getQryInfo().getModuleId());
        moduleInfo = this.rdmModuleInfoService.queryByPk(moduleInfo);
        comFeatureCodePackage = moduleInfo != null ? moduleInfo.getFeatureCode() : appCode;
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("qryId", qryId);
        expMap.put("appCode", appCode);
        expMap.put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "/"));
        tableConfig.getQryInfo().setQryPage(ExpressionUtil.parse((String)"page/${comFeatureCodePackage}/${qryId}QryPage.html", expMap));
        String targetPath = ExpressionUtil.parse((String)"${appCode}-application/src/main/resources/META-INF/query/", expMap);
        File dir = new File(rootPath, targetPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File jsonFile = new File(dir, qryId + ".json");
        String jsonString = JSON.toJSONString((Object)tableConfig);
        try (FileOutputStream output = new FileOutputStream(jsonFile);){
            IOUtils.write((String)jsonString, (OutputStream)output, (String)"UTF-8");
        }
        catch (Exception e) {
            logger.error("{}\u67e5\u8be2\u6a21\u578b\u6570\u636e\u751f\u6210\u5f02\u5e38{}", new Object[]{qryId, e.getMessage(), e});
        }
    }

    QryTableConfigDTO generationTableConfig(QryModelInfoDTO qryModel) {
        QryTableConfigDTO tableConfig = new QryTableConfigDTO();
        Map config = tableConfig.getTableMap();
        ModelTableInfoDTO tableParam = new ModelTableInfoDTO();
        tableParam.setReferenceId(qryModel.getQryId());
        List modelList = this.modelTableInfoService.queryList((Object)tableParam);
        QryModelRelationDTO relationParam = new QryModelRelationDTO();
        relationParam.setQryId(qryModel.getQryId());
        List relationList = this.qryModelRelationService.queryList((Object)relationParam);
        for (ModelTableInfoDTO m : modelList) {
            QryTableInfoDTO qryTableInfoDTO = new QryTableInfoDTO();
            qryTableInfoDTO.setTableModelId(m.getObjectId());
            qryTableInfoDTO.setTableModelCode(m.getObjectCode());
            qryTableInfoDTO.setTableModelName(m.getObjectName());
            qryTableInfoDTO.setTableModelAlias(m.getObjectCode());
            config.put(m.getObjectId(), qryTableInfoDTO);
        }
        for (Object relation : relationList) {
            QryTableInfoDTO prev;
            QryTableInfoDTO second;
            String string = relation.getTableMainId();
            String secondId = relation.getTableSecondId();
            QryTableInfoDTO main = (QryTableInfoDTO)config.get(string);
            if (main != null) {
                main.setTableModelAlias(relation.getTableMainAlias());
            }
            if ((second = (QryTableInfoDTO)config.get(secondId)) != null) {
                second.setTableModelAlias(relation.getTableSecondAlias());
            }
            if (main == null || second == null) continue;
            QryTableInfoDTO next = main.getNext();
            if (next != null) {
                while (next != null) {
                    next = next.getNext();
                }
                main = next;
            }
            if ((prev = second.getPrev()) != null) {
                QryTableInfoDTO temp = main;
                main = second;
                second = temp;
            }
            main.setNext(second);
            main.setRelation((QryModelRelationDTO)relation);
            second.setPrev(main);
        }
        ArrayList<QryTableInfoDTO> rootRelations = new ArrayList<QryTableInfoDTO>();
        for (Map.Entry entry : config.entrySet()) {
            QryTableInfoDTO table = (QryTableInfoDTO)entry.getValue();
            if (table.getPrev() != null) continue;
            rootRelations.add(table);
        }
        ArrayList<String> exps = new ArrayList<String>();
        for (QryTableInfoDTO rMap : rootRelations) {
            StringBuffer sb = new StringBuffer();
            this.recursionRelation(sb, rMap);
            exps.add(sb.toString());
        }
        tableConfig.setFromExpression(StringUtils.join(exps, (String)","));
        return tableConfig;
    }

    void recursionRelation(StringBuffer sb, QryTableInfoDTO rMap) {
        QryTableInfoDTO next = rMap.getNext();
        QryModelRelationDTO relation = rMap.getRelation();
        if (relation == null) {
            if (StringUtils.isBlank((CharSequence)sb.toString())) {
                sb.append(rMap.getTableModelCode());
            }
            return;
        }
        String mainId = rMap.getTableModelId();
        String secondId = next.getTableModelId();
        if (StringUtils.equals((CharSequence)relation.getTableMainId(), (CharSequence)mainId)) {
            sb.append(relation.getTableMainCode()).append(" ").append(relation.getTableMainAlias()).append(" ").append(relation.getRelationType()).append(" join ").append(relation.getTableSecondCode()).append(" ").append(relation.getTableSecondAlias()).append(" ").append(" on ").append(relation.getRelationCond());
        } else {
            String type = relation.getRelationType();
            if (StringUtils.equals((CharSequence)type, (CharSequence)"left")) {
                type = "right";
            } else if (StringUtils.equals((CharSequence)type, (CharSequence)"right")) {
                type = "left";
            }
            sb.append(relation.getTableSecondCode()).append(" ").append(relation.getTableSecondAlias()).append(" ").append(type).append(" join ").append(relation.getTableMainCode()).append(" ").append(relation.getTableMainAlias()).append(" ").append(" on ").append(relation.getRelationCond());
        }
        sb.append(" ");
        next = rMap.getNext();
        if (next != null) {
            this.recursionRelation(sb, next);
        }
    }

    ModelTableFieldDTO generateTableField(ModelTableFieldDTO field) {
        String javaPropertyName = TmModelUtil.fieldToProperty((String)field.getFieldCode());
        field.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
        field.setJavaPropertyName(javaPropertyName);
        field.setJavaType(TmModelUtil.fieldTypeToJavaType((String)field.getFieldType()));
        return field;
    }

    private List<Map<String, Object>> getOptionList(Collection<ModelTableFieldDTO> fieldList) {
        ArrayList<Map<String, Object>> optionList = new ArrayList<Map<String, Object>>();
        HashMap optionsSet = new HashMap();
        if (CollectionUtils.isNotEmpty(fieldList)) {
            for (ModelTableFieldDTO field : fieldList) {
                String fieldId = field.getFieldId();
                String fieldOption = field.getFieldOption();
                String dictId = field.getDictId();
                String dictDslId = field.getDictDslId();
                if (!StringUtils.isNotBlank((CharSequence)fieldOption)) continue;
                DictOptionEnumDTO enumParam = new DictOptionEnumDTO();
                enumParam.setDictId(dictId);
                enumParam.setSubsId(dictDslId);
                List dictList = this.dictOptionEnumService.queryList((Object)enumParam);
                DictOptionInfoDTO optionInfo = new DictOptionInfoDTO();
                optionInfo.setDictId(dictId);
                optionInfo.setSubsId(dictDslId);
                if ((optionInfo = (DictOptionInfoDTO)this.dictOptionInfoService.queryByPk((Object)optionInfo)) == null) continue;
                if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                    for (DictOptionEnumDTO dict : dictList) {
                        Matcher m;
                        if (StringUtils.isBlank((CharSequence)dict.getOptionEnum())) {
                            String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionCode());
                            dict.setOptionEnum(optionEnum);
                        }
                        if (!(m = NumberCheckPattern.matcher(dict.getOptionEnum())).matches()) continue;
                        String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionEnum());
                        dict.setOptionEnum(optionEnum);
                    }
                }
                String oriDictCode = optionInfo.getDictCode();
                optionInfo.setDictCode(TmModelUtil.tableCodeToClassName((String)optionInfo.getDictCode()));
                HashMap<String, Object> optionMap = new HashMap<String, Object>();
                optionMap.put("dictCode", optionInfo.getDictCode());
                optionMap.put("dictId", oriDictCode);
                optionMap.put("option", optionInfo);
                optionMap.put("dictList", dictList);
                if (optionsSet.get(oriDictCode) != null) continue;
                optionsSet.put(oriDictCode, optionMap);
                optionList.add(optionMap);
            }
        }
        return optionList;
    }
}

