/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamPortalService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.CodeTemplateRepoPullTask;
import com.irdstudio.allinapaas.portal.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskRptgenService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskRptgenDTO;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionEnumService;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.CodeProduceInfoService;
import com.irdstudio.allinrdm.dev.console.facade.RptDevInfoService;
import com.irdstudio.allinrdm.dev.console.facade.RptModelItemService;
import com.irdstudio.allinrdm.dev.console.facade.dto.RptModelItemDTO;
import com.irdstudio.allinrdm.dev.console.types.ModelStat;
import com.irdstudio.allinrdm.dev.console.types.RptDevType;
import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintpaas.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.allintpaas.sdk.report.facade.operation.dto.RptModelInfoDTO;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RptGenTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(RptGenTask.class);
    private static final Pattern NumberCheckPattern = Pattern.compile("^\\d+\\S*");
    private PaasTaskInfoDTO taskInfo;
    private PaasTaskRptgenService paasRptgenService;
    private PaasAppsInfoService paasAppsInfoService;
    private ComBaseInfoService comBaseInfoService;
    private RdmModuleInfoService rdmModuleInfoService;
    private CodeProduceInfoService codeProduceInfoService;
    private DictOptionEnumService dictOptionEnumService;
    private DictOptionInfoService dictOptionInfoService;
    private RptDevInfoService rptDevInfoService;
    private RptModelItemService rptModelItemService;

    public RptGenTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            this.paasRptgenService = (PaasTaskRptgenService)SpringContextUtils.getBean(PaasTaskRptgenService.class);
            this.paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            this.comBaseInfoService = (ComBaseInfoService)SpringContextUtils.getBean(ComBaseInfoService.class);
            this.rdmModuleInfoService = (RdmModuleInfoService)SpringContextUtils.getBean(RdmModuleInfoService.class);
            this.codeProduceInfoService = (CodeProduceInfoService)SpringContextUtils.getBean(CodeProduceInfoService.class);
            this.dictOptionEnumService = (DictOptionEnumService)SpringContextUtils.getBean(DictOptionEnumService.class);
            this.dictOptionInfoService = (DictOptionInfoService)SpringContextUtils.getBean(DictOptionInfoService.class);
            this.rptDevInfoService = (RptDevInfoService)SpringContextUtils.getBean(RptDevInfoService.class);
            this.rptModelItemService = (RptModelItemService)SpringContextUtils.getBean(RptModelItemService.class);
            PaasTaskRptgenDTO fngenDTO = new PaasTaskRptgenDTO();
            fngenDTO.setTaskId(this.taskInfo.getTaskId());
            fngenDTO = (PaasTaskRptgenDTO)this.paasRptgenService.queryByPk((Object)fngenDTO);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String moduleId = this.taskInfo.getModuleId();
            String rptModelId = fngenDTO.getRptModelId();
            String comId = null;
            RptModelInfoDTO rptParam = new RptModelInfoDTO();
            rptParam.setSubsId(subsId);
            rptParam.setAppId(appId);
            if (StringUtils.isNotBlank((CharSequence)rptModelId)) {
                rptParam.setRptModelId(rptModelId);
            }
            if (StringUtils.isNotBlank(comId)) {
                rptParam.setComId(comId);
            }
            if (StringUtils.isNotBlank((CharSequence)moduleId)) {
                rptParam.setModuleId(moduleId);
            }
            rptParam.setRptDevType(RptDevType.LowCode.getCode());
            List rptList = this.rptDevInfoService.queryList((Object)rptParam);
            if (CollectionUtils.isNotEmpty((Collection)rptList)) {
                PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
                appInfo.setAppId(appId);
                appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
                if (appInfo == null) {
                    throw new RuntimeException(appId + "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                appInfo.setLoginUserId(this.taskInfo.getLoginUserId());
                this.checkAndImportCom(appInfo, "COM01019", "S03013");
                CodeTemplateRepoPullTask templatePullTask = new CodeTemplateRepoPullTask();
                templatePullTask.syncRun();
                String nowTime = CurrentDateUtil.getTodayDate();
                String rootPath = SdEnvUtil.PROJECT_PATH + File.separator + appId;
                File rootDir = new File(rootPath);
                FileUtils.deleteQuietly((File)rootDir);
                if (!rootDir.exists()) {
                    rootDir.mkdirs();
                }
                PaasAppsParamPortalService paasAppsParamService = (PaasAppsParamPortalService)SpringContextUtils.getBean(PaasAppsParamPortalService.class);
                Map appsParam = paasAppsParamService.queryAppParamMap(appInfo.getAppId(), "dev");
                String packagePrefixVal = "com.irdstudio";
                if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)appsParam, (Object)"package_prefix"))) {
                    packagePrefixVal = MapUtils.getString((Map)appsParam, (Object)"package_prefix");
                }
                String appCode = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
                for (RptModelInfoDTO rptDevInfo : rptList) {
                    RptModelItemDTO itemParam = new RptModelItemDTO();
                    itemParam.setAscOrder("orderValue");
                    itemParam.setRptModelId(rptDevInfo.getRptModelId());
                    List itemList = this.rptModelItemService.queryList((Object)itemParam);
                    if (CollectionUtils.isEmpty((Collection)itemList)) {
                        logger.info(rptDevInfo.getRptModelId() + " \u62a5\u8868\u65e0\u5f00\u53d1\u660e\u7ec6\uff0c \u4e0d\u751f\u6210\u4ee3\u7801");
                        continue;
                    }
                    HashMap<String, Map<String, Object>> optionsMap = new HashMap<String, Map<String, Object>>();
                    for (RptModelItemDTO item : itemList) {
                        List rptItem = null;
                        try {
                            rptItem = JSON.parseArray((String)item.getRptItemItem(), Map.class);
                        }
                        catch (Exception e) {
                            logger.error("{}\u62a5\u8868\u5361\u7247\u89e3\u6790\u5f02\u5e38{}", new Object[]{item.getRptItemId(), e.getMessage(), e});
                            continue;
                        }
                        List<Map<String, Object>> optionsList = this.getOptionList(rptItem);
                        item.setRptItemItemList(rptItem);
                        item.setOptionsList(optionsList);
                        if (!CollectionUtils.isNotEmpty(optionsList)) continue;
                        for (Map<String, Object> dic : optionsList) {
                            String dictId = MapUtils.getString(dic, (Object)"dictId");
                            if (optionsMap.get(dictId) != null) continue;
                            optionsMap.put(dictId, dic);
                        }
                    }
                    String featureCodePackage = "";
                    RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
                    moduleInfo.setModuleId(rptDevInfo.getModuleId());
                    moduleInfo = this.rdmModuleInfoService.queryByPk(moduleInfo);
                    if (moduleInfo != null) {
                        featureCodePackage = moduleInfo.getFeatureCode();
                        packagePrefixVal = moduleInfo.getOrgCode();
                    } else {
                        featureCodePackage = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
                    }
                    String appCodePackage = (packagePrefixVal + "." + featureCodePackage).replaceAll("_|\\.|-", "/");
                    CodeTemplateDataBo ctdb = new CodeTemplateDataBo();
                    ctdb.getMapData().put("appCode", appCode);
                    ctdb.getMapData().put("appCodePackage", appCodePackage.replaceAll("_|\\.|-|/", "."));
                    ctdb.getMapData().put("featureCodePackage", featureCodePackage.replaceAll("_|\\.|-", "."));
                    ctdb.getMapData().put("featureCodePackagePath", featureCodePackage.replaceAll("_|\\.|-", "/"));
                    ctdb.getMapData().put("appsParam", appsParam);
                    ctdb.getMapData().put("nowTime", nowTime);
                    ctdb.getMapData().put("rptDevInfo", rptDevInfo);
                    ctdb.getMapData().put("rptItemList", itemList);
                    ctdb.getMapData().put("optionList", optionsMap.values());
                    ctdb.getMapData().put("BASE_PATH", this.getBasePath(featureCodePackage.replaceAll("_|\\.|-", "/")));
                    ctdb.getMapData().put("CARD_BASE_PATH", this.getBasePath("allintpaas.sdk.card".replaceAll("_|\\.|-", "/")));
                    List<String> mainCodeTemplateFiles = Arrays.asList("${appCode}-web/src/main/java/${appCodePackage}/web/operation/", "XXXRptController.java", "${appCode}-infrastructure/src/main/resources/mybatis/mapper/${appCodePackage}/", "XXXMapperImpl.xml", "${appCode}-start/src/main/resources/front/page/${featureCodePackage}/", "XXXRptPage.html");
                    HashMap<String, String> expMap = new HashMap<String, String>();
                    expMap.put("appCode", SdEnvUtil.wrapperAppCode(appInfo.getAppCode()));
                    expMap.put("appCodePackage", appCodePackage);
                    expMap.put("featureCodePackage", featureCodePackage.replaceAll("_|\\.|-", "/"));
                    for (int i = 0; i < mainCodeTemplateFiles.size(); i += 2) {
                        String path = mainCodeTemplateFiles.get(i);
                        String templateFile = mainCodeTemplateFiles.get(i + 1);
                        String targetPath = ExpressionUtil.parse((String)path, expMap);
                        this.codeProduceInfoService.produceCodeFile("rpt", templateFile, rptDevInfo.getRptModelId(), "XXX", rptDevInfo.getRptModelId(), null, targetPath, appInfo.getAppId(), ctdb);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                        for (RptModelItemDTO itemDev : itemList) {
                            ctdb.getMapData().put("itemDev", itemDev);
                            String targetPath = ExpressionUtil.parse((String)"${appCode}-start/src/main/resources/front/page/${featureCodePackage}/components/", expMap);
                            this.codeProduceInfoService.produceCodeFile("rpt", "XXXRpt.js", rptDevInfo.getRptModelId() + itemDev.getOrderValue(), "XXX", rptDevInfo.getRptModelId(), null, targetPath, appInfo.getAppId(), ctdb);
                        }
                    }
                    String id = rptDevInfo.getRptModelId();
                    File idDir = new File(SdEnvUtil.PROJECT_PATH + File.separator + id);
                    this.genCardDataJsonFile(rptDevInfo, idDir.getAbsolutePath(), appCode);
                    if (idDir.exists()) {
                        FileUtils.copyDirectory((File)idDir, (File)rootDir);
                    }
                    rptDevInfo.setModelStat(ModelStat.Generated.getCode());
                    this.rptDevInfoService.updateByPk((Object)rptDevInfo);
                }
            }
            this.taskInfo.setTaskErrorMsg(null);
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u62a5\u8868\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u62a5\u8868\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }

    private String getBasePath(String codePackagePath) {
        String[] strs = StringUtils.split((String)codePackagePath, (String)"/");
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("..");
        for (String s : strs) {
            paths.add("..");
        }
        return StringUtils.join(paths, (String)"/");
    }

    private void genCardDataJsonFile(RptModelInfoDTO rptInfo, String rootPath, String appCode) {
        String rptModelId = rptInfo.getRptModelId();
        RptModelInfoDTO rptModel = new RptModelInfoDTO();
        BeanUtility.beanCopy((Object)rptInfo, (Object)rptModel);
        String featureCodePackage = "";
        RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
        moduleInfo.setModuleId(rptInfo.getModuleId());
        moduleInfo = this.rdmModuleInfoService.queryByPk(moduleInfo);
        featureCodePackage = moduleInfo != null ? moduleInfo.getFeatureCode() : appCode;
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("rptModelId", rptModelId);
        expMap.put("appCode", appCode);
        expMap.put("featureCodePackage", featureCodePackage.replaceAll("_|\\.|-", "/"));
        rptModel.setRptModelPage(ExpressionUtil.parse((String)"page/${featureCodePackage}/${rptModelId}RptPage.html", expMap));
        String targetPath = ExpressionUtil.parse((String)"${appCode}-application/src/main/resources/META-INF/report/", expMap);
        File dir = new File(rootPath, targetPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File jsonFile = new File(dir, rptModelId + ".json");
        String jsonString = JSON.toJSONString((Object)rptModel);
        try (FileOutputStream output = new FileOutputStream(jsonFile);){
            IOUtils.write((String)jsonString, (OutputStream)output, (String)"UTF-8");
        }
        catch (Exception e) {
            logger.error("{}\u62a5\u8868\u6570\u636e\u751f\u6210\u5f02\u5e38{}", new Object[]{rptModelId, e.getMessage(), e});
        }
    }

    private List<Map<String, Object>> getOptionList(List<Map> cardDataItem) {
        ArrayList<Map<String, Object>> optionList = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isNotEmpty(cardDataItem)) {
            for (Map field : cardDataItem) {
                String fieldId = MapUtils.getString((Map)field, (Object)"fieldId");
                String fieldOption = MapUtils.getString((Map)field, (Object)"fieldOption");
                String dictId = MapUtils.getString((Map)field, (Object)"dictId");
                String dictDslId = MapUtils.getString((Map)field, (Object)"dictDslId");
                if (!StringUtils.isNotBlank((CharSequence)fieldOption)) continue;
                DictOptionEnumDTO enumParam = new DictOptionEnumDTO();
                enumParam.setDictId(dictId);
                enumParam.setSubsId(dictDslId);
                List dictList = this.dictOptionEnumService.queryList((Object)enumParam);
                DictOptionInfoDTO optionInfo = new DictOptionInfoDTO();
                optionInfo.setDictId(dictId);
                optionInfo.setSubsId(dictDslId);
                if ((optionInfo = (DictOptionInfoDTO)this.dictOptionInfoService.queryByPk((Object)optionInfo)) == null) continue;
                if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                    for (DictOptionEnumDTO dict : dictList) {
                        Matcher m;
                        if (StringUtils.isBlank((CharSequence)dict.getOptionEnum())) {
                            String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionCode());
                            dict.setOptionEnum(optionEnum);
                        }
                        if (!(m = NumberCheckPattern.matcher(dict.getOptionEnum())).matches()) continue;
                        String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionEnum());
                        dict.setOptionEnum(optionEnum);
                    }
                }
                String oriDictCode = optionInfo.getDictCode();
                optionInfo.setDictCode(TmModelUtil.tableCodeToClassName((String)optionInfo.getDictCode()));
                HashMap<String, Object> optionMap = new HashMap<String, Object>();
                optionMap.put("dictCode", optionInfo.getDictCode());
                optionMap.put("dictId", oriDictCode);
                optionMap.put("option", optionInfo);
                optionMap.put("dictList", dictList);
                optionList.add(optionMap);
            }
        }
        return optionList;
    }
}

