/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.admin.console.web.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.irdstudio.allinapaas.admin.console.facade.PaasCbaInfoService;
import com.irdstudio.allinapaas.admin.console.facade.PaasSubsToolService;
import com.irdstudio.allinapaas.admin.console.facade.dto.PaasCbaInfoDTO;
import com.irdstudio.allinapaas.admin.console.facade.dto.PaasSubsToolDTO;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.ops.console.web.controller.api.PaasCbaFtpController;
import com.irdstudio.allinapaas.portal.console.web.controller.api.SummaryController;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasSubsToolController
extends BaseController<PaasSubsToolDTO, PaasSubsToolService> {
    private HttpClient httpClient = HttpClients.createDefault();
    @Autowired
    private PaasCbaInfoService paasCbaInfoService;
    @Autowired
    private PaasEnvInfoService paasEnvInfoService;
    @Autowired
    private SSubsInfoService sSubsInfoService;

    @RequestMapping(value={"/api/paas/subs/tools"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasSubsToolDTO>> queryPaasSubsToolAll(PaasSubsToolDTO dto) {
        List outputVo = ((PaasSubsToolService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/subs/tool/{toolId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasSubsToolDTO> queryByPk(@PathVariable(value="toolId") String toolId) {
        PaasSubsToolDTO inVo = new PaasSubsToolDTO();
        inVo.setToolId(toolId);
        PaasSubsToolDTO outputVo = (PaasSubsToolDTO)((PaasSubsToolService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/subs/tool/{subsId}/{envId}/{cbaCode}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasSubsToolDTO> queryByUniqueKey(@PathVariable(value="subsId") String subsId, @PathVariable(value="envId") String envId, @PathVariable(value="cbaCode") String cbaCode) {
        PaasSubsToolDTO inVo = new PaasSubsToolDTO();
        inVo.setSubsId(subsId);
        inVo.setEnvId(envId);
        inVo.setCbaCode(cbaCode);
        PaasSubsToolDTO outputVo = ((PaasSubsToolService)this.getService()).queryByUniqueKey(inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/subs/tool"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasSubsToolDTO> queryByPk_requestParam(@RequestParam(value="subsId") String subsId, @RequestParam(value="envId", required=false) String envId, @RequestParam(value="cbaCode") String cbaCode) {
        PaasSubsToolDTO inVo = new PaasSubsToolDTO();
        inVo.setSubsId(subsId);
        inVo.setEnvId(envId);
        inVo.setCbaCode(cbaCode);
        PaasSubsToolDTO outputVo = ((PaasSubsToolService)this.getService()).queryByUniqueKey(inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/subs/tool"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasSubsToolDTO inPaasSubsToolDTO) {
        int outputVo = ((PaasSubsToolService)this.getService()).deleteByPk((Object)inPaasSubsToolDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/subs/tool"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasSubsToolDTO inPaasSubsToolDTO) {
        this.setUserInfoToVO(inPaasSubsToolDTO);
        inPaasSubsToolDTO.setLastUpdateUser(inPaasSubsToolDTO.getLoginUserId());
        inPaasSubsToolDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        this.handleToolUrl(inPaasSubsToolDTO);
        int outputVo = ((PaasSubsToolService)this.getService()).updateByPk((Object)inPaasSubsToolDTO);
        if (outputVo == 0) {
            if (StringUtils.isBlank((CharSequence)inPaasSubsToolDTO.getToolId())) {
                inPaasSubsToolDTO.setToolId(UUIDUtil.getShortUUID());
            }
            outputVo = ((PaasSubsToolService)this.getService()).insert((Object)inPaasSubsToolDTO);
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/subs/tool"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasSubsTool(@RequestBody PaasSubsToolDTO inPaasSubsToolDTO) {
        this.setUserInfoToVO(inPaasSubsToolDTO);
        inPaasSubsToolDTO.setCreateUser(inPaasSubsToolDTO.getLoginUserId());
        inPaasSubsToolDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPaasSubsToolDTO.setLastUpdateUser(inPaasSubsToolDTO.getLoginUserId());
        inPaasSubsToolDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        if (StringUtils.isBlank((CharSequence)inPaasSubsToolDTO.getToolId())) {
            inPaasSubsToolDTO.setToolId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((PaasSubsToolService)this.getService()).insert((Object)inPaasSubsToolDTO);
        return this.getResponseData(outputVo);
    }

    private void handleToolUrl(PaasSubsToolDTO tool) {
        if (StringUtils.isBlank((CharSequence)tool.getToolDesc())) {
            String subsName = tool.getSubsName();
            String softName = tool.getSoftName();
            if (StringUtils.isNotBlank((CharSequence)subsName) && StringUtils.isNotBlank((CharSequence)softName)) {
                tool.setToolDesc(String.format("%s-%s", subsName, softName));
            }
        }
        String cbaCode = tool.getCbaCode();
        String subsId = tool.getSubsId();
        String envId = tool.getEnvId();
        PaasCbaInfoDTO cbaInfo = new PaasCbaInfoDTO();
        cbaInfo.setCbaCode(cbaCode);
        cbaInfo = (PaasCbaInfoDTO)this.paasCbaInfoService.queryByPk((Object)cbaInfo);
        if (cbaInfo == null) {
            cbaInfo = new PaasCbaInfoDTO();
            cbaInfo.setCbaCode(cbaCode);
        }
        SSubsInfoDTO subsInfo = new SSubsInfoDTO();
        subsInfo.setSubsId(subsId);
        subsInfo = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)subsInfo);
        if (subsInfo == null) {
            subsInfo = new SSubsInfoDTO();
        }
        PaasEnvInfoDTO envInfo = new PaasEnvInfoDTO();
        envInfo.setEnvId(envId);
        envInfo = (PaasEnvInfoDTO)this.paasEnvInfoService.queryByPk((Object)envInfo);
        if (envInfo == null) {
            envInfo = new PaasEnvInfoDTO();
            envInfo.setEnvId(envId);
        }
        HashMap root = new HashMap();
        root.putAll(BeanUtility.bean2Map((Object)tool));
        root.putAll(BeanUtility.bean2Map((Object)cbaInfo));
        root.putAll(BeanUtility.bean2Map((Object)envInfo));
        root.putAll(BeanUtility.bean2Map((Object)subsInfo));
        if (StringUtils.isNotBlank((CharSequence)cbaInfo.getCbaOverviewInterface())) {
            String overviewUrl = ExpressionUtil.parse((String)cbaInfo.getCbaOverviewInterface(), root);
            tool.setToolOverviewUrl(overviewUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)cbaInfo.getCbaUrl())) {
            String consoleUrl = ExpressionUtil.parse((String)cbaInfo.getCbaUrl(), root);
            tool.setToolConsoleUrl(consoleUrl);
        }
    }

    @RequestMapping(value={"/api/paas/subs/tool/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySubsToolSummary(@RequestBody Map<String, Object> params) {
        String cbaCode = MapUtils.getString(params, (Object)"cbaCode");
        String subsId = MapUtils.getString(params, (Object)"subsId");
        String envId = MapUtils.getString(params, (Object)"envId");
        PaasSubsToolDTO toolInfo = new PaasSubsToolDTO();
        toolInfo.setCbaCode(cbaCode);
        toolInfo.setSubsId(subsId);
        toolInfo.setEnvId(envId);
        toolInfo = ((PaasSubsToolService)this.getService()).queryByUniqueKey(toolInfo);
        if (toolInfo == null) {
            throw new RuntimeException(String.format("\u672a\u914d\u7f6e\u5de5\u5177\u5730\u5740", new Object[0]));
        }
        PaasCbaInfoDTO cbaInfo = new PaasCbaInfoDTO();
        cbaInfo.setCbaCode(cbaCode);
        cbaInfo = (PaasCbaInfoDTO)this.paasCbaInfoService.queryByPk((Object)cbaInfo);
        if (cbaInfo == null) {
            throw new RuntimeException(String.format("Paas\u7ec4\u4ef6\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", new Object[0]));
        }
        if (StringUtils.equals((CharSequence)cbaCode, (CharSequence)"paas-tool-nginx")) {
            return ResponseData.create((Object)Collections.EMPTY_LIST, (String)"9999", (String)String.format("\u6682\u65e0", new Object[0]), (boolean)false);
        }
        if (StringUtils.equals((CharSequence)cbaCode, (CharSequence)"paas-tool-nacos")) {
            List<Map<String, Object>> result = this.handlerNacosApi(toolInfo.getToolOverviewUrl());
            return this.getResponseData(result);
        }
        if (StringUtils.equals((CharSequence)cbaCode, (CharSequence)"paas-tool-ftp")) {
            try {
                PaasCbaFtpController paasCbaFtpController = (PaasCbaFtpController)((Object)SpringContextUtils.getBean(PaasCbaFtpController.class));
                return paasCbaFtpController.querySummaryPaasFtp(params);
            }
            catch (Exception e) {
                logger.error("FTP\u6982\u89c8\u63a5\u53e3\u8c03\u7528\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(String.format("\u6570\u636e\u83b7\u53d6\u5931\u8d25", new Object[0]));
            }
        }
        if (StringUtils.equals((CharSequence)cbaCode, (CharSequence)"paas-dev-code")) {
            SummaryController summaryController = (SummaryController)((Object)SpringContextUtils.getBean(SummaryController.class));
            List result = (List)summaryController.paasDevCodeSummary(params).getRows();
            return this.getResponseData(result);
        }
        if (StringUtils.equals((CharSequence)cbaCode, (CharSequence)"paas-dev-maven")) {
            SummaryController summaryController = (SummaryController)((Object)SpringContextUtils.getBean(SummaryController.class));
            List result = (List)summaryController.paasDevMavenSummary(params).getRows();
            return this.getResponseData(result);
        }
        HttpPost postMethod = new HttpPost(toolInfo.getToolOverviewUrl());
        HttpResponse response = null;
        try {
            String reqJson = JSON.toJSONString(params);
            StringEntity entity = new StringEntity(reqJson, ContentType.APPLICATION_JSON);
            postMethod.setEntity((HttpEntity)entity);
            response = this.httpClient.execute((HttpUriRequest)postMethod);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            ResponseData output = (ResponseData)JSON.parseObject((String)json, ResponseData.class);
            if (output == null) {
                throw new RuntimeException(String.format("\u6570\u636e\u83b7\u53d6\u5931\u8d25", new Object[0]));
            }
            return output;
        }
        catch (Exception e) {
            logger.error("\u5916\u90e8\u5de5\u5177\u6982\u89c8\u63a5\u53e3\u8c03\u7528\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(String.format("\u6570\u636e\u83b7\u53d6\u5931\u8d25", new Object[0]));
        }
    }

    private List<Map<String, Object>> handlerNacosApi(String url) {
        HttpGet method = new HttpGet(url);
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)method);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject nacosResp = JSON.parseObject((String)json);
            if (nacosResp == null) {
                throw new RuntimeException(String.format("\u6570\u636e\u83b7\u53d6\u5931\u8d25", new Object[0]));
            }
            int count = MapUtils.getIntValue((Map)nacosResp, (Object)"count", (int)0);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("cName", "\u670d\u52a1\u6570\u91cf");
            map.put("name", "services");
            map.put("num", count);
            return Arrays.asList(map);
        }
        catch (Exception e) {
            logger.error("\u5916\u90e8\u5de5\u5177\u6982\u89c8\u63a5\u53e3\u8c03\u7528\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

