/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.deliver.console.web.controller.api;

import com.irdstudio.allinapaas.deliver.console.facade.BatInstTaskService;
import com.irdstudio.allinapaas.deliver.console.facade.BatTaskUnitConfigService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.BatInstTaskDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.BatInstTaskTreeDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.BatTaskUnitConfigDTO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class BatInstTaskController
extends BaseController<BatInstTaskDTO, BatInstTaskService> {
    @Autowired
    private BatTaskUnitConfigService batTaskUnitConfigService;

    @RequestMapping(value={"/api/bat/inst/tasks"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BatInstTaskDTO>> queryBatInstTaskAll(BatInstTaskDTO dto) {
        List outputVo = ((BatInstTaskService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bat/inst/tasks/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BatInstTaskDTO>> queryList(BatInstTaskDTO dto) {
        List outputVo = ((BatInstTaskService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bat/inst/task/{batchSerialNo}/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<BatInstTaskDTO> queryByPk(@PathVariable(value="batchSerialNo") String batchSerialNo, @PathVariable(value="taskId") String taskId) {
        BatInstTaskDTO inVo = new BatInstTaskDTO();
        inVo.setBatchSerialNo(batchSerialNo);
        inVo.setTaskId(taskId);
        BatInstTaskDTO outputVo = (BatInstTaskDTO)((BatInstTaskService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bat/inst/task"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody BatInstTaskDTO inBatInstTaskDTO) {
        int outputVo = ((BatInstTaskService)this.getService()).deleteByPk((Object)inBatInstTaskDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bat/inst/task"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody BatInstTaskDTO inBatInstTaskDTO) {
        int outputVo = ((BatInstTaskService)this.getService()).updateByPk((Object)inBatInstTaskDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bat/inst/task"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertBatInstTask(@RequestBody BatInstTaskDTO inBatInstTaskDTO) {
        int outputVo = ((BatInstTaskService)this.getService()).insert((Object)inBatInstTaskDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bat/inst/task/tree/{batchSerialNo}/{batchId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BatInstTaskTreeDTO> queryInstTaskTree(@PathVariable(value="batchSerialNo") String batchSerialNo, @PathVariable(value="batchId") String batchId) {
        BatInstTaskDTO inVo = new BatInstTaskDTO();
        inVo.setBatchSerialNo(batchSerialNo);
        inVo.setBatchId(batchId);
        List outputVo = ((BatInstTaskService)this.getService()).queryBatInstTaskTree(inVo);
        return outputVo;
    }

    @RequestMapping(value={"/api/bat/inst/task/hangup"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> hangUp(@RequestBody BatInstTaskDTO inBatInstTaskVo) {
        BatInstTaskDTO updateParam = new BatInstTaskDTO();
        updateParam.setBatchSerialNo(inBatInstTaskVo.getBatchSerialNo());
        updateParam.setTaskId(inBatInstTaskVo.getTaskId());
        updateParam.setTaskInterveneState("2");
        int outputVo = ((BatInstTaskService)this.getService()).updateByPk((Object)inBatInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bat/inst/task/hangdown"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> hangDown(@RequestBody BatInstTaskDTO inBatInstTaskVo) {
        BatInstTaskDTO updateParam = new BatInstTaskDTO();
        updateParam.setBatchSerialNo(inBatInstTaskVo.getBatchSerialNo());
        updateParam.setTaskId(inBatInstTaskVo.getTaskId());
        updateParam.setTaskInterveneState("0");
        int outputVo = ((BatInstTaskService)this.getService()).updateByPk((Object)inBatInstTaskVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/bat/inst/task/skip"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> skip(@RequestBody BatInstTaskDTO inBatInstTaskVo) {
        BatTaskUnitConfigDTO params = new BatTaskUnitConfigDTO();
        params.setTaskId(inBatInstTaskVo.getTaskId());
        BatTaskUnitConfigDTO configVO = (BatTaskUnitConfigDTO)this.batTaskUnitConfigService.queryByPk((Object)params);
        ResponseData data = null;
        if (configVO != null && StringUtils.isNotEmpty((CharSequence)configVO.getTaskSkipTactic()) && !configVO.getTaskSkipTactic().equals("2")) {
            BatInstTaskDTO updateParam = new BatInstTaskDTO();
            updateParam.setBatchSerialNo(inBatInstTaskVo.getBatchSerialNo());
            updateParam.setTaskId(inBatInstTaskVo.getTaskId());
            updateParam.setTaskInterveneState("1");
            int outputVo = ((BatInstTaskService)this.getService()).updateByPk((Object)inBatInstTaskVo);
            data = this.getResponseData(outputVo);
        } else {
            data = this.getResponseData(-1);
            data.setMessage("\u8be5\u4efb\u52a1\u4e0d\u5141\u8bb8\u7f6e\u8fc7\uff01");
        }
        return data;
    }
}

