/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.deliver.console.web.controller.api;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoPortalService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoSummaryDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoWorkerSummaryDTO;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class PaasEcsInfoPortalController
extends AbstractController {
    @Autowired
    @Qualifier(value="paasEcsInfoPortalServiceImpl")
    protected PaasEcsInfoPortalService paasEcsInfoService;

    @PostMapping(value={"/api/portal/paas/ecs/info"})
    @ResponseBody
    public ResponseData<Integer> insertPaasEcsInfo(@RequestBody PaasEcsInfoDTO inPaasEcsInfoVo) {
        inPaasEcsInfoVo.setEcsId(UUIDUtil.getShortUUID());
        this.setUserInfoToVO(inPaasEcsInfoVo);
        int outputVo = this.paasEcsInfoService.insert((Object)inPaasEcsInfoVo);
        return this.getResponseData(outputVo);
    }

    @DeleteMapping(value={"/api/portal/paas/ecs/info"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasEcsInfoDTO inPaasEcsInfoVo) {
        this.setUserInfoToVO(inPaasEcsInfoVo);
        int outputVo = this.paasEcsInfoService.deleteByPk(inPaasEcsInfoVo);
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/api/portal/paas/ecs/info"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasEcsInfoDTO inPaasEcsInfoVo) {
        this.setUserInfoToVO(inPaasEcsInfoVo);
        int outputVo = this.paasEcsInfoService.updateByPk((Object)inPaasEcsInfoVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/portal/paas/ecs/info/{ecsId}"})
    @ResponseBody
    public ResponseData<PaasEcsInfoDTO> queryByPk(@PathVariable(value="ecsId") String ecsId) {
        PaasEcsInfoDTO inVo = new PaasEcsInfoDTO();
        inVo.setEcsId(ecsId);
        PaasEcsInfoDTO outputVo = (PaasEcsInfoDTO)this.paasEcsInfoService.queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/ecs/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasEcsInfoDTO>> queryPaasEcsInfoAll(PaasEcsInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        if (StringUtils.isNotBlank((CharSequence)vo.getPaasDuId()) && vo.getPaasDuId().contains(",")) {
            String[] ids = StringUtils.split((String)vo.getPaasDuId(), (String)",");
            vo.setPaasCatalogIds(Arrays.asList(ids));
            vo.setPaasDuId(null);
        }
        if (StringUtils.contains((CharSequence)vo.getAppId(), (CharSequence)",")) {
            vo.setAppIdList(Arrays.asList(StringUtils.split((String)vo.getAppId(), (String)",")));
            vo.setAppId(null);
        }
        outputVo = this.paasEcsInfoService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/env/ecs/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasEcsInfoDTO>> queryAllWithEnvInfoByPage(PaasEcsInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        if (StringUtils.isNotBlank((CharSequence)vo.getPaasDuId()) && vo.getPaasDuId().contains(",")) {
            String[] ids = StringUtils.split((String)vo.getPaasDuId(), (String)",");
            vo.setPaasCatalogIds(Arrays.asList(ids));
            vo.setPaasDuId(null);
        }
        outputVo = this.paasEcsInfoService.queryAllWithEnvInfoByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/ecs/info/summarys"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasEcsInfoSummaryDTO>> queryPaasEcsInfoSummaryList(@RequestBody PaasEcsInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = this.paasEcsInfoService.queryPaasEcsInfoSummaryList(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/ecs/info/b/summarys"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasEcsInfoSummaryDTO>> queryCatalogEcsSummaryList(@RequestBody PaasEcsInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = this.paasEcsInfoService.queryCatalogEcsSummaryList(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/ecs/info/worker/summarys"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasEcsInfoWorkerSummaryDTO>> queryTdpWorkerSummary(PaasEcsInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = this.paasEcsInfoService.queryTdpWorkerSummary(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/ecs/info/param"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryEcsInfoParamValue(@RequestParam(value="paramValue") String paramValue) {
        String outputVo = this.paasEcsInfoService.queryEcsInfoParamValue(paramValue);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/ecs/info/url"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> getTestEcsUrl(@RequestParam(value="paramValue") String paramValue) {
        String outputVo = this.paasEcsInfoService.getTestEcsUrl(paramValue);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/ecs/info/console/url"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> getPaasConsoleRequestUrl(@RequestBody PaasEcsInfoDTO paasEcsInfoVO) {
        String outputVo = this.paasEcsInfoService.getPaasConsoleRequestUrl(paasEcsInfoVO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/ecs/infos/du"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> paasEnvDuEcsListByPage(PaasEcsInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = this.paasEcsInfoService.paasEnvDuEcsListByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/ecs/infos/subs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> paasEnvSubsEcsListByPage(PaasEcsInfoDTO vo) {
        List outputVo = null;
        this.setUserInfoToVO(vo);
        outputVo = this.paasEcsInfoService.paasEnvSubsEcsListByPage(vo);
        return this.getResponseData(outputVo);
    }
}

