/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.deliver.console.web.controller.api;

import com.irdstudio.allinapaas.deliver.console.facade.PaasScriptInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasScriptInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasScriptInfoController
extends BaseController<PaasScriptInfoDTO, PaasScriptInfoService> {
    @RequestMapping(value={"/api/paas/script/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasScriptInfoDTO>> queryPaasScriptInfoAll(PaasScriptInfoDTO dto) {
        if (StringUtils.contains((CharSequence)dto.getScriptGroup(), (CharSequence)",")) {
            dto.setScriptGroupList(Arrays.asList(StringUtils.split((String)dto.getScriptGroup(), (String)",")));
            dto.setScriptGroup(null);
        }
        if (StringUtils.contains((CharSequence)dto.getScriptSubgroup(), (CharSequence)",")) {
            dto.setScriptSubgroupList(Arrays.asList(StringUtils.split((String)dto.getScriptSubgroup(), (String)",")));
            dto.setScriptSubgroup(null);
        }
        List outputVo = ((PaasScriptInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/script/info/{scriptId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasScriptInfoDTO> queryByPk(@PathVariable(value="scriptId") String scriptId) {
        PaasScriptInfoDTO inVo = new PaasScriptInfoDTO();
        inVo.setScriptId(scriptId);
        PaasScriptInfoDTO outputVo = (PaasScriptInfoDTO)((PaasScriptInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/script/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasScriptInfoDTO inPaasScriptInfoDTO) {
        int outputVo = ((PaasScriptInfoService)this.getService()).deleteByPk((Object)inPaasScriptInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/script/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasScriptInfoDTO inPaasScriptInfoDTO) {
        this.setUserInfoToVO(inPaasScriptInfoDTO);
        String userId = inPaasScriptInfoDTO.getLoginUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inPaasScriptInfoDTO.setUpdateUser(userId);
        inPaasScriptInfoDTO.setUpdateTime(now);
        int outputVo = ((PaasScriptInfoService)this.getService()).updateByPk((Object)inPaasScriptInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/script/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasScriptInfo(@RequestBody PaasScriptInfoDTO inPaasScriptInfoDTO) {
        this.setUserInfoToVO(inPaasScriptInfoDTO);
        String userId = inPaasScriptInfoDTO.getLoginUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inPaasScriptInfoDTO.setCreateUser(userId);
        inPaasScriptInfoDTO.setCreateTime(now);
        inPaasScriptInfoDTO.setUpdateUser(userId);
        inPaasScriptInfoDTO.setUpdateTime(now);
        if (StringUtils.isBlank((CharSequence)inPaasScriptInfoDTO.getScriptId())) {
            inPaasScriptInfoDTO.setScriptId(UUIDUtil.getUUID());
        }
        int outputVo = ((PaasScriptInfoService)this.getService()).insert((Object)inPaasScriptInfoDTO);
        return this.getResponseData(outputVo);
    }
}

