/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsAdjustService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoPortalService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasTemplateInfoService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsAdjustDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDBDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.portal.console.application.service.impl.apptype.PaasAppsTypeClazzServiceImpl;
import com.irdstudio.allinapaas.portal.console.application.service.utils.DBAppSqlFileGenerate;
import com.irdstudio.allinapaas.portal.console.application.service.utils.DrawOsrvArrangeTable;
import com.irdstudio.allinapaas.portal.console.application.service.utils.JGitUtil;
import com.irdstudio.allinapaas.portal.console.application.service.utils.MiddleAppConfigFileGenerate;
import com.irdstudio.allinapaas.portal.console.types.AdjustType;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInfoService;
import com.irdstudio.allinrdm.dev.console.types.LogAction;
import com.irdstudio.allinrdm.dev.console.types.annotations.AppDevLogAnno;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasAppsInfoPortalController
extends BaseController<PaasAppsInfoDTO, PaasAppsInfoPortalService> {
    private static final Logger logger = LoggerFactory.getLogger(PaasAppsInfoPortalController.class);
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    private PaasEnvParamService paasEnvParamService;
    @Autowired
    private SrvModelInfoService srvModelInfoService;
    @Autowired
    @Qualifier(value="paasTemplateInfoService")
    private PaasTemplateInfoService paasTemplateInfoService;
    @Autowired
    @Qualifier(value="sSubsInfoService")
    private SSubsInfoService sSubsInfoService;
    @Autowired
    @Qualifier(value="paasAppsAdjustServiceImpl")
    private PaasAppsAdjustService paasAppsAdjustService;
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;
    @Value(value="${project.tmp.path}")
    private String projectTmpPath;
    @Value(value="${facenter.code.path:}")
    private String facenterCodePath;
    private DrawOsrvArrangeTable drawOsrvArrangeTable = new DrawOsrvArrangeTable();

    @RequestMapping(value={"/api/portal/paas/apps/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryPaasAppsInfoAll(PaasAppsInfoDTO vo) {
        if (org.apache.commons.lang3.StringUtils.contains((CharSequence)vo.getAppCategory(), (CharSequence)",")) {
            vo.setAppCategorys(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)vo.getAppCategory(), (String)",")));
            vo.setAppCategory(null);
        }
        List outputVo = this.paasAppsInfoService.queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/infos/pop/comps"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryMarketPopPageData(PaasAppsInfoDTO vo) {
        List outputVo = this.paasAppsInfoService.queryMarketPopPageData(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/infos/refs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryAppReferenceComponentsByPage(PaasAppsInfoDTO vo) {
        List outputVo = ((PaasAppsInfoPortalService)this.getService()).queryAppReferenceComponentsByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/infos/by/refeds"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryAppByReferencedByPage(PaasAppsInfoDTO vo) {
        List outputVo = ((PaasAppsInfoPortalService)this.getService()).queryAppByReferencedByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info/filtrate"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryPaasAppsInfos(PaasAppsInfoDTO vo) {
        List outputVo = this.paasAppsInfoService.queryAllByFiltrate(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info/merag/{origin}/{target}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> mergeApp(@PathVariable(value="origin") String origin, @PathVariable(value="target") String target, @RequestParam(value="subsCode") String subsCode) {
        ArrayList adjustContentList = new ArrayList();
        this.srvModelInfoService.mergeAppByAppId(origin, target, adjustContentList);
        int num = this.modelTableInfoService.mergeAppByProjectId(origin, target, adjustContentList);
        PaasAppsAdjustDTO adjustLog = new PaasAppsAdjustDTO();
        adjustLog.setRecordKeyid(UUIDUtil.getUUID());
        adjustLog.setSubsCode(subsCode);
        SSubsInfoDTO sys = new SSubsInfoDTO();
        sys.setSubsCode(subsCode);
        sys = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)sys);
        if (sys != null) {
            adjustLog.setSubsName(sys.getSubsName());
        }
        adjustLog.setAppId(origin);
        PaasAppsInfoDTO originApp = new PaasAppsInfoDTO();
        originApp.setAppId(origin);
        originApp = (PaasAppsInfoDTO)((PaasAppsInfoPortalService)this.getService()).queryByPk((Object)originApp);
        if (originApp != null) {
            adjustLog.setAppCode(originApp.getAppCode());
            adjustLog.setAppName(originApp.getAppName());
        }
        adjustLog.setAdjustContent(JSON.toJSONString(adjustContentList));
        PaasAppsInfoDTO targetApp = new PaasAppsInfoDTO();
        targetApp.setAppId(target);
        targetApp = (PaasAppsInfoDTO)((PaasAppsInfoPortalService)this.getService()).queryByPk((Object)targetApp);
        if (targetApp != null && originApp != null) {
            adjustLog.setAdjustDesc(String.format("%s[%s]\u5408\u5e76\u5230%s[%s]", originApp.getAppName(), originApp.getAppCode(), targetApp.getAppName(), targetApp.getAppCode()));
        } else {
            adjustLog.setAdjustDesc(AdjustType.Combine.getName());
        }
        adjustLog.setAdjustType(AdjustType.Combine.getCode());
        adjustLog.setAdjustUser(this.getUserInfo().getUserId());
        adjustLog.setAdjustTime(CurrentDateUtil.getTodayDateEx2());
        this.paasAppsAdjustService.insert((Object)adjustLog);
        return this.getResponseData(num);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info/move"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> moveApp(@RequestBody Map<String, Object> param) {
        ArrayList<Map<String, Object>> adjustContentList = new ArrayList<Map<String, Object>>();
        String appId = MapUtils.getString(param, (Object)"appId");
        String targetSubsId = MapUtils.getString(param, (Object)"targetSubsId");
        SSubsInfoDTO targetSys = new SSubsInfoDTO();
        targetSys.setSubsId(targetSubsId);
        targetSys = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)targetSys);
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDTO)((PaasAppsInfoPortalService)this.getService()).queryByPk((Object)appInfo);
        SSubsInfoDTO originSys = new SSubsInfoDTO();
        originSys.setSubsId(appInfo.getSubsId());
        originSys = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)originSys);
        appInfo.setSubsId(targetSys.getSubsId());
        appInfo.setSubsCode(targetSys.getSubsCode());
        appInfo.setSubsName(targetSys.getSubsName());
        adjustContentList.add(this.createAdjustMap("\u7cfb\u7edf", String.format("%s %s", originSys.getSubsName(), originSys.getSubsCode()), String.format("%s %s", targetSys.getSubsName(), targetSys.getSubsCode())));
        adjustContentList.add(this.createAdjustMap("\u67b6\u6784\u7c7b\u578b", appInfo.getArchType(), targetSys.getArchType()));
        appInfo.setArchType(targetSys.getArchType());
        String appTemplateId = targetSys.getArchType() + appInfo.getAppType();
        PaasTemplateInfoDTO templateInfo = new PaasTemplateInfoDTO();
        templateInfo.setAppTemplateId(appTemplateId);
        templateInfo = (PaasTemplateInfoDTO)this.paasTemplateInfoService.queryByPk((Object)templateInfo);
        if (templateInfo != null) {
            adjustContentList.add(this.createAdjustMap("\u5e94\u7528\u6a21\u677f", String.format("%s %s", appInfo.getAppTemplateId(), appInfo.getAppTemplateName()), String.format("%s %s", templateInfo.getAppTemplateId(), templateInfo.getAppTemplateName())));
            appInfo.setAppTemplateId(templateInfo.getAppTemplateId());
            appInfo.setAppTemplateName(templateInfo.getAppTemplateName());
        } else if (appInfo.getAppType().equals(AppType.A10.getCode())) {
            templateInfo = new PaasTemplateInfoDTO();
            templateInfo.setAppType(appInfo.getAppType());
            templateInfo.setAppTemplateId(null);
            List templates = this.paasTemplateInfoService.queryListByPage((Object)templateInfo);
            if (CollectionUtils.isNotEmpty((Collection)templates)) {
                adjustContentList.add(this.createAdjustMap("\u5e94\u7528\u6a21\u677f", String.format("%s %s", appInfo.getAppTemplateId(), appInfo.getAppTemplateName()), String.format("%s %s", templateInfo.getAppTemplateId(), templateInfo.getAppTemplateName())));
                templateInfo = (PaasTemplateInfoDTO)templates.get(0);
                appInfo.setAppTemplateId(templateInfo.getAppTemplateId());
                appInfo.setAppTemplateName(templateInfo.getAppTemplateName());
            }
        }
        ((PaasAppsInfoPortalService)this.getService()).updateByPk((Object)appInfo);
        PaasAppsAdjustDTO adjustLog = new PaasAppsAdjustDTO();
        adjustLog.setRecordKeyid(UUIDUtil.getUUID());
        adjustLog.setSubsId(originSys.getSubsId());
        adjustLog.setSubsCode(originSys.getSubsCode());
        adjustLog.setSubsName(originSys.getSubsName());
        adjustLog.setAppId(appInfo.getAppId());
        adjustLog.setAppCode(appInfo.getAppCode());
        adjustLog.setAppName(appInfo.getAppName());
        adjustLog.setAdjustContent(JSON.toJSONString(adjustContentList));
        if (appInfo != null) {
            adjustLog.setAdjustDesc(String.format("%s[%s]\u79fb\u52a8\u5230%s[%s]", appInfo.getAppName(), appInfo.getAppCode(), targetSys.getSubsName(), targetSys.getSubsCode()));
        } else {
            adjustLog.setAdjustDesc(AdjustType.Move.getName());
        }
        adjustLog.setAdjustType(AdjustType.Move.getCode());
        adjustLog.setAdjustUser(this.getUserInfo().getUserId());
        adjustLog.setAdjustTime(CurrentDateUtil.getTodayDateEx2());
        this.paasAppsAdjustService.insert((Object)adjustLog);
        return this.getResponseData(1);
    }

    private Map<String, Object> createAdjustMap(String desc, String before, String after) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("desc", desc);
        map.put("beforeContent", before);
        map.put("afterContent", after);
        return map;
    }

    @RequestMapping(value={"/api/portal/paas/apps/info/{appId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasAppsInfoDTO> queryByPk(@PathVariable(value="appId") String appId) {
        PaasAppsInfoDTO inVo = new PaasAppsInfoDTO();
        inVo.setAppId(appId);
        PaasAppsInfoDTO outputVo = (PaasAppsInfoDTO)((PaasAppsInfoPortalService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasAppsInfoDTO inPaasAppsInfoVo) {
        this.setUserInfoToVO(inPaasAppsInfoVo);
        int outputVo = ((PaasAppsInfoPortalService)this.getService()).deleteByPk((Object)inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @AppDevLogAnno(action=LogAction.Delete, desc="\u5220\u9664\u5e94\u7528 ${args[0].subsId} ${args[0].appId}", appId="${args[0].appId}")
    @RequestMapping(value={"/api/portal/paas/apps/info/project"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteFromProject(@RequestBody PaasAppsInfoDTO inPaasAppsInfoVo) {
        this.setUserInfoToVO(inPaasAppsInfoVo);
        int outputVo = ((PaasAppsInfoPortalService)this.getService()).deleteByCond(inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasAppsInfoDTO inPaasAppsInfoVo) {
        int outputVo = ((PaasAppsInfoPortalService)this.getService()).updateByPk((Object)inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info/replace/template"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateAppTemplateIdByPk(@RequestBody PaasAppsInfoDTO inPaasAppsInfoVo) {
        int outputVo = this.paasAppsInfoService.updateAppTemplateIdByPk(inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info/subsId"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateBySysCode(@RequestBody PaasAppsInfoDTO inPaasAppsInfoVo) {
        int outputVo = this.paasAppsInfoService.updateBySubsCode(inPaasAppsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertPaasAppsInfo(@RequestBody PaasAppsInfoDTO inPaasAppsInfoVo) {
        String now = CurrentDateUtil.getTodayDateEx2();
        String userId = this.getUserInfo().getUserId();
        inPaasAppsInfoVo.setCreateUser(userId);
        inPaasAppsInfoVo.setCreateTime(now);
        inPaasAppsInfoVo.setLastUpdateUser(userId);
        inPaasAppsInfoVo.setLastUpdateTime(now);
        inPaasAppsInfoVo.setAppId(UUIDUtil.getUUID());
        int outputVo = ((PaasAppsInfoPortalService)this.getService()).insert((Object)inPaasAppsInfoVo);
        return this.getResponseData(inPaasAppsInfoVo.getAppId());
    }

    @RequestMapping(value={"/api/portal/paas/apps/info/project"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertPaasAppsInfoFromProject(@RequestParam(name="cpAppId", required=false) String cpAppId, @RequestBody PaasAppsInfoDTO inPaasAppsInfoDTO) {
        this.setUserInfoToVO(inPaasAppsInfoDTO);
        String now = CurrentDateUtil.getTodayDateEx2();
        String userId = this.getUserInfo().getUserId();
        String appType = inPaasAppsInfoDTO.getAppType();
        String archType = inPaasAppsInfoDTO.getArchType();
        String subsId = inPaasAppsInfoDTO.getSubsId();
        inPaasAppsInfoDTO.setSubsId(subsId);
        inPaasAppsInfoDTO.setCreateUser(userId);
        inPaasAppsInfoDTO.setCreateTime(now);
        inPaasAppsInfoDTO.setLastUpdateUser(userId);
        inPaasAppsInfoDTO.setLastUpdateTime(now);
        int outputVo = ((PaasAppsInfoPortalService)this.getService()).insert((Object)inPaasAppsInfoDTO);
        return this.getResponseData(inPaasAppsInfoDTO.getAppId());
    }

    @RequestMapping(value={"/api/portal/paas/apps/infos/index"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryAppsInfoData(@RequestBody PaasAppsInfoDTO param) {
        List outputVo = ((PaasAppsInfoPortalService)this.getService()).queryAppsInfoData(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/infos/page/index"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryAppsInfoDataByPage(PaasAppsInfoDTO param) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)param.getAppIds())) {
            param.setAppIdList(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)param.getAppIds(), (String)",")));
        }
        List outputVo = ((PaasAppsInfoPortalService)this.getService()).queryAppsInfoDataByPage(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/client/portal/paas/apps/infos/page/index"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryAppsInfoDataByPage_client(PaasAppsInfoDTO param) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)param.getAppIds())) {
            param.setAppIdList(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)param.getAppIds(), (String)",")));
        }
        List outputVo = ((PaasAppsInfoPortalService)this.getService()).queryAppsInfoDataByPage(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/infos/page/index/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryAppCountByAppCategory(PaasAppsInfoDTO param) {
        List outputVo = this.paasAppsInfoService.queryAppCountByAppCategory(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/infos/ddspaas/page/index"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryDDspaasAppsInfoDataByPage(PaasAppsInfoDTO param) {
        List outputVo = ((PaasAppsInfoPortalService)this.getService()).queryDDspaasAppsInfoDataByPage(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info/group/summarys"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Map<String, Object>> queryAppsIndexGroupSummary(@RequestBody PaasAppsInfoDTO param) {
        Map outputVo = this.srvModelInfoService.queryAppsIndexGroupSummary(param.getSubsId(), param.getBizDbName());
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/infos/component"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryComponentApp(@RequestBody PaasAppsInfoDTO param) {
        List outputVo = ((PaasAppsInfoPortalService)this.getService()).queryComponentApp(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/infos/platform/component"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryPlatformComponentAppByPage(PaasAppsInfoDTO param) {
        List outputVo = ((PaasAppsInfoPortalService)this.getService()).queryPlatformComponentAppByPage(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info/pull/repo"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> pullComponentRepo(@RequestParam(value="check", required=false) boolean check, @RequestBody PaasAppsInfoDTO vo) {
        ResponseData outputVo = this.getResponseData("\u62c9\u53d6\u6210\u529f");
        logger.info("\u4ee3\u7801\u76ee\u5f55\uff1a" + this.facenterCodePath + File.separator + vo.getAppId());
        PaasAppsInfoDTO appInfo = (PaasAppsInfoDTO)((PaasAppsInfoPortalService)this.getService()).queryByPk((Object)vo);
        if (appInfo == null) {
            outputVo.setRows((Object)"\u5e94\u7528\u4e0d\u5b58\u5728");
        } else {
            File repoPath;
            if (check && (repoPath = new File(this.facenterCodePath + File.separator + appInfo.getAppId())).exists() && repoPath.listFiles().length > 0) {
                outputVo.setRows((Object)"\u4ed3\u5e93\u5df2\u5b58\u5728");
                return outputVo;
            }
            PaasEnvParamDTO tdpaasProduct = new PaasEnvParamDTO();
            tdpaasProduct.setParamGroup("git.allinpaas.product");
            tdpaasProduct.setEnvId("paas");
            List productList = this.paasEnvParamService.queryList((Object)tdpaasProduct);
            tdpaasProduct.setParamGroup("git.user");
            List gitList = this.paasEnvParamService.queryList((Object)tdpaasProduct);
            productList.addAll(gitList);
            HashMap<String, PaasEnvParamDTO> map = new HashMap<String, PaasEnvParamDTO>();
            for (PaasEnvParamDTO param : productList) {
                map.put(param.getParamCode(), param);
            }
            String productRemote = ((PaasEnvParamDTO)map.get("git.allinpaas.product.remote.path")).getParamValue();
            String branchName = ((PaasEnvParamDTO)map.get("git.allinpaas.product.branch.name")).getParamValue();
            String userName = ((PaasEnvParamDTO)map.get("git.username")).getParamValue();
            String password = ((PaasEnvParamDTO)map.get("git.password")).getParamValue();
            String url = String.format("%s/%s.git", productRemote, appInfo.getAppCode());
            if (this.repositoryPush(this.facenterCodePath + File.separator + appInfo.getAppId(), url, userName, password, branchName)) {
                outputVo.setRows((Object)"\u62c9\u53d6\u6210\u529f");
            } else {
                outputVo.setRows((Object)"\u62c9\u53d6\u5931\u8d25");
            }
        }
        return outputVo;
    }

    public boolean repositoryPush(String localPath, String remotePath, String username, String password, String branchName) {
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    @RequestMapping(value={"/api/portal/paas/apps/infos/groups"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryAllGroupByPage(PaasAppsInfoDTO vo) {
        List outputVo = this.paasAppsInfoService.queryAllGroupByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/infos/dbs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDBDTO>> queryDbAppListByPage(PaasAppsInfoDBDTO vo) {
        List outputVo = this.paasAppsInfoService.queryDbAppListByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info/seq"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryAppIdSeqWithPrefix(@RequestParam(value="subsId") String subsId) {
        String seq = this.paasAppsInfoService.queryAppIdSeqWithPrefix(subsId, subsId);
        return this.getResponseData(seq);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info/idreset"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> appIdReset(@RequestBody Map<String, Object> param) {
        String subsId = MapUtils.getString(param, (Object)"subsId");
        String appId = MapUtils.getString(param, (Object)"appId");
        String newAppId = MapUtils.getString(param, (Object)"newAppId");
        SSubsInfoDTO targetSys = new SSubsInfoDTO();
        targetSys.setSubsId(subsId);
        targetSys = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)targetSys);
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDTO)((PaasAppsInfoPortalService)this.getService()).queryByPk((Object)appInfo);
        ((PaasAppsInfoPortalService)this.getService()).appIdReset(appId, newAppId);
        PaasAppsAdjustDTO adjustLog = new PaasAppsAdjustDTO();
        adjustLog.setRecordKeyid(UUIDUtil.getUUID());
        adjustLog.setSubsId(targetSys.getSubsId());
        adjustLog.setSubsCode(targetSys.getSubsCode());
        adjustLog.setSubsName(targetSys.getSubsName());
        adjustLog.setAppId(appInfo.getAppId());
        adjustLog.setAppCode(appInfo.getAppCode());
        adjustLog.setAppName(appInfo.getAppName());
        adjustLog.setAdjustContent(JSON.toJSONString((Object)appInfo));
        adjustLog.setAdjustDesc(String.format("\u5e94\u7528\u7f16\u53f7\u7531 %s \u8c03\u6574\u4e3a %s", appId, newAppId));
        adjustLog.setAdjustType(AdjustType.ChangeAppId.getCode());
        adjustLog.setAdjustUser(this.getUserInfo().getUserId());
        adjustLog.setAdjustTime(CurrentDateUtil.getTodayDateEx2());
        this.paasAppsAdjustService.insert((Object)adjustLog);
        return this.getResponseData(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/api/portal/paas/apps/info/config"})
    @ResponseBody
    public ResponseData<String> obtainMiddleConfigFile(@RequestParam(name="appId") String appId, @RequestParam(name="envId") String envId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)appId)) {
            logger.info("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u914d\u7f6e\u6587\u4ef6\u7684\u5e94\u7528\u7f16\u53f7!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u914d\u7f6e\u6587\u4ef6\u7684\u5e94\u7528\u7f16\u53f7!");
            return data;
        }
        MiddleAppConfigFileGenerate fileGenTool = new MiddleAppConfigFileGenerate();
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDTO)((PaasAppsInfoPortalService)this.getService()).queryByPk((Object)appInfo);
        fileGenTool.pullTemplateRepo(appInfo.getAppTemplateId());
        File configFile = fileGenTool.obtainConfigFile(appId, envId);
        StringBuffer content = new StringBuffer("");
        HashMap<String, String> map = new HashMap<String, String>(3);
        if (configFile != null && configFile.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF-8"));
                String data = br.readLine();
                while (data != null) {
                    content.append(data + "\n");
                    data = br.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            map.put("content", content.toString());
            map.put("fileType", fileGenTool.getFileType(configFile));
            map.put("fileName", configFile.getName());
        }
        String jsonResult = JSON.toJSONString(map);
        return this.getResponseData(jsonResult);
    }

    @PostMapping(value={"/api/portal/paas/apps/info/config"})
    @ResponseBody
    public ResponseData<String> updateMiddleConfigFile(@RequestBody Map<String, Object> updateData) {
        String appId = MapUtils.getString(updateData, (Object)"appId");
        String envId = MapUtils.getString(updateData, (Object)"envId");
        String fileName = MapUtils.getString(updateData, (Object)"fileName");
        String content = MapUtils.getString(updateData, (Object)"content");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)appId)) {
            logger.info("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u914d\u7f6e\u6587\u4ef6\u7684\u5e94\u7528\u7f16\u53f7!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u914d\u7f6e\u6587\u4ef6\u7684\u5e94\u7528\u7f16\u53f7!");
            return data;
        }
        MiddleAppConfigFileGenerate fileGenTool = new MiddleAppConfigFileGenerate();
        fileGenTool.updateConfigFile(appId, envId, fileName, content);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put("success", true);
        String jsonResult = JSON.toJSONString(map);
        return this.getResponseData(jsonResult);
    }

    @GetMapping(value={"/api/portal/paas/apps/info/deploy/config"})
    @ResponseBody
    public ResponseData<String> obtainMiddleDeployConfigFile(@RequestParam(name="appId") String appId, @RequestParam(name="envId") String envId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)appId)) {
            logger.info("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u914d\u7f6e\u6587\u4ef6\u7684\u5e94\u7528\u7f16\u53f7!");
            ResponseData data = this.getResponseData(null);
            data.setMessage("\u9700\u8981\u4f20\u5165\u8981\u6253\u5f00\u914d\u7f6e\u6587\u4ef6\u7684\u5e94\u7528\u7f16\u53f7!");
            return data;
        }
        MiddleAppConfigFileGenerate fileGenTool = new MiddleAppConfigFileGenerate();
        String[] configFile = fileGenTool.obtainDeployConfigFile(appId, envId);
        HashMap<String, String> map = new HashMap<String, String>(3);
        if (configFile != null) {
            map.put("content", configFile[1]);
            map.put("fileType", fileGenTool.getFileType(configFile[0]));
            map.put("fileName", configFile[0]);
        }
        String jsonResult = JSON.toJSONString(map);
        return this.getResponseData(jsonResult);
    }

    @RequestMapping(value={"/api/portal/paas/apps/info/regenerate/code"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> reGenerateCode(@RequestParam(value="appId") String appId) {
        PaasAppsInfoDTO inVo = new PaasAppsInfoDTO();
        inVo.setAppId(appId);
        PaasAppsInfoDTO appInfo = (PaasAppsInfoDTO)((PaasAppsInfoPortalService)this.getService()).queryByPk((Object)inVo);
        this.setUserInfoToVO(appInfo);
        try {
            PaasAppsTypeClazzServiceImpl genService = new PaasAppsTypeClazzServiceImpl(String.format("PaasAppsType%sServiceImpl", appInfo.getAppType()));
            boolean flag = genService.genPaasAppsCode(appInfo);
            logger.info("\u5e94\u7528\u4ee3\u7801\u751f\u6210\u7ed3\u679c {}", (Object)flag);
            return this.getResponseData(flag, "\u751f\u6210\u6210\u529f", "\u751f\u6210\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u4ee3\u7801\u751f\u6210\u5931\u8d25 " + appInfo.getAppId() + " " + e.getMessage(), (Throwable)e);
            return this.getResponseData(false, "\u751f\u6210\u6210\u529f", "\u751f\u6210\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/api/portal/paas/apps/infos/notz"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsInfoDTO>> queryNotZAppListByPage(PaasAppsInfoDTO param) {
        if (StringUtils.isNotBlank((String)param.getAppType()) && param.getAppType().contains(",")) {
            String[] appTyps = StringUtils.split((String)param.getAppType(), (String)",");
            param.setAppTypes(Arrays.asList(appTyps));
            param.setAppType(null);
        }
        List outputVo = this.paasAppsInfoService.queryNotZAppListByPage(param);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/api/portal/paas/apps/info/db/sql"})
    @ResponseBody
    public ResponseData<String> obtainSqlFile(@RequestParam(name="appId") String appId, @RequestParam(name="envId") String envId, @RequestParam(name="generate") Boolean generateFlag, @RequestParam(name="fileName") String fileName) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)appId)) {
            throw new RuntimeException("\u9700\u8981\u4f20\u5165\u5e94\u7528\u7f16\u53f7");
        }
        DBAppSqlFileGenerate generate = new DBAppSqlFileGenerate();
        String[] fileInfo = generate.obtainSqlFile(appId, envId, generateFlag.booleanValue(), fileName);
        if (fileInfo != null) {
            return this.getResponseData(fileInfo[1]);
        }
        throw new RuntimeException("\u83b7\u53d6" + fileName + "\u5931\u8d25");
    }

    @PostMapping(value={"/api/portal/paas/apps/info/db/sql"})
    @ResponseBody
    public ResponseData<String> updateSqlFile(@RequestBody Map<String, Object> updateData) {
        String appId = MapUtils.getString(updateData, (Object)"appId");
        String envId = MapUtils.getString(updateData, (Object)"envId");
        String fileName = MapUtils.getString(updateData, (Object)"fileName");
        String content = MapUtils.getString(updateData, (Object)"content");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)appId)) {
            throw new RuntimeException("\u9700\u8981\u4f20\u5165\u5e94\u7528\u7f16\u53f7");
        }
        DBAppSqlFileGenerate generate = new DBAppSqlFileGenerate();
        generate.updateSqlFile(appId, envId, fileName, content);
        return this.getResponseData("\u4fdd\u5b58\u6210\u529f");
    }
}

