/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsPropertiesDTO;
import com.irdstudio.allinapaas.portal.console.application.service.task.AppRepoPullTask;
import com.irdstudio.allinapaas.portal.console.types.PropSource;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.Yaml;

@RestController
@RequestMapping(value={"/"})
public class PaasAppsPropertiesPortalController
extends AbstractController {
    @RequestMapping(value={"/api/paas/apps/propertie/load/file"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsPropertiesDTO>> loadFromAppRepo(PaasAppsPropertiesDTO vo) {
        String appId = vo.getAppId();
        AppRepoPullTask appRepoPullTask = new AppRepoPullTask(appId);
        appRepoPullTask.syncRun();
        String appRoot = appRepoPullTask.getAppPath();
        List<File> applicationFiles = this.applicationFile(new File(appRoot));
        if (CollectionUtils.isNotEmpty(applicationFiles)) {
            ArrayList<PaasAppsPropertiesDTO> fileProperties = new ArrayList<PaasAppsPropertiesDTO>();
            for (File propFile : applicationFiles) {
                if (!propFile.exists() || propFile.isDirectory()) continue;
                String fileName = propFile.getName();
                List<String> contentList = this.loadFileContent(propFile);
                if (StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".yml")) {
                    String ymlContent = StringUtils.join(contentList, (String)"\n");
                    Yaml yaml = new Yaml();
                    Map root = (Map)yaml.loadAs(ymlContent, Map.class);
                    Map<String, String> ymlProp = this.convertYamlToProperties(root);
                    for (Map.Entry<String, String> entry : ymlProp.entrySet()) {
                        String keyName = entry.getKey();
                        PaasAppsPropertiesDTO appProp = new PaasAppsPropertiesDTO();
                        appProp.setPropName(keyName);
                        appProp.setPropValue(entry.getValue());
                        appProp.setPropSource(PropSource.Const.getCode());
                        appProp.setFileName(fileName);
                        appProp.setPropDesc(propFile.getAbsolutePath().replace(new File(appRoot).getAbsolutePath(), "").replace(File.separator, "/"));
                        appProp.setFileType("yml");
                        appProp.setPluginConfId(appId);
                        appProp.setAppId(appId);
                        fileProperties.add(appProp);
                    }
                    continue;
                }
                for (String line : contentList) {
                    String[] props;
                    if (StringUtils.startsWith((CharSequence)(line = StringUtils.trim((String)line)), (CharSequence)"#") || (props = StringUtils.split((String)line, (String)"=")) == null || props.length <= 1) continue;
                    String key = props[0];
                    String value = props[1];
                    if (props.length > 2) {
                        List<String> subProps = Arrays.asList(props).subList(1, props.length);
                        value = StringUtils.join(subProps, (String)"=");
                    }
                    PaasAppsPropertiesDTO appProp = new PaasAppsPropertiesDTO();
                    appProp.setPropName(key);
                    appProp.setPropValue(value);
                    appProp.setPropSource(PropSource.Const.getCode());
                    appProp.setFileName(fileName);
                    appProp.setPropDesc(propFile.getAbsolutePath().replace(new File(appRoot).getAbsolutePath(), "").replace(File.separator, "/"));
                    appProp.setFileType("properties");
                    appProp.setPluginConfId(appId);
                    appProp.setAppId(appId);
                    fileProperties.add(appProp);
                }
            }
            fileProperties.sort((o1, o2) -> {
                if (o1.getPropDesc().compareToIgnoreCase(o2.getPropDesc()) == 0) {
                    return o1.getPropName().compareToIgnoreCase(o2.getPropName());
                }
                return o1.getPropDesc().compareToIgnoreCase(o2.getPropDesc());
            });
            return this.getResponseData(fileProperties);
        }
        return this.getResponseData(Collections.emptyList());
    }

    private List<File> applicationFile(File parentFile) {
        if (!parentFile.exists()) {
            return Collections.emptyList();
        }
        if (StringUtils.equalsAny((CharSequence)parentFile.getName(), (CharSequence[])new CharSequence[]{".git"})) {
            return Collections.emptyList();
        }
        ArrayList<File> list = new ArrayList<File>();
        if (parentFile.isFile() && StringUtils.equalsAny((CharSequence)parentFile.getName(), (CharSequence[])new CharSequence[]{"application.properties", "application.yml"})) {
            list.add(parentFile);
        }
        if (parentFile.isDirectory()) {
            File[] files;
            for (File subFile : files = parentFile.listFiles()) {
                list.addAll(this.applicationFile(subFile));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadFileContent(File file) {
        FileInputStream configInputStream = null;
        List configs = null;
        try {
            configInputStream = new FileInputStream(file);
            configs = IOUtils.readLines((InputStream)configInputStream, (String)"UTF-8");
        }
        catch (Exception e) {
            try {
                logger.error(String.format("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6%s\u6d41\u5931\u8d25", file.getName()), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(configInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)configInputStream);
        }
        IOUtils.closeQuietly((InputStream)configInputStream);
        if (configs == null) {
            logger.error(String.format("\u8bfb\u53d6%s\u5931\u8d25", file.getName()));
            return Collections.emptyList();
        }
        return configs;
    }

    private Map<String, String> convertYamlToProperties(Map<String, Object> root) {
        HashMap<String, String> prop = new HashMap<String, String>();
        if (root != null && root.size() > 0) {
            for (Map.Entry<String, Object> entry : root.entrySet()) {
                if (entry.getValue() == null) {
                    prop.put(entry.getKey(), null);
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    this.recursionConvert(prop, entry.getKey(), (Map)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        String key = String.format("%s[%s]", entry.getKey(), i);
                        Map value = (Map)list.get(i);
                        this.recursionConvert(prop, key, value);
                    }
                    continue;
                }
                prop.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return prop;
    }

    private void recursionConvert(Map<String, String> prop, String parentKey, Map<String, Object> parentValue) {
        if (parentValue != null && parentValue.size() > 0) {
            for (Map.Entry<String, Object> entry : parentValue.entrySet()) {
                if (entry.getValue() == null) {
                    prop.put(parentKey + "." + entry.getKey(), null);
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    this.recursionConvert(prop, parentKey + "." + entry.getKey(), (Map)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        String key = String.format("%s[%s]", parentKey + "." + entry.getKey(), i);
                        Object value = list.get(i);
                        if (value == null || !(value instanceof Map)) continue;
                        this.recursionConvert(prop, key, (Map)value);
                    }
                    continue;
                }
                prop.put(parentKey + "." + entry.getKey(), entry.getValue().toString());
            }
        }
    }
}

