/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasApptypeInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasApptypeInfoDTO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasApptypeInfoController
extends BaseController<PaasApptypeInfoDTO, PaasApptypeInfoService> {
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;

    @RequestMapping(value={"/api/paas/apptype/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasApptypeInfoDTO>> queryPaasApptypeInfoAll(PaasApptypeInfoDTO dto) {
        if (StringUtils.isNotBlank((String)dto.getAppTypeCategory()) && dto.getAppTypeCategory().contains(",")) {
            String[] appCategorys = StringUtils.split((String)dto.getAppTypeCategory(), (String)",");
            dto.setAppTypeCategorys(Arrays.asList(appCategorys));
            dto.setAppTypeCategory(null);
        }
        List outputVo = ((PaasApptypeInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apptype/infos/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasApptypeInfoDTO>> queryList(PaasApptypeInfoDTO dto) {
        if (StringUtils.isNotBlank((String)dto.getAppTypeCategory()) && dto.getAppTypeCategory().contains(",")) {
            String[] appCategorys = StringUtils.split((String)dto.getAppTypeCategory(), (String)",");
            dto.setAppTypeCategorys(Arrays.asList(appCategorys));
            dto.setAppTypeCategory(null);
        }
        List outputVo = ((PaasApptypeInfoService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apptype/info/{appTypeId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasApptypeInfoDTO> queryByPk(@PathVariable(value="appTypeId") String appTypeId) {
        PaasApptypeInfoDTO inVo = new PaasApptypeInfoDTO();
        inVo.setAppTypeId(appTypeId);
        PaasApptypeInfoDTO outputVo = (PaasApptypeInfoDTO)((PaasApptypeInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apptype/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasApptypeInfoDTO inPaasApptypeInfoDTO) {
        PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
        appParam.setAppType(inPaasApptypeInfoDTO.getAppTypeId());
        List appList = this.paasAppsInfoService.queryListByPage((Object)appParam);
        if (CollectionUtils.isNotEmpty((Collection)appList)) {
            return this.getResponseData(-1, "", "\u6709\u5173\u8054\u7684\u5e94\u7528\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        int outputVo = ((PaasApptypeInfoService)this.getService()).deleteByPk((Object)inPaasApptypeInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apptype/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasApptypeInfoDTO inPaasApptypeInfoDTO) {
        int outputVo = ((PaasApptypeInfoService)this.getService()).updateByPk((Object)inPaasApptypeInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apptype/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasApptypeInfo(@RequestBody PaasApptypeInfoDTO inPaasApptypeInfoDTO) {
        int outputVo = ((PaasApptypeInfoService)this.getService()).insert((Object)inPaasApptypeInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apptype/infos/counts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasApptypeInfoDTO>> queryListWithCountByPage(PaasApptypeInfoDTO dto) {
        List outputVo = ((PaasApptypeInfoService)this.getService()).queryListWithCountByPage(dto);
        return this.getResponseData(outputVo);
    }
}

