/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.admin.console.facade.PaasCbaInfoService;
import com.irdstudio.allinapaas.admin.console.facade.PaasSubsCbaService;
import com.irdstudio.allinapaas.admin.console.facade.PaasSubsToolService;
import com.irdstudio.allinapaas.admin.console.facade.dto.PaasSubsCbaDTO;
import com.irdstudio.allinapaas.admin.console.facade.dto.PaasSubsToolDTO;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsLayerService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsMeasureService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoPortalService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsMeasureDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocDirectoryService;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocDirectoryDTO;
import com.irdstudio.allinapaas.portal.console.application.service.task.AnalysisTableMatchItemTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskHisService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskHisDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinapaas.portal.console.web.controller.api.ModuleSyncController;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.AnalysisIndexExcelDataDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.wiki.console.facade.WikiBaseInfoService;
import com.irdstudio.allinrdm.wiki.console.facade.WikiService;
import com.irdstudio.allinrdm.wiki.console.facade.dto.WikiBaseInfoDTO;
import com.irdstudio.allinrdm.wiki.console.facade.dto.WikiSubsDirectoryDTO;
import com.irdstudio.allinrdm.wiki.console.types.WikiType;
import com.irdstudio.allintpaas.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintpaas.admin.facade.dto.SDicDTO;
import com.irdstudio.allintpaas.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.paas.mon.facade.ApmClient;
import com.irdstudio.sdk.beans.core.threadpool.ApplicationThreadPool2;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.EasyUITreeData;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/"})
public class SSubsInfoPortalController
extends BaseController<SSubsInfoDTO, SSubsInfoPortalService> {
    @Autowired
    @Qualifier(value="paasAppsInfoServiceImpl")
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    private PaasAppsMeasureService paasAppsMeasureService;
    @Autowired
    @Qualifier(value="paasDocDirectoryServiceImpl")
    private PaasDocDirectoryService paasDocDirectoryService;
    @Autowired
    @Lazy
    private AllinCloudPortalClient portalClient;
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    private ApplicationThreadPool2 applicationThreadPool;
    @Autowired
    private PaasAppsLayerService paasAppsLayerService;
    @Autowired
    private SeqInstInfoService seqService;
    @Autowired
    private WikiBaseInfoService wikiBaseInfoService;
    @Autowired
    private PaasTaskHisService paasTaskHisService;
    @Autowired
    private PaasSubsCbaService paasSubsCbaService;
    @Autowired
    private PaasSubsToolService paasSubsToolService;
    @Autowired
    private PaasEnvParamService paasEnvParamService;
    @Autowired
    private PaasCbaInfoService paasCbaInfoService;

    @RequestMapping(value={"/api/portal/s/subs/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SSubsInfoDTO>> querySSubsInfoAll(SSubsInfoDTO vo) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getSolutionType()) && org.apache.commons.lang3.StringUtils.contains((CharSequence)vo.getSolutionType(), (CharSequence)",")) {
            vo.setSolutionTypes(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)vo.getSolutionType(), (String)",")));
            vo.setSolutionType(null);
        }
        List outputVo = ((SSubsInfoPortalService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/infos/envs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SSubsInfoDTO>> queryWithEnvListByPage(SSubsInfoDTO vo) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getSolutionType()) && org.apache.commons.lang3.StringUtils.contains((CharSequence)vo.getSolutionType(), (CharSequence)",")) {
            vo.setSolutionTypes(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)vo.getSolutionType(), (String)",")));
            vo.setSolutionType(null);
        }
        List outputVo = ((SSubsInfoPortalService)this.getService()).queryWithEnvListByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/info/max"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> querySSubsInfoMaxOrder() {
        Integer outputVo = ((SSubsInfoPortalService)this.getService()).querySSubsInfoMaxOrder();
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/infos/ddspaas"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryDdspaasSummaryByPage(SSubsInfoDTO vo) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getSolutionType()) && org.apache.commons.lang3.StringUtils.contains((CharSequence)vo.getSolutionType(), (CharSequence)",")) {
            vo.setSolutionTypes(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)vo.getSolutionType(), (String)",")));
            vo.setSolutionType(null);
        }
        this.setUserInfoToVO(vo);
        List outputVo = ((SSubsInfoPortalService)this.getService()).queryDdspaasSummaryByPage(vo);
        ResponseData resp = this.getResponseData(outputVo);
        resp.setTotal(vo.getTotal().intValue());
        return resp;
    }

    @RequestMapping(value={"/api/portal/s/subs/infos/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySubsSummary(SSubsInfoDTO vo) {
        List outputVo = ((SSubsInfoPortalService)this.getService()).querySubsSummary(vo);
        ResponseData resp = this.getResponseData(outputVo);
        resp.setTotal(vo.getTotal().intValue());
        return resp;
    }

    @RequestMapping(value={"/api/portal/s/subs/info/{subsId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SSubsInfoDTO> queryByPk(@PathVariable(value="subsId") String subsId) {
        SSubsInfoDTO inVo = new SSubsInfoDTO();
        inVo.setSubsId(subsId);
        SSubsInfoDTO outputVo = (SSubsInfoDTO)((SSubsInfoPortalService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SSubsInfoDTO inSSubsInfoVo) {
        this.setUserInfoToVO(inSSubsInfoVo);
        int outputVo = ((SSubsInfoPortalService)this.getService()).deleteByPk((Object)inSSubsInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SSubsInfoDTO inSSubsInfoVo) {
        SSubsInfoDTO oldSubsInfo = (SSubsInfoDTO)((SSubsInfoPortalService)this.getService()).queryByPk((Object)inSSubsInfoVo);
        this.setUserInfoToVO(inSSubsInfoVo);
        inSSubsInfoVo.setLastUpdateUser(inSSubsInfoVo.getLoginUserId());
        inSSubsInfoVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((SSubsInfoPortalService)this.getService()).updateByPk((Object)inSSubsInfoVo);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)inSSubsInfoVo.getDocLibraryId())) {
            this.initWikiDirectory(inSSubsInfoVo, !org.apache.commons.lang3.StringUtils.equals((CharSequence)oldSubsInfo.getDocLibraryId(), (CharSequence)inSSubsInfoVo.getDocLibraryId()));
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSSubsInfo(@RequestBody SSubsInfoDTO inSSubsInfoVo) {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        inSSubsInfoVo.setSubsDataDate(formatter.format(date));
        this.setUserInfoToVO(inSSubsInfoVo);
        inSSubsInfoVo.setCreateUser(inSSubsInfoVo.getLoginUserId());
        inSSubsInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inSSubsInfoVo.setLastUpdateUser(inSSubsInfoVo.getLoginUserId());
        inSSubsInfoVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)inSSubsInfoVo.getSubsId())) {
            inSSubsInfoVo.setSubsId(this.seqService.nextSequence("PAAS-SUBS-ID", inSSubsInfoVo.getSolutionType()));
        }
        int outputVo = ((SSubsInfoPortalService)this.getService()).insert((Object)inSSubsInfoVo);
        try {
            ApmClient apmService = (ApmClient)SpringContextUtils.getBean(ApmClient.class);
            HashMap<String, String> inRmpPanelInfoVo = new HashMap<String, String>();
            inRmpPanelInfoVo.put("loginUserId", inSSubsInfoVo.getLoginUserId());
            inRmpPanelInfoVo.put("panelDataCycle", "R");
            inRmpPanelInfoVo.put("panelDataInterval", "10");
            inRmpPanelInfoVo.put("panelLayout", "2");
            inRmpPanelInfoVo.put("subsId", inSSubsInfoVo.getSubsId());
            inRmpPanelInfoVo.put("panelId", inSSubsInfoVo.getSubsId() + "-default");
            inRmpPanelInfoVo.put("panelName", inSSubsInfoVo.getSubsName() + "\u9762\u677f");
            apmService.insertRmpPanelInfo(inRmpPanelInfoVo);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u76d1\u63a7\u9762\u677f\u5931\u8d25 " + e.getMessage(), (Throwable)e);
        }
        final ModuleSyncController moduleSyncController = (ModuleSyncController)((Object)SpringContextUtils.getBean(ModuleSyncController.class));
        if (moduleSyncController != null) {
            final HashMap<String, String> syncParam = new HashMap<String, String>();
            syncParam.put("syncData", "SSubsInfo");
            syncParam.put("subsId", inSSubsInfoVo.getSubsId());
            new Thread(){

                @Override
                public void run() {
                    moduleSyncController.queryAppsCheckLogAll(syncParam);
                }
            }.start();
        }
        this.paasAppsLayerService.appLayerInit(inSSubsInfoVo);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)inSSubsInfoVo.getDocLibraryId())) {
            this.initWikiDirectory(inSSubsInfoVo, true);
        } else {
            WikiBaseInfoDTO wikiBase = new WikiBaseInfoDTO();
            wikiBase.setWikiId(inSSubsInfoVo.getSubsId());
            wikiBase.setWikiName(inSSubsInfoVo.getSubsName());
            wikiBase.setWikiType(WikiType.System.getCode());
            wikiBase.setWikiCategory(WikiType.System.getCode());
            wikiBase.setWikiArchiveFlag(YesOrNO.NO.getCode());
            wikiBase.setWikiIncharge(inSSubsInfoVo.getChargeMan());
            wikiBase.setWikiInchargeName(inSSubsInfoVo.getChargeManName());
            wikiBase.setWikiDesc(inSSubsInfoVo.getSubsIntro());
            wikiBase.setCreateUser(inSSubsInfoVo.getLoginUserId());
            wikiBase.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            wikiBase.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
            wikiBase.setLastModifyUser(inSSubsInfoVo.getLoginUserId());
            this.wikiBaseInfoService.insert((Object)wikiBase);
        }
        PaasSubsCbaDTO subsCba = new PaasSubsCbaDTO();
        subsCba.setSubsId(inSSubsInfoVo.getSubsId());
        subsCba.setCbaCode("paas-dev-code");
        this.paasSubsCbaService.insert((Object)subsCba);
        PaasSubsToolDTO gitTool = new PaasSubsToolDTO();
        gitTool.setToolId(UUIDUtil.getShortUUID());
        gitTool.setToolDesc(String.format("%s-gitlab", inSSubsInfoVo.getSubsName()));
        gitTool.setToolCategory("code");
        gitTool.setSoftId("000023");
        gitTool.setSoftCode("gitlab");
        gitTool.setSoftName("Gitlab-ee 15.1 ");
        gitTool.setEnvId("");
        gitTool.setCbaCode("paas-dev-code");
        gitTool.setToolConsoleUrl(String.format("/allincloud/page/allincloud-portal/RedirectGitlab.html?subsId=%s&subsName=%s#subsId=%s&subsName=%s", inSSubsInfoVo.getSubsId(), inSSubsInfoVo.getSubsName(), inSSubsInfoVo.getSubsId(), inSSubsInfoVo.getSubsName()));
        gitTool.setToolOverviewUrl("/allinapaas/api/summary/paas/dev/code");
        gitTool.setToolUrl("/allinapaas/api/summary/paas/dev/code");
        gitTool.setSubsId(inSSubsInfoVo.getSubsId());
        this.paasSubsToolService.insert((Object)gitTool);
        PaasSubsCbaDTO subsMavenCba = new PaasSubsCbaDTO();
        subsMavenCba.setSubsId(inSSubsInfoVo.getSubsId());
        subsMavenCba.setCbaCode("paas-dev-maven");
        this.paasSubsCbaService.insert((Object)subsMavenCba);
        PaasSubsToolDTO mavenTool = new PaasSubsToolDTO();
        mavenTool.setToolId(UUIDUtil.getShortUUID());
        mavenTool.setToolDesc(String.format("%s-gitlab", inSSubsInfoVo.getSubsName()));
        mavenTool.setToolCategory("repo");
        mavenTool.setSoftId("000020");
        mavenTool.setSoftCode("Nexus");
        mavenTool.setSoftName("Nexus Repository Manager OSS 2.13.0-01");
        mavenTool.setEnvId("");
        mavenTool.setCbaCode("paas-dev-maven");
        mavenTool.setToolConsoleUrl(String.format("/allinapaas/page/allinapaas/admin/console/RedirectNexus.html?subsId=${subsId}&subsName=${subsName}#subsId=${subsId}&subsName=${subsName}", inSSubsInfoVo.getSubsId(), inSSubsInfoVo.getSubsName(), inSSubsInfoVo.getSubsId(), inSSubsInfoVo.getSubsName()));
        mavenTool.setToolOverviewUrl("/allinapaas/api/summary/paas/dev/maven");
        PaasEnvParamDTO mavenParam = this.paasEnvParamService.queryEnvParamByCodeReturnValue("mavent_public_url");
        if (mavenParam != null) {
            mavenTool.setToolUrl(mavenParam.getParamValue().replace("content/repositories/public/", ""));
        }
        mavenTool.setSubsId(inSSubsInfoVo.getSubsId());
        this.paasSubsToolService.insert((Object)mavenTool);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/info/gen/wiki/dirs"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestParam(value="subsId") String subsId) {
        SSubsInfoDTO inSSubsInfoVo = new SSubsInfoDTO();
        inSSubsInfoVo.setSubsId(subsId);
        inSSubsInfoVo = (SSubsInfoDTO)((SSubsInfoPortalService)this.getService()).queryByPk((Object)inSSubsInfoVo);
        this.setUserInfoToVO(inSSubsInfoVo);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)inSSubsInfoVo.getDocLibraryId())) {
            this.initWikiDirectory(inSSubsInfoVo, true);
        }
        return this.getResponseData(1);
    }

    private void initWikiDirectory(final SSubsInfoDTO subsInfo, final Boolean recovery) {
        final ArrayList<WikiSubsDirectoryDTO> wikiDirList = new ArrayList<WikiSubsDirectoryDTO>();
        PaasDocDirectoryDTO param = new PaasDocDirectoryDTO();
        param.setLibId(subsInfo.getDocLibraryId());
        param.setSize(Integer.valueOf(1000));
        List docDirList = this.paasDocDirectoryService.queryList((Object)param);
        if (CollectionUtils.isNotEmpty((Collection)docDirList)) {
            String nowTime = CurrentDateUtil.getTodayDateEx2();
            HashMap<String, String> keyMap = new HashMap<String, String>();
            for (PaasDocDirectoryDTO dir : docDirList) {
                String abvId;
                String key = (String)keyMap.get(dir.getDirId());
                if (key == null) {
                    key = UUIDUtil.getUUID();
                    keyMap.put(dir.getDirId(), key);
                }
                if ((abvId = (String)keyMap.get(dir.getDirAbvId())) == null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dir.getDirAbvId())) {
                    abvId = UUIDUtil.getUUID();
                    keyMap.put(dir.getDirAbvId(), abvId);
                }
                WikiSubsDirectoryDTO wikiDir = new WikiSubsDirectoryDTO();
                wikiDir.setDirId(key);
                wikiDir.setDirPid(abvId);
                wikiDir.setDirName(dir.getDirName());
                wikiDir.setDirOrder(dir.getDirOrder());
                wikiDir.setWikiId(subsInfo.getSubsId());
                wikiDir.setSubsId(subsInfo.getSubsId());
                wikiDir.setCreateUser(subsInfo.getLoginUserId());
                wikiDir.setCreateTime(nowTime);
                wikiDirList.add(wikiDir);
            }
        }
        new Thread(){

            @Override
            public void run() {
                WikiService wikiService = (WikiService)SpringContextUtils.getBean(WikiService.class);
                try {
                    WikiBaseInfoDTO wikiBase = new WikiBaseInfoDTO();
                    wikiBase.setWikiId(subsInfo.getSubsId());
                    wikiBase.setWikiName(subsInfo.getSubsName());
                    wikiBase.setWikiType(WikiType.System.getCode());
                    wikiBase.setWikiCategory(WikiType.System.getCode());
                    wikiBase.setWikiArchiveFlag(YesOrNO.NO.getCode());
                    wikiBase.setWikiIncharge(subsInfo.getChargeMan());
                    wikiBase.setWikiInchargeName(subsInfo.getChargeManName());
                    wikiBase.setWikiDesc(subsInfo.getSubsIntro());
                    wikiBase.setCreateUser(subsInfo.getLoginUserId());
                    wikiBase.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                    wikiBase.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
                    wikiBase.setLastModifyUser(subsInfo.getLoginUserId());
                    int re = SSubsInfoPortalController.this.wikiBaseInfoService.updateByPk((Object)wikiBase);
                    if (re == 0) {
                        re = SSubsInfoPortalController.this.wikiBaseInfoService.insert((Object)wikiBase);
                    }
                    ResponseData resp = wikiService.saveSubsDirectors(recovery, wikiDirList);
                    logger.info(subsInfo.getSubsCode() + " wiki\u76ee\u5f55\u521d\u59cb\u5316\u7ed3\u679c {}", (Object)JSON.toJSONString((Object)resp));
                }
                catch (Exception e) {
                    logger.error(subsInfo.getSubsCode() + e.getMessage(), (Throwable)e);
                }
            }
        }.start();
    }

    @RequestMapping(value={"/api/portal/s/subs/info/all"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SSubsInfoDTO>> queryAllSSubsInfo(SSubsInfoDTO vo) {
        List outputVo = ((SSubsInfoPortalService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/api/portal/s/subs/info/app/nav/{subsId}"})
    @ResponseBody
    public List<Object> queryTree(@PathVariable(value="subsId") String subsId, @RequestParam(name="appId", required=false) String appId, @RequestParam(name="onlyTable", required=false) boolean onlyTable, @RequestParam(name="appType", required=false) String appType) {
        List treeData = ((SSubsInfoPortalService)this.getService()).queryAppsTreeNav(subsId, appId, Boolean.valueOf(onlyTable), appType);
        return treeData;
    }

    @PostMapping(value={"/api/portal/s/subs/info/app/nav/pop/{subsId}"})
    @ResponseBody
    public List<Object> queryAppsTreeForPop(@PathVariable(value="subsId") String subsId, @RequestParam(name="appId", required=false) String appId, @RequestParam(name="onlyTable", required=false) boolean onlyTable, @RequestParam(name="appType", required=false) String appType) {
        List treeData = ((SSubsInfoPortalService)this.getService()).queryAppsTreeForPop(subsId, appId, Boolean.valueOf(onlyTable), appType);
        return treeData;
    }

    @PostMapping(value={"/api/portal/s/subs/info/nav/group/{subsId}"})
    @ResponseBody
    public List<Object> queryBizDbTree(@PathVariable(value="subsId") String subsId, @RequestParam(name="bizDbName", required=true) String bizDbName) {
        List treeData = ((SSubsInfoPortalService)this.getService()).queryBizDbTreeNav(subsId, bizDbName);
        return treeData;
    }

    @RequestMapping(value={"/api/portal/s/subs/info/tc/nav"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<EasyUITreeData>> queryTComponentIndex(@RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="appType", required=false) String appType) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)subsId)) {
            subsId = null;
        }
        List treeList = ((SSubsInfoPortalService)this.getService()).queryTComponentIndex(subsId, appType);
        return this.getResponseData(treeList);
    }

    @RequestMapping(value={"/api/portal/s/subs/info/third/tree"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<EasyUITreeData>> querySubsTreeExcludeSelf(@RequestParam(value="subsId", required=false) String subsId) {
        List treeList = ((SSubsInfoPortalService)this.getService()).querySubsTreeExcludeSelf(subsId);
        return this.getResponseData(treeList);
    }

    @RequestMapping(value={"/api/portal/s/subs/info/third/tree/market"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<EasyUITreeData>> querySubsTreeForMarketWithAppType(@RequestParam(value="appType", required=false) String appType) {
        List treeList = ((SSubsInfoPortalService)this.getService()).querySubsTreeForMarket(appType);
        return this.getResponseData(treeList);
    }

    @RequestMapping(value={"/api/portal/s/subs/info/apps/tree"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<EasyUITreeData>> querySubsTreeForMarket(@RequestParam(value="subsId", required=true) String subsId) {
        List treeList = ((SSubsInfoPortalService)this.getService()).querySubsAppsTree(subsId);
        return this.getResponseData(treeList);
    }

    @RequestMapping(value={"/api/portal/s/subs/infos/apps"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Map<String, Object>> querySubsApps() {
        SSubsInfoDTO vo = new SSubsInfoDTO();
        vo.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List subsList = ((SSubsInfoPortalService)this.getService()).queryList((Object)vo);
        PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
        appParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List appList = this.paasAppsInfoService.queryListByPage((Object)appParam);
        HashMap<String, List> outputVo = new HashMap<String, List>();
        outputVo.put("subs", subsList);
        outputVo.put("apps", appList);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/wiki/subs/page/upload"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertWikiDocumentWithFile(HttpServletRequest request, @RequestPart(value="file", required=false) MultipartFile file) {
        boolean flag = ((SSubsInfoPortalService)this.getService()).insertWikiDocumentWithFile(request, file);
        return this.getResponseData(flag ? "\u4fdd\u5b58\u6210\u529f" : "\u5904\u7406\u5931\u8d25");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/wiki/subs/page/preview"}, method={RequestMethod.GET})
    public void loadWikiDocumentFile(@RequestParam(value="subsId") String subsId, @RequestParam(value="dirId") String dirId, @RequestParam(value="docTitle") String docTitle, @RequestParam(value="docType") String docType, @RequestParam(value="previewType", required=false) String previewType, @RequestParam(value="loginUserId") String loginUserId, HttpServletResponse response) throws IOException {
        block19: {
            File targetFile;
            block20: {
                targetFile = ((SSubsInfoPortalService)this.getService()).loadWikiFileForView(subsId, dirId, docTitle, docType, loginUserId);
                if (targetFile == null) break block20;
                BufferedInputStream bis = null;
                BufferedOutputStream bos = null;
                try {
                    int bytesRead;
                    response.setContentType("application/" + docType);
                    if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)previewType, (CharSequence)"preview")) {
                        response.setHeader("Content-Disposition", "attachment;filename=" + new String(targetFile.getName().getBytes(), "iso-8859-1"));
                    }
                    ServletOutputStream out = response.getOutputStream();
                    bis = new BufferedInputStream(new FileInputStream(targetFile));
                    bos = new BufferedOutputStream((OutputStream)out);
                    byte[] buff = new byte[2048];
                    while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                        bos.write(buff, 0, bytesRead);
                    }
                    ResourceCloseUtil.closeInputStream((InputStream)bis);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    break block19;
                }
                finally {
                    ResourceCloseUtil.closeInputStream(bis);
                    ResourceCloseUtil.closeOutputStream(bos);
                }
                ResourceCloseUtil.closeOutputStream((OutputStream)bos);
                break block19;
            }
            response.setContentType("application/" + docType + ";charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(targetFile.getName().getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            try (PrintWriter rsp = response.getWriter();){
                rsp.write("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/wiki/subs/page/preview/docx/{fileName}"}, method={RequestMethod.GET})
    public void loaddDocxWithFileName(@RequestParam(value="subsId") String subsId, @RequestParam(value="dirId") String dirId, @RequestParam(value="docTitle") String docTitle, @RequestParam(value="docType") String docType, @RequestParam(value="previewType", required=false) String previewType, @RequestParam(value="loginUserId") String loginUserId, HttpServletResponse response) throws IOException {
        block19: {
            File targetFile;
            block20: {
                targetFile = ((SSubsInfoPortalService)this.getService()).loadWikiFileForView(subsId, dirId, docTitle, docType, loginUserId);
                if (targetFile == null) break block20;
                BufferedInputStream bis = null;
                BufferedOutputStream bos = null;
                try {
                    int bytesRead;
                    response.setContentType("application/" + docType);
                    if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)previewType, (CharSequence)"preview")) {
                        response.setHeader("Content-Disposition", "attachment;filename=" + new String(targetFile.getName().getBytes(), "iso-8859-1"));
                    }
                    ServletOutputStream out = response.getOutputStream();
                    bis = new BufferedInputStream(new FileInputStream(targetFile));
                    bos = new BufferedOutputStream((OutputStream)out);
                    byte[] buff = new byte[2048];
                    while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                        bos.write(buff, 0, bytesRead);
                    }
                    ResourceCloseUtil.closeInputStream((InputStream)bis);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    break block19;
                }
                finally {
                    ResourceCloseUtil.closeInputStream(bis);
                    ResourceCloseUtil.closeOutputStream(bos);
                }
                ResourceCloseUtil.closeOutputStream((OutputStream)bos);
                break block19;
            }
            response.setContentType("application/" + docType + ";charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(targetFile.getName().getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            try (PrintWriter rsp = response.getWriter();){
                rsp.write("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/portal/s/subs/info/import/template"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> excelTemplateDownload(HttpServletResponse response) {
        ResponseData responseData;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File file = new File(templateRootPath + File.separator + "xlsx" + File.separator + "\u7cfb\u7edf\u6a21\u677f.xlsx");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u7cfb\u7edf\u6a21\u677f.xlsx".getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            responseData = this.getResponseData(true);
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dexcel\u6a21\u578b\u5f02\u5e38", (Throwable)e);
            ResponseData responseData2 = this.getResponseData(false);
            return responseData2;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return responseData;
    }

    @PostMapping(value={"/api/portal/s/subs/info/import/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestPart(value="file") MultipartFile file) {
        try {
            UserInfo userInfo = this.getUserInfo();
            String userId = userInfo.getUserId();
            String nowTime = CurrentDateUtil.getTodayDateEx2();
            String createTime = CurrentDateUtil.getTodayDateEx2();
            List<String> HEAD = Arrays.asList("\u5e94\u7528\u7f16\u53f7", "\u5e94\u7528\u7b80\u79f0", "\u5e94\u7528\u540d\u79f0", "\u5e94\u7528\u7c7b\u578b", "\u5e94\u7528\u67b6\u6784\u5206\u5c42", "\u7cfb\u7edf\u7f16\u53f7", "\u7cfb\u7edf\u7b80\u79f0", "\u7cfb\u7edf\u540d\u79f0", "\u7cfb\u7edf\u82f1\u6587\u5168\u79f0", "\u7cfb\u7edf\u7b80\u4ecb", "\u7cfb\u7edf\u4f7f\u7528\u8303\u56f4", "\u7cfb\u7edf\u670d\u52a1\u5bf9\u8c61", "\u7cfb\u7edf\u72b6\u6001");
            ArrayList headCellList = new ArrayList();
            ExcelReader excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            SubsInfoExcelReadListener subsListener = new SubsInfoExcelReadListener();
            ReadSheet subsSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).registerReadListener((ReadListener)subsListener)).headRowNumber(Integer.valueOf(1))).build();
            excelReader.read(new ReadSheet[]{subsSheet});
            if (subsListener.getList().size() > 0) {
                SDicDTO dicParam = new SDicDTO();
                dicParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
                dicParam.setOpttypes(Arrays.asList("ARCH_LEVEL_TYPE", "SUBS_STATE", "SCOPE_USE", "SERVICE_USED"));
                List dictList = this.portalClient.queryDicList(dicParam);
                HashMap<String, SDicDTO> dictMap = new HashMap<String, SDicDTO>();
                if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                    for (SDicDTO d : dictList) {
                        String key = String.format("%s-%s", d.getOpttype(), d.getCnname());
                        dictMap.put(key, d);
                    }
                }
                List<SSubsInfoDTO> subsList = subsListener.getList();
                for (SSubsInfoDTO s : subsList) {
                    SDicDTO code;
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.getArchLevelType())) {
                        String archLevel = s.getArchLevelType();
                        code = (SDicDTO)dictMap.get("ARCH_LEVEL_TYPE-" + archLevel);
                        if (code != null) {
                            s.setArchLevelType(code.getEnname());
                        }
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.getScopeUse())) {
                        String scopeUse = s.getScopeUse();
                        code = (SDicDTO)dictMap.get("SCOPE_USE-" + scopeUse);
                        if (code != null) {
                            s.setScopeUse(code.getEnname());
                        }
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.getServiceUsed())) {
                        String serviceUsed = s.getServiceUsed();
                        code = (SDicDTO)dictMap.get("SERVICE_USED-" + serviceUsed);
                        if (code != null) {
                            s.setServiceUsed(code.getEnname());
                        }
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s.getSubsState())) {
                        String state = s.getSubsState();
                        code = (SDicDTO)dictMap.get("SUBS_STATE-" + state);
                        if (code != null) {
                            s.setSubsState(code.getEnname());
                        }
                    }
                    s.setSolutionType("S");
                }
                ((SSubsInfoPortalService)this.getService()).saveSubsInfoImportList(subsList);
            }
            return this.getResponseData("S");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u6570\u636e\u6807\u51c6\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
            return this.getResponseData("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/api/portal/s/subs/info/matchItem"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> appRefactorStd(@RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId, @RequestParam(value="objectId", required=false) String objectId) {
        if (AnalysisTableMatchItemTask.taskDebounce.get(appId) == null) {
            String userId = this.getUserInfo().getUserId();
            AnalysisTableMatchItemTask.taskDebounce.put(appId, "R");
            AnalysisTableMatchItemTask task = new AnalysisTableMatchItemTask(subsId, appId, objectId, null, userId);
            this.applicationThreadPool.add((Callable)task);
            return this.getResponseData("\u6267\u884c\u6210\u529f");
        }
        return this.getResponseData("\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u5019\uff01");
    }

    @RequestMapping(value={"/api/portal/s/subs/info/subs/matchItem"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> appRefactorStd(@RequestParam(value="subsId") String subsId, @RequestParam(value="appId", required=false) String appId) {
        if (AnalysisTableMatchItemTask.taskDebounce.get(subsId + appId) == null) {
            String userId = this.getUserInfo().getUserId();
            AnalysisTableMatchItemTask.taskDebounce.put(subsId + appId, "R");
            AnalysisTableMatchItemTask task = new AnalysisTableMatchItemTask(subsId, appId, null, null, userId);
            this.applicationThreadPool.add((Callable)task);
            return this.getResponseData("\u6267\u884c\u6210\u529f");
        }
        return this.getResponseData("\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u5019\uff01");
    }

    @RequestMapping(value={"/api/portal/s/subs/info/matchItem/stat"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> appRefactorStdStat(@RequestParam(value="key") String key) {
        if (AnalysisTableMatchItemTask.taskDebounce.get(key) == null) {
            return this.getResponseData("done");
        }
        return this.getResponseData("running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @RequestMapping(value={"/api/portal/s/subs/info/implstd"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Integer> appsImplStd(@RequestParam(value="subsId") String subsId, @RequestParam(value="appId") String appId, @RequestParam(value="objectId", required=false) String objectId, @RequestParam(value="dataMarkFlag") String dataMarkFlag) {
        PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
        appParam.setSubsId(subsId);
        appParam.setAppId(appId);
        List appList = this.paasAppsInfoService.queryList((Object)appParam);
        if (CollectionUtils.isEmpty((Collection)appList)) {
            return this.getResponseData(0);
        }
        String nowTime = CurrentDateUtil.getTodayDateEx2();
        String userId = this.getUserInfo().getUserId();
        SSubsInfoDTO subsInfo = new SSubsInfoDTO();
        subsInfo.setSubsId(subsId);
        subsInfo = (SSubsInfoDTO)((SSubsInfoPortalService)this.getService()).queryByPk((Object)subsInfo);
        String needDsl = subsInfo.getNeedDsl();
        String dslId = subsInfo.getDslId();
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)needDsl, (CharSequence)YesOrNO.YES.getCode())) {
            return this.getResponseData(-1, "", "\u8be5\u7cfb\u7edf\u4e0d\u843d\u6807");
        }
        int num = 0;
        for (PaasAppsInfoDTO app : appList) {
            block15: {
                BigDecimal re;
                long costTime;
                Date endData;
                Date startDate;
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)app.getDataMarkStat(), (CharSequence)"R")) continue;
                PaasTaskHisDTO appHis = new PaasTaskHisDTO();
                appHis.setTaskHisId(UUIDUtil.getShortUUID());
                appHis.setTaskId(appHis.getTaskHisId());
                appHis.setAppId(app.getAppId());
                appHis.setSubsId(app.getSubsId());
                appHis.setTaskCategory("L");
                appHis.setTaskType("L00001");
                appHis.setTaskName(String.format("%s\u8868\u6a21\u578b\u843d\u6807", app.getAppName()));
                appHis.setStartTime(CurrentDateUtil.getTodayDateEx2());
                appHis.setCreateUser(this.getUserInfo().getUserId());
                appHis.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                app.setDataMarkFlag(dataMarkFlag);
                app.setDataMarkTime(nowTime);
                app.setDataMarkStat("R");
                this.paasAppsInfoService.updateByPk((Object)app);
                ModelTableInfoDTO tbParam = new ModelTableInfoDTO();
                tbParam.setAppId(app.getAppId());
                tbParam.setObjectId(objectId);
                List tableList = this.modelTableInfoService.queryList((Object)tbParam);
                if (CollectionUtils.isNotEmpty((Collection)tableList)) {
                    for (ModelTableInfoDTO tb : tableList) {
                        this.modelTableFieldService.fieldRefactorByObjectId(tb.getObjectId(), dataMarkFlag, dslId, userId);
                    }
                }
                ++num;
                AnalysisIndexExcelDataDTO analysisData = this.modelTableInfoService.querySysAnalysisIndexData(app.getSubsId(), app.getAppId());
                PaasAppsMeasureDTO measure = new PaasAppsMeasureDTO();
                measure.setFieldCnRate(new BigDecimal(analysisData.getFieldCNRate()));
                measure.setFieldMarkFlagRate(new BigDecimal(analysisData.getFieldMarkFlagRate()));
                measure.setFieldStdFlagRate(new BigDecimal(analysisData.getFieldStdFlagRate()));
                app.setDataMarkStat(YesOrNO.YES.getCode());
                this.paasAppsMeasureService.updateByPk((Object)measure);
                appHis.setTaskState(String.valueOf(6));
                String startTime = appHis.getStartTime();
                appHis.setEndTime(CurrentDateUtil.getTodayDateEx2());
                String endTime = appHis.getEndTime();
                try {
                    startDate = DateUtils.parseDate((String)startTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                    endData = DateUtils.parseDate((String)endTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                    costTime = endData.getTime() - startDate.getTime();
                    re = new BigDecimal(costTime).divide(new BigDecimal(1000), 2, RoundingMode.HALF_UP);
                    appHis.setCostTime(re);
                }
                catch (Exception e) {
                    logger.error("\u8fd0\u884c\u8017\u65f6\u8ba1\u7b97\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                }
                this.paasTaskHisService.insert((Object)appHis);
                break block15;
                catch (Exception e) {
                    try {
                        logger.error("\u6267\u884c\u843d\u6807\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                        app.setDataMarkStat(YesOrNO.NO.getCode());
                        appHis.setTaskState(String.valueOf(7));
                    }
                    catch (Throwable throwable) {
                        String startTime2 = appHis.getStartTime();
                        appHis.setEndTime(CurrentDateUtil.getTodayDateEx2());
                        String endTime2 = appHis.getEndTime();
                        try {
                            Date startDate2 = DateUtils.parseDate((String)startTime2, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                            Date endData2 = DateUtils.parseDate((String)endTime2, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                            long costTime2 = endData2.getTime() - startDate2.getTime();
                            BigDecimal re2 = new BigDecimal(costTime2).divide(new BigDecimal(1000), 2, RoundingMode.HALF_UP);
                            appHis.setCostTime(re2);
                        }
                        catch (Exception e2) {
                            logger.error("\u8fd0\u884c\u8017\u65f6\u8ba1\u7b97\u5f02\u5e38 " + e2.getMessage(), (Throwable)e2);
                        }
                        this.paasTaskHisService.insert((Object)appHis);
                        throw throwable;
                    }
                    startTime = appHis.getStartTime();
                    appHis.setEndTime(CurrentDateUtil.getTodayDateEx2());
                    endTime = appHis.getEndTime();
                    try {
                        startDate = DateUtils.parseDate((String)startTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                        endData = DateUtils.parseDate((String)endTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                        costTime = endData.getTime() - startDate.getTime();
                        re = new BigDecimal(costTime).divide(new BigDecimal(1000), 2, RoundingMode.HALF_UP);
                        appHis.setCostTime(re);
                    }
                    catch (Exception e3) {
                        logger.error("\u8fd0\u884c\u8017\u65f6\u8ba1\u7b97\u5f02\u5e38 " + e3.getMessage(), (Throwable)e3);
                    }
                    this.paasTaskHisService.insert((Object)appHis);
                }
            }
            this.paasAppsInfoService.updateByPk((Object)app);
        }
        return this.getResponseData(num);
    }

    @RequestMapping(value={"/api/portal/s/subs/info/seq"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryAllSSubsInfo(@RequestParam(value="solutionType") String solutionType) {
        String result = ((SSubsInfoPortalService)this.getService()).querySSubsInfoMaxOrderWithPrefix(solutionType);
        return this.getResponseData(result);
    }

    @RequestMapping(value={"/api/portal/s/subs/info/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySummary(Map<String, Object> param) {
        List outputVo = ((SSubsInfoPortalService)this.getService()).querySummary(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/portal/s/subs/info/summary/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySubsInfoSummary(SSubsInfoDTO param) {
        List outputVo = ((SSubsInfoPortalService)this.getService()).querySubsInfoSummaryByPage(param);
        ResponseData result = this.getResponseData(outputVo);
        result.setTotal(param.getTotal().intValue());
        return result;
    }

    @RequestMapping(value={"/api/portal/s/subs/info/summary/group/solutionType"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySummaryBySolutionTypeGroup(SSubsInfoDTO param) {
        List outputVo = ((SSubsInfoPortalService)this.getService()).querySummaryBySolutionTypeGroup(param);
        ResponseData result = this.getResponseData(outputVo);
        result.setTotal(param.getTotal().intValue());
        return result;
    }

    @RequestMapping(value={"/api/portal/s/subs/info/summary/cba"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> querySubsCbaSummary(@RequestBody Map<String, Object> params) {
        return this.getResponseData(((SSubsInfoPortalService)this.getService()).querySubsCbaSummary(params));
    }

    public static class SubsInfoExcelReadListener
    extends AnalysisEventListener {
        private List<SSubsInfoDTO> list = new ArrayList<SSubsInfoDTO>();
        private List<String> HEAD = Arrays.asList("\u5e94\u7528\u7f16\u53f7", "\u5e94\u7528\u7b80\u79f0", "\u5e94\u7528\u540d\u79f0", "\u5e94\u7528\u7c7b\u578b", "\u5e94\u7528\u67b6\u6784\u5206\u5c42", "\u7cfb\u7edf\u7f16\u53f7", "\u7cfb\u7edf\u7b80\u79f0", "\u7cfb\u7edf\u540d\u79f0", "\u7cfb\u7edf\u82f1\u6587\u5168\u79f0", "\u7cfb\u7edf\u7b80\u4ecb", "\u7cfb\u7edf\u4f7f\u7528\u8303\u56f4", "\u7cfb\u7edf\u670d\u52a1\u5bf9\u8c61", "\u7cfb\u7edf\u72b6\u6001");
        private List<String> headCellList = new ArrayList<String>();

        public List<SSubsInfoDTO> getList() {
            return this.list;
        }

        public void setList(List<SSubsInfoDTO> list) {
            this.list = list;
        }

        public void invokeHeadMap(Map headMap, AnalysisContext context) {
            super.invokeHeadMap(headMap, context);
            int size = headMap.size();
            for (int i = 0; i < size; ++i) {
                this.headCellList.add((String)headMap.get(i));
            }
        }

        public void invoke(Object data, AnalysisContext context) {
            Map map = (Map)data;
            SSubsInfoDTO subsInfo = new SSubsInfoDTO();
            String id = (String)map.get(5);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
                return;
            }
            subsInfo.setArchLevelType((String)map.get(4));
            subsInfo.setSubsId((String)map.get(5));
            subsInfo.setSubsCode((String)map.get(6));
            subsInfo.setSubsName((String)map.get(7));
            subsInfo.setSubsEnname((String)map.get(8));
            subsInfo.setSubsIntro((String)map.get(9));
            subsInfo.setScopeUse((String)map.get(10));
            subsInfo.setServiceUsed((String)map.get(11));
            subsInfo.setSubsState((String)map.get(12));
            this.list.add(subsInfo);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        public String checkExcelFormat() {
            if (this.headCellList.size() != this.HEAD.size()) {
                return "\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e";
            }
            for (int i = 0; i < this.HEAD.size(); ++i) {
                if (StringUtils.equals((String)this.headCellList.get(i), (String)this.HEAD.get(i))) continue;
                return "\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e";
            }
            return null;
        }
    }
}

