/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasMarketAppinfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasMarketStdinfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasMarketSysinfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateInfoDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.sdk.beans.core.vo.EasyUITreeData;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="TransferOutsideMarketController")
@RequestMapping(value={"/api/om/"})
public class TransferOutsideMarketController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(TransferOutsideMarketController.class);
    @Autowired
    @Lazy
    private PaasEnvParamService paasEnvParamService;

    @RequestMapping(value={"/paas/market/appinfo/index"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasMarketAppinfoDTO>> queryAppsInfoData(@RequestBody PaasMarketAppinfoDTO param) {
        String industryType = this.getIndustryType();
        if (!StringUtils.equals((CharSequence)param.getLimitIndustryType(), (CharSequence)YesOrNO.NO.getCode()) && StringUtils.isBlank((CharSequence)param.getIndustryType())) {
            param.setIndustryType(industryType);
        }
        String baseUrl = this.getRequestBaseUrl();
        String json = this.requestOpenApi(baseUrl + "om/paas/market/appinfo/index", param);
        List output = JSON.parseArray((String)json, PaasMarketAppinfoDTO.class);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/paas/market/appinfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<PaasMarketAppinfoDTO> queryAppsInfoDataByPk(@RequestBody PaasMarketAppinfoDTO param) {
        String baseUrl = this.getRequestBaseUrl();
        String json = this.requestOpenApi(baseUrl + "om/paas/market/appinfo", param);
        PaasMarketAppinfoDTO output = (PaasMarketAppinfoDTO)JSON.parseObject((String)json, PaasMarketAppinfoDTO.class);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/paas/market/sysinfo/index"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasMarketSysinfoDTO>> querySysinfoData(@RequestBody PaasMarketSysinfoDTO param) {
        String industryType = this.getIndustryType();
        if (!StringUtils.equals((CharSequence)param.getLimitIndustryType(), (CharSequence)YesOrNO.NO.getCode()) && StringUtils.isBlank((CharSequence)param.getIndustryType())) {
            param.setIndustryType(industryType);
        }
        String baseUrl = this.getRequestBaseUrl();
        String json = this.requestOpenApi(baseUrl + "om/paas/market/sysinfo/index", param);
        List output = JSON.parseArray((String)json, PaasMarketSysinfoDTO.class);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/paas/market/sysinfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<PaasMarketSysinfoDTO> querySysinfoDataByPk(@RequestBody PaasMarketSysinfoDTO param) {
        String baseUrl = this.getRequestBaseUrl();
        String json = this.requestOpenApi(baseUrl + "om/paas/market/sysinfo", param);
        PaasMarketSysinfoDTO output = (PaasMarketSysinfoDTO)JSON.parseObject((String)json, PaasMarketSysinfoDTO.class);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/paas/market/stdinfo/index"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasMarketStdinfoDTO>> querStdinfoData(@RequestBody PaasMarketStdinfoDTO param) {
        String industryType = this.getIndustryType();
        if (!StringUtils.equals((CharSequence)param.getLimitIndustryType(), (CharSequence)YesOrNO.NO.getCode()) && StringUtils.isBlank((CharSequence)param.getIndustryType())) {
            param.setIndustryType(industryType);
        }
        String baseUrl = this.getRequestBaseUrl();
        String json = this.requestOpenApi(baseUrl + "om/paas/market/stdinfo/index", param);
        List output = JSON.parseArray((String)json, PaasMarketStdinfoDTO.class);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/paas/market/stdinfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<PaasMarketStdinfoDTO> querStdinfoDataByPk(@RequestBody PaasMarketStdinfoDTO param) {
        String baseUrl = this.getRequestBaseUrl();
        String json = this.requestOpenApi(baseUrl + "om/paas/market/stdinfo", param);
        PaasMarketStdinfoDTO output = (PaasMarketStdinfoDTO)JSON.parseObject((String)json, PaasMarketStdinfoDTO.class);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/paas/template/info/index"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTemplateInfoDTO>> queryProdAppsInfoData(@RequestBody PaasMarketAppinfoDTO param) {
        param.setSize(Integer.valueOf(1000));
        String baseUrl = this.getRequestBaseUrl();
        String json = this.requestOpenApi(baseUrl + "om/paas/template/info/index", param);
        List output = JSON.parseArray((String)json, PaasTemplateInfoDTO.class);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/paas/template/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<PaasTemplateInfoDTO> queryProdAppsInfoDataByPk(@RequestBody PaasMarketAppinfoDTO param) {
        String baseUrl = this.getRequestBaseUrl();
        String json = this.requestOpenApi(baseUrl + "om/paas/template/info", param);
        PaasTemplateInfoDTO output = (PaasTemplateInfoDTO)JSON.parseObject((String)json, PaasTemplateInfoDTO.class);
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/paas/market/sysinfo/pop/tree"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<EasyUITreeData>> querySysTreeForMarket(@RequestBody Map<String, Object> param) {
        String industryType = this.getIndustryType();
        param.put("industryType", industryType);
        String baseUrl = this.getRequestBaseUrl();
        String json = this.requestOpenApi(baseUrl + "om/paas/market/sysinfo/pop/tree", param);
        List treeList = JSON.parseArray((String)json, EasyUITreeData.class);
        return this.getResponseData(treeList);
    }

    public String requestOpenApi(String url, Object param) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost postMethod = new HttpPost(url);
        HttpResponse response = null;
        try {
            String reqJson = JSON.toJSONString((Object)param);
            StringEntity entity = new StringEntity(reqJson, ContentType.APPLICATION_JSON);
            postMethod.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)postMethod);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            return json;
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getRequestBaseUrl() {
        PaasEnvParamDTO envParam = new PaasEnvParamDTO();
        envParam.setParamCode("allinpaas.open.api.http.url");
        envParam.setEnvId("paas");
        envParam = (PaasEnvParamDTO)this.paasEnvParamService.queryByPk((Object)envParam);
        return envParam.getParamValue();
    }

    private String getIndustryType() {
        PaasEnvParamDTO envParam = new PaasEnvParamDTO();
        envParam.setParamCode("allinpaas.open.api.industry.type");
        envParam.setEnvId("paas");
        envParam = (PaasEnvParamDTO)this.paasEnvParamService.queryByPk((Object)envParam);
        if (envParam != null) {
            return envParam.getParamValue();
        }
        return "BNK";
    }
}

