/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.portal.console.facade.HomePageService;
import com.irdstudio.allinapaas.portal.console.facade.dto.HomePageDTO;
import com.irdstudio.allintpaas.admin.facade.AllinCloudPortalClient;
import com.irdstudio.sdk.admin.service.vo.SRoleuserDTO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class HomePageController
extends AbstractController {
    @Autowired
    @Qualifier(value="sSubsInfoService")
    private SSubsInfoService sSubsInfoService;
    @Autowired
    @Qualifier(value="PageService")
    private HomePageService homePageService;

    @RequestMapping(value={"/api/batch/home/pages/summarys"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryHomeSummaryPage(HomePageDTO param) {
        String envId = "dev";
        param.setEnvId(envId);
        UserInfo user = this.getUserInfo();
        param.setUserId(user.getUserId());
        SRoleuserDTO sRoleuserDTO = new SRoleuserDTO();
        sRoleuserDTO.setActorno(user.getUserId());
        AllinCloudPortalClient portalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
        List roles = portalClient.queryAllByCondition(sRoleuserDTO);
        List userRoles = roles.stream().map(r -> r.getRoleno()).collect(Collectors.toList());
        param.setUserRoles(userRoles);
        List homePageVOList = this.homePageService.querySummaryAll(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/api/paas/pages/summarys"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryPaasSummaryByPage(HomePageDTO param) {
        List homePageVOList = this.homePageService.queryPaasSummaryByPage(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/api/batch/home/pages/iaas/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryIaasSummary(HomePageDTO param) {
        List homePageVOList = this.homePageService.queryIaasSummary(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/api/batch/home/pages"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<HomePageDTO>> queryHomePage(HomePageDTO param) {
        String envId = "dev";
        param.setEnvId(envId);
        UserInfo user = this.getUserInfo();
        param.setUserId(user.getUserId());
        if (StringUtils.isNotBlank((CharSequence)param.getSolutionType()) && StringUtils.contains((CharSequence)param.getSolutionType(), (CharSequence)",")) {
            param.setSolutionTypes(Arrays.asList(StringUtils.split((String)param.getSolutionType(), (String)",")));
            param.setSolutionType(null);
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSubsIds())) {
            param.setSubsIdList(Arrays.asList(StringUtils.split((String)param.getSubsIds(), (String)",")));
        }
        SRoleuserDTO sRoleuserDTO = new SRoleuserDTO();
        sRoleuserDTO.setActorno(user.getUserId());
        AllinCloudPortalClient portalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
        List roles = portalClient.queryAllByCondition(sRoleuserDTO);
        List userRoles = roles.stream().map(r -> r.getRoleno()).collect(Collectors.toList());
        param.setUserRoles(userRoles);
        this.setUserInfoToVO(param);
        List homePageVOList = this.homePageService.queryAll(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/api/subs/pages"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<HomePageDTO>> querySubsInfoPage(HomePageDTO param) {
        if (StringUtils.isNotBlank((CharSequence)param.getSolutionType()) && StringUtils.contains((CharSequence)param.getSolutionType(), (CharSequence)",")) {
            param.setSolutionTypes(Arrays.asList(StringUtils.split((String)param.getSolutionType(), (String)",")));
            param.setSolutionType(null);
        }
        List homePageVOList = this.homePageService.queryAll(param);
        return this.getResponseData(homePageVOList);
    }

    @RequestMapping(value={"/client/home/queryWXIndex"}, method={RequestMethod.POST})
    public List<Map<String, Object>> queryWXIndex(@RequestBody HomePageDTO param) {
        return this.homePageService.queryWXIndex(param);
    }
}

