/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.web.controller.api;

import com.irdstudio.allinapaas.deliver.console.facade.PaasDeployInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoPortalService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasScriptInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasDeployInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsActionDTO;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskAppopsService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasDeployInfoWithActionDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskAppopsDTO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasTaskAppopsController
extends BaseController<PaasTaskAppopsDTO, PaasTaskAppopsService>
implements FrameworkService {
    @Autowired
    private PaasDeployInfoService paasDeployInfoService;
    @Autowired
    private PaasEcsInfoPortalService paasEcsInfoService;
    @Autowired
    private PaasScriptInfoService paasScriptInfoService;
    @Autowired
    private PaasTaskAppopsService paasTaskAppopsService;

    @RequestMapping(value={"/api/paas/task/appopss"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTaskAppopsDTO>> queryPaasTaskAppopsAll(PaasTaskAppopsDTO dto) {
        if (StringUtils.contains((CharSequence)dto.getTaskType(), (CharSequence)",")) {
            String[] taskTypes = StringUtils.split((String)dto.getTaskType(), (String)",");
            dto.setTaskTypes(Arrays.asList(taskTypes));
            dto.setTaskType(null);
        }
        List outputVo = ((PaasTaskAppopsService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/appops/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasTaskAppopsDTO> queryByPk(@PathVariable(value="taskId") String taskId) {
        PaasTaskAppopsDTO inVo = new PaasTaskAppopsDTO();
        inVo.setTaskId(taskId);
        PaasTaskAppopsDTO outputVo = (PaasTaskAppopsDTO)((PaasTaskAppopsService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/appops"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasTaskAppopsDTO inPaasTaskAppopsDTO) {
        int outputVo = ((PaasTaskAppopsService)this.getService()).deleteByPk((Object)inPaasTaskAppopsDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/appops"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<String> updateByPk(@RequestBody PaasTaskAppopsDTO inPaasTaskAppopsDTO) {
        this.setUserInfoToVO(inPaasTaskAppopsDTO);
        inPaasTaskAppopsDTO.setLastUpdateUser(inPaasTaskAppopsDTO.getLoginUserId());
        inPaasTaskAppopsDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PaasTaskAppopsService)this.getService()).updateByPk((Object)inPaasTaskAppopsDTO);
        return this.getResponseData(inPaasTaskAppopsDTO.getTaskId());
    }

    @RequestMapping(value={"/api/paas/task/appops"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertPaasTaskAppops(@RequestBody PaasTaskAppopsDTO inPaasTaskAppopsDTO) {
        this.setUserInfoToVO(inPaasTaskAppopsDTO);
        inPaasTaskAppopsDTO.setCreateUser(inPaasTaskAppopsDTO.getLoginUserId());
        inPaasTaskAppopsDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPaasTaskAppopsDTO.setLastUpdateUser(inPaasTaskAppopsDTO.getLoginUserId());
        inPaasTaskAppopsDTO.setLastUpdateTime(inPaasTaskAppopsDTO.getCreateTime());
        if (StringUtils.isBlank((CharSequence)inPaasTaskAppopsDTO.getTaskId())) {
            inPaasTaskAppopsDTO.setTaskId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((PaasTaskAppopsService)this.getService()).insert((Object)inPaasTaskAppopsDTO);
        return this.getResponseData(inPaasTaskAppopsDTO.getTaskId());
    }

    @RequestMapping(value={"/api/paas/task/appops/init"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> initTaskAppopsList(@RequestBody Map<String, Object> params) {
        String subsId = MapUtils.getString(params, (Object)"subsId");
        String envId = MapUtils.getString(params, (Object)"envId");
        String actionId = MapUtils.getString(params, (Object)"actionId");
        String appIds = MapUtils.getString(params, (Object)"appList");
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        int outpputVO = 0;
        PaasDeployInfoDTO appParam = new PaasDeployInfoDTO();
        appParam.setSubsId(subsId);
        appParam.setEnvId(envId);
        appParam.setActionId(actionId);
        appParam.setAppIdList(Arrays.asList(StringUtils.split((String)appIds, (String)",")));
        List appList = this.paasDeployInfoService.queryAllBySubsCode(appParam);
        List appWithActinoList = this.beansCopy(appList, PaasDeployInfoWithActionDTO.class);
        if (CollectionUtils.isNotEmpty((Collection)appWithActinoList)) {
            for (PaasDeployInfoWithActionDTO appDeploy : appWithActinoList) {
                if (!CollectionUtils.isNotEmpty((Collection)appDeploy.getActionList())) continue;
                for (PaasAppsActionDTO action : appDeploy.getActionList()) {
                    String scriptId = action.getScriptId();
                    String scriptName = action.getScriptName();
                    PaasTaskAppopsDTO taskAppops = new PaasTaskAppopsDTO();
                    taskAppops.setScriptId(scriptId);
                    taskAppops.setAppId(action.getAppId());
                    List taskList = this.paasTaskAppopsService.queryListByPage((Object)taskAppops);
                    if (CollectionUtils.isNotEmpty((Collection)taskList)) continue;
                    PaasTaskAppopsDTO insertTask = new PaasTaskAppopsDTO();
                    insertTask.setCreateUser(userId);
                    insertTask.setCreateTime(now);
                    insertTask.setLastUpdateUser(userId);
                    insertTask.setLastUpdateTime(now);
                    insertTask.setSubsId(appDeploy.getSubsId());
                    insertTask.setAppId(appDeploy.getAppId());
                    insertTask.setTaskType("D01001");
                    insertTask.setTaskCategory("D");
                    if (StringUtils.equals((CharSequence)actionId, (CharSequence)"appOpsStart")) {
                        insertTask.setAppopsType("start");
                    } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"appOpsStop")) {
                        insertTask.setAppopsType("stop");
                    } else {
                        insertTask.setAppopsType("restart");
                    }
                    if (StringUtils.isBlank((CharSequence)insertTask.getTaskId())) {
                        insertTask.setTaskId(UUIDUtil.getShortUUID());
                    }
                    insertTask.setScriptId(scriptId);
                    insertTask.setScriptName(scriptName);
                    PaasEcsInfoDTO ecsParam = new PaasEcsInfoDTO();
                    ecsParam.setSubsId(subsId);
                    ecsParam.setAppId(action.getAppId());
                    ecsParam.setEnvId(envId);
                    List ecsList = this.paasEcsInfoService.queryListByPage((Object)ecsParam);
                    if (!CollectionUtils.isNotEmpty((Collection)ecsList)) continue;
                    insertTask.setEcsId(((PaasEcsInfoDTO)ecsList.get(0)).getEcsId());
                    int re = ((PaasTaskAppopsService)this.getService()).insert((Object)insertTask);
                    if (re <= 0) continue;
                    outpputVO += re;
                }
            }
        }
        return this.getResponseData(outpputVO);
    }
}

