/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictItemInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictItemInfoDao {
    private static final Logger logger = LoggerFactory.getLogger(DictItemInfoDao.class);
    Connection conn = null;

    public DictItemInfoDao(Connection conn) {
        this.conn = conn;
    }

    public DictItemInfo queryByPk(final String itemId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_item_info");
                this.WHERE("item_id = ?");
                param.add(itemId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictItemInfo> list = new ArrayList<DictItemInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictItemInfo bean = (DictItemInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictItemInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return list.isEmpty() ? null : (DictItemInfo)((Object)list.get(0));
    }

    public List<DictItemInfo> queryDictItemInfoList(final DictItemInfo paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_item_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictItemInfo> list = new ArrayList<DictItemInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictItemInfo bean = (DictItemInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictItemInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryDictItemInfoList is wrong", e);
        }
        return list;
    }

    public List<DictItemInfo> queryByItemNames(final List<String> names, final String objectId) {
        if (names == null || names.isEmpty()) {
            return new ArrayList<DictItemInfo>(0);
        }
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_item_info");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < names.size(); ++i) {
                    param.add(names.get(i));
                    sb.append("?");
                    if (i >= names.size() - 1) continue;
                    sb.append(",");
                }
                this.WHERE(String.format("item_name in (%s)", sb.toString()));
                if (objectId != null) {
                    this.WHERE("(access_level = '1' or ( access_level = '2' and app_id in (select app_id from `allinrdm_db`.model_table_info where object_id = ?)))");
                    param.add(objectId);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictItemInfo> list = new ArrayList<DictItemInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictItemInfo bean = (DictItemInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictItemInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByItemNames is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<DictItemInfo> queryByItemExtNames(final List<String> names, final String objectId) {
        if (names == null || names.isEmpty()) {
            return new ArrayList<DictItemInfo>(0);
        }
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("item.*, ext.ext_name");
                this.FROM("`allinrdm_db`.dict_item_ext ext join `allinrdm_db`.dict_item_info item on ext.item_id = item.item_id");
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < names.size(); ++i) {
                    param.add(names.get(i));
                    sb.append("?");
                    if (i >= names.size() - 1) continue;
                    sb.append(",");
                }
                this.WHERE(String.format("ext_name in (%s)", sb.toString()));
                if (objectId != null) {
                    this.WHERE("(access_level = '1' or ( access_level = '2' and item.app_id in (select app_id from `allinrdm_db`.model_table_info where object_id = ?)))");
                    param.add(objectId);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictItemInfo> list = new ArrayList<DictItemInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictItemInfo bean = (DictItemInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictItemInfo.class));
                String extName = rs.getString("ext_name");
                bean.setExtName(extName);
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByItemExtNames is wrong", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    public List<DictItemInfo> queryDictItemInfoList(final String appId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_item_info item");
                this.WHERE("exists (select item_id from `allinrdm_db`.model_table_field ff where ff.item_id = item.item_id and exists (      select tb.object_id from `allinrdm_db`.model_table_info tb where tb.app_id = ? and tb.object_id = ff.object_id))");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictItemInfo> list = new ArrayList<DictItemInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictItemInfo bean = (DictItemInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictItemInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryDictItemInfoList is wrong", e);
        }
        return list;
    }

    public List<DictItemInfo> queryDictItemInfoList(final List<String> appIds) {
        final ArrayList<DictItemInfo> param = new ArrayList<DictItemInfo>();
        if (CollectionUtils.isEmpty(appIds)) {
            return param;
        }
        final ArrayList<String> inSql = new ArrayList<String>();
        for (int i = 0; i < appIds.size(); ++i) {
            inSql.add("?");
        }
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinrdm_db`.dict_item_info item");
                String inSqlStr = StringUtils.join((Iterable)inSql, (String)",");
                this.WHERE("exists (select item_id from `allinrdm_db`.model_table_field ff where ff.item_id = item.item_id and exists (      select tb.object_id from `allinrdm_db`.model_table_info tb where tb.app_id in (" + inSqlStr + ") and tb.object_id = ff.object_id))");
                param.addAll(appIds);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DictItemInfo> list = new ArrayList<DictItemInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                DictItemInfo bean = (DictItemInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, DictItemInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryDictItemInfoList is wrong", e);
        }
        return list;
    }
}

