/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.vo.TreeData;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaasAppsInfoDao {
    private static final Logger logger = LoggerFactory.getLogger(PaasAppsInfoDao.class);
    Connection conn = null;

    public PaasAppsInfoDao(Connection conn) {
        this.conn = conn;
    }

    public PaasAppsInfo queryByPk(final PaasAppsInfo paasAppsInfo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_apps_info");
                this.WHERE("app_id = ?");
                param.add(paasAppsInfo.getAppId());
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasAppsInfo> list = new ArrayList<PaasAppsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                PaasAppsInfo bean = (PaasAppsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasAppsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return list.isEmpty() ? null : (PaasAppsInfo)((Object)list.get(0));
    }

    public PaasAppsInfo queryByBatchSerialNo(final String batchSerialNo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_apps_info");
                this.WHERE("app_id in ( select app_id from `allinpaas_db`.bat_inst_batch WHERE batch_serial_no = ? )");
                param.add(batchSerialNo);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasAppsInfo> list = new ArrayList<PaasAppsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                PaasAppsInfo bean = (PaasAppsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasAppsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return list.isEmpty() ? null : (PaasAppsInfo)((Object)list.get(0));
    }

    public PaasAppsInfo queryByAppId(final String appId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_apps_info");
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasAppsInfo> list = new ArrayList<PaasAppsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                PaasAppsInfo bean = (PaasAppsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasAppsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryByPk is wrong", e);
        }
        return list.isEmpty() ? null : (PaasAppsInfo)((Object)list.get(0));
    }

    public boolean updateByPk(final PaasAppsInfo appInfo) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinpaas_db`.paas_apps_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)appInfo));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("app_id")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("app_id = ?");
                param.add(appInfo.getAppId());
            }
        }.toString();
        PreparedStatement ps = null;
        try {
            int i;
            ps = this.conn.prepareStatement(sql);
            for (i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            i = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("update by pk is wrong", e);
        }
        return true;
    }

    public List<PaasAppsInfo> queryPaasAppsInfoListBySysCode(final String sysId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_apps_info");
                if (sysId != null) {
                    this.WHERE("subs_id = ?");
                    param.add(sysId);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasAppsInfo> list = new ArrayList<PaasAppsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasAppsInfo bean = (PaasAppsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasAppsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasAppsParamList is wrong", e);
        }
        return list;
    }

    public List<PaasAppsInfo> queryPaasAppsInfoListByAppType(final String appType) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_apps_info");
                this.WHERE("IFNULL(subs_id, '') ='' ");
                if (appType != null && appType.equals(AppType.A10.getCode())) {
                    this.WHERE("app_type = ?");
                    param.add(appType);
                } else if (appType != null && appType.equals(AppType.A10.getCode())) {
                    List<String> appTypes = Arrays.asList(AppType.A10.getCode(), AppType.A10.getCode());
                    ArrayList<String> qList = new ArrayList<String>();
                    for (String at : appTypes) {
                        qList.add("?");
                        param.add(at);
                    }
                    this.WHERE("app_type in (" + StringUtils.join(qList, (String)",") + ")");
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasAppsInfo> list = new ArrayList<PaasAppsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasAppsInfo bean = (PaasAppsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasAppsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasAppsParamList is wrong", e);
        }
        return list;
    }

    public List<PaasAppsInfo> queryComponentAndFuncAppList(final String subsId, final List<String> appTypes) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_apps_info");
                if (subsId != null) {
                    this.WHERE("subs_id=?");
                    param.add(subsId);
                } else if (StringUtils.isBlank((CharSequence)subsId)) {
                    this.WHERE("IFNULL(subs_id, '') = ''");
                }
                if (appTypes != null) {
                    ArrayList<String> qList = new ArrayList<String>();
                    for (String at : appTypes) {
                        qList.add("?");
                        param.add(at);
                    }
                    this.WHERE("app_type in (" + StringUtils.join(qList, (String)",") + ")");
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasAppsInfo> list = new ArrayList<PaasAppsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasAppsInfo bean = (PaasAppsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasAppsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasAppsParamList is wrong", e);
        }
        return list;
    }

    public boolean insertPaasAppsInfo(final PaasAppsInfo vo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("`allinpaas_db`.paas_apps_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)vo));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            if (re == 1) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query insertPaasAppsInfo is wrong", e);
        }
        return false;
    }

    public int deleteByAppId(final String appId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.paas_apps_info");
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByAppId is wrong", e);
        }
    }

    public Integer querySysCodeAppOrder(final String subsId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("max(app_order)");
                this.FROM("`allinpaas_db`.paas_apps_info");
                this.WHERE("subs_id = ?");
                param.add(subsId);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            rs.next();
            return rs.getInt(1);
        }
        catch (Exception e) {
            throw new RuntimeException("querySysCodeAppOrder is wrong", e);
        }
    }

    public List<PaasAppsInfo> queryPaasAppsInfoList(final PaasAppsInfo paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_apps_info");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasAppsInfo> list = new ArrayList<PaasAppsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasAppsInfo bean = (PaasAppsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasAppsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasAppsInfoList is wrong", e);
        }
        return list;
    }

    public List<PaasAppsInfo> queryReferenceApp(final String appId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("t.*");
                this.FROM("`allinpaas_db`.paas_apps_info t");
                this.WHERE("app_id in (\n    select app_id from `allinrdm_db`.srv_model_info where srv_model_id in (\n        select row_op_target_id from `allinrdm_db`.osrv_arrange_table where srv_model_id in (\n            select srv_model_id from `allinrdm_db`.srv_model_info where app_id = ? \n        )\n    )\n)");
                param.add(appId);
                this.WHERE("app_id != ? ");
                param.add(appId);
                this.ORDER_BY("subs_id");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasAppsInfo> list = new ArrayList<PaasAppsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasAppsInfo bean = (PaasAppsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasAppsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryReferenceApp is wrong", e);
        }
        return list;
    }

    public List<PaasAppsInfo> querySDKApp(final String archType) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("t.*");
                this.FROM("`allinpaas_db`.paas_apps_info t");
                this.WHERE("subs_id in ( select tf_sdk_id from `allinrdm_db`.tcl_framework_info where tcl_id = ? )");
                param.add(archType);
                this.ORDER_BY("app_order");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasAppsInfo> list = new ArrayList<PaasAppsInfo>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasAppsInfo bean = (PaasAppsInfo)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasAppsInfo.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query querySDKApp is wrong", e);
        }
        return list;
    }

    public List<TreeData> queryTableModelPackage(final String appId) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("package_id as id, package_name as text, 'false' as checked, 'open' as state, package_abv_id as parentid, package_type as attributes");
                this.FROM("`allinrdm_db`.model_folder_info");
                this.WHERE("app_id = ?");
                param.add(appId);
                this.WHERE("package_type='2'");
                this.ORDER_BY("package_type,package_name");
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<TreeData> list = new ArrayList<TreeData>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                TreeData bean = new TreeData();
                bean.setId(rs.getString("id"));
                bean.setText(rs.getString("text"));
                bean.setChecked(rs.getString("checked"));
                bean.setState(rs.getString("state"));
                bean.setParentid(rs.getString("parentid"));
                bean.setAttributes(rs.getString("attributes"));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryTableModelPackage is wrong", e);
        }
        return list;
    }
}

