/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.fadpaas.FadpaasPageRenderFactory;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.fadpaas.IFadpaasPageRender;
import com.irdstudio.allinrdm.dev.console.facade.PageModelFieldService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelLogService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelPackageService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelParamService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateFileService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelLogDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelPackageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateFileDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.PageTemplateType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FadpaasPagePlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private BatInstBatch batchInst;
    private Map<String, Object> extParam = null;
    private String pageModelId = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        this.pageModelId = MapUtils.getString(this.extParam, (Object)"pageModelId");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean result;
        block44: {
            this.logger.info("\u9875\u9762\u6a21\u578b\u4ee3\u7801\u751f\u6210\u63d2\u4ef6");
            result = true;
            Connection conn = null;
            try {
                File routeTemplateFile;
                String subsCode = this.appInfo.getAppCode();
                conn = this.getPluginConnection();
                String userId = MapUtils.getString(this.extParam, (Object)"loginUserId");
                PageModelPackageService pageModelPackageService = (PageModelPackageService)SpringContextUtils.getBean(PageModelPackageService.class);
                PageModelInfoService pageModelInfoService = (PageModelInfoService)SpringContextUtils.getBean(PageModelInfoService.class);
                PageModelLogService pageModelLogService = (PageModelLogService)SpringContextUtils.getBean(PageModelLogService.class);
                PageModelParamService pageModelParamService = (PageModelParamService)SpringContextUtils.getBean(PageModelParamService.class);
                PageTemplateInfoService pageTemplateInfoService = (PageTemplateInfoService)SpringContextUtils.getBean(PageTemplateInfoService.class);
                PageTemplateFileService pageTemplateFileService = (PageTemplateFileService)SpringContextUtils.getBean(PageTemplateFileService.class);
                PageModelFieldService pageModelFieldService = (PageModelFieldService)SpringContextUtils.getBean(PageModelFieldService.class);
                String gitLocalPath = SdEnvUtil.TEMPLATE_PATH;
                PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
                PaasAppsParam gen_path = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "gen_path");
                String genTargetPath = "page";
                if (gen_path != null) {
                    genTargetPath = gen_path.getParamValue();
                }
                String appTemplatePath = SdEnvUtil.getTemplatePath(this.appInfo, this.getSdTemplate());
                String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
                String targetPath = SdEnvUtil.PROJECT_PATH + appCode + File.separator + genTargetPath + File.separator;
                PageModelInfoDTO modelParam = new PageModelInfoDTO();
                modelParam.setPageModelCatalog(PageTemplateType.Page.getCode());
                modelParam.setAppId(this.appInfo.getAppId());
                modelParam.setPageModelId(this.pageModelId);
                List modelList = pageModelInfoService.queryList((Object)modelParam);
                PageModelPackageDTO packageParam = new PageModelPackageDTO();
                packageParam.setAppId(this.appInfo.getAppId());
                packageParam.setSize(Integer.valueOf(1000));
                List packageList = pageModelPackageService.queryList((Object)packageParam);
                Map<String, String> modelPathMap = this.createPackageMap(packageList);
                ArrayList<Map<String, String>> routes = new ArrayList<Map<String, String>>();
                if (!CollectionUtils.isNotEmpty((Collection)modelList)) break block44;
                for (PageModelInfoDTO modelInfoDTO : modelList) {
                    PageModelInfoDTO modelInfo = modelInfoDTO;
                    IFadpaasPageRender render = FadpaasPageRenderFactory.get(modelInfo.getPageModelType());
                    if (render != null) {
                        render.render(modelInfo, appTemplatePath, targetPath, modelPathMap, routes);
                    } else {
                        PageModelParamDTO param = new PageModelParamDTO();
                        param.setPageModelId(modelInfo.getPageModelId());
                        param.setQueryRef("query");
                        List paramList = pageModelParamService.queryList((Object)param);
                        if (StringUtils.isBlank((CharSequence)modelInfo.getPageTemplateId())) {
                            this.logger.error(String.format("\u9875\u9762\u6a21\u677f\u672a\u914d\u7f6e\u6a21\u677f %s", modelInfo.getPageModelCode()));
                            continue;
                        }
                        PageTemplateInfoDTO templateParam = new PageTemplateInfoDTO();
                        templateParam.setAppTemplateId(modelInfo.getPageTemplateId());
                        PageTemplateInfoDTO template = (PageTemplateInfoDTO)pageTemplateInfoService.queryByPk((Object)templateParam);
                        PageTemplateFileDTO fileParam = new PageTemplateFileDTO();
                        fileParam.setPageTemplateId(template.getPageTemplateId());
                        fileParam.setSize(Integer.valueOf(1000));
                        List fileList = pageTemplateFileService.queryList((Object)fileParam);
                        String localAppTemplatePath = appTemplatePath + File.separator + template.getPageTemplateCode();
                        if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                            for (PageTemplateFileDTO file : fileList) {
                                String templateName = file.getFileName() + ".vm";
                                String tempPath = localAppTemplatePath + File.separator + templateName;
                                File tempFile = new File(tempPath);
                                if (!tempFile.exists()) continue;
                                try {
                                    String oriFileName;
                                    String packagePath = modelPathMap.get(modelInfo.getPackageId());
                                    if (StringUtils.isBlank((CharSequence)packagePath)) {
                                        packagePath = "";
                                    }
                                    String basePath = this.getBasePath(packagePath);
                                    Map<String, Object> root = this.prepareParam(modelInfo, paramList, appTemplatePath, basePath);
                                    ArrayList dataCodes = new ArrayList();
                                    paramList.forEach(pageModelParamVO -> {
                                        List fields = pageModelParamVO.getFields();
                                        if (CollectionUtils.isNotEmpty((Collection)fields)) {
                                            fields.forEach(f -> {
                                                if (StringUtils.isNotEmpty((CharSequence)f.getFieldOption()) && !dataCodes.contains(f)) {
                                                    dataCodes.add(f.getFieldOption());
                                                }
                                            });
                                        }
                                    });
                                    String dataCodeJoin = String.join((CharSequence)",", dataCodes);
                                    root.put("BASE_PATH", basePath);
                                    root.put("pageModelInfo", modelInfo);
                                    root.put("dataCodeJoin", dataCodeJoin);
                                    root.put("localAppTemplatePath", localAppTemplatePath);
                                    String html = FreemarkerUtil.produceStringByTemplate((String)localAppTemplatePath, (String)templateName, root);
                                    File targetDir = new File(targetPath + File.separator + packagePath);
                                    if (!targetDir.exists()) {
                                        targetDir.mkdirs();
                                    }
                                    if (!StringUtils.endsWith((CharSequence)(oriFileName = modelInfo.getPageModelCode()), (CharSequence)".html")) {
                                        oriFileName = oriFileName + ".html";
                                    }
                                    File targetFile = new File(targetDir, oriFileName);
                                    try (FileOutputStream output = new FileOutputStream(targetFile);){
                                        IOUtils.write((String)html, (OutputStream)output, (String)"utf-8");
                                    }
                                    boolean jsFlag = this.renderOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".js", localAppTemplatePath, root, targetPath, packagePath, targetDir);
                                    boolean cssFlag = this.renderOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".ccs", localAppTemplatePath, root, targetPath, packagePath, targetDir);
                                    Map<String, String> route = this.createRoute(packagePath, targetFile);
                                    route.put("jsFlag", String.valueOf(jsFlag));
                                    route.put("cssFlag", String.valueOf(cssFlag));
                                    route.put("cnname", modelInfo.getPageModelName());
                                    routes.add(route);
                                }
                                catch (Exception e) {
                                    this.logger.error("\u83b7\u53d6\u9875\u9762\u6a21\u578b\u9884\u89c8html\u5931\u8d25 " + file.getFileId(), e);
                                }
                            }
                        }
                    }
                    PageModelLogDTO genLog = new PageModelLogDTO();
                    genLog.setLogId(UUIDUtil.getUUID());
                    BeanUtility.beanCopy((Object)modelInfo, (Object)genLog);
                    if (StringUtils.isBlank((CharSequence)genLog.getSubsId())) {
                        genLog.setSubsId(this.batchInst.getSubsId());
                    }
                    genLog.setCreateUser(userId);
                    genLog.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                    genLog.setGenState("S");
                    pageModelLogService.insert((Object)genLog);
                }
                if (!CollectionUtils.isNotEmpty(routes) || !(routeTemplateFile = new File(appTemplatePath + File.separator + "views-routes.js.vm")).exists()) break block44;
                HashMap<String, ArrayList<Map<String, String>>> root = new HashMap<String, ArrayList<Map<String, String>>>();
                root.put("routes", routes);
                String localAppTemplatePath = appTemplatePath;
                String routesJs = FreemarkerUtil.produceStringByTemplate((String)localAppTemplatePath, (String)routeTemplateFile.getName(), root);
                PaasAppsParam routePath = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "route_path");
                String routeTargetPath = "router";
                if (routePath != null) {
                    routeTargetPath = routePath.getParamValue();
                }
                File targetFile = new File(new File(targetPath).getParent() + File.separator + routeTargetPath + File.separator + "views-routes.js");
                try (FileOutputStream output = new FileOutputStream(targetFile);){
                    IOUtils.write((String)routesJs, (OutputStream)output, (String)"utf-8");
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
                result = false;
            }
            finally {
                if (conn != null) {
                    this.closePluginConnection(conn);
                }
            }
        }
        return result;
    }
}

