/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeClassContext;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeContext;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDeclareVar;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDependency;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeImport;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeMethod;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.gencode.CodeGenerateConstant;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.ArchType;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.MapBeanUtil;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class TdpFacadePlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private BatInstBatch batchInst;
    private Map<String, Object> extParam;
    private String loginUserId = "";
    private String srvModelId = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        this.loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        this.srvModelId = MapUtils.getString(this.extParam, (Object)"srvModelId");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u751f\u6210facade\u5b50\u5de5\u7a0b\u4ee3\u7801");
        boolean result = true;
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            SSubsInfo sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
            this.generateIsrvAppService(conn);
            this.generateOsrvAppService(conn);
            ArchType archTypeEnum = ArchType.get((String)this.appInfo.getArchType());
            if (StringUtils.isNotBlank((CharSequence)archTypeEnum.getXmlPrefix())) {
                this.generateSofaXML(conn);
            }
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            ArrayList paramsList = new ArrayList();
            List<PaasAppsInfo> referenceApps = paasAppsInfoDao.queryReferenceApp(this.appInfo.getAppId());
            if (CollectionUtils.isNotEmpty(referenceApps)) {
                List<String> compTypes = Arrays.asList(AppType.A10.getCode(), AppType.A10.getCode());
                for (PaasAppsInfo paas : referenceApps) {
                    if (compTypes.contains(paas.getAppType())) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    if (paas.getAppMavenPom() != null) {
                        map.put("code", paas.getAppMavenPom());
                    } else {
                        map.put("code", "");
                    }
                    paramsList.add(map);
                }
            }
            List<OsrvArrangeDependency> dependencies = this.querySubsSDKDependencies(sSubsInfo, conn);
            CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
            TmProjectInfoBo pomTp = new TmProjectInfoBo();
            pomTp.setProjectId(this.appInfo.getAppCode());
            pomTp.setProjectCode(this.appInfo.getAppCode());
            pomTp.setProjectName(this.appInfo.getAppName());
            pomBo.setTmProjectInfo(pomTp);
            pomBo.getMapData().put("appCodes", paramsList);
            pomBo.getMapData().put("sdkList", dependencies);
            this.wrapAppsParam(this.appInfo.getAppId(), pomBo, conn);
            String package_prefix = this.getPackagePrefix(pomBo);
            this.produceCodeFile("facade-pom.xml", "", "facade-", "facade", "", this.appInfo, pomBo);
        }
        catch (SQLException e) {
            this.logger.error(" \u6267\u884c sql \u5f02\u5e38 " + e.getMessage(), e);
            result = false;
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210 facade \u5b50\u5de5\u7a0b\u4ee3\u7801\u9519\u8bef", e);
            result = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return result;
    }

    private void generateSofaXML(Connection conn) throws Exception {
        CodeTemplateDataBo bo = new CodeTemplateDataBo();
        String author = this.appInfo.getCreateUser();
        TmProjectInfoBo tpib = new TmProjectInfoBo();
        tpib.setProjectId(this.appInfo.getAppCode());
        tpib.setProjectCode(this.appInfo.getAppCode());
        tpib.setProjectName(this.appInfo.getAppName());
        bo.setTmProjectInfo(tpib);
        bo.getEnvBo().setAuthor(this.loginUserId);
        bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
        bo.getEnvBo().setDesc("");
        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
        SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
        List<ModelTableInfo> tableList = modelTableInfoDao.queryModelTableInfoList(this.appInfo.getAppId());
        ArrayList<String> tableCodeList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(tableList)) {
            for (ModelTableInfo table : tableList) {
                int serNum;
                if (table.getObjectType().intValue() == Integer.valueOf(ObjectType.Inout.getCode()).intValue() || (serNum = srvModelInfoDao.countByTableModelId(this.appInfo.getAppId(), table.getObjectId())) == 0 && table.getObjectType().intValue() == Integer.valueOf(ObjectType.Data.getCode()).intValue()) continue;
                String serviceClassName = TmModelUtil.tableCodeToClassName((String)table.getObjectCode());
                serviceClassName = StringUtils.uncapitalize((String)serviceClassName);
                tableCodeList.add(serviceClassName);
            }
        }
        SrvModelInfo modelParam = new SrvModelInfo();
        modelParam.setAppId(this.appInfo.getAppId());
        List<SrvModelInfo> modelList = srvModelInfoDao.querySrvModelInfoList(modelParam, Arrays.asList(SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
        if (CollectionUtils.isNotEmpty(modelList)) {
            for (SrvModelInfo model : modelList) {
                String tableClassName = TmModelUtil.modelCodeToClassName((String)model.getSrvModelCode());
                tableClassName = StringUtils.uncapitalize((String)tableClassName);
                tableCodeList.add(tableClassName);
            }
        }
        bo.getMapData().put("MethodDealList", tableCodeList);
        bo.getMapData().put("tableModelCode", this.appInfo.getAppCode());
        this.wrapAppsParam(this.appInfo.getAppId(), bo, conn);
        String package_prefix = this.getPackagePrefix(bo);
        ArchType archTypeEnum = ArchType.get((String)this.appInfo.getArchType());
        String xmlPrefix = archTypeEnum != null ? archTypeEnum.getXmlPrefix() : ArchType.Sofa.getXmlPrefix();
        this.produceCodeFile(xmlPrefix + "-consumer-XXX.xml", this.appInfo.getAppCode(), CodeGenerateConstant.TABLE_VAR_NOSPLIT, "facade", "src/main/resources/" + xmlPrefix + "/", this.appInfo, bo);
    }

    private void generateIsrvAppService(Connection conn) throws Exception, SQLException {
        String subsCode = this.appInfo.getAppCode();
        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
        SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
        List<ModelTableInfo> tableList = modelTableInfoDao.queryModelTableInfoList(this.appInfo.getAppId());
        ArrayList ctdbList = new ArrayList(tableList.size());
        ModelTableInfo userTokenInfo = modelTableInfoDao.queryCommonTableModelInfo(this.appInfo.getAppId(), "UserTokenInfo");
        ModelTableInfo isrvRspInfo = modelTableInfoDao.queryCommonTableModelInfo(this.appInfo.getAppId(), "IsrvRspInfo");
        ModelTableInfo pageInfo = modelTableInfoDao.queryCommonTableModelInfo(this.appInfo.getAppId(), "PageInfo");
        TmProjectInfoBo tpib = new TmProjectInfoBo();
        tpib.setProjectId(this.appInfo.getAppCode());
        tpib.setProjectCode(this.appInfo.getAppCode());
        tpib.setProjectName(this.appInfo.getAppName());
        ArrayList inoutParamList = new ArrayList(tableList.size());
        if (CollectionUtils.isNotEmpty(tableList)) {
            String package_prefix;
            ArrayList<CodeTemplateDataBo> codeBoList = new ArrayList<CodeTemplateDataBo>(tableList.size());
            ArrayList<CodeTemplateDataBo> ctdbDtoList = new ArrayList<CodeTemplateDataBo>(tableList.size());
            SrvModelInfo modelParam = new SrvModelInfo();
            modelParam.setAppId(this.appInfo.getAppId());
            modelParam.setSrvModelCatalog(SrvModelCatalogEnum.SrvServer.getCode());
            for (ModelTableInfo table : tableList) {
                ObjectType objectTypeEnum = ObjectType.getType((String)String.valueOf(table.getObjectType()));
                if (objectTypeEnum == ObjectType.Inout || objectTypeEnum == ObjectType.Common || objectTypeEnum == ObjectType.Data || objectTypeEnum == ObjectType.FreeStyleData) continue;
                modelParam.setTableModelId(table.getObjectId());
                List<SrvModelInfo> modelList = srvModelInfoDao.querySrvModelInfoList(modelParam);
                String inputDOName = TmModelUtil.modelCodeToClassName((String)table.getObjectCode()) + "Input";
                ModelTableInfo inputDO = modelTableInfoDao.queryInoutTableModelInfo(this.appInfo.getAppId(), inputDOName);
                if (inputDO == null) continue;
                String tableClassName = TmModelUtil.modelCodeToClassName((String)table.getObjectCode());
                String tableModelCode = table.getObjectCode();
                HashMap<String, OsrvArrangeImport> importMap = new HashMap<String, OsrvArrangeImport>();
                HashMap<String, OsrvArrangeDeclareVar> propMap = new HashMap<String, OsrvArrangeDeclareVar>();
                OsrvArrangeDeclareVar inputDTOProp = new OsrvArrangeDeclareVar();
                String inputDO_className = this.wrapperTableToClassName(inputDO.getObjectCode(), inputDO.getObjectType().toString(), inputDO.getObjectId());
                inputDTOProp.setVarClassName(inputDO_className);
                inputDTOProp.setVarName(StringUtils.uncapitalize((String)inputDO_className));
                inputDTOProp.setListFlag(YesOrNO.NO.getCode());
                inputDTOProp.setComment(String.format("%s %s\u53ca\u6269\u5c55\u53c2\u6570\u5bf9\u8c61", IOType.Input.getName(), inputDO.getObjectName()));
                propMap.put(inputDTOProp.getVarName(), inputDTOProp);
                OsrvArrangeImport inputDTOProp_import = new OsrvArrangeImport();
                inputDTOProp_import.setClassName(inputDO_className);
                inputDTOProp_import.setProjectCode(tpib.getProjectCode());
                inputDTOProp_import.setImportType(this.judgeTableToClassName(inputDO.getObjectCode(), inputDO.getObjectType().toString(), inputDO.getObjectId()));
                importMap.put(inputDTOProp_import.getClassName(), inputDTOProp_import);
                OsrvArrangeImport isrvRspInfo_import = new OsrvArrangeImport();
                String isrvRspInfo_class = this.wrapperTableToClassName(isrvRspInfo.getObjectCode(), isrvRspInfo.getObjectType().toString(), isrvRspInfo.getObjectId());
                isrvRspInfo_import.setClassName(isrvRspInfo_class);
                isrvRspInfo_import.setProjectCode(tpib.getProjectCode());
                isrvRspInfo_import.setImportType(this.judgeTableToClassName(isrvRspInfo.getObjectCode(), isrvRspInfo.getObjectType().toString(), isrvRspInfo.getObjectId()));
                importMap.put(isrvRspInfo_import.getClassName(), isrvRspInfo_import);
                OsrvArrangeDeclareVar tableDO = new OsrvArrangeDeclareVar();
                String tableDO_className = this.wrapperTableToClassName(table.getObjectCode(), table.getObjectType().toString(), table.getObjectId());
                tableDO.setVarClassName(tableDO_className);
                tableDO.setVarName(StringUtils.uncapitalize((String)tableDO_className));
                tableDO.setListFlag(YesOrNO.NO.getCode());
                tableDO.setComment(String.format("%s %s", IOType.Input.getName(), table.getObjectName()));
                propMap.put(tableDO.getVarName(), tableDO);
                OsrvArrangeImport tableDO_import = new OsrvArrangeImport();
                tableDO_import.setClassName(tableDO_className);
                tableDO_import.setProjectCode(tpib.getProjectCode());
                tableDO_import.setImportType(this.judgeTableToClassName(table.getObjectCode(), table.getObjectType().toString(), table.getObjectId()));
                importMap.put(tableDO_import.getClassName(), tableDO_import);
                OsrvArrangeImport serviceInput_import = new OsrvArrangeImport();
                serviceInput_import.setClassName("ServiceInput");
                serviceInput_import.setProjectCode(tpib.getProjectCode());
                serviceInput_import.setImportType(this.judgeTableToClassName("ServiceInput", ObjectType.Common.getCode(), null));
                importMap.put(serviceInput_import.getClassName(), serviceInput_import);
                OsrvArrangeImport serviceOutput_import = new OsrvArrangeImport();
                serviceOutput_import.setClassName("ServiceOutput");
                serviceOutput_import.setProjectCode(tpib.getProjectCode());
                serviceOutput_import.setImportType(this.judgeTableToClassName("ServiceOutput", ObjectType.Common.getCode(), null));
                importMap.put(serviceOutput_import.getClassName(), serviceOutput_import);
                if (CollectionUtils.isNotEmpty(modelList)) {
                    CodeTemplateDataBo bo = new CodeTemplateDataBo();
                    String author = table.getCreateUser();
                    String TablebjectType2 = String.valueOf(table.getObjectType());
                    bo.setTmProjectInfo(tpib);
                    bo.getEnvBo().setAuthor(this.loginUserId);
                    bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                    bo.getEnvBo().setDesc(String.format("%s Facade %s", this.appInfo.getAppName(), table.getObjectName()));
                    Map dataMap = bo.getMapData();
                    ArrayList methods = new ArrayList(modelList.size());
                    dataMap.put("methods", methods);
                    for (SrvModelInfo modelInfo : modelList) {
                        HashMap<String, Object> method = new HashMap<String, Object>();
                        method.put("modelInfo", (Object)modelInfo);
                        SrvModelTypeEnum srvModelTypeEnum = SrvModelTypeEnum.getModelByType((String)modelInfo.getSrvModelType());
                        method.put("methodName", modelInfo.getSrvModelCode());
                        String inputGenClass = inputDO_className;
                        SrvModelInout serviceInputInout = new SrvModelInout();
                        serviceInputInout.setSrvModelId(modelInfo.getSrvModelId());
                        serviceInputInout.setListFlag(YesOrNO.NO.getCode());
                        serviceInputInout.setTableModelCode(String.format("%s<%s>", "ServiceInput", inputGenClass));
                        SrvModelInout inoutParam = new SrvModelInout();
                        inoutParam.setSrvModelId(modelInfo.getSrvModelId());
                        inoutParam.setIoType(IOType.Output.getCode());
                        List<SrvModelInout> outputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                        String outputGenericsClass = tableDO_className;
                        if (CollectionUtils.isNotEmpty(outputParams)) {
                            SrvModelInout outputInout = outputParams.get(0);
                            outputGenericsClass = this.wrapperTableToClassName(outputInout.getTableModelCode(), outputInout.getObjectType().toString(), outputInout.getTableModelId());
                        }
                        SrvModelInout serviceOutputInout = new SrvModelInout();
                        serviceOutputInout.setSrvModelId(modelInfo.getSrvModelId());
                        serviceOutputInout.setListFlag(YesOrNO.NO.getCode());
                        serviceOutputInout.setTableModelCode(String.format("%s<%s>", "ServiceOutput", outputGenericsClass));
                        method.put("input", (Object)serviceInputInout);
                        method.put("output", (Object)serviceOutputInout);
                        methods.add(method);
                    }
                    dataMap.put("importList", importMap.values());
                    bo.getMapData().put("tableModelCode", table.getObjectCode() + "_ds");
                    bo.getMapData().put("tableClassName", TmModelUtil.tableCodeToClassName((String)table.getObjectCode()));
                    codeBoList.add(bo);
                }
                CodeTemplateDataBo dtoBO = new CodeTemplateDataBo();
                dtoBO.setTmProjectInfo(tpib);
                ModelTableInfoBo inputDOBO = this.generateTableBO(inputDO, conn);
                inputDOBO.setModelClassName(inputDO_className);
                dtoBO.setMainTableModel(inputDOBO);
                dtoBO.getMapData().put("tableModelCode", TmModelUtil.propertyToField((String)StringUtils.uncapitalize((String)inputDO_className)));
                dtoBO.getEnvBo().setDesc(String.format("%s Facade DTO %s", this.appInfo.getAppName(), inputDO.getObjectName()));
                dtoBO.getEnvBo().setAuthor(this.loginUserId);
                dtoBO.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                ctdbDtoList.add(dtoBO);
            }
            Map<String, Object> appsParam = this.wrapAppsParam(this.appInfo.getAppId(), null, conn);
            for (CodeTemplateDataBo ctdb : codeBoList) {
                ctdb.getMapData().put("appsParam", appsParam);
                package_prefix = this.getPackagePrefix(ctdb);
                Map mapData = ctdb.getMapData();
                this.produceCodeFile("XXXService.java", "XXXService", "facade", "src/main/java/" + package_prefix + "/" + TdpFacadePlugin.formatClassPath(subsCode) + "/facade/", this.appInfo, ctdb);
            }
            for (CodeTemplateDataBo ctdb : ctdbDtoList) {
                ctdb.getMapData().put("appsParam", appsParam);
                package_prefix = this.getPackagePrefix(ctdb);
                this.produceCodeFile("XXXDTO.java", "XXXDTO", "facade", "src/main/java/" + package_prefix + "/" + TdpFacadePlugin.formatClassPath(subsCode) + "/facade/dto/", this.appInfo, ctdb);
            }
        }
    }

    private void generateOsrvAppService(Connection conn) throws Exception, SQLException {
        String subsCode = this.appInfo.getAppCode();
        SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
        SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>();
        ArrayList<CodeTemplateDataBo> ctdbDtoList = new ArrayList<CodeTemplateDataBo>();
        ArrayList<CodeTemplateDataBo> ctdbInputList = new ArrayList<CodeTemplateDataBo>();
        ArrayList<CodeTemplateDataBo> ctdbOutputList = new ArrayList<CodeTemplateDataBo>();
        SrvModelInfo modelParam = new SrvModelInfo();
        modelParam.setAppId(this.appInfo.getAppId());
        modelParam.setSrvModelId(this.srvModelId);
        List<SrvModelInfo> modelList = srvModelInfoDao.querySrvModelInfoList(modelParam, Arrays.asList(SrvModelCatalogEnum.ComponentServer.getCode(), SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
        TmProjectInfoBo tpib = new TmProjectInfoBo();
        tpib.setProjectId(this.appInfo.getAppCode());
        tpib.setProjectCode(this.appInfo.getAppCode());
        tpib.setProjectName(this.appInfo.getAppName());
        HashMap<String, OsrvArrangeClassContext> clsCtxMap = new HashMap<String, OsrvArrangeClassContext>();
        HashMap<String, SrvModelInout> serverInoutMap = new HashMap<String, SrvModelInout>();
        if (CollectionUtils.isNotEmpty(modelList)) {
            String package_prefix;
            OsrvArrangeClassContext clsCtx;
            for (Object model : modelList) {
                String string = TmModelUtil.modelCodeToClassName((String)model.getSrvModelCode());
                clsCtx = (OsrvArrangeClassContext)clsCtxMap.get(string + model.getSrvModelCatalog());
                if (clsCtx == null) {
                    clsCtx = new OsrvArrangeClassContext(this.appInfo, model.getSrvModelCatalog(), conn);
                    clsCtx.setClassName(string);
                    clsCtxMap.put(string + model.getSrvModelCatalog(), clsCtx);
                }
                OsrvArrangeContext osrvCtx = new OsrvArrangeContext(this.appInfo, (SrvModelInfo)((Object)model), conn);
                osrvCtx.setTableClassName(string);
                SrvModelInout inoutParam = new SrvModelInout();
                inoutParam.setSrvModelId(model.getSrvModelId());
                inoutParam.setIoType(IOType.Input.getCode());
                List<SrvModelInout> inputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                inoutParam.setIoType(IOType.Output.getCode());
                List<SrvModelInout> outputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                inoutParam.setIoType(IOType.Middle.getCode());
                List<SrvModelInout> middleParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                this.initOsrvCtx(osrvCtx, inputParams, outputParams);
                clsCtx.getMethodCtxList().add(osrvCtx);
                CodeTemplateDataBo inputBo = this.createBigDTO(osrvCtx, inputParams, IOType.Input, serverInoutMap);
                CodeTemplateDataBo outputBo = this.createBigDTO(osrvCtx, outputParams, IOType.Output, serverInoutMap);
                if (!StringUtils.equals((CharSequence)model.getSrvModelCatalog(), (CharSequence)SrvModelCatalogEnum.BackServer.getCode()) || StringUtils.equals((CharSequence)model.getSrvModelType(), (CharSequence)SrvModelTypeEnum.CUSTOM_BACK_SERVICE.getType())) {
                    inputBo.setTmProjectInfo(tpib);
                    ctdbInputList.add(inputBo);
                    outputBo.setTmProjectInfo(tpib);
                    ctdbOutputList.add(outputBo);
                }
                for (SrvModelInout inout : middleParams) {
                    serverInoutMap.put(inout.getTableModelCode(), inout);
                }
            }
            Collection serverInouts = serverInoutMap.values();
            for (SrvModelInout srvModelInout : serverInouts) {
                CodeTemplateDataBo dtoBO = new CodeTemplateDataBo();
                dtoBO.setTmProjectInfo(tpib);
                dtoBO.getEnvBo().setAuthor(this.loginUserId);
                dtoBO.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                dtoBO.getEnvBo().setDesc(String.format("%s Facade DTO %s-%s", this.appInfo.getAppName(), srvModelInout.getTableModelName(), srvModelInout.getTableModelCode()));
                ModelTableInfo table = modelTableInfoDao.queryModelTableInfo(srvModelInout.getTableModelId());
                if (table.getObjectType().equals(ObjectType.Table.getIntCode()) || table.getObjectType().equals(ObjectType.Common.getIntCode())) continue;
                ModelTableInfoBo tableBo = this.generateTableBO(table, conn);
                tableBo.setModelClassName(this.wrapperTableToClassName(table.getObjectCode(), table.getObjectType().toString(), table.getObjectId()));
                dtoBO.setMainTableModel(tableBo);
                dtoBO.getMapData().put("tableModelCode", TmModelUtil.propertyToField((String)StringUtils.uncapitalize((String)tableBo.getModelClassName())));
                dtoBO.getMapData().put("objectType", String.valueOf(table.getObjectType()));
                ctdbDtoList.add(dtoBO);
            }
            for (Map.Entry entry : clsCtxMap.entrySet()) {
                clsCtx = (OsrvArrangeClassContext)entry.getValue();
                OsrvArrangeImport serviceInput_import = new OsrvArrangeImport();
                serviceInput_import.setClassName("ServiceInput");
                serviceInput_import.setProjectCode(tpib.getProjectCode());
                serviceInput_import.setImportType(this.judgeTableToClassName("ServiceInput", ObjectType.Common.getCode(), null));
                clsCtx.addImport(serviceInput_import);
                OsrvArrangeImport serviceOutput_import = new OsrvArrangeImport();
                serviceOutput_import.setClassName("ServiceOutput");
                serviceOutput_import.setProjectCode(tpib.getProjectCode());
                serviceOutput_import.setImportType(this.judgeTableToClassName("ServiceOutput", ObjectType.Common.getCode(), null));
                clsCtx.addImport(serviceOutput_import);
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(this.loginUserId);
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s Facade %s", this.appInfo.getAppName(), clsCtx.getClassName()));
                bo.getMapData().put("clsCtx", clsCtx);
                for (OsrvArrangeContext osrvCtx : clsCtx.getMethodCtxList()) {
                    clsCtx.addImport(osrvCtx.getImportList());
                }
                ctdbList.add(bo);
            }
            Map<String, Object> appsParam = this.wrapAppsParam(this.appInfo.getAppId(), null, conn);
            for (CodeTemplateDataBo ctdb : ctdbList) {
                OsrvArrangeClassContext clsCtx2 = (OsrvArrangeClassContext)ctdb.getMapData().get("clsCtx");
                ctdb.getMapData().put("appsParam", appsParam);
                String package_prefix2 = this.getPackagePrefix(ctdb);
                this.produceCodeFile("XXXOsrvAppService.java", clsCtx2.getClassName() + clsCtx2.getServiceSuffix(), "XXXOsrvAppService", "facade", "src/main/java/" + package_prefix2 + "/" + TdpFacadePlugin.formatClassPath(subsCode).replaceAll("_|-", ".") + "/facade/", this.appInfo, ctdb);
            }
            for (CodeTemplateDataBo ctdb : ctdbDtoList) {
                ctdb.getMapData().put("appsParam", appsParam);
                package_prefix = this.getPackagePrefix(ctdb);
                this.produceCodeFile("XXXDTO.java", "XXXDTO", "facade", "src/main/java/" + package_prefix + "/" + TdpFacadePlugin.formatClassPath(subsCode) + "/facade/dto/", this.appInfo, ctdb);
            }
            for (CodeTemplateDataBo ctdb : ctdbInputList) {
                ctdb.getMapData().put("appsParam", appsParam);
                package_prefix = this.getPackagePrefix(ctdb);
                this.produceCodeFile("XXXOsrvAppServiceInput.java", "XXXOsrvAppServiceInput", "facade", "src/main/java/" + package_prefix + "/" + TdpFacadePlugin.formatClassPath(subsCode).replaceAll("_|-", ".") + "/facade/dto/", this.appInfo, ctdb);
            }
            for (CodeTemplateDataBo ctdb : ctdbOutputList) {
                ctdb.getMapData().put("appsParam", appsParam);
                package_prefix = this.getPackagePrefix(ctdb);
                this.produceCodeFile("XXXOsrvAppServiceInput.java", "XXXOsrvAppServiceInput", "facade", "src/main/java/" + package_prefix + "/" + TdpFacadePlugin.formatClassPath(subsCode).replaceAll("_|-", ".") + "/facade/dto/", this.appInfo, ctdb);
            }
        }
    }

    private void initOsrvCtx(OsrvArrangeContext osrvCtx, List<SrvModelInout> inputParams, List<SrvModelInout> outputParams) throws Exception {
        OsrvArrangeMethod method = new OsrvArrangeMethod();
        osrvCtx.setMethod(method);
        if (StringUtils.isNotBlank((CharSequence)osrvCtx.getSrvModelInfo().getSrvModelMethod())) {
            method.setMethodName(osrvCtx.getSrvModelInfo().getSrvModelMethod());
        } else {
            method.setMethodName("handle");
        }
        this.getOsrvMethod(osrvCtx, inputParams, outputParams);
    }

    private void getOsrvMethod(OsrvArrangeContext osrvCtx, List<SrvModelInout> inputParams, List<SrvModelInout> outputParams) throws SQLException, Exception {
        SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(osrvCtx.getConn());
        OsrvArrangeMethod method = osrvCtx.getMethod();
        SrvModelInout inoutParam = new SrvModelInout();
        inoutParam.setSrvModelId(osrvCtx.getSrvModelInfo().getSrvModelId());
        String input = this.getMethodParam(inputParams, osrvCtx, "Input");
        method.setInputListFlag(YesOrNO.NO.getCode());
        method.setInputBigFlag(YesOrNO.YES.getCode());
        String mainParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), method.getMethodName(), IOType.Input);
        SrvModelInout inputInout = null;
        for (SrvModelInout inout : inputParams) {
            if (!StringUtils.equals((CharSequence)inout.getTableModelCode(), (CharSequence)mainParam)) continue;
            inputInout = inout;
        }
        mainParam = inputInout != null ? this.wrapperTableToClassName(inputInout.getTableModelCode(), inputInout.getObjectType().toString(), inputInout.getTableModelId()) : this.wrapperTableToClassName(mainParam, ObjectType.Inout.getCode(), null);
        method.setMainInput("input.getInput()");
        method.setInput(input);
        String mainOutputParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), method.getMethodName(), IOType.Output);
        String output = this.getMethodParam(outputParams, osrvCtx, "Output");
        method.setOutputListFlag(YesOrNO.NO.getCode());
        method.setOutputBigFlag(YesOrNO.YES.getCode());
        SrvModelInout outputInout = null;
        for (SrvModelInout inout : outputParams) {
            if (!StringUtils.equals((CharSequence)inout.getTableModelCode(), (CharSequence)mainOutputParam)) continue;
            outputInout = inout;
        }
        mainOutputParam = outputInout != null ? this.wrapperTableToClassName(outputInout.getTableModelCode(), outputInout.getObjectType().toString(), outputInout.getTableModelId()) : this.wrapperTableToClassName(mainOutputParam, ObjectType.Inout.getCode(), null);
        method.setOutput(output);
    }

    private CodeTemplateDataBo createBigDTO(OsrvArrangeContext osrvCtx, List<SrvModelInout> inoutParams, IOType ioType, Map<String, SrvModelInout> serverInoutMap) throws Exception {
        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(osrvCtx.getConn());
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(osrvCtx.getConn());
        HashMap otherFacadeImport = new HashMap();
        CodeTemplateDataBo bigBo = new CodeTemplateDataBo();
        String mainParameter = this.getBigDTOClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), osrvCtx.getMethod().getMethodName(), ioType);
        bigBo.getEnvBo().setAuthor(this.loginUserId);
        bigBo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
        bigBo.getEnvBo().setDesc(String.format("%s Facade DTO %s", this.appInfo.getAppName(), osrvCtx.getSrvModelInfo().getSrvModelName()));
        bigBo.getMapData().put("tableModelCode", TmModelUtil.propertyToField((String)mainParameter));
        bigBo.getMapData().put("tableClassName", mainParameter);
        ArrayList<Map> properties = new ArrayList<Map>();
        bigBo.getMapData().put("properties", properties);
        for (SrvModelInout inout : inoutParams) {
            serverInoutMap.put(inout.getTableModelCode(), inout);
            Map prop = MapBeanUtil.beanToMap((Object)((Object)inout));
            String propClass = this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
            prop.put("comment", String.format("%s %s", IOType.getIOType((String)inout.getIoType()).getName(), inout.getTableModelName()));
            prop.put("className", propClass);
            prop.put("propName", StringUtils.uncapitalize((String)propClass));
            ModelTableInfo tableInfo = modelTableInfoDao.queryModelTableInfo(inout.getTableModelId());
            String importType = this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
            prop.put("importType", importType);
            if (!tableInfo.getAppId().equals(this.appInfo.getAppId())) {
                PaasAppsInfo otherAppParam = new PaasAppsInfo();
                otherAppParam.setSubsId(this.appInfo.getSubsId());
                otherAppParam.setAppId(tableInfo.getAppId());
                List<PaasAppsInfo> otherApps = paasAppsInfoDao.queryPaasAppsInfoList(otherAppParam);
                if (CollectionUtils.isNotEmpty(otherApps)) {
                    PaasAppsInfo otherApp = otherApps.get(0);
                    HashMap<String, String> importInfo = new HashMap<String, String>();
                    importInfo.put("projectCode", otherApp.getAppCode());
                    importInfo.put("className", propClass);
                    importInfo.put("propName", StringUtils.uncapitalize((String)propClass));
                    otherFacadeImport.put(propClass, importInfo);
                    prop.put("import", "N");
                    prop.put("projectCode", otherApp.getAppCode());
                }
            } else {
                prop.put("projectCode", this.appInfo.getAppCode());
                prop.put("import", "Y");
            }
            properties.add(prop);
        }
        bigBo.getMapData().put("otherFacadeImport", otherFacadeImport.values());
        return bigBo;
    }
}

