/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.fadpaas;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.fadpaas.IFadpaasPageRender;
import com.irdstudio.allinrdm.dev.console.facade.PageModelFieldService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelLogService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelPackageService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelParamService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateFileService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelPackageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelSubpageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateFileDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.ParamType;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFadpaasPageRender
implements IFadpaasPageRender {
    public static final Logger logger = LoggerFactory.getLogger(AbstractFadpaasPageRender.class);

    public String wrapperPath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public String replaceSuffix(String fileName) {
        if (fileName.lastIndexOf(".") >= 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public boolean renderOtherTemplate(String pageModelCode, String templateName, String suffix, String appTemplatePath, Map<String, Object> root, String targetPath, String packagePath, File targetDir) throws Exception {
        String templateFile = templateName + suffix + ".vm";
        String tempPath = appTemplatePath + File.separator + templateFile;
        File tempFile = new File(tempPath);
        boolean flag = false;
        if (tempFile.exists()) {
            String content = FreemarkerUtil.produceStringByTemplate((String)appTemplatePath, (String)templateFile, root);
            File contentTargetDir = new File(targetPath + File.separator + packagePath);
            if (!contentTargetDir.exists()) {
                contentTargetDir.mkdirs();
            }
            String fileName = this.replaceSuffix(pageModelCode) + suffix;
            File file = new File(targetDir, fileName);
            try (FileOutputStream output = new FileOutputStream(file);){
                IOUtils.write((String)content, (OutputStream)output, (String)"utf-8");
            }
            flag = true;
        }
        return flag;
    }

    public boolean checkOtherTemplate(String pageModelCode, String templateName, String suffix, String appTemplatePath) {
        String templateFile = templateName + suffix + ".vm";
        String tempPath = appTemplatePath + File.separator + templateFile;
        File tempFile = new File(tempPath);
        boolean flag = tempFile.exists();
        return flag;
    }

    public Map<String, Object> prepareParam(PageModelInfoDTO modelInfo, List<PageModelParamDTO> paramList, String appTemplatePath, String basePath) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("BASE_PATH", "../../../");
        Pattern listReg = Pattern.compile("(\\S+)\\[(\\d+)\\]");
        if (CollectionUtils.isNotEmpty(paramList)) {
            HashMap quickMap = new HashMap();
            for (PageModelParamDTO param : paramList) {
                String paramCode = param.getParamCode();
                if (!ParamType.kv.getCode().equals(param.getParamType())) {
                    if (CollectionUtils.isNotEmpty((Collection)param.getFields()) && (ParamType.fields.getCode().equals(param.getParamType()) || ParamType.formFields.getCode().equals(param.getParamType()))) {
                        root.put(paramCode, param.getFields());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getQueryFields()) && ParamType.conds.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getQueryFields());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getButtons()) && ParamType.buttons.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getButtons());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getLinkeds()) && ParamType.linkeds.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getLinkeds());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getSubspages()) && ParamType.subpages.getCode().equals(param.getParamType())) {
                        List subpages = param.getSubspages();
                        ArrayList<Map<String, Object>> subPageMapList = new ArrayList<Map<String, Object>>();
                        if (CollectionUtils.isNotEmpty((Collection)subpages)) {
                            for (PageModelSubpageDTO sub : subpages) {
                                Map<String, Object> subPageParam = this.fetchSubPageParam(modelInfo, sub, sub.getModelInfo(), appTemplatePath, basePath);
                                subPageMapList.add(subPageParam);
                            }
                        }
                        root.put(paramCode, subPageMapList);
                        continue;
                    }
                    try {
                        List list = JSON.parseArray((String)param.getParamValue(), Map.class);
                        root.put(paramCode, list);
                    }
                    catch (Exception e) {
                        logger.error("\u89e3\u6790\u53c2\u6570json\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                String[] paths = StringUtils.split((String)paramCode, (String)".");
                if (paths == null) {
                    root.put(paramCode, this.parseParamValue(param));
                    continue;
                }
                Map<String, Object> var = root;
                for (int i = 0; i < paths.length; ++i) {
                    String key;
                    String path = paths[i];
                    Matcher m = listReg.matcher(path);
                    boolean isList = m.matches();
                    if (isList) {
                        int k;
                        List<Object> list;
                        key = m.group(1);
                        int index = Integer.valueOf(m.group(2));
                        if (paths.length - 1 == i) {
                            list = (ArrayList<Object>)var.get(key);
                            if (list == null) {
                                list = new ArrayList<Object>(index);
                                var.put(key, list);
                            }
                            if (list.size() <= index) {
                                for (k = list.size(); k <= index; ++k) {
                                    list.add(null);
                                }
                            }
                            list.set(index, this.parseParamValue(param));
                            continue;
                        }
                        list = (List)var.get(key);
                        if (list == null) {
                            list = new ArrayList(index);
                            var.put(key, list);
                        }
                        if (list.size() <= index) {
                            for (k = list.size(); k <= index; ++k) {
                                list.add(new HashMap());
                            }
                        }
                        if ((var = (Map)list.get(index)) != null) continue;
                        var = new HashMap();
                        list.set(index, var);
                        continue;
                    }
                    key = path;
                    if (paths.length - 1 == i) {
                        var.put(key, this.parseParamValue(param));
                        continue;
                    }
                    HashMap temp = (HashMap)var.get(key);
                    if (temp == null) {
                        temp = new HashMap();
                        var.put(key, temp);
                    }
                    var = temp;
                }
            }
        }
        return root;
    }

    public String parseParamValue(PageModelParamDTO param) {
        if (param == null) {
            return "";
        }
        return param.getParamValue();
    }

    public Map<String, String> createPackageMap(List<PageModelPackageDTO> packageList) {
        HashMap<String, String> pathMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(packageList)) {
            HashMap<String, PageModelPackageDTO> map = new HashMap<String, PageModelPackageDTO>();
            for (PageModelPackageDTO p : packageList) {
                map.put(p.getPackageId(), p);
            }
            for (PageModelPackageDTO p : packageList) {
                ArrayList<String> paths = new ArrayList<String>();
                paths.add(p.getPackageCode());
                PageModelPackageDTO parent = (PageModelPackageDTO)map.get(p.getPackageAbvId());
                while (parent != null) {
                    paths.add(parent.getPackageCode());
                    parent = (PageModelPackageDTO)map.get(parent.getPackageAbvId());
                }
                Collections.reverse(paths);
                pathMap.put(p.getPackageId(), StringUtils.join(paths, (String)File.separator));
            }
        }
        return pathMap;
    }

    public String getBasePath(String packagePath) {
        String[] pathNum = StringUtils.split((String)packagePath, (String)File.separator);
        int deep = pathNum.length;
        ++deep;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= deep; ++i) {
            list.add("../");
        }
        return StringUtils.join(list, (String)"");
    }

    public Map<String, String> createRoute(String packagePath, File page) {
        Object[] paths = StringUtils.split((String)(packagePath + File.separator + this.replaceSuffix(page.getName())), (String)File.separator);
        String path = StringUtils.join((Object[])paths, (String)"/");
        HashMap<String, String> route = new HashMap<String, String>();
        route.put("path", path);
        route.put("name", StringUtils.join((Object[])paths, (String)"-"));
        route.put("pageName", page.getName());
        return route;
    }

    public Map<String, Object> fetchSubPageParam(PageModelInfoDTO rootModelInfo, PageModelSubpageDTO subPage, PageModelInfoDTO modelInfo, String appTemplatePath, String basePath) {
        if (modelInfo != null) {
            PageModelPackageService pageModelPackageService = (PageModelPackageService)SpringContextUtils.getBean(PageModelPackageService.class);
            PageModelInfoService pageModelInfoService = (PageModelInfoService)SpringContextUtils.getBean(PageModelInfoService.class);
            PageModelLogService pageModelLogService = (PageModelLogService)SpringContextUtils.getBean(PageModelLogService.class);
            PageModelParamService pageModelParamService = (PageModelParamService)SpringContextUtils.getBean(PageModelParamService.class);
            PageTemplateInfoService pageTemplateInfoService = (PageTemplateInfoService)SpringContextUtils.getBean(PageTemplateInfoService.class);
            PageTemplateFileService pageTemplateFileService = (PageTemplateFileService)SpringContextUtils.getBean(PageTemplateFileService.class);
            PageModelFieldService pageModelFieldService = (PageModelFieldService)SpringContextUtils.getBean(PageModelFieldService.class);
            PageModelParamDTO param = new PageModelParamDTO();
            param.setPageModelId(modelInfo.getPageModelId());
            param.setQueryRef("query");
            List paramList = pageModelParamService.queryList((Object)param);
            if (StringUtils.isBlank((CharSequence)modelInfo.getPageTemplateId())) {
                logger.error(String.format("\u9875\u9762\u6a21\u677f\u672a\u914d\u7f6e\u6a21\u677f %s", modelInfo.getPageModelCode()));
                return Collections.emptyMap();
            }
            PageTemplateInfoDTO templateParam = new PageTemplateInfoDTO();
            templateParam.setPageTemplateCode(modelInfo.getPageTemplateId());
            PageTemplateInfoDTO template = (PageTemplateInfoDTO)pageTemplateInfoService.queryByPk((Object)templateParam);
            PageTemplateFileDTO fileParam = new PageTemplateFileDTO();
            fileParam.setPageTemplateId(template.getPageTemplateId());
            List fileList = pageTemplateFileService.queryList((Object)fileParam);
            String localAppTemplatePath = appTemplatePath + File.separator + template.getPageTemplateId();
            if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                PageTemplateFileDTO file = (PageTemplateFileDTO)fileList.get(0);
                String templateName = file.getFileName() + ".vm";
                String tempPath = localAppTemplatePath + File.separator + templateName;
                File tempFile = new File(tempPath);
                if (tempFile.exists()) {
                    Map<String, Object> root = this.prepareParam(modelInfo, paramList, appTemplatePath, basePath);
                    ArrayList dataCodes = new ArrayList();
                    paramList.forEach(pageModelParamVO -> {
                        List fields = pageModelParamVO.getFields();
                        if (CollectionUtils.isNotEmpty((Collection)fields)) {
                            fields.forEach(f -> {
                                if (StringUtils.isNotEmpty((CharSequence)f.getFieldOption()) && !dataCodes.contains(f)) {
                                    dataCodes.add(f.getFieldOption());
                                }
                            });
                        }
                    });
                    String dataCodeJoin = String.join((CharSequence)",", dataCodes);
                    root.put("templateName", templateName);
                    root.put("templateFilePrefix", this.replaceSuffix(file.getFileName()));
                    root.put("rootModelInfo", rootModelInfo);
                    root.put("subPage", subPage);
                    root.put("BASE_PATH", basePath);
                    root.put("pageModelInfo", modelInfo);
                    root.put("dataCodeJoin", dataCodeJoin);
                    root.put("localAppTemplatePath", localAppTemplatePath);
                    ArrayList<String> jsList = new ArrayList<String>();
                    File localTemplateFile = new File(localAppTemplatePath);
                    if (localTemplateFile.exists()) {
                        File[] files;
                        for (File f : files = localTemplateFile.listFiles()) {
                            if (!StringUtils.endsWithAny((CharSequence)f.getName(), (CharSequence[])new CharSequence[]{".js.vm"})) continue;
                            jsList.add(f.getName());
                        }
                    }
                    root.put("jsList", jsList);
                    boolean jsFlag = this.checkOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".js", localAppTemplatePath);
                    boolean cssFlag = this.checkOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".ccs", localAppTemplatePath);
                    root.put("jsFlag", jsFlag);
                    root.put("cssFlag", cssFlag);
                    return root;
                }
            }
        }
        return Collections.emptyMap();
    }
}

