/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deliver;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatBatchInfoConfigDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatBatchInfoConfig;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDeployInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.sdk.beans.core.util.KeyUtil;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class MiddleAppInstallPlugin
extends AbstractPlugin {
    private BatInstBatch opsLog;
    private PaasAppsInfo appInfo = null;
    private Map<String, Object> extParam;
    private String actionId;
    private String actionShell;
    private String envId;
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (MiddleAppInstallPlugin.this.logger != null) {
                MiddleAppInstallPlugin.this.logger.info(line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (MiddleAppInstallPlugin.this.logger != null) {
                MiddleAppInstallPlugin.this.logger.error(line);
            } else {
                System.err.println(line);
            }
        }
    };

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        BatBatchInfoConfigDao batBatchInfoConfigDao = new BatBatchInfoConfigDao(conn);
        this.opsLog = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        BatBatchInfoConfig batchInfo = batBatchInfoConfigDao.queryWithKeys(this.opsLog.getBatchId());
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.opsLog.getAppId());
        this.extParam = batInstBatchDao.getExtParam(this.opsLog);
        this.actionId = MapUtils.getString(this.extParam, (Object)"actionId");
        this.actionShell = MapUtils.getString(this.extParam, (Object)"actionShell");
        this.envId = this.opsLog.getEnvId();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        try {
            File dir;
            conn = this.getPluginConnection();
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
            BatInstBatch batInstBatch = batInstBatchDao.queryByBatchSerialNo(this.context.getSzBatchSn());
            String currEnvId = batInstBatch.getEnvId();
            PaasEnvInfo envInfo = paasEnvInfoDao.queryByPk(currEnvId);
            PaasEnvParam deployRoot = paasEnvParamDao.queryByCode("deploy_root", currEnvId);
            String deployRootDir = this.getDeployRootDir(deployRoot.getParamValue());
            PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
            Map<String, Object> appsParam = paasAppsParamDao.queryAppParamMap(this.appInfo.getAppId(), this.envId);
            String configFileName = MapUtils.getString(appsParam, (Object)"config.file.name");
            String configFilePath = MapUtils.getString(appsParam, (Object)"config.file.path");
            String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
            PaasEcsInfo ecsInfo = this.getEcsInfo(paasEcsInfoDao);
            String opsPath = SdEnvUtil.getTemplateScriptPath(this.appInfo);
            if (StringUtils.isBlank((String)opsPath)) {
                this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
                throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
            }
            String installPath = opsPath + File.separator;
            if (!new File(installPath).exists()) {
                this.logger.error("\u4e2d\u95f4\u4ef6\u5e94\u7528\u5b89\u88c5\u5305\u4e0d\u5b58\u5728");
                throw new RuntimeException("\u4e2d\u95f4\u4ef6\u5e94\u7528\u5b89\u88c5\u5305\u4e0d\u5b58\u5728 " + installPath);
            }
            this.logger.info("\u767b\u9646\u670d\u52a1\u5668 " + ecsInfo.getEcsIp());
            RemoteSSHClient client = new RemoteSSHClient(ecsInfo.getEcsIp(), ecsInfo.getEcsLoginUser(), ecsInfo.getEcsLoginPwd());
            boolean loginFlag = client.connect();
            if (!loginFlag) {
                this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
                throw new RuntimeException("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            }
            if (!client.fileExists(deployRootDir + "/" + appCode)) {
                client.executeCommand("mkdir -p " + deployRootDir + "/" + appCode, this.sshPrinter);
            }
            if ((dir = new File(installPath)).exists()) {
                File[] files;
                for (File file : files = dir.listFiles()) {
                    if (!file.isFile()) continue;
                    client.upload(file.getAbsolutePath(), deployRootDir + "/" + appCode);
                }
                String localMediumPath = SdEnvUtil.TEMPLATE_PATH + File.separator + this.appInfo.getAppTemplateId() + "-medium";
                dir = new File(localMediumPath);
                for (File file : files = dir.listFiles()) {
                    if (!file.isFile()) continue;
                    client.upload(file.getAbsolutePath(), deployRootDir + "/" + appCode);
                }
                String filePath = SdEnvUtil.PROJECT_PATH + File.separator + this.appInfo.getAppCode() + File.separator + configFileName;
                File configFile = new File(filePath);
                if (configFile.exists()) {
                    client.upload(configFile.getAbsolutePath(), deployRootDir + "/" + appCode);
                }
                client.executeCommand(String.format("chmod 777 %s/%s/install.sh", deployRootDir, appCode), this.sshPrinter);
                this.logger.info(String.format("\u6267\u884c\u811a\u672c %s/%s/install.sh %s/%s", deployRootDir, appCode, deployRootDir, appCode));
                client.executeCommand(String.format("bash %s/%s/install.sh %s/%s", deployRootDir, appCode, deployRootDir, appCode), this.sshPrinter);
            } else {
                this.logger.error("\u4e2d\u95f4\u4ef6\u5e94\u7528\u5b89\u88c5\u5305\u4e0d\u5b58\u5728");
                flag = false;
            }
            if (conn.isClosed()) {
                this.closePluginConnection(conn);
                conn = this.getPluginConnection();
                paasDeployInfoDao = new PaasDeployInfoDao(conn);
            }
            this.updateDeployPath(currEnvId, this.appInfo, ecsInfo, "", deployRootDir + "/" + appCode, null, paasDeployInfoDao);
        }
        catch (Exception e) {
            this.logger.error("\u5b89\u88c5\u4e2d\u95f4\u4ef6\u5e94\u7528\u5b89\u88c5\u5305\u5230\u670d\u52a1\u5668\u5931\u8d25" + e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }

    private String getDeployRootDir(String deployRootDir) {
        if (deployRootDir == null) {
            deployRootDir = "/agent";
        }
        return deployRootDir;
    }

    private PaasEcsInfo getEcsInfo(PaasEcsInfoDao paasEcsInfoDao) throws Exception {
        if (this.appInfo != null) {
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            ecsParam.setSubsId(this.appInfo.getSubsId());
            ecsParam.setAppId(this.appInfo.getAppId());
            ecsParam.setEnvId(this.opsLog.getEnvId());
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfoWithAppDu(ecsParam);
            return CollectionUtils.isEmpty(ecsList) ? null : ecsList.get(0);
        }
        return paasEcsInfoDao.queryByPk(this.opsLog.getEcsId());
    }

    private void updateDeployPath(String envId, PaasAppsInfo appInfo, PaasEcsInfo ecs, String startModelName, String deployPath, PaasEnvParam loggingFile, PaasDeployInfoDao paasDeployInfoDao) throws Exception {
        boolean flag = true;
        PaasDeployInfo deployInfo = paasDeployInfoDao.queryByAppId(appInfo.getAppId(), envId);
        if (deployInfo == null) {
            deployInfo = new PaasDeployInfo();
            flag = false;
            deployInfo.setAppDeployId(KeyUtil.createUUIDKey());
        }
        deployInfo.setSubsId(appInfo.getSubsId());
        deployInfo.setAppId(appInfo.getAppId());
        deployInfo.setAppName(appInfo.getAppCode());
        deployInfo.setAppCnname(appInfo.getAppName());
        deployInfo.setAppVersion(appInfo.getAppVersion());
        deployInfo.setAppType(appInfo.getAppType());
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        deployInfo.setAppDeployPath(deployPath);
        deployInfo.setEnvId(envId);
        deployInfo.setAppOrder(0);
        deployInfo.setEcsId(ecs.getEcsId());
        deployInfo.setEcsIp(ecs.getEcsIp());
        deployInfo.setEcsName(ecs.getEcsName());
        deployInfo.setEcsRegion(ecs.getEcsRegionId());
        deployInfo.setAppPort(ecs.getEcsPort());
        deployInfo.setAppState("R");
        deployInfo.setOperUserid("admin");
        deployInfo.setOperTime(CurrentDateUtil.getTodayDateEx2());
        if (flag) {
            paasDeployInfoDao.updateByPk(deployInfo);
        } else {
            paasDeployInfoDao.insertPaasDeployInfo(deployInfo);
        }
        if (StringUtils.equals((String)appInfo.getLinkedSaas(), (String)YesOrNO.YES.getCode())) {
            // empty if block
        }
    }
}

