/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoPortalService;
import com.irdstudio.allinapaas.deliver.console.facade.PluginNginxConfService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginNginxConfDTO;
import com.irdstudio.allinapaas.deliver.console.types.NginxSrc;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TerminalExecUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class AllinPaasNginxSyncPlugin
extends AbstractPlugin {
    protected BatInstBatch batchInst = null;
    protected PaasAppsInfo appInfo = null;
    protected SSubsInfo sSubsInfo = null;
    protected PaasEnvInfo envInfo = null;
    protected Map<String, Object> extParam;
    protected String paasDuId = "D000001";
    protected String ecsId = "";
    private String nginxConfPath = "/usr/local/nginx/conf/apps/";
    private String nginxCommand = "/usr/local/nginx/sbin/nginx";

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        PluginNginxConfService service = (PluginNginxConfService)SpringContextUtils.getBean(PluginNginxConfService.class);
        PluginNginxConfDTO param = new PluginNginxConfDTO();
        param.setPluginConfId(taskId);
        param = (PluginNginxConfDTO)service.queryByPk((Object)param);
        if (param == null) {
            return false;
        }
        if (StringUtils.equals((CharSequence)NginxSrc.Manual.getName(), (CharSequence)param.getNginxSrc()) && StringUtils.isBlank((CharSequence)param.getNginxConf())) {
            message.getMessage().add("nginx\u914d\u7f6e\u5185\u5bb9");
            return false;
        }
        return super.validate(batchId, taskId, message);
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        PluginNginxConfService service = (PluginNginxConfService)SpringContextUtils.getBean(PluginNginxConfService.class);
        PluginNginxConfDTO param = new PluginNginxConfDTO();
        param.setPluginConfId(taskId);
        param = (PluginNginxConfDTO)service.queryByPk((Object)param);
        if (param == null) {
            return true;
        }
        param.setPluginConfId(newTaskId);
        int re = service.insert((Object)param);
        return re == 1;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
        PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        String currEnvId = this.batchInst.getEnvId();
        this.envInfo = paasEnvInfoDao.queryByPk(currEnvId);
        return true;
    }

    @Override
    public boolean execute() {
        if (StringUtils.equals((CharSequence)this.appInfo.getLinkedSaas(), (CharSequence)YesOrNO.YES.getCode())) {
            PaasEcsInfoDTO ecs;
            PaasEcsInfoPortalService paasEcsInfoService = (PaasEcsInfoPortalService)SpringContextUtils.getBean(PaasEcsInfoPortalService.class);
            PaasEcsInfoDTO ecsParam = new PaasEcsInfoDTO();
            if (StringUtils.isNotBlank((CharSequence)this.ecsId)) {
                ecsParam.setEcsId(this.ecsId);
            } else {
                ecsParam.setSubsId(this.appInfo.getSubsId());
                ecsParam.setAppId(this.appInfo.getAppId());
                ecsParam.setEnvId(this.envInfo.getEnvId());
            }
            List ecsList = paasEcsInfoService.queryListByPage((Object)ecsParam);
            PaasEcsInfoDTO paasEcsInfoDTO = ecs = CollectionUtils.isNotEmpty((Collection)ecsList) ? (PaasEcsInfoDTO)ecsList.get(0) : null;
            if (ecs == null) {
                this.logger.error("\u83b7\u53d6\u670d\u52a1\u5668\u4e3a\u7a7a");
                return false;
            }
            PluginNginxConfService pluginNginxConfService = (PluginNginxConfService)SpringContextUtils.getBean(PluginNginxConfService.class);
            PluginNginxConfDTO nginxConfDTO = new PluginNginxConfDTO();
            nginxConfDTO.setPluginConfId(this.context.getSzTaskId());
            nginxConfDTO = (PluginNginxConfDTO)pluginNginxConfService.queryByPk((Object)nginxConfDTO);
            HashMap requestData = new HashMap();
            String conf = this.getNginxConf(this.appInfo.getAppCode(), ecs);
            if (nginxConfDTO != null && StringUtils.equals((CharSequence)nginxConfDTO.getNginxSrc(), (CharSequence)NginxSrc.Manual.getCode())) {
                conf = nginxConfDTO.getNginxConf();
            }
            this.logger.info("\u540c\u6b65nginx\u914d\u7f6e :" + JSON.toJSONString(requestData));
            if (StringUtils.isNotBlank((CharSequence)conf)) {
                File confFile = new File(this.nginxConfPath, String.format("%s.conf", this.appInfo.getAppId()));
                try {
                    FileUtils.writeStringToFile((File)confFile, (String)conf, (Charset)Charset.forName("UTF-8"));
                }
                catch (IOException e) {
                    this.logger.error("\u914d\u7f6e\u6587\u4ef6\u5199\u5165\u5931\u8d25 " + e.getMessage(), e);
                    return false;
                }
                TerminalExecUtil.localTerminalExec((File)new File("/"), s -> this.logger.debug(s), (String[])new String[]{String.format("%s -s stop && %s", this.nginxCommand, this.nginxCommand)});
                return true;
            }
            return false;
        }
        this.logger.info(this.appInfo.getAppName() + "\u5e94\u7528\u4e0d\u6302\u63a5\u5230\u7814\u53d1\u4e91");
        return true;
    }

    public String getNginxConf(String appCode, PaasEcsInfoDTO ecs) {
        String ip;
        String conf = "";
        String server_port = "";
        if (StringUtils.isNotBlank((CharSequence)ecs.getEcsPort())) {
            server_port = ecs.getEcsPort();
        }
        if (StringUtils.isBlank((CharSequence)(ip = ecs.getEcsOutIp()))) {
            ip = ecs.getEcsIp();
        }
        conf = String.format("location ~ /%s/ {\n     rewrite /%s/(.*) /$1 break;\n     proxy_pass http://%s:%s;\n     proxy_set_header X-Real-IP $remote_addr;\n     proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;\n }\n", appCode, appCode, ip, server_port);
        return conf;
    }
}

