/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoPortalService;
import com.irdstudio.allinapaas.deliver.console.facade.PluginNginxConfService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginNginxConfDTO;
import com.irdstudio.allinapaas.deliver.console.types.NginxSrc;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class SaasNginxSyncPlugin
extends AbstractPlugin {
    protected BatInstBatch batchInst = null;
    protected PaasAppsInfo appInfo = null;
    protected SSubsInfo sSubsInfo = null;
    protected PaasEnvInfo envInfo = null;
    protected Map<String, Object> extParam;
    protected String paasDuId = "D000001";
    protected String ecsId = "";

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        PluginNginxConfService service = (PluginNginxConfService)SpringContextUtils.getBean(PluginNginxConfService.class);
        PluginNginxConfDTO param = new PluginNginxConfDTO();
        param.setPluginConfId(taskId);
        param = (PluginNginxConfDTO)service.queryByPk((Object)param);
        if (param == null) {
            return false;
        }
        if (StringUtils.equals((CharSequence)NginxSrc.Manual.getName(), (CharSequence)param.getNginxSrc()) && StringUtils.isBlank((CharSequence)param.getNginxConf())) {
            message.getMessage().add("nginx\u914d\u7f6e\u5185\u5bb9");
            return false;
        }
        return super.validate(batchId, taskId, message);
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        PluginNginxConfService service = (PluginNginxConfService)SpringContextUtils.getBean(PluginNginxConfService.class);
        PluginNginxConfDTO param = new PluginNginxConfDTO();
        param.setPluginConfId(taskId);
        param = (PluginNginxConfDTO)service.queryByPk((Object)param);
        if (param == null) {
            return true;
        }
        param.setPluginConfId(newTaskId);
        int re = service.insert((Object)param);
        return re == 1;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
        PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        String currEnvId = this.batchInst.getEnvId();
        this.envInfo = paasEnvInfoDao.queryByPk(currEnvId);
        return true;
    }

    @Override
    public boolean execute() {
        if (StringUtils.equals((CharSequence)this.appInfo.getLinkedSaas(), (CharSequence)YesOrNO.YES.getCode())) {
            PaasEcsInfoDTO ecs;
            PaasEcsInfoPortalService paasEcsInfoService = (PaasEcsInfoPortalService)SpringContextUtils.getBean(PaasEcsInfoPortalService.class);
            PaasEcsInfoDTO ecsParam = new PaasEcsInfoDTO();
            if (StringUtils.isNotBlank((CharSequence)this.ecsId)) {
                ecsParam.setEcsId(this.ecsId);
            } else {
                ecsParam.setSubsId(this.appInfo.getSubsId());
                ecsParam.setAppId(this.appInfo.getAppId());
                ecsParam.setEnvId(this.envInfo.getEnvId());
            }
            List ecsList = paasEcsInfoService.queryListByPage((Object)ecsParam);
            PaasEcsInfoDTO paasEcsInfoDTO = ecs = CollectionUtils.isNotEmpty((Collection)ecsList) ? (PaasEcsInfoDTO)ecsList.get(0) : null;
            if (ecs == null) {
                this.logger.error("\u83b7\u53d6\u670d\u52a1\u5668\u4e3a\u7a7a");
                return false;
            }
            PluginNginxConfService pluginNginxConfService = (PluginNginxConfService)SpringContextUtils.getBean(PluginNginxConfService.class);
            PluginNginxConfDTO nginxConfDTO = new PluginNginxConfDTO();
            nginxConfDTO.setPluginConfId(this.context.getSzTaskId());
            nginxConfDTO = (PluginNginxConfDTO)pluginNginxConfService.queryByPk((Object)nginxConfDTO);
            String url = String.format("%s/client/s/subs/info/sync/nginx", this.envInfo.getEnvAppsPortal());
            HashMap<String, String> requestData = new HashMap<String, String>();
            String conf = this.getNginxConf(this.appInfo.getAppCode(), ecs);
            if (nginxConfDTO != null && StringUtils.equals((CharSequence)nginxConfDTO.getNginxSrc(), (CharSequence)NginxSrc.Manual.getCode())) {
                conf = nginxConfDTO.getNginxConf();
            }
            requestData.put("conf", conf);
            requestData.put("appId", this.appInfo.getAppId());
            this.logger.info("\u540c\u6b65nginx\u914d\u7f6e :" + JSON.toJSONString(requestData));
            String string = this.requestOpenApi(url, requestData, false);
        } else {
            this.logger.info(this.appInfo.getAppName() + "\u5e94\u7528\u4e0d\u6302\u63a5\u5230\u5e94\u7528\u95e8\u6237");
        }
        return true;
    }

    public String requestOpenApi(String url, Object param, boolean printErrorLog) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost postMethod = new HttpPost(url);
        HttpResponse response = null;
        try {
            String reqJson = JSON.toJSONString((Object)param);
            StringEntity entity = new StringEntity(reqJson, ContentType.APPLICATION_JSON);
            postMethod.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)postMethod);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            return json;
        }
        catch (IOException e) {
            if (printErrorLog) {
                e.printStackTrace();
                this.logger.error(e.getMessage(), e);
            }
            return null;
        }
    }

    public String getNginxConf(String appCode, PaasEcsInfoDTO ecs) {
        String ip;
        String conf = "";
        String server_port = "";
        if (StringUtils.isNotBlank((CharSequence)ecs.getEcsPort())) {
            server_port = ecs.getEcsPort();
        }
        if (StringUtils.isBlank((CharSequence)(ip = ecs.getEcsOutIp()))) {
            ip = ecs.getEcsIp();
        }
        conf = String.format("location ~ /%s/ {\n     rewrite /%s/(.*) /$1 break;\n     proxy_pass http://%s:%s;\n     proxy_set_header X-Real-IP $remote_addr;\n     proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;\n }\n", appCode, appCode, ip, server_port);
        return conf;
    }
}

