/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SUserDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SUser;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginGitConf;
import com.irdstudio.allincloud.portal.facade.GiteeService;
import com.irdstudio.allincloud.portal.facade.dto.GiteeRequestVO;
import com.irdstudio.allincloud.portal.facade.dto.GiteeResponseVO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.GroupParams;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.User;

public class DocsCheckRemoteRepoPlugin
extends AbstractPlugin {
    private BatInstBatch buildLog;
    private Map<String, Object> extParam;
    private String pluginName = null;
    private PluginGitConf pluginParam = null;
    private String gitLocalPathFileName;
    private String repoName = null;
    private String access_token = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.buildLog = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.buildLog);
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        String sysCode = this.buildLog.getSubsId();
        this.pluginName = this.context.getSzPluginName();
        this.pluginParam = new PluginGitConf();
        this.pluginParam.setGitUserName(paasEnvParamDao.queryByCodeReturnValue("git.username"));
        this.pluginParam.setGitPassword(paasEnvParamDao.queryByCodeReturnValue("git.password"));
        this.pluginParam.setGitBranchName(paasEnvParamDao.queryByCodeReturnValue("git.push.branch.name"));
        String pushUrl = paasEnvParamDao.queryByCodeReturnValue("git.push.remote.path");
        if (!pushUrl.endsWith("/")) {
            pushUrl = pushUrl + "/";
        }
        this.pluginParam.setGitRemotePath(String.format("%s%s.git", pushUrl, SdEnvUtil.wrapperAppCode(sysCode)));
        this.repoName = sysCode;
        this.access_token = paasEnvParamDao.queryByCodeReturnValue("git.open.api.access_token");
        if (this.pluginParam == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u6570\u636eGit\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean result = true;
        String loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            String sysCode = this.buildLog.getSubsId();
            SSubsInfo sysInfo = sSubsInfoDao.querySSubsInfoWithKeys(sysCode);
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEnvParam envParam = new PaasEnvParam();
            envParam.setEnvId("paas");
            envParam.setParamGroup("git.user");
            List<PaasEnvParam> gitParamList = paasEnvParamDao.queryPaasEnvParamList(envParam);
            if (CollectionUtils.isNotEmpty(gitParamList)) {
                String gitType = this.getEnvParamByCode("git.type", gitParamList);
                String gitHostUrl = this.getEnvParamByCode("git.host.url", gitParamList);
                String accessToken = this.getEnvParamByCode("git.open.api.access_token", gitParamList);
                if (gitHostUrl.endsWith("/")) {
                    gitHostUrl = gitHostUrl.substring(0, gitHostUrl.length() - 1);
                }
                String subsGitGroup = String.format("%s/%s", gitHostUrl, sysInfo.getSubsCode());
                this.logger.info(String.format("\u5f53\u524d\u4ed3\u5e93\u5bf9\u63a5\u662f %s", gitType));
                if (StringUtils.equals((CharSequence)"gitee", (CharSequence)gitType)) {
                    result = this.giteeHandler(sysInfo.getSubsCode(), loginUserId, gitHostUrl, accessToken, sysInfo.getSubsName() + "wiki", conn);
                } else if (StringUtils.equals((CharSequence)"gitlab", (CharSequence)gitType)) {
                    result = this.gitlabHandler(sysInfo.getSubsCode(), loginUserId, gitHostUrl, accessToken, sysInfo.getSubsName() + "wiki", conn);
                }
            }
        }
        catch (Exception e) {
            result = false;
            this.logger.error("\u68c0\u67e5\u521d\u59cb\u4ed3\u5e93\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return result;
    }

    private String getEnvParamByCode(String paramCode, List<PaasEnvParam> paramList) {
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasEnvParam param : paramList) {
                if (!param.getParamCode().equals(paramCode)) continue;
                return param.getParamValue();
            }
        }
        return null;
    }

    private boolean gitlabHandler(String subsGitGroup, String currentUserId, String gitHostUrl, String accessToken, String desc, Connection conn) throws Exception {
        boolean result;
        block25: {
            result = true;
            try {
                SUserDao sUserDao = new SUserDao(conn);
                String group = subsGitGroup;
                GitLabApi gitLabApi = new GitLabApi(gitHostUrl, accessToken);
                User gitUserInfo = null;
                try {
                    gitUserInfo = gitLabApi.getUserApi().getUser(currentUserId);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (gitUserInfo == null) {
                    SUser sUser = new SUser();
                    sUser.setActorno(currentUserId);
                    sUser = sUserDao.queryByPk(sUser);
                    gitUserInfo = new User();
                    gitUserInfo.setName(currentUserId);
                    gitUserInfo.setUsername(currentUserId);
                    gitUserInfo.setEmail(sUser.getUsermail());
                    try {
                        gitUserInfo = gitLabApi.getUserApi().createUser(gitUserInfo, (CharSequence)(currentUserId + currentUserId), false);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                }
                GroupApi groupApi = gitLabApi.getGroupApi();
                Group namespace = null;
                try {
                    namespace = groupApi.getGroup((Object)group);
                }
                catch (GitLabApiException e) {
                    this.logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                    namespace = null;
                }
                if (namespace == null) {
                    try {
                        GroupParams createGroupParam = new GroupParams();
                        createGroupParam.withName(group);
                        createGroupParam.withPath(group);
                        createGroupParam.withDescription(desc);
                        namespace = groupApi.createGroup(createGroupParam);
                        this.logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = groupApi.addMember((Object)group, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                this.logger.info("\u4ed3\u5e93\u7ec4\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                        }
                        catch (GitLabApiException member) {}
                    }
                    catch (GitLabApiException e) {
                        this.logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                        result = false;
                        return result;
                    }
                }
                String projectName = subsGitGroup + "-wiki";
                ProjectApi prjApi = gitLabApi.getProjectApi();
                Project prj = null;
                try {
                    prj = prjApi.getProject(group, projectName);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (prj == null || prj.getId() == null || prj.getId() < 0L) {
                    prj = new Project();
                    prj.setName(projectName);
                    prj.setPath(projectName);
                    prj.setDescription(desc);
                    Project newPrj = null;
                    try {
                        newPrj = prjApi.createProject(namespace.getId(), prj);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                    if (newPrj != null) {
                        this.logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = prjApi.addMember((Object)newPrj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                this.logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                            break block25;
                        }
                        catch (GitLabApiException gitLabApiException) {}
                        break block25;
                    }
                    this.logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u521b\u5efa\u5931\u8d25\u4e86");
                    result = false;
                    break block25;
                }
                this.logger.info("\u77e5\u8bc6\u5e93 \u4ed3\u5e93\u5df2\u5b58\u5728");
                result = true;
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528gitlab api \u5f02\u5e38 " + e.getMessage(), e);
                result = false;
            }
        }
        return result;
    }

    private boolean giteeHandler(String subsGitGroup, String currentUserId, String gitHostUrl, String accessToken, String desc, Connection conn) throws Exception {
        GiteeService giteeService = (GiteeService)SpringContextUtils.getBean(GiteeService.class);
        boolean result = true;
        String type = "org";
        String ownName = subsGitGroup;
        GiteeRequestVO requestParam = new GiteeRequestVO();
        requestParam.setAccess_token(accessToken);
        GiteeResponseVO response = giteeService.queryOrg(subsGitGroup, requestParam);
        if (response == null || StringUtils.isBlank((CharSequence)response.getUrl())) {
            GiteeRequestVO createOrgParam = new GiteeRequestVO();
            createOrgParam.setAccess_token(accessToken);
            createOrgParam.setName(subsGitGroup);
            createOrgParam.setOrg(subsGitGroup);
            response = giteeService.createOrg(createOrgParam);
            this.logger.info("gitee \u521b\u5efa\u7ec4\u7ec7\u4ed3\u5e93\u8fd4\u56de\u62a5\u6587 " + JSON.toJSONString((Object)response));
        }
        String projectName = subsGitGroup + "-wiki";
        requestParam = new GiteeRequestVO();
        requestParam.setAccess_token(accessToken);
        requestParam.setName(projectName);
        requestParam.setOrg(subsGitGroup);
        requestParam.setHas_issues(Boolean.valueOf(true));
        requestParam.setHas_wiki(Boolean.valueOf(true));
        requestParam.setCan_comment(Boolean.valueOf(true));
        response = giteeService.createOrgRepo(type + "s", subsGitGroup, requestParam);
        this.logger.info(String.format("\u521b\u5efa\u77e5\u8bc6\u5e93 %s \u8fd4\u56de %s", projectName, JSON.toJSON((Object)response)));
        return result;
    }
}

