/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableIndexDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableIndex;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.WikiSubsPage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.plugin.DataBaseSQLScriptPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.plugin.ModelTableStructVO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.FileUtil;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class GenAppSqlScript
implements DocGenerate {
    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoListBySysCode(subsId);
            if (CollectionUtils.isNotEmpty(appList)) {
                ArrayList<File> returnFiles = new ArrayList<File>(appList.size());
                for (PaasAppsInfo appInfo : appList) {
                    File file = this.generateAppDoc(template, appInfo.getAppId(), baseDir, connTool, null);
                    if (file == null) continue;
                    returnFiles.add(file);
                }
                ArrayList<File> arrayList = returnFiles;
                return arrayList;
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u5e93\u811a\u672c\u751f\u6210\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6570\u636e\u5e93\u811a\u672c\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            File file;
            File currentFile;
            conn = connTool.getConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(appId);
            SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(appInfo.getSubsId());
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            String userId = template.getLoginUserId();
            Map appInfoMap = BeanUtility.bean2Map((Object)((Object)appInfo));
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                appInfoMap.putAll(subsInfoMap);
                fileName = this.renderDocName(template.getDocNameTemplate(), appInfoMap);
            }
            if ((currentFile = this.getDocDirPath(template, baseDir, conn)) == null) {
                logger.error("\u751f\u6210\u6587\u4ef6\u4fdd\u5b58\u76ee\u5f55\u8def\u5f84\u5931\u8d25");
                File file2 = null;
                return file2;
            }
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            if ((file = new File(SdEnvUtil.TEMPLATE_PATH + fileName)).exists()) {
                FileUtils.deleteQuietly((File)file);
            }
            List<ModelTableStructVO> tableStructs = this.queryModelTableStructByProjectId(appInfo.getAppId(), conn);
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            DataBaseSQLScriptPlugin plugin = new DataBaseSQLScriptPlugin();
            for (ModelTableStructVO vo : tableStructs) {
                vo.setDbms(String.valueOf(appInfo.getBizDbDbms()));
                String content = plugin.generateDDLScript(template.getDocFile(), vo);
                FileUtil.writeContent((String)content, (String)file.getAbsolutePath(), (boolean)true);
            }
            File targetFile = new File(currentFile, fileName);
            FileUtils.copyFile((File)file, (File)targetFile);
            WikiSubsPage wikiPage = new WikiSubsPage();
            wikiPage.setDocTitle(fileName.replaceAll(".sql", ""));
            wikiPage.setSubsId(appInfo.getSubsId());
            wikiPage.setDocType("sql");
            wikiPage.setDocVersion(CurrentDateUtil.getTodayDateEx2());
            wikiPage.setLoginUserId(template.getLoginUserId());
            this.saveToWikiConsole(appInfo.getSubsId(), template, wikiPage, conn);
            File file3 = targetFile;
            return file3;
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u5e93\u811a\u672c\u751f\u6210\u5f02\u5e38 " + appId + " " + e.getMessage(), (Throwable)e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File generateGroupDoc(PaasDocTemplate template, String subsId, String groupName, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsInfo appParam = new PaasAppsInfo();
            appParam.setSubsId(subsId);
            appParam.setBizDbName(groupName);
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoList(appParam);
            if (CollectionUtils.isNotEmpty(appList)) {
                File file;
                File currentFile;
                PaasAppsInfo appInfo = appList.get(0);
                String dbmsId = appInfo.getBizDbDbms();
                SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(appInfo.getSubsId());
                Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
                String userId = template.getLoginUserId();
                appInfo.setAppCode(appInfo.getBizDbName());
                appInfo.setAppName(appInfo.getBizDbCnname());
                Map appInfoMap = BeanUtility.bean2Map((Object)((Object)appInfo));
                String fileName = template.getDocName();
                if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                    appInfoMap.putAll(subsInfoMap);
                    fileName = this.renderDocName(template.getDocNameTemplate(), appInfoMap);
                }
                if ((currentFile = this.getDocDirPath(template, baseDir, conn)) == null) {
                    logger.error("\u751f\u6210\u6587\u4ef6\u4fdd\u5b58\u76ee\u5f55\u8def\u5f84\u5931\u8d25");
                    File file2 = null;
                    return file2;
                }
                if (!currentFile.exists()) {
                    currentFile.mkdirs();
                }
                if ((file = new File(SdEnvUtil.TEMPLATE_PATH + fileName)).exists()) {
                    FileUtils.deleteQuietly((File)file);
                }
                ArrayList tableStructs = new ArrayList();
                for (PaasAppsInfo app : appList) {
                    List<ModelTableStructVO> appTableList = this.queryModelTableStructByProjectId(app.getAppId(), conn);
                    if (!CollectionUtils.isNotEmpty((Collection)appTableList)) continue;
                    tableStructs.addAll(appTableList);
                }
                DocTemplateRepoPullQueueExecutor.syncRun();
                String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
                DataBaseSQLScriptPlugin plugin = new DataBaseSQLScriptPlugin();
                for (ModelTableStructVO vo : tableStructs) {
                    vo.setDbms(dbmsId);
                    String content = plugin.generateDDLScript(template.getDocFile(), vo);
                    FileUtil.writeContent((String)content, (String)file.getAbsolutePath(), (boolean)true);
                }
                File targetFile = new File(currentFile, fileName);
                FileUtils.copyFile((File)file, (File)targetFile);
                WikiSubsPage wikiPage = new WikiSubsPage();
                wikiPage.setDocTitle(fileName.replaceAll(".sql", ""));
                wikiPage.setSubsId(appInfo.getSubsId());
                wikiPage.setDocType("sql");
                wikiPage.setDocVersion(CurrentDateUtil.getTodayDateEx2());
                wikiPage.setLoginUserId(template.getLoginUserId());
                this.saveToWikiConsole(appInfo.getSubsId(), template, wikiPage, conn);
                File file3 = targetFile;
                return file3;
            }
            File file = null;
            return file;
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u5e93\u811a\u672c\u751f\u6210\u5f02\u5e38 " + subsId + " " + e.getMessage(), (Throwable)e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
        return null;
    }

    private List<ModelTableStructVO> queryModelTableStructByProjectId(String projectId, Connection conn) throws Exception {
        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
        ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
        ModelTableIndexDao modelTableIndexDao = new ModelTableIndexDao(conn);
        ArrayList<ModelTableStructVO> sqlScripts = new ArrayList<ModelTableStructVO>();
        ModelTableInfo tableParam = new ModelTableInfo();
        tableParam.setAppId(projectId);
        tableParam.setObjectType(ObjectType.Table.getIntCode());
        List<ModelTableInfo> tableInfoVOs = modelTableInfoDao.queryTableListWithCond(tableParam);
        List<ModelTableField> tableFieldVOs = modelTableFieldDao.queryFieldByAppId(projectId);
        List<ModelTableIndex> tableIndexVOs = modelTableIndexDao.queryModelTableInfos(projectId);
        ModelTableStructVO sqlScript = null;
        ArrayList<ModelTableField> tableFieldVOs2 = null;
        for (ModelTableInfo tableInfoVO : tableInfoVOs) {
            sqlScript = new ModelTableStructVO();
            sqlScript.setTable(tableInfoVO);
            sqlScript.setIndexs(new ArrayList<ModelTableIndex>());
            tableFieldVOs2 = new ArrayList<ModelTableField>();
            for (int i = 0; i < tableFieldVOs.size(); ++i) {
                if (!tableFieldVOs.get(i).getObjectId().equals(tableInfoVO.getObjectId())) continue;
                tableFieldVOs2.add(tableFieldVOs.get(i));
                tableFieldVOs.remove(i);
                --i;
            }
            for (int k = 0; k < tableIndexVOs.size(); ++k) {
                if (!tableInfoVO.getObjectId().equals(tableIndexVOs.get(k).getObjectId())) continue;
                sqlScript.getIndexs().add(tableIndexVOs.get(k));
                tableIndexVOs.remove(k);
                --k;
            }
            sqlScript.setFields(tableFieldVOs2);
            sqlScripts.add(sqlScript);
        }
        return sqlScripts;
    }
}

