/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.AppsCheckLogDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.AppsCheckLog;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.WikiSubsPage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import java.io.File;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GenAppsCheckExcel
implements DocGenerate {
    private final int loadPageSize = 500;
    private AppsCheckLogDao appsCheckLogDao = null;

    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        return null;
    }

    private int calcLoop(int size) {
        int loop = size / 500;
        if (size % 500 > 0) {
            return loop + 1;
        }
        return loop;
    }

    public void appsCheckData(ExcelWriter excelWriter, WriteSheet sheet, String appId, String batchSerialNo) {
        AppsCheckLog param = new AppsCheckLog();
        param.setAppId(appId);
        param.setBatchSerialNo(batchSerialNo);
        param.setSize(500);
        List<AppsCheckLog> list = this.appsCheckLogDao.queryListByPage(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill(list, sheet);
        } else {
            excelWriter.fill(list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(page);
                list = this.appsCheckLogDao.queryListByPage(param);
                excelWriter.fill(list, sheet);
            }
        }
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            String moduleCode = "apdpaas";
            conn = connTool.getConnection();
            File currentFile = this.getDocDirPath(template, baseDir, conn);
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            this.appsCheckLogDao = new AppsCheckLogDao(conn);
            PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(appId);
            SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(appInfo.getSubsId());
            String subsId = subsInfo.getSubsId();
            String subsCode = subsInfo.getSubsCode();
            String subsName = subsInfo.getSubsName();
            String userId = template.getLoginUserId();
            BatInstBatch instBatchParam = new BatInstBatch();
            instBatchParam.setAppId(appId);
            instBatchParam.setBatchId("APPS-CHECK");
            List<BatInstBatch> instBatchList = batInstBatchDao.queryList(instBatchParam);
            String batchSerialNo = null;
            if (CollectionUtils.isNotEmpty(instBatchList)) {
                batchSerialNo = instBatchList.get(0).getBatchSerialNo();
            }
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            Map appInfoMap = BeanUtility.bean2Map((Object)((Object)appInfo));
            appInfoMap.put("today", today);
            appInfoMap.put("todayTime", todayTime);
            appInfoMap.putAll(subsInfoMap);
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), appInfoMap);
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
            WriteSheet fieldSheet = EasyExcel.writerSheet((Integer)0, null).build();
            this.appsCheckData(excelWriter, fieldSheet, appId, batchSerialNo);
            excelWriter.finish();
            WikiSubsPage excelPage = new WikiSubsPage();
            excelPage.setDocTitle(fileName.replaceAll(".xlsx", ""));
            excelPage.setSubsId(subsId);
            excelPage.setDocType("xlsx");
            excelPage.setDocVersion(today);
            excelPage.setDocTag(String.format("[\"\u5e94\u7528\u6821\u9a8c\u7ed3\u679c\"]", new Object[0]));
            excelPage.setLoginUserId(template.getLoginUserId());
            this.saveToWikiConsole(subsId, template, excelPage, conn);
            File file = targetFile;
            return file;
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u6821\u9a8c\u7ed3\u679c\u751f\u6210\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5e94\u7528\u6821\u9a8c\u7ed3\u679c\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
    }
}

