/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.AbstractCellWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.excel.write.metadata.fill.FillWrapper;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvArrangeTableDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.OsrvEvalIsrvDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelPackageDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.WikiSubsPage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class GenInterfaceExcel
implements DocGenerate {
    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(subsId);
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoListBySysCode(subsId);
            if (CollectionUtils.isNotEmpty(appList)) {
                ArrayList<File> returnFile = new ArrayList<File>(appList.size());
                for (PaasAppsInfo appInfo : appList) {
                    try {
                        File file = this.generateAppDoc(template, appInfo.getAppId(), baseDir, connTool, extParams);
                        if (file == null) continue;
                        returnFile.add(file);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                ArrayList<File> arrayList = returnFile;
                return arrayList;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
        return null;
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            File currentFile;
            conn = connTool.getConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(appId);
            String subsId = appInfo.getSubsId();
            SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(subsId);
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            File returnFile = null;
            Map appInfoMap = BeanUtility.bean2Map((Object)((Object)appInfo));
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                appInfoMap.putAll(subsInfoMap);
                fileName = this.renderDocName(template.getDocNameTemplate(), appInfoMap);
            }
            if ((currentFile = this.getDocDirPath(template, baseDir, conn)) == null) {
                logger.error("\u751f\u6210\u6587\u4ef6\u4fdd\u5b58\u76ee\u5f55\u8def\u5f84\u5931\u8d25");
                File file = null;
                return file;
            }
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            String currentFilePath = currentFile.getAbsolutePath();
            try {
                DocTemplateRepoPullQueueExecutor.syncRun();
                String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
                String infFile = this.generateAppInf(appInfo, templateRootPath + File.separator + template.getDocFile(), conn);
                File srcFile = new File(infFile);
                File targetFile = new File(currentFile, fileName);
                FileUtils.moveFile((File)srcFile, (File)targetFile);
                returnFile = targetFile;
                String docName = srcFile.getName();
                WikiSubsPage appDoc = new WikiSubsPage();
                appDoc.setDocType("xlsx");
                appDoc.setDocTitle(fileName.replace(".xlsx", ""));
                appDoc.setAppCode(appInfo.getAppCode());
                appDoc.setAppId(appInfo.getAppId());
                appDoc.setAppName(appInfo.getAppName());
                appDoc.setSubsId(subsId);
                appDoc.setLoginUserId(template.getLoginUserId());
                this.saveToWikiConsole(subsId, template, appDoc, conn);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            File file = returnFile;
            return file;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
    }

    private String generateAppInf(PaasAppsInfo appInfo, String templatePath, Connection conn) throws Exception {
        Object fieldList;
        SrvModelPackageDao srvModelPackageDao = new SrvModelPackageDao(conn);
        SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
        SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
        ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
        OsrvArrangeTableDao osrvArrangeTableDao = new OsrvArrangeTableDao(conn);
        OsrvEvalIsrvDao osrvEvalIsrvDao = new OsrvEvalIsrvDao(conn);
        String appId = appInfo.getAppId();
        SrvModelInfo infoParam = new SrvModelInfo();
        infoParam.setAppId(appId);
        List<SrvModelInfo> srvList = srvModelInfoDao.querySrvModelInfoList(infoParam, Arrays.asList(SrvModelCatalogEnum.ComponentServer.getCode(), SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
        ArrayList<IndexInfo> indexList = new ArrayList<IndexInfo>(srvList.size());
        HashMap<String, Object> inoutMap = new HashMap<String, Object>();
        for (SrvModelInfo info : srvList) {
            IndexInfo ii = new IndexInfo();
            ii.setSrvModelCode(info.getSrvModelCode());
            ii.setSrvModelDesc(info.getSrvModelDesc());
            ii.setSrvModelName(info.getSrvModelName());
            ii.setAppVesion(appInfo.getAppVersion());
            ii.setApiUrl("/api/" + info.getSrvModelCode().toLowerCase());
            ii.setSrvModelId(info.getSrvModelId());
            indexList.add(ii);
            SrvModelInout inoutParam = new SrvModelInout();
            inoutParam.setSrvModelId(info.getSrvModelId());
            List<SrvModelInout> inoutList = srvModelInoutDao.querySrvModelInoutList(inoutParam);
            if (!CollectionUtils.isNotEmpty(inoutList)) continue;
            for (SrvModelInout inout : inoutList) {
                ArrayList<Object> list = (ArrayList<Object>)inoutMap.get(inout.getSrvModelId() + inout.getIoType());
                fieldList = new ArrayList();
                List<ModelTableField> tableFields = modelTableFieldDao.queryModelTableFieldList(inout.getTableModelId());
                for (int k = 0; k < tableFields.size(); ++k) {
                    ModelTableField ff = tableFields.get(k);
                    FieldInfo fieldInfo = FieldInfo.createByModelTableField(ff);
                    fieldInfo.setSeq(String.valueOf(k + 1));
                    fieldList.add(fieldInfo);
                }
                if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
                    if (list == null) {
                        list = new ArrayList<Object>();
                        inoutMap.put(inout.getSrvModelId() + inout.getIoType(), list);
                    }
                    list.add(fieldList);
                }
                inoutMap.put(inout.getSrvModelId() + inout.getTableModelId() + inout.getIoType() + "H", (Object)inout);
            }
        }
        String templateFileName = templatePath;
        String excelTempFile = SdEnvUtil.TEMPLATE_PATH + File.separator + appInfo.getAppId() + "-temp.xlsx";
        String targetFile = SdEnvUtil.TEMPLATE_PATH + File.separator + appInfo.getAppId() + ".xlsx";
        ExcelWriterBuilder writerBuilder = EasyExcel.write((String)targetFile);
        ExcelWriter excelWriter = writerBuilder.withTemplate(templateFileName).build();
        Workbook workbook = excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook();
        int sheetCount = indexList.size();
        for (int i = 1; i <= sheetCount; ++i) {
            if (i < sheetCount) {
                fieldList = excelWriter.writeContext().writeWorkbookHolder().getCachedWorkbook().cloneSheet(i);
            }
            IndexInfo currentInfo = (IndexInfo)indexList.get(i - 1);
            try {
                workbook.setSheetName(i, currentInfo.getSrvModelCode());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            Sheet currentSheet = workbook.getSheetAt(i);
            int destRow = 7;
            destRow = this.copySubTableForFill(inoutMap, currentInfo, IOType.Input, workbook, currentSheet, destRow);
            destRow = this.copySubTableForFill(inoutMap, currentInfo, IOType.Output, workbook, currentSheet, destRow);
        }
        excelWriter.finish();
        try {
            FileUtils.copyFile((File)new File(targetFile), (File)new File(excelTempFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        writerBuilder = EasyExcel.write((String)targetFile);
        excelWriter = writerBuilder.withTemplate(excelTempFile).build();
        WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet().registerWriteHandler((WriteHandler)new AbstractCellWriteHandler(){

            public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
                if (cell.getRowIndex() > 0 && cell.getColumnIndex() == 0) {
                    CreationHelper createHelper = writeSheetHolder.getSheet().getWorkbook().getCreationHelper();
                    Hyperlink hyperlink = createHelper.createHyperlink(HyperlinkType.DOCUMENT);
                    hyperlink.setAddress("'" + cellDataList.get(0).getStringValue() + "'!A1");
                    cell.setHyperlink(hyperlink);
                }
            }
        })).build();
        excelWriter.fill(indexList, writeSheet);
        int startSheet = 1;
        for (IndexInfo ii : indexList) {
            List outputList;
            logger.info("fill index {}", (Object)startSheet);
            ExcelWriterSheetBuilder builder = EasyExcel.writerSheet((Integer)startSheet);
            WriteSheet writeTableSheet = builder.build();
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
            List inputList = (List)inoutMap.get(ii.getSrvModelId() + IOType.Input.getCode());
            if (CollectionUtils.isNotEmpty((Collection)inputList)) {
                for (int i = 0; i < inputList.size(); ++i) {
                    List fieldList2 = (List)inputList.get(i);
                    String name = "input";
                    if (i > 0) {
                        name = name + i;
                    }
                    excelWriter.fill((Object)new FillWrapper(name, (Collection)fieldList2), writeTableSheet);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(outputList = (List)inoutMap.get(ii.getSrvModelId() + IOType.Output.getCode())))) {
                for (int i = 0; i < outputList.size(); ++i) {
                    List fieldList3 = (List)outputList.get(i);
                    String name = "output" + i;
                    excelWriter.fill((Object)new FillWrapper(name, (Collection)fieldList3), writeTableSheet);
                }
            }
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("srvModelCode", ii.getSrvModelCode());
            headMap.put("srvModelName", ii.getSrvModelName());
            excelWriter.fill(headMap, writeTableSheet);
            ++startSheet;
        }
        excelWriter.writeContext().writeWorkbookHolder().getWorkbook().setActiveSheet(0);
        excelWriter.finish();
        FileUtils.deleteQuietly((File)new File(excelTempFile));
        return targetFile;
    }

    public static final String fieldTypeToJavaType(String fieldType) {
        if (StringUtils.isEmpty((CharSequence)fieldType)) {
            return "\u65e0\u6548\u6570\u636e\u7c7b\u578b";
        }
        if ("VARCHAR".equals(fieldType = fieldType.toUpperCase()) || "VARCHAR2".equals(fieldType) || "CLOB".equals(fieldType) || "CHAR".equals(fieldType) || "NCHAR".equals(fieldType) || "CHAR2".equals(fieldType) || "TIMESTAMP".equals(fieldType) || "TEXT".equals(fieldType) || "LONG".equals(fieldType) || "DATE".equals(fieldType) || "LONGBLOB".equals(fieldType) || "DATETIME".equals(fieldType) || "NVARCHAR".equals(fieldType)) {
            return "String";
        }
        if ("INT".equals(fieldType) || "SMALLINT".equals(fieldType) || "MEDIUMINT".equals(fieldType)) {
            return "Integer";
        }
        if ("DECIMAL".equals(fieldType) || "NUMBER".equals(fieldType) || "BIGINT".equals(fieldType)) {
            return "BigDecimal";
        }
        return fieldType;
    }

    private static void copyRow(Workbook workbook, Sheet worksheet, int sourceRowNum, int destinationRowNum) {
        Row newRow = worksheet.getRow(destinationRowNum);
        Row sourceRow = worksheet.getRow(sourceRowNum);
        if (newRow != null) {
            worksheet.shiftRows(destinationRowNum, worksheet.getLastRowNum(), 1);
            newRow = worksheet.createRow(destinationRowNum);
        } else {
            newRow = worksheet.createRow(destinationRowNum);
        }
        for (int i = 0; i < sourceRow.getLastCellNum(); ++i) {
            Cell oldCell = sourceRow.getCell(i);
            Cell newCell = newRow.createCell(i);
            if (oldCell == null) {
                newCell = null;
                continue;
            }
            CellStyle newCellStyle = workbook.createCellStyle();
            newCellStyle.cloneStyleFrom(oldCell.getCellStyle());
            newCell.setCellStyle(newCellStyle);
            if (oldCell.getCellComment() != null) {
                newCell.setCellComment(oldCell.getCellComment());
            }
            if (oldCell.getHyperlink() != null) {
                newCell.setHyperlink(oldCell.getHyperlink());
            }
            if (oldCell.getCellType() == CellType.BLANK.getCode()) {
                newCell.setCellType(CellType.BLANK.getCode());
                continue;
            }
            if (oldCell.getCellType() == CellType.BOOLEAN.getCode()) {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                continue;
            }
            if (oldCell.getCellType() == CellType.ERROR.getCode()) {
                newCell.setCellValue((double)oldCell.getErrorCellValue());
                continue;
            }
            if (oldCell.getCellType() == CellType.FORMULA.getCode()) {
                newCell.setCellValue(oldCell.getCellFormula());
                continue;
            }
            if (oldCell.getCellType() == CellType.NUMERIC.getCode()) {
                newCell.setCellValue(oldCell.getNumericCellValue());
                continue;
            }
            if (oldCell.getCellType() != CellType.STRING.getCode()) continue;
            newCell.setCellValue(oldCell.getRichStringCellValue());
        }
    }

    private int copySubTableForFill(Map<String, Object> inoutMap, IndexInfo currentInfo, IOType ioType, Workbook workbook, Sheet currentSheet, int destRow) {
        List inputList = (List)inoutMap.get(currentInfo.getSrvModelId() + ioType.getCode());
        if (inputList == null) {
            return destRow;
        }
        int[] copySrcRow = new int[]{4, 5, 6};
        int start = 0;
        for (int iiIdex = 0; iiIdex < inputList.size(); ++iiIdex) {
            int j;
            SrvModelInout inout;
            List fieldList = (List)inputList.get(iiIdex);
            if (CollectionUtils.isEmpty((Collection)fieldList)) continue;
            if (start == 0 && IOType.Input == ioType) {
                inout = (SrvModelInout)((Object)inoutMap.get(currentInfo.getSrvModelId() + ((FieldInfo)fieldList.get(0)).getObjectId() + IOType.Input.getCode() + "H"));
                Row firstRow = currentSheet.getRow(4);
                Cell cell = firstRow.getCell(0);
                cell.setCellValue(String.format("\u8f93\u5165\uff08%s %s\uff09", inout.getTableModelName(), TmModelUtil.modelCodeToClassName((String)inout.getTableModelCode())));
                for (j = 1; j < fieldList.size(); ++j) {
                    if (currentSheet.getRow(6 + j) == null) {
                        currentSheet.createRow(6 + j);
                        continue;
                    }
                    currentSheet.shiftRows(6 + j, currentSheet.getLastRowNum(), 1);
                    currentSheet.createRow(6 + j);
                }
                destRow = destRow + fieldList.size() - 1;
                ++start;
                continue;
            }
            inout = (SrvModelInout)((Object)inoutMap.get(currentInfo.getSrvModelId() + ((FieldInfo)fieldList.get(0)).getObjectId() + ioType.getCode() + "H"));
            int firstHead = destRow;
            int[] nArray = copySrcRow;
            j = nArray.length;
            for (int i = 0; i < j; ++i) {
                int src = nArray[i];
                GenInterfaceExcel.copyRow(workbook, currentSheet, src, destRow++);
            }
            Row row = currentSheet.getRow(firstHead);
            Cell firstCell = row.getCell(0);
            if (IOType.Input == ioType) {
                firstCell.setCellValue(String.format("\u8f93\u5165\uff08%s %s\uff09", inout.getTableModelName(), TmModelUtil.modelCodeToClassName((String)inout.getTableModelCode())));
            } else {
                firstCell.setCellValue(String.format("\u8f93\u51fa\uff08%s %s\uff09", inout.getTableModelName(), TmModelUtil.modelCodeToClassName((String)inout.getTableModelCode())));
            }
            Row fillRow = currentSheet.getRow(firstHead + 2);
            for (int i = 0; i < fillRow.getLastCellNum(); ++i) {
                Cell cell = fillRow.getCell(i);
                String cellString = cell.getStringCellValue();
                if (cellString.contains("input.") && IOType.Input == ioType) {
                    cellString = cellString.replaceAll("input", "input" + start);
                    cell.setCellValue(cellString);
                    continue;
                }
                if (!cellString.contains("input.") || IOType.Output != ioType) continue;
                cellString = cellString.replaceAll("input", "output" + start);
                cell.setCellValue(cellString);
            }
            int blankRow = firstHead + 2;
            for (int j2 = 1; j2 < fieldList.size(); ++j2) {
                if (currentSheet.getRow(blankRow + j2) == null) {
                    currentSheet.createRow(blankRow + j2);
                    continue;
                }
                currentSheet.shiftRows(blankRow + j2, currentSheet.getLastRowNum(), 1);
                currentSheet.createRow(blankRow + j2);
            }
            destRow = destRow + fieldList.size() - 1;
            ++start;
        }
        return destRow;
    }

    public static class FieldInfo {
        @ExcelProperty(value={"\u53c2\u6570\u540d\u79f0", "\u5e8f\u53f7"})
        private String seq;
        @ExcelProperty(value={"\u53c2\u6570\u540d\u79f0", "\u4e2d\u6587\u540d\u79f0"})
        private String fieldName;
        @ExcelProperty(value={"\u53c2\u6570\u540d\u79f0", "\u82f1\u6587\u540d\u79f0"})
        private String fieldCode;
        @ExcelProperty(value={"\u53c2\u6570\u540d\u79f0", "\u7c7b\u578b"})
        private String fieldType;
        @ExcelProperty(value={"\u53c2\u6570\u540d\u79f0", "\u53d6\u503c\u8303\u56f4"})
        private String fieldLength;
        @ExcelProperty(value={"\u53c2\u6570\u540d\u79f0", "\u6821\u9a8c\u7c7b\u578b"})
        private String validType;
        @ExcelProperty(value={"\u53c2\u6570\u540d\u79f0", "\u5b57\u6bb5\u9879\u8bf4\u660e"})
        private String fieldDesc;
        @ExcelProperty(value={"\u53c2\u6570\u540d\u79f0", "\u5fc5\u586b\u7c7b\u578b"})
        private String isAllowNull;
        @ExcelIgnore
        private String objectId;

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public String getSeq() {
            return this.seq;
        }

        public void setSeq(String seq) {
            this.seq = seq;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldCode() {
            return this.fieldCode;
        }

        public void setFieldCode(String fieldCode) {
            this.fieldCode = fieldCode;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public String getFieldLength() {
            return this.fieldLength;
        }

        public void setFieldLength(String fieldLength) {
            this.fieldLength = fieldLength;
        }

        public String getValidType() {
            return this.validType;
        }

        public void setValidType(String validType) {
            this.validType = validType;
        }

        public String getFieldDesc() {
            return this.fieldDesc;
        }

        public void setFieldDesc(String fieldDesc) {
            this.fieldDesc = fieldDesc;
        }

        public String getIsAllowNull() {
            return this.isAllowNull;
        }

        public void setIsAllowNull(String isAllowNull) {
            this.isAllowNull = isAllowNull;
        }

        public static FieldInfo createByModelTableField(ModelTableField field) {
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setObjectId(field.getObjectId());
            fieldInfo.setFieldCode(TmModelUtil.fieldToProperty((String)field.getFieldCode()));
            fieldInfo.setFieldName(field.getFieldName());
            fieldInfo.setFieldDesc(field.getFieldDesc());
            fieldInfo.setFieldLength(String.valueOf(field.getFieldLength()));
            fieldInfo.setFieldType(GenInterfaceExcel.fieldTypeToJavaType(field.getFieldType()));
            if (field.getIsAllowNull() != null && field.getIsAllowNull().equals("Y")) {
                fieldInfo.setIsAllowNull("M");
            } else {
                fieldInfo.setIsAllowNull("O");
            }
            fieldInfo.setSeq(String.valueOf(field.getFieldOrder()));
            return fieldInfo;
        }
    }

    public static class IndexInfo {
        @ExcelProperty(value={"\u63a5\u53e3\u540d\u79f0"})
        private String srvModelCode;
        @ExcelProperty(value={"\u63a5\u53e3\u540d\u79f0-\u4e2d\u6587"})
        private String srvModelName;
        @ExcelProperty(value={"\u63a5\u53e3\u8bf4\u660e"})
        private String srvModelDesc;
        @ExcelProperty(value={"\u7248\u672c"})
        private String appVesion;
        @ExcelProperty(value={"\u8def\u5f84"})
        private String apiUrl;
        @ExcelIgnore
        private String srvModelId;

        public String getSrvModelId() {
            return this.srvModelId;
        }

        public void setSrvModelId(String srvModelId) {
            this.srvModelId = srvModelId;
        }

        public String getSrvModelCode() {
            return this.srvModelCode;
        }

        public void setSrvModelCode(String srvModelCode) {
            this.srvModelCode = srvModelCode;
        }

        public String getSrvModelName() {
            return this.srvModelName;
        }

        public void setSrvModelName(String srvModelName) {
            this.srvModelName = srvModelName;
        }

        public String getSrvModelDesc() {
            return this.srvModelDesc;
        }

        public void setSrvModelDesc(String srvModelDesc) {
            this.srvModelDesc = srvModelDesc;
        }

        public String getAppVesion() {
            return this.appVesion;
        }

        public void setAppVesion(String appVesion) {
            this.appVesion = appVesion;
        }

        public String getApiUrl() {
            return this.apiUrl;
        }

        public void setApiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
        }
    }
}

