/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.Rows;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableIndexDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableIndex;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.WikiSubsPage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.vo.TreeData;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.plugin.ModelTableStructVO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.word.util.TableModelUtil;
import com.irdstudio.sdk.beans.word.vo.tablemodel.ColumnInfo;
import com.irdstudio.sdk.beans.word.vo.tablemodel.PkgTableModelInfo;
import com.irdstudio.sdk.beans.word.vo.tablemodel.TableModelInfo;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class GenTableWordDocx
implements DocGenerate {
    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(subsId);
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoListBySysCode(subsId);
            if (CollectionUtils.isNotEmpty(appList)) {
                ArrayList<File> returnFile = new ArrayList<File>(appList.size());
                for (PaasAppsInfo appInfo : appList) {
                    File currentFile;
                    Map appInfoMap = BeanUtility.bean2Map((Object)((Object)appInfo));
                    String fileName = template.getDocName();
                    if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                        appInfoMap.putAll(subsInfoMap);
                        fileName = this.renderDocName(template.getDocNameTemplate(), appInfoMap);
                    }
                    if ((currentFile = this.getDocDirPath(template, baseDir, conn)) == null) {
                        logger.error("\u751f\u6210\u6587\u4ef6\u4fdd\u5b58\u76ee\u5f55\u8def\u5f84\u5931\u8d25");
                        List<File> list = null;
                        return list;
                    }
                    if (!currentFile.exists()) {
                        currentFile.mkdirs();
                    }
                    String currentFilePath = currentFile.getAbsolutePath();
                    String projectId = appInfo.getAppId();
                    if (StringUtils.isBlank((CharSequence)projectId)) continue;
                    try {
                        List<TreeData> treeDataList = paasAppsInfoDao.queryTableModelPackage(projectId);
                        for (int i = 0; i < treeDataList.size(); ++i) {
                            if (!projectId.equals(treeDataList.get(i).getParentid())) continue;
                            treeDataList.remove(i);
                            --i;
                        }
                        List<ModelTableStructVO> tableStructs = this.queryModelTableStructByProjectId(projectId, conn);
                        List<PkgTableModelInfo> pkgTableModelInfos = this.tableStruct2GenWordTableBean(treeDataList, tableStructs);
                        DocTemplateRepoPullQueueExecutor.syncRun();
                        String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
                        String genFileName = TableModelUtil.genWord4AllDocTemplate((String)projectId, pkgTableModelInfos, (String)(templateRootPath + File.separator + template.getDocFile()), (String)(currentFilePath + File.separator));
                        File appTableDoc = new File(currentFilePath + File.separator + genFileName);
                        String resultFileName = String.format("%s\u8868\u8bbe\u8ba1\u6587\u6863.docx", appInfo.getAppName());
                        File resultFile = new File(currentFilePath + File.separator + fileName);
                        FileUtils.moveFile((File)appTableDoc, (File)resultFile);
                        returnFile.add(resultFile);
                        FileUtils.deleteQuietly((File)appTableDoc);
                        FileUtils.deleteQuietly((File)new File(currentFilePath + projectId + "_single_table_model_result.docx"));
                        WikiSubsPage tableDoc = new WikiSubsPage();
                        tableDoc.setDocType("docx");
                        tableDoc.setDocTitle(fileName.replace(".docx", ""));
                        tableDoc.setAppCode(appInfo.getAppCode());
                        tableDoc.setAppId(appInfo.getAppId());
                        tableDoc.setAppName(appInfo.getAppName());
                        tableDoc.setSubsId(subsId);
                        tableDoc.setLoginUserId(template.getLoginUserId());
                        this.saveToWikiConsole(subsId, template, tableDoc, conn);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                ArrayList<File> arrayList = returnFile;
                return arrayList;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            File currentFile;
            conn = connTool.getConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(appId);
            String subsId = appInfo.getSubsId();
            SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(subsId);
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            File returnFile = null;
            Map appInfoMap = BeanUtility.bean2Map((Object)((Object)appInfo));
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                appInfoMap.putAll(subsInfoMap);
                fileName = this.renderDocName(template.getDocNameTemplate(), appInfoMap);
            }
            if ((currentFile = this.getDocDirPath(template, baseDir, conn)) == null) {
                logger.error("\u751f\u6210\u6587\u4ef6\u4fdd\u5b58\u76ee\u5f55\u8def\u5f84\u5931\u8d25");
                File file = null;
                return file;
            }
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            String currentFilePath = currentFile.getAbsolutePath();
            String projectId = appInfo.getAppId();
            if (StringUtils.isBlank((CharSequence)projectId)) {
                File file = null;
                return file;
            }
            try {
                List<TreeData> treeDataList = paasAppsInfoDao.queryTableModelPackage(projectId);
                for (int i = 0; i < treeDataList.size(); ++i) {
                    if (!projectId.equals(treeDataList.get(i).getParentid())) continue;
                    treeDataList.remove(i);
                    --i;
                }
                List<ModelTableStructVO> tableStructs = this.queryModelTableStructByProjectId(projectId, conn);
                List<PkgTableModelInfo> pkgTableModelInfos = this.tableStruct2GenWordTableBean(treeDataList, tableStructs);
                DocTemplateRepoPullQueueExecutor.syncRun();
                String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
                String genFileName = TableModelUtil.genWord4AllDocTemplate((String)projectId, pkgTableModelInfos, (String)(templateRootPath + File.separator + template.getDocFile()), (String)(currentFilePath + File.separator));
                File appTableDoc = new File(currentFilePath + File.separator + genFileName);
                String resultFileName = String.format("%s\u8868\u8bbe\u8ba1\u6587\u6863.docx", appInfo.getAppName());
                File resultFile = new File(currentFilePath + File.separator + fileName);
                FileUtils.moveFile((File)appTableDoc, (File)resultFile);
                returnFile = resultFile;
                FileUtils.deleteQuietly((File)appTableDoc);
                FileUtils.deleteQuietly((File)new File(currentFilePath + projectId + "_single_table_model_result.docx"));
                WikiSubsPage tableDoc = new WikiSubsPage();
                tableDoc.setDocType("docx");
                tableDoc.setDocTitle(fileName.replace(".docx", ""));
                tableDoc.setAppCode(appInfo.getAppCode());
                tableDoc.setAppId(appInfo.getAppId());
                tableDoc.setAppName(appInfo.getAppName());
                tableDoc.setSubsId(subsId);
                tableDoc.setLoginUserId(template.getLoginUserId());
                this.saveToWikiConsole(subsId, template, tableDoc, conn);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            File file = returnFile;
            return file;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File generateGroupDoc(PaasDocTemplate template, String subsId, String groupName, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsInfo appParam = new PaasAppsInfo();
            appParam.setSubsId(subsId);
            appParam.setBizDbName(groupName);
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoList(appParam);
            if (CollectionUtils.isNotEmpty(appList)) {
                File currentFile;
                PaasAppsInfo appInfo = appList.get(0);
                SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(subsId);
                Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
                File returnFile = null;
                appInfo.setAppCode(appInfo.getBizDbName());
                appInfo.setAppName(appInfo.getBizDbCnname());
                Map appInfoMap = BeanUtility.bean2Map((Object)((Object)appInfo));
                String fileName = template.getDocName();
                if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                    appInfoMap.putAll(subsInfoMap);
                    fileName = this.renderDocName(template.getDocNameTemplate(), appInfoMap);
                }
                if ((currentFile = this.getDocDirPath(template, baseDir, conn)) == null) {
                    logger.error("\u751f\u6210\u6587\u4ef6\u4fdd\u5b58\u76ee\u5f55\u8def\u5f84\u5931\u8d25");
                    File file = null;
                    return file;
                }
                if (!currentFile.exists()) {
                    currentFile.mkdirs();
                }
                String currentFilePath = currentFile.getAbsolutePath();
                String projectId = appInfo.getAppId();
                if (StringUtils.isBlank((CharSequence)projectId)) {
                    File file = null;
                    return file;
                }
                try {
                    List<TreeData> treeDataList = paasAppsInfoDao.queryTableModelPackage(projectId);
                    for (int i = 0; i < treeDataList.size(); ++i) {
                        if (!projectId.equals(treeDataList.get(i).getParentid())) continue;
                        treeDataList.remove(i);
                        --i;
                    }
                    ArrayList<ModelTableStructVO> tableStructs = new ArrayList<ModelTableStructVO>();
                    for (PaasAppsInfo app : appList) {
                        List<ModelTableStructVO> appTableList = this.queryModelTableStructByProjectId(app.getAppId(), conn);
                        if (!CollectionUtils.isNotEmpty(appTableList)) continue;
                        tableStructs.addAll(appTableList);
                    }
                    List<PkgTableModelInfo> pkgTableModelInfos = this.tableStruct2GenWordTableBean(treeDataList, tableStructs);
                    DocTemplateRepoPullQueueExecutor.syncRun();
                    String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
                    String genFileName = TableModelUtil.genWord4AllDocTemplate((String)projectId, pkgTableModelInfos, (String)(templateRootPath + File.separator + template.getDocFile()), (String)(currentFilePath + File.separator));
                    File appTableDoc = new File(currentFilePath + File.separator + genFileName);
                    String resultFileName = String.format("%s\u8868\u8bbe\u8ba1\u6587\u6863.docx", appInfo.getAppName());
                    File resultFile = new File(currentFilePath + File.separator + fileName);
                    FileUtils.moveFile((File)appTableDoc, (File)resultFile);
                    returnFile = resultFile;
                    FileUtils.deleteQuietly((File)appTableDoc);
                    FileUtils.deleteQuietly((File)new File(currentFilePath + projectId + "_single_table_model_result.docx"));
                    WikiSubsPage tableDoc = new WikiSubsPage();
                    tableDoc.setDocType("docx");
                    tableDoc.setDocTitle(fileName.replace(".docx", ""));
                    tableDoc.setAppCode(appInfo.getAppCode());
                    tableDoc.setAppId(appInfo.getAppId());
                    tableDoc.setAppName(appInfo.getAppName());
                    tableDoc.setSubsId(subsId);
                    tableDoc.setLoginUserId(template.getLoginUserId());
                    this.saveToWikiConsole(subsId, template, tableDoc, conn);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                File file = returnFile;
                return file;
            }
            File file = null;
            return file;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
        return null;
    }

    private List<ModelTableStructVO> queryModelTableStructByProjectId(String projectId, Connection conn) throws Exception {
        ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
        ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
        ModelTableIndexDao modelTableIndexDao = new ModelTableIndexDao(conn);
        ArrayList<ModelTableStructVO> sqlScripts = new ArrayList<ModelTableStructVO>();
        ModelTableInfo tableParam = new ModelTableInfo();
        tableParam.setAppId(projectId);
        tableParam.setObjectType(ObjectType.Table.getIntCode());
        List<ModelTableInfo> tableInfoVOs = modelTableInfoDao.queryTableListWithCond(tableParam);
        List<ModelTableField> tableFieldVOs = modelTableFieldDao.queryFieldByAppId(projectId);
        List<ModelTableIndex> tableIndexVOs = modelTableIndexDao.queryModelTableInfos(projectId);
        ModelTableStructVO sqlScript = null;
        ArrayList<ModelTableField> tableFieldVOs2 = null;
        for (ModelTableInfo tableInfoVO : tableInfoVOs) {
            sqlScript = new ModelTableStructVO();
            sqlScript.setTable(tableInfoVO);
            sqlScript.setIndexs(new ArrayList<ModelTableIndex>());
            tableFieldVOs2 = new ArrayList<ModelTableField>();
            for (int i = 0; i < tableFieldVOs.size(); ++i) {
                if (!tableFieldVOs.get(i).getObjectId().equals(tableInfoVO.getObjectId())) continue;
                tableFieldVOs2.add(tableFieldVOs.get(i));
                tableFieldVOs.remove(i);
                --i;
            }
            for (int k = 0; k < tableIndexVOs.size(); ++k) {
                if (!tableInfoVO.getObjectId().equals(tableIndexVOs.get(k).getObjectId())) continue;
                sqlScript.getIndexs().add(tableIndexVOs.get(k));
                tableIndexVOs.remove(k);
                --k;
            }
            sqlScript.setFields(tableFieldVOs2);
            sqlScripts.add(sqlScript);
        }
        return sqlScripts;
    }

    private List<PkgTableModelInfo> tableStruct2GenWordTableBean(List<TreeData> treeDataList, List<ModelTableStructVO> tableStructs) {
        ArrayList<PkgTableModelInfo> pkgTableModelInfos = new ArrayList<PkgTableModelInfo>();
        PkgTableModelInfo pkgTableInfo = null;
        if (Objects.nonNull(treeDataList) && treeDataList.size() > 0) {
            for (TreeData data : treeDataList) {
                pkgTableInfo = new PkgTableModelInfo();
                pkgTableInfo.setPkgName(data.getText());
                ArrayList<TableModelInfo> tableInfos = new ArrayList<TableModelInfo>();
                for (ModelTableStructVO vo : tableStructs) {
                    if (!data.getId().equals(vo.getTable().getFolderId())) continue;
                    tableInfos.add(this.modelTableStruct2TableModelInfo(vo, data.getText()));
                }
                pkgTableInfo.setTableInfos(tableInfos);
                pkgTableModelInfos.add(pkgTableInfo);
            }
        } else {
            pkgTableInfo = new PkgTableModelInfo();
            ArrayList<TableModelInfo> tableInfos = new ArrayList<TableModelInfo>();
            for (ModelTableStructVO vo : tableStructs) {
                tableInfos.add(this.modelTableStruct2TableModelInfo(vo, ""));
            }
            pkgTableInfo.setTableInfos(tableInfos);
            pkgTableModelInfos.add(pkgTableInfo);
        }
        return pkgTableModelInfos;
    }

    private TableModelInfo modelTableStruct2TableModelInfo(ModelTableStructVO vo, String pkgName) {
        TableModelInfo tableModelInfo = new TableModelInfo();
        List<ModelTableField> fields = vo.getFields();
        ColumnInfo columnInfo = new ColumnInfo();
        ArrayList<RowRenderData> columns = new ArrayList<RowRenderData>();
        ArrayList<RowRenderData> indexs = new ArrayList<RowRenderData>();
        int c = 0;
        RowRenderData column = null;
        for (ModelTableField field : fields) {
            if (!"Y".equals(field.getIsPk())) continue;
            column = Rows.of((String[])new String[]{String.valueOf(++c), field.getFieldCode(), field.getFieldName(), this.getDataType(field), "\u4e3b\u952e", this.checkCanNull(field)}).create();
            columns.add(column);
        }
        for (ModelTableField field : fields) {
            if ("Y".equals(field.getIsPk())) continue;
            column = Rows.of((String[])new String[]{String.valueOf(++c), field.getFieldCode(), field.getFieldName(), this.getDataType(field), "", this.checkCanNull(field)}).create();
            columns.add(column);
        }
        indexs.add(Rows.of((String[])new String[]{"", "", ""}).create());
        columnInfo.setColumns(columns);
        columnInfo.setIndexs(indexs);
        tableModelInfo.setColumnInfo(columnInfo);
        tableModelInfo.setTableName(vo.getTable().getObjectCode());
        tableModelInfo.setTableCnName(vo.getTable().getObjectName());
        tableModelInfo.setBelongTo(pkgName);
        return tableModelInfo;
    }

    private String getDataType(ModelTableField fieldVO) {
        String dataType = fieldVO.getFieldType();
        if (fieldVO.getFieldLength() != null && fieldVO.getFieldLength() > 0) {
            dataType = dataType + "(" + fieldVO.getFieldLength();
        }
        if (fieldVO.getFieldPrecision() != null && fieldVO.getFieldPrecision() > 0) {
            dataType = dataType + "," + fieldVO.getFieldPrecision();
        }
        dataType = dataType + ")";
        return dataType;
    }

    private String checkCanNull(ModelTableField fieldVO) {
        String canNull = null;
        canNull = "Y".equals(fieldVO.getIsPk()) ? "N" : ("N".equals(fieldVO.getIsAllowNull()) ? "N" : "Y");
        return canNull;
    }
}

