/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasTemplateInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginGitConf;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import java.io.File;
import java.sql.Connection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppTemplateRepoPullTask
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(AppTemplateRepoPullTask.class);
    public static final String createDbSqlFileName = "create_db.sql";
    public static final String createAppSqlFileName = "create_app.sql";
    public static final String initDataSqlFileName = "init_data.sql";
    private static String gitUserName;
    private static String gitPassword;
    private static String branchName;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private String appTemplateId = null;
    private String gitUrl = null;
    private String appTemplatePath = null;

    public AppTemplateRepoPullTask(String appTemplateId, String gitUrl) {
        this.appTemplateId = appTemplateId;
        this.gitUrl = gitUrl;
    }

    public AppTemplateRepoPullTask(String appTemplateId) {
        this.appTemplateId = appTemplateId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String gitLocalPath;
        String gitLocalPathFileName;
        PluginGitConf pluginParam;
        Connection conn;
        block10: {
            this.isRunning.set(true);
            conn = null;
            pluginParam = new PluginGitConf();
            if (gitUserName == null) {
                conn = TConnPool.getDefaultPool().getConnection();
                PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
                gitUserName = paasEnvParamDao.queryByCodeReturnValue("git.dev.template.store.username");
                gitPassword = paasEnvParamDao.queryByCodeReturnValue("git.dev.template.store.password");
                branchName = paasEnvParamDao.queryByCodeReturnValue("git.prjtemplate.branch.name");
            }
            pluginParam.setGitUserName(gitUserName);
            pluginParam.setGitPassword(gitPassword);
            pluginParam.setGitBranchName(branchName);
            if (StringUtils.isBlank((CharSequence)this.gitUrl)) {
                conn = TConnPool.getDefaultPool().getConnection(conn);
                PaasTemplateInfoDao paasTemplateInfoDao = new PaasTemplateInfoDao(conn);
                PaasTemplateInfo templateInfo = paasTemplateInfoDao.queryPaasTemplateInfo(this.appTemplateId);
                this.gitUrl = templateInfo.getAppTemplateGitUrl();
            }
            pluginParam.setGitRemotePath(this.gitUrl);
            gitLocalPathFileName = this.appTemplateId + "-template";
            gitLocalPath = SdEnvUtil.TEMPLATE_PATH;
            if (pluginParam != null && gitLocalPath != null) break block10;
            TConnPool.getDefaultPool().releaseConnection(conn);
            return;
        }
        try {
            boolean flag = false;
            if (gitLocalPath != null) {
                flag = this.repositoryCreate(gitLocalPath + gitLocalPathFileName, pluginParam.getGitRemotePath(), pluginParam.getGitUserName(), pluginParam.getGitPassword(), pluginParam.getGitBranchName());
                if (flag) {
                    this.appTemplatePath = new File(gitLocalPath + gitLocalPathFileName).getAbsolutePath();
                    logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + pluginParam.getGitRemotePath());
                } else {
                    logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + pluginParam.getGitRemotePath());
                }
                TConnPool.getDefaultPool().releaseConnection(conn);
                return;
            }
            TConnPool.getDefaultPool().releaseConnection(conn);
            return;
        }
        catch (Exception e) {
            try {
                logger.error("\u6587\u6863\u6a21\u677f\u4ed3\u5e93\u62c9\u53d6\u4efb\u52a1\u5931\u8d25 " + e.getMessage(), (Throwable)e);
                TConnPool.getDefaultPool().releaseConnection(conn);
            }
            catch (Throwable throwable) {
                TConnPool.getDefaultPool().releaseConnection(conn);
                throw throwable;
            }
        }
        this.isRunning.set(false);
    }

    public void asyncRun() {
        this.start();
    }

    public void syncRun() {
        this.run();
    }

    private boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, arg_0 -> ((Logger)logger).info(arg_0));
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    public String getAppTemplatePath() {
        return this.appTemplatePath;
    }
}

