/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.WikiRepoPushTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiRepoCommitQueueExecutor {
    private static Logger logger = LoggerFactory.getLogger(WikiRepoCommitQueueExecutor.class);
    private static ConcurrentLinkedQueue<WikiRepoPushTask> taskQueue = new ConcurrentLinkedQueue();
    private static AtomicBoolean isRunning = new AtomicBoolean(false);

    public static void addTask(WikiRepoPushTask task) {
        taskQueue.add(task);
    }

    public static void run(WikiRepoPushTask task) {
        taskQueue.add(task);
        if (isRunning.get()) {
            return;
        }
        WikiRepoCommitQueueExecutor.start();
    }

    public static synchronized void start() {
        if (isRunning.get()) {
            return;
        }
        WikiRepoCommitQueueExecutor.loop();
    }

    public static void loop() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (!taskQueue.isEmpty()) {
                    WikiRepoPushTask task = (WikiRepoPushTask)taskQueue.poll();
                    try {
                        task.execute();
                    }
                    catch (Exception e) {
                        logger.error("wiki \u6587\u6863\u4ed3\u5e93\u63a8\u9001\u4efb\u52a1\u5931\u8d25 " + e.getMessage(), (Throwable)e);
                    }
                }
                isRunning.set(false);
            }
        };
        thread.start();
        isRunning.set(true);
    }
}

