/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.git;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasTemplateInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginGitConf;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class GitPullProjectTempPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private String pluginName = null;
    private PluginGitConf pluginParam = null;
    private String gitLocalPath = null;
    private String gitLocalPathFileName;
    private String mediumUrl;
    private String gitlabName;
    private String gitlabPwd;

    public boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, this.logger::info);
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    this.logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String s) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        BatInstBatch batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        PaasTemplateInfoDao paasTemplateInfoDao = new PaasTemplateInfoDao(conn);
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(batchInst.getAppId());
        this.pluginName = this.context.getSzPluginName();
        this.pluginParam = new PluginGitConf();
        this.pluginParam.setGitUserName(paasEnvParamDao.queryByCodeReturnValue("git.dev.template.store.username"));
        this.pluginParam.setGitPassword(paasEnvParamDao.queryByCodeReturnValue("git.dev.template.store.password"));
        this.gitlabName = paasEnvParamDao.queryByCodeReturnValue("git.username");
        this.gitlabPwd = paasEnvParamDao.queryByCodeReturnValue("git.password");
        PaasTemplateInfo templateInfo = paasTemplateInfoDao.queryPaasTemplateInfo(this.appInfo.getAppTemplateId());
        if (templateInfo == null) {
            PaasTemplateInfo templateParam = new PaasTemplateInfo();
            templateParam.setAppType(this.appInfo.getAppType());
            templateParam.setArchType(this.appInfo.getArchType());
            List<PaasTemplateInfo> templateList = paasTemplateInfoDao.queryPaasTemplateInfoList(templateParam);
            templateInfo = (PaasTemplateInfo)((Object)templateList.stream().findFirst().get());
            this.appInfo.setAppTemplateId(templateInfo.getAppTemplateId());
            this.appInfo.setAppTemplateName(templateInfo.getAppTemplateName());
            paasAppsInfoDao.updateByPk(this.appInfo);
        }
        if (templateInfo == null) {
            this.logger.error("\u5e94\u7528\u5173\u8054\u7684\u6a21\u578b\u4e0d\u5b58\u5728");
            return false;
        }
        this.pluginParam.setGitRemotePath(templateInfo.getAppTemplateGitUrl());
        this.pluginParam.setGitBranchName(paasEnvParamDao.queryByCodeReturnValue("git.prjtemplate.branch.name"));
        int firstIndex = this.pluginParam.getGitRemotePath().lastIndexOf("/");
        int lastIndex = this.pluginParam.getGitRemotePath().lastIndexOf(".");
        this.gitLocalPathFileName = templateInfo.getAppTemplateId() + "-template";
        this.gitLocalPath = SdEnvUtil.TEMPLATE_PATH;
        if (this.pluginParam == null || this.gitLocalPath == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + s + "\u7684\u6570\u636eGit\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        this.logger.info("........................................................................");
        boolean flag = true;
        if (this.gitLocalPath != null) {
            flag = this.repositoryCreate(this.gitLocalPath + this.gitLocalPathFileName, this.pluginParam.getGitRemotePath(), this.pluginParam.getGitUserName(), this.pluginParam.getGitPassword(), this.pluginParam.getGitBranchName());
            if (!flag) {
                flag = this.repositoryCreate(this.gitLocalPath + this.gitLocalPathFileName, this.pluginParam.getGitRemotePath(), this.gitlabName, this.gitlabPwd, this.pluginParam.getGitBranchName());
            }
            if (flag) {
                this.logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + this.gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
            } else {
                this.logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + this.gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
            }
            if (StringUtils.isNotBlank((CharSequence)this.mediumUrl)) {
                this.logger.info(String.format("\u83b7\u53d6\u5e94\u7528\u6a21\u677f\u5bf9\u5e94\u5b89\u88c5\u4ecb\u8d28 %s", this.mediumUrl));
                String localMediumPath = this.appInfo.getAppTemplateId() + "-medium";
                this.repositoryCreate(this.gitLocalPath + localMediumPath, this.mediumUrl, this.gitlabName, this.gitlabPwd, this.pluginParam.getGitBranchName());
            }
            return flag;
        }
        return false;
    }
}

