/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.git;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SUserDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SUser;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginGitConf;
import com.irdstudio.allincloud.portal.facade.GiteeService;
import com.irdstudio.allincloud.portal.facade.dto.GiteeRequestVO;
import com.irdstudio.allincloud.portal.facade.dto.GiteeResponseVO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Group;
import org.gitlab4j.api.models.GroupParams;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.User;

public class GitPushCheckRepoPlugin
extends AbstractPlugin {
    private String pluginName = null;
    private PluginGitConf pluginParam = null;
    private String gitLocalPath = null;
    private String gitLocalPathFileName;
    private String repoName = null;
    private PaasAppsInfo appInfo = null;
    private BatInstBatch batchInst;
    private Map<String, Object> extParam = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection connection, String s) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(connection);
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(connection);
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(connection);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.pluginName = this.context.getSzPluginName();
        this.pluginParam = new PluginGitConf();
        this.pluginParam.setGitUserName(paasEnvParamDao.queryByCodeReturnValue("git.username"));
        this.pluginParam.setGitPassword(paasEnvParamDao.queryByCodeReturnValue("git.password"));
        this.pluginParam.setGitType(paasEnvParamDao.queryByCodeReturnValue("git.type"));
        this.pluginParam.setGitAccessToken(paasEnvParamDao.queryByCodeReturnValue("git.open.api.access_token"));
        this.pluginParam.setGitHostUrl(paasEnvParamDao.queryByCodeReturnValue("git.host.url"));
        this.pluginParam.setGitBranchName(paasEnvParamDao.queryByCodeReturnValue("git.push.branch.name"));
        String pushUrl = paasEnvParamDao.queryByCodeReturnValue("git.push.remote.path");
        if (!pushUrl.endsWith("/")) {
            pushUrl = pushUrl + "/";
        }
        this.pluginParam.setGitRemotePath(String.format("%s%s.git", pushUrl, SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode())));
        this.repoName = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        this.gitLocalPath = SdEnvUtil.getAppBuildOutputPath(this.appInfo);
        if (this.pluginParam == null || this.gitLocalPath == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + s + "\u7684\u6570\u636eGit\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean result = true;
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            this.logger.info(String.format("\u5f53\u524d\u4ed3\u5e93\u5bf9\u63a5\u662f %s", this.pluginParam.getGitType()));
            if (StringUtils.equals((String)"gitee", (String)this.pluginParam.getGitType())) {
                result = this.giteeHandler(conn);
            } else if (StringUtils.equals((String)"gitlab", (String)this.pluginParam.getGitType())) {
                result = this.gitlabHandler(conn);
            }
        }
        catch (Exception e) {
            result = false;
            this.logger.error("\u68c0\u67e5\u521d\u59cb\u4ed3\u5e93\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return result;
    }

    private boolean gitlabHandler(Connection conn) throws Exception {
        boolean result;
        block30: {
            result = true;
            try {
                PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
                SUserDao sUserDao = new SUserDao(conn);
                this.pluginParam.setGitBranchName(paasEnvParamDao.queryByCodeReturnValue("git.push.branch.name"));
                SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
                SSubsInfo sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
                String pushUrl = sSubsInfo.getSubsGitGroup();
                if (StringUtils.isBlank((String)pushUrl)) {
                    pushUrl = paasEnvParamDao.queryByCodeReturnValue("git.push.remote.path");
                }
                if (pushUrl.endsWith("/")) {
                    pushUrl = pushUrl.substring(0, pushUrl.length() - 1);
                }
                String group = pushUrl.substring(pushUrl.lastIndexOf("/") + 1);
                String projectName = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
                String currentUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
                this.logger.info("\u5f53\u524d\u7528\u6237\uff1a " + currentUserId);
                GitLabApi gitLabApi = new GitLabApi(this.pluginParam.getGitHostUrl(), this.pluginParam.getGitAccessToken());
                User gitUserInfo = null;
                try {
                    gitUserInfo = gitLabApi.getUserApi().getUser(currentUserId);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (gitUserInfo == null) {
                    SUser sUser = new SUser();
                    sUser.setActorno(currentUserId);
                    sUser = sUserDao.queryByPk(sUser);
                    gitUserInfo = new User();
                    gitUserInfo.setName(currentUserId);
                    gitUserInfo.setUsername(currentUserId);
                    gitUserInfo.setEmail(sUser.getUsermail());
                    try {
                        gitUserInfo = gitLabApi.getUserApi().createUser(gitUserInfo, (CharSequence)(currentUserId + currentUserId), false);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                }
                GroupApi groupApi = gitLabApi.getGroupApi();
                Group namespace = null;
                try {
                    namespace = groupApi.getGroup((Object)group);
                }
                catch (GitLabApiException e) {
                    this.logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                    namespace = null;
                }
                if (namespace == null) {
                    try {
                        GroupParams createGroupParam = new GroupParams();
                        createGroupParam.withName(group);
                        createGroupParam.withPath(group);
                        createGroupParam.withDescription(sSubsInfo.getSubsName());
                        namespace = groupApi.createGroup(createGroupParam);
                        this.logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = groupApi.addMember((Object)group, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                this.logger.info("\u4ed3\u5e93\u7ec4\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                        }
                        catch (GitLabApiException member) {}
                    }
                    catch (GitLabApiException e) {
                        this.logger.error(String.format("\u4ed3\u5e93\u7ec4%s\u672a\u521b\u5efa", group));
                        result = false;
                        return result;
                    }
                }
                ProjectApi prjApi = gitLabApi.getProjectApi();
                Project prj = null;
                try {
                    prj = prjApi.getProject(group, projectName);
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                if (prj == null || prj.getId() == null || prj.getId() < 0L) {
                    prj = new Project();
                    prj.setName(projectName);
                    prj.setPath(projectName);
                    prj.setDescription(this.appInfo.getAppName());
                    Project newPrj = null;
                    try {
                        newPrj = prjApi.createProject(namespace.getId(), prj);
                    }
                    catch (GitLabApiException gitLabApiException) {
                        // empty catch block
                    }
                    if (newPrj != null) {
                        this.logger.info("\u4ed3\u5e93\u521b\u5efa\u6210 \u5c06\u5f53\u524d\u7528\u6237\u6dfb\u52a0\u4e3a\u4ed3\u5e93\u6210\u5458");
                        try {
                            Member member = prjApi.addMember((Object)newPrj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                            if (member != null) {
                                this.logger.info("\u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                            }
                            break block30;
                        }
                        catch (GitLabApiException gitLabApiException) {}
                        break block30;
                    }
                    this.logger.info("\u4ed3\u5e93\u521b\u5efa\u5931\u8d25\u4e86");
                    result = false;
                    break block30;
                }
                this.logger.info("\u4ed3\u5e93\u5df2\u5b58\u5728");
                try {
                    Member member = prjApi.addMember((Object)prj, gitUserInfo.getId(), AccessLevel.MAINTAINER);
                    if (member != null) {
                        this.logger.info("\u4ed3\u5e93\u6210\u5458\u6dfb\u52a0\u6210\u529f");
                    }
                }
                catch (GitLabApiException gitLabApiException) {
                    // empty catch block
                }
                result = true;
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528gitlab api \u5f02\u5e38 " + e.getMessage(), e);
                result = false;
            }
        }
        return result;
    }

    private boolean giteeHandler(Connection conn) throws Exception {
        String group;
        GiteeService giteeService = (GiteeService)SpringContextUtils.getBean(GiteeService.class);
        boolean result = true;
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        String type = "enterprise";
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
        SSubsInfo sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
        String pushUrl = sSubsInfo.getSubsGitGroup();
        if (StringUtils.isBlank((String)pushUrl)) {
            pushUrl = paasEnvParamDao.queryByCodeReturnValue("git.push.remote.path");
        }
        if (pushUrl.endsWith("/")) {
            pushUrl = pushUrl.substring(0, pushUrl.length() - 1);
        }
        String ownName = group = pushUrl.substring(pushUrl.lastIndexOf("/") + 1);
        if (StringUtils.isNotBlank((String)paasEnvParamDao.queryByCodeReturnValue("git.open.api.enterprise.name"))) {
            type = "enterprise";
            ownName = paasEnvParamDao.queryByCodeReturnValue("git.open.api.enterprise.name");
        } else if (StringUtils.isNotBlank((String)paasEnvParamDao.queryByCodeReturnValue("git.open.api.org.name"))) {
            type = "org";
            ownName = paasEnvParamDao.queryByCodeReturnValue("git.open.api.org.name");
        } else {
            type = "user";
        }
        GiteeResponseVO response = null;
        if (type.equals("user")) {
            GiteeRequestVO requestParam = new GiteeRequestVO();
            requestParam.setAccess_token(this.pluginParam.getGitAccessToken());
            response = giteeService.queryUserRepo(paasEnvParamDao.queryByCodeReturnValue("git.open.api.user.name"), this.repoName, requestParam);
        } else {
            response = new GiteeResponseVO();
            response.setMessage("Not Found Project");
        }
        String message = response.getMessage();
        String remoteUrl = response.getUrl();
        if (message.equals("Not Found Project") || StringUtils.isBlank((String)remoteUrl)) {
            GiteeRequestVO requestParam = new GiteeRequestVO();
            requestParam.setAccess_token(this.pluginParam.getGitAccessToken());
            requestParam.setName(this.repoName);
            requestParam.setDescription(String.format("\u9886\u57df\u5e94\u7528\u81ea\u52a8\u521b\u5efa\u4ed3\u5e93 %s-%s", this.appInfo.getAppCode(), this.appInfo.getAppName()));
            requestParam.setHas_issues(Boolean.valueOf(true));
            requestParam.setHas_wiki(Boolean.valueOf(true));
            requestParam.setCan_comment(Boolean.valueOf(true));
            response = type.equals("enterprise") || type.equals("org") ? giteeService.createOrgRepo(type + "s", ownName, requestParam) : giteeService.createUserRepos(requestParam);
            remoteUrl = response.getUrl();
            if (StringUtils.isBlank((String)remoteUrl)) {
                if (response.getError() != null && response.getError().getBase() != null && response.getError().getBase().size() > 0) {
                    String msg = ((String)response.getError().getBase().get(0)).toString();
                    if (msg.contains("\u5df2\u5b58\u5728\u540c\u5730\u5740\u4ed3\u5e93") || msg.contains("The same path repository already exists")) {
                        result = true;
                        this.logger.info("\u5df2\u5b58\u5728\u540c\u5730\u5740\u4ed3\u5e93 " + remoteUrl);
                    } else {
                        result = false;
                        this.logger.info("\u4ed3\u5e93\u521b\u5efa\u5931\u8d25 " + JSON.toJSONString((Object)response));
                    }
                } else {
                    result = false;
                    this.logger.info("\u4ed3\u5e93\u521b\u5efa\u5931\u8d25 " + JSON.toJSONString((Object)response));
                }
            } else {
                this.logger.info("\u4ed3\u5e93\u521b\u5efa\u6210\u529f " + remoteUrl);
            }
        } else {
            this.logger.info("\u8fdc\u7a0b\u4ed3\u5e93\u5b58\u5728\uff0c \u4e0d\u9700\u8981\u521b\u5efa " + remoteUrl);
        }
        return result;
    }
}

