/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.git;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginGitConf;
import java.sql.Connection;

public class GitPushPlugin
extends AbstractPlugin {
    private String pluginName = null;
    private PluginGitConf pluginParam = null;
    private String gitLocalPath = null;
    private String gitLocalPathFileName;

    public boolean repositoryPush(String localPath, String remotePath, String username, String password, String branchName) {
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.addAll();
            jGitUtil.commit("auto code generate commit");
            jGitUtil.push();
        }
        catch (Exception e) {
            this.logger.error("\u63d0\u4ea4\u4ee3\u7801\u5f02\u5e38 " + e.getMessage(), e);
            return false;
        }
        jGitUtil.close();
        return true;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection connection, String s) {
        this.pluginName = this.context.getSzPluginName();
        this.pluginParam = new PluginGitConf();
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(connection);
        this.pluginParam.setGitUserName(paasEnvParamDao.queryByCodeReturnValue("git.username"));
        this.pluginParam.setGitPassword(paasEnvParamDao.queryByCodeReturnValue("git.password"));
        this.pluginParam.setGitRemotePath(paasEnvParamDao.queryByCodeReturnValue("git.remote.path"));
        this.pluginParam.setGitBranchName(paasEnvParamDao.queryByCodeReturnValue("git.branch.name"));
        int firstIndex = this.pluginParam.getGitRemotePath().lastIndexOf("/");
        int lastIndex = this.pluginParam.getGitRemotePath().lastIndexOf(".");
        this.gitLocalPathFileName = this.pluginParam.getGitRemotePath().substring(firstIndex, lastIndex);
        this.gitLocalPath = paasEnvParamDao.queryByCodeReturnValue("git.local.path");
        if (this.pluginParam == null || this.gitLocalPath == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + s + "\u7684\u6570\u636eGit\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        this.logger.info("........................................................................");
        boolean flag = true;
        if (this.gitLocalPath != null) {
            flag = this.repositoryPush(this.gitLocalPath + this.gitLocalPathFileName, this.pluginParam.getGitRemotePath(), this.pluginParam.getGitUserName(), this.pluginParam.getGitPassword(), this.pluginParam.getGitBranchName());
            if (flag) {
                this.logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + this.gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
            } else {
                this.logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + this.gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
            }
            return flag;
        }
        return false;
    }
}

