/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.git;

import com.irdstudio.allinapaas.deliver.console.facade.PluginGitConfService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginGitConfDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SUserDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SUserProfileDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SUserProfile;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginGitConf;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ProdPullRepoPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private BatInstBatch batchInst;
    private Map<String, Object> extParam = null;
    private String pluginName = null;
    private PluginGitConf pluginParam = null;
    private String gitLocalPath = null;
    private String gitLocalPathFileName;

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        PluginGitConfService service = (PluginGitConfService)SpringContextUtils.getBean(PluginGitConfService.class);
        PluginGitConfDTO param = new PluginGitConfDTO();
        param.setPluginConfId(taskId);
        param = (PluginGitConfDTO)service.queryByPk((Object)param);
        if (param == null) {
            return false;
        }
        message.getMessage().addAll(param.validate());
        return CollectionUtils.isEmpty((Collection)message.getMessage());
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        return super.copyConfig(batchId, taskId, newTaskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, this.logger::info);
            return true;
        }
        try (JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);){
            jGitUtil.pull(branchName);
        }
        return true;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String s) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        PaasMarketAppinfoDao paasMarketAppinfoDao = new PaasMarketAppinfoDao(conn);
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.pluginName = this.context.getSzPluginName();
        this.pluginParam = new PluginGitConf();
        PluginGitConfService service = (PluginGitConfService)SpringContextUtils.getBean(PluginGitConfService.class);
        PluginGitConfDTO param = new PluginGitConfDTO();
        param.setPluginConfId(this.context.getSzTaskId());
        param = (PluginGitConfDTO)service.queryByPk((Object)param);
        if (param != null) {
            this.pluginParam.setGitRemotePath(param.getRepoUrl());
            this.pluginParam.setGitBranchName(param.getBranchName());
            if (StringUtils.isNotBlank((CharSequence)param.getUserName()) && StringUtils.isNotBlank((CharSequence)param.getPassword())) {
                this.pluginParam.setGitUserName(param.getUserName());
                this.pluginParam.setGitPassword(param.getPassword());
            } else {
                SUserProfileDao sUserProfileDao = new SUserProfileDao(conn);
                SUserDao sUserDao = new SUserDao(conn);
                String currentUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
                SUserProfile userProfile = sUserProfileDao.queryByPk(currentUserId);
                if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
                    this.logger.error("************************************\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01************************************");
                    return false;
                }
                this.pluginParam.setGitUserName(userProfile.getGitUsername());
                if (StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
                    this.pluginParam.setGitPassword(userProfile.getGitAccessToken());
                } else {
                    this.pluginParam.setGitPassword(userProfile.getGitPassword());
                }
            }
        } else {
            SUserProfileDao sUserProfileDao = new SUserProfileDao(conn);
            SUserDao sUserDao = new SUserDao(conn);
            String currentUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
            SUserProfile userProfile = sUserProfileDao.queryByPk(currentUserId);
            if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
                this.logger.error("************************************\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01************************************");
                return false;
            }
            this.pluginParam.setGitUserName(userProfile.getGitUsername());
            if (StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
                this.pluginParam.setGitPassword(userProfile.getGitAccessToken());
            } else {
                this.pluginParam.setGitPassword(userProfile.getGitPassword());
            }
            this.pluginParam.setGitRemotePath(this.appInfo.getAppGitUrl());
            this.pluginParam.setGitBranchName("master");
            PaasAppsParam branch = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "git.branch");
            if (branch != null && StringUtils.isNotBlank((CharSequence)branch.getParamValue())) {
                this.pluginParam.setGitBranchName(branch.getParamValue());
            }
        }
        this.gitLocalPathFileName = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        this.gitLocalPath = SdEnvUtil.BUILD_PATH;
        if (StringUtils.equalsAny((CharSequence)this.batchInst.getBatchId(), (CharSequence[])new CharSequence[]{"SDKCOM-IMP"})) {
            this.gitLocalPath = SdEnvUtil.PROJECT_PATH;
        }
        if (this.pluginParam == null || this.gitLocalPath == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + s + "\u7684\u6570\u636eGit\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        this.logger.info("........................................................................");
        this.logger.info("\u62c9\u53d6\u4ed3\u5e93\uff1a" + this.pluginParam.getGitRemotePath());
        boolean flag = true;
        if (this.gitLocalPath != null) {
            flag = this.repositoryCreate(this.gitLocalPath + this.gitLocalPathFileName, this.pluginParam.getGitRemotePath(), this.pluginParam.getGitUserName(), this.pluginParam.getGitPassword(), this.pluginParam.getGitBranchName());
            if (flag) {
                this.logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + this.gitLocalPath + " \u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
            } else {
                this.logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + this.gitLocalPath + " n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
            }
            return flag;
        }
        return false;
    }
}

