/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsPropertiesService;
import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.design.console.types.MarketSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsPropertiesDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsSqlDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsProperties;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsSql;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.AppCreateWay;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CPMarketInfoTask
extends AbstractMarketTask {
    private PaasMarketAppinfo appInfo = null;
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryPaasMarketAppinfo(MapUtils.getString(extParam, (Object)"marketAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        Connection sqliteConn = null;
        try {
            Object paasAppsInfoDao;
            conn = this.getConnection();
            String subsFlag = MapUtils.getString(this.extParam, (Object)"subsFlag");
            String marketSource = MapUtils.getString(this.extParam, (Object)"marketSource");
            String subsId = MapUtils.getString(this.extParam, (Object)"marketSubsId");
            String subsCode = MapUtils.getString(this.extParam, (Object)"marketSubsCode");
            String destSysId = MapUtils.getString(this.extParam, (Object)"paasSubsId");
            String destSysCode = MapUtils.getString(this.extParam, (Object)"paasSubsCode");
            ArrayList<PaasMarketAppinfo> appInfoList = new ArrayList<PaasMarketAppinfo>();
            if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
                    PaasMarketAppinfo appParam = new PaasMarketAppinfo();
                    appParam.setSubsId(subsId);
                    List<PaasMarketAppinfo> sysApps = ((PaasMarketAppinfoDao)paasAppsInfoDao).queryPaasMarketAppinfoList(appParam);
                    appInfoList.addAll(sysApps);
                } else {
                    appInfoList.add(this.appInfo);
                }
            } else {
                String respJson;
                PaasMarketAppinfo param;
                PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
                String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    param = new PaasMarketAppinfo();
                    param.setSubsId(subsId);
                    respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo/index", (Object)param);
                    if (StringUtils.isBlank((CharSequence)respJson)) {
                        boolean bl = flag = false;
                        return bl;
                    }
                    List sysApps = JSON.parseArray((String)respJson, PaasMarketAppinfo.class);
                    appInfoList.addAll(sysApps);
                } else {
                    param = new PaasMarketAppinfo();
                    param.setMarketAppId(MapUtils.getString(this.extParam, (Object)"marketAppId"));
                    respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo", (Object)param);
                    if (StringUtils.isBlank((CharSequence)respJson)) {
                        boolean sysApps = flag = false;
                        return sysApps;
                    }
                    PaasMarketAppinfo marketApp = (PaasMarketAppinfo)((Object)JSON.parseObject((String)respJson, PaasMarketAppinfo.class));
                    appInfoList.add(marketApp);
                }
            }
            paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasTemplateParamDao paasTemplateParamDao = new PaasTemplateParamDao(conn);
            PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
            PaasAppsSqlDao paasAppsSqlDao = new PaasAppsSqlDao(conn);
            PaasAppsPropertiesService paasAppsPropertiesService = (PaasAppsPropertiesService)SpringContextUtils.getBean(PaasAppsPropertiesService.class);
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            String createTime = CurrentDateUtil.getTodayDateEx2();
            boolean cpSysInfo = true;
            List<String> cpnAppTypes = Arrays.asList(AppType.A10.getCode());
            for (PaasMarketAppinfo srcApp : appInfoList) {
                File sqliteFile = null;
                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                    String marketUrl = paasEnvParamDao.queryByCodeReturnValue("git.market.remote.path");
                    sqliteFile = this.getIMPSysSqliteFile(this.extParam, marketUrl, null);
                } else {
                    sqliteFile = this.getSqliteFile(srcApp);
                }
                sqliteConn = this.getSqliteConnection(sqliteFile);
                if (cpSysInfo) {
                    SSubsInfoDao sqliteSSubsInfoDao = new SSubsInfoDao(sqliteConn);
                    SSubsInfo sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(destSysId);
                    if (sSubsInfo == null && !StringUtils.equals((CharSequence)destSysId, (CharSequence)"dspaas")) {
                        sSubsInfo = new SSubsInfo();
                        sSubsInfo = sqliteSSubsInfoDao.querySSubsInfoWithKeys(destSysId);
                        sSubsInfoDao.insertSSubsInfo(sSubsInfo);
                    }
                    cpSysInfo = false;
                }
                PaasMarketAppinfoDao keyMapDao = new PaasMarketAppinfoDao(sqliteConn);
                PaasAppsInfoDao sqlitePaasAppsInfoDao = new PaasAppsInfoDao(sqliteConn);
                PaasAppsParamDao sqliteAppParamDao = new PaasAppsParamDao(sqliteConn);
                PaasAppsSqlDao sqliteAppSqlDao = new PaasAppsSqlDao(sqliteConn);
                PaasAppsPropertiesDao sqliteAppPropertiesDao = new PaasAppsPropertiesDao(sqliteConn);
                String newAppId = keyMapDao.queryKeyMap(srcApp.getAppId());
                PaasAppsInfo sqliteSrcApp = sqlitePaasAppsInfoDao.queryByAppId(newAppId);
                PaasAppsInfo destApp = new PaasAppsInfo();
                BeanUtils.copyProperties((Object)((Object)destApp), (Object)((Object)srcApp));
                BeanUtils.copyProperties((Object)((Object)destApp), (Object)((Object)sqliteSrcApp));
                destApp.setAppId(newAppId);
                SSubsInfo sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(destSysId);
                if (sSubsInfo != null) {
                    destApp.setSubsId(sSubsInfo.getSubsId());
                    destApp.setSubsCode(sSubsInfo.getSubsCode());
                    destApp.setSubsName(sSubsInfo.getSubsName());
                } else if (StringUtils.equals((CharSequence)destSysId, (CharSequence)"dspaas")) {
                    destApp.setSubsCode(destSysCode);
                    destApp.setSubsId(destSysId);
                    destApp.setSubsName("\u4e2d\u53f0\u5e94\u7528");
                }
                destApp.setCreateTime(createTime);
                destApp.setLastUpdateTime(createTime);
                destApp.setAppAdminType(srcApp.getAppAdminType());
                destApp.setRefMarketAppid(srcApp.getMarketAppId());
                destApp.setAppCreateWay(AppCreateWay.BaseOnMarket.getCode());
                ((PaasAppsInfoDao)paasAppsInfoDao).insertPaasAppsInfo(destApp);
                PaasAppsParam paasAppsParam = new PaasAppsParam();
                paasAppsParam.setAppId(newAppId);
                List<PaasAppsParam> appParamList = sqliteAppParamDao.queryPaasAppsParamList(paasAppsParam);
                if (CollectionUtils.isNotEmpty(appParamList)) {
                    for (PaasAppsParam param : appParamList) {
                        param.setAppId(destApp.getAppId());
                        paasAppsParamDao.insert(param);
                    }
                }
                PaasAppsSql sqlParam = new PaasAppsSql();
                sqlParam.setAppId(newAppId);
                List<PaasAppsSql> sqlList = sqliteAppSqlDao.queryPaasAppsSqlList(sqlParam);
                this.batchInsertPage("`allinpaas_db`.paas_apps_sql", sqlList, conn);
                PaasAppsProperties propParam = new PaasAppsProperties();
                propParam.setAppId(newAppId);
                List<PaasAppsProperties> propList = sqliteAppPropertiesDao.queryPaasAppsPropertiesList(propParam);
                this.batchInsertPage("`allinpaas_db`.paas_apps_properties", propList, conn);
                this.closeSqliteConnection(sqliteConn);
            }
        }
        catch (Exception e) {
            this.logger.error("\u590d\u5236\u7cfb\u7edf\u4e0e\u5e94\u7528\u4fe1\u606f", (Throwable)e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
        return flag;
    }
}

